
/*
 * FC_MediaPlayer_clienthandler_Videomanager.cpp
 *
 *  Created on: July19, 2017
 *      Author: Abinaya (abc1cob)
 */
/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define  ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_SERVICE_MEDIAPLAYER
#include "trcGenProj/Header/FC_MediaPlayer_clienthandler_Videomanager.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_SERVICE_MEDIAPLAYER
#endif

#include "FC_MediaPlayer_main.h"
#include "FC_MediaPlayer_clienthandler_Videomanager.h"
#include "MediaPlayerInterface.h"
#include "FunctionTracer.h"
#include "LocalSPM.h"
#include "VarTrace.h"

// Version defines for used service
#define VIDEOMANAGER_FI_MAJOR_VERSION  VIDEOMANAGER_MAINFI_C_U16_SERVICE_MAJORVERSION
#define VIDEOMANAGER_FI_MINOR_VERSION  VIDEOMANAGER_MAINFI_C_U16_SERVICE_MINORVERSION

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(fc_mediaplayer_tclClientHandler_Videomanager, ahl_tclBaseWork)
    ON_MESSAGE_SVCDATA(VIDEOMANAGER_MAINFI_C_U16_DVD,AMT_C_U8_CCAMSG_OPCODE_STATUS,onDVDSourceStateChange)
END_MSG_MAP()



fc_mediaplayer_tclClientHandler_Videomanager::
fc_mediaplayer_tclClientHandler_Videomanager(fc_mediaplayer_tclApp* poMainAppl) //finished: 100%
    : ahl_tclBaseOneThreadClientHandler(
      /* Application Pointer          */ poMainAppl,
      /* ID of used Service           */ CCA_C_U16_SRV_VIDEO_MANAGER ,
      /* MajorVersion of used Service */ VIDEOMANAGER_FI_MAJOR_VERSION,
      /* MinorVersion of used Service */ VIDEOMANAGER_FI_MINOR_VERSION)
{
    ENTRY
    m_poMainAppInstance = poMainAppl;
    m_bServiceAvailable = false; 
    vAddAutoRegisterForProperty(VIDEOMANAGER_MAINFI_C_U16_DVD);
}

fc_mediaplayer_tclClientHandler_Videomanager::~fc_mediaplayer_tclClientHandler_Videomanager()
{
    ENTRY
    // TODO Auto-generated destructor stub
}

tVoid fc_mediaplayer_tclClientHandler_Videomanager::onDVDSourceStateChange(amt_tclServiceData* poMessage)
{
    ENTRY
    //Create Object of Visitor Message
      fi_tclVisitorMessage oVisitorMsg(poMessage);

      //Create Object of VehicelBTAddress Status
    videomanager_mainfi_tclMsgDVDStatus oFiDataObject;

      //Get Data from Visitor Message
      if( OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObject, VIDEOMANAGER_FI_MAJOR_VERSION))
      {
          tResult  res = MediaPlayerInterface::GetInstance().VideoManagerSourceUpdate(VIDEO_SOURCE_DVD ,((tVideoSourceState)oFiDataObject.DVD_StateInfo.enType));
          ETG_TRACE_USR4((" fc_mediaplayer_tclClientHandler_Videomanager , DVD Status update::%d ",((unsigned int)(oFiDataObject.DVD_StateInfo.enType))));
      }

}

tVoid fc_mediaplayer_tclClientHandler_Videomanager::vOnServiceAvailable()
{
   ETG_TRACE_USR4((" ENTER :fc_mediaplayer_tclClientHandler_Videomanager::vOnServiceAvailable entered. AppID = %u.",u16GetServerAppID()));
   m_bServiceAvailable = true; 

}

tVoid fc_mediaplayer_tclClientHandler_Videomanager::vOnServiceUnavailable()
{


 m_bServiceAvailable = false; 
 ETG_TRACE_USR2(("fc_mediaplayer_tclClientHandler_Videomanager: vOnServiceUnavailable() entered. AppID = %u.",u16GetServerAppID()));


}

tVoid fc_mediaplayer_tclClientHandler_Videomanager::vSendDVDVideoSourceState(bool activeState)
{
    ENTRY
   VARTRACE(activeState)
      tResult result = MP_NO_ERROR;
if(m_bServiceAvailable)
{
 

    //Create Object of GetDevice Info MethodStart
    videomanager_mainfi_tclMsgRequestVideoSourceStateMethodStart startMessage;
    startMessage.tVideoSource.enType = videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_DVD;
    if(activeState == true)
    {
    startMessage.tRequestedState.enType = videomanager_fi_tcl_e8_vdmRequestedSourceState::FI_EN_ACTIVE ;
    }
    else
    {
    startMessage.tRequestedState.enType = videomanager_fi_tcl_e8_vdmRequestedSourceState::FI_EN_INACTIVE ;
    }
    //Create Object of Visitor Message
    fi_tclVisitorMessage oVisitorMsgOutput(startMessage, VIDEOMANAGER_FI_MAJOR_VERSION);
    vInitServiceData (oVisitorMsgOutput,                    // ServiceDataMsg
            0,                                    // CmdCounter
            VIDEOMANAGER_MAINFI_C_U16_REQUESTVIDEOSOURCESTATE,     // Function ID
            AMT_C_U8_CCAMSG_OPCODE_METHODSTART);  //OpCode
    ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);

    // Check for Error after posting message
    if (AIL_EN_N_NO_ERROR != enResult)
    {
        ETG_TRACE_ERR (("Unable to send VideoSourceStateMethodStart ail_tenCommunicationError=%u",(tU32)enResult));
        result = -1;
    }
    else
    {
        //Do nothing.
    }
    startMessage.vDestroy();
}
else
{
	    ETG_TRACE_ERR (("Unable to send  VideoSourceStateMethodStart  , service unavailable"));
        result = -1;
}
    VARTRACE(result)
    return;

}

tVoid fc_mediaplayer_tclClientHandler_Videomanager::vRequestDeserializerforDVD()
{
    ENTRY


    tResult result = MP_NO_ERROR;
if(m_bServiceAvailable)
{
    //Create Object of GetDevice Info MethodStart
    videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodStart startMessage;
    startMessage.tVideoSource.enType = videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_DVD;
    //Create Object of Visitor Message
    fi_tclVisitorMessage oVisitorMsgOutput(startMessage, VIDEOMANAGER_FI_MAJOR_VERSION);
    vInitServiceData (oVisitorMsgOutput,                    // ServiceDataMsg
            0,                                    // CmdCounter
            VIDEOMANAGER_MAINFI_C_U16_REQUESTACCESSTODESERIALIZER,     // Function ID
            AMT_C_U8_CCAMSG_OPCODE_METHODSTART);  //OpCode
    ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);

    // Check for Error after posting message
    if (AIL_EN_N_NO_ERROR != enResult)
    {
        ETG_TRACE_ERR (("Unable to send RequestAccessToDeserializerMethodStart ail_tenCommunicationError=%u",(tU32)enResult));
        result = -1;
    }
    else
    {
        //Do nothing.
    }
    startMessage.vDestroy();
}
else
{
	 ETG_TRACE_ERR (("Unable to send RequestAccessToDeserializerMethodStart , service unavailable"));
     result = -1;
}
    //VARTRACE(result)
    return;

}

tVoid fc_mediaplayer_tclClientHandler_Videomanager::vSendVideoStateAcknowledgement(tVideoSourceState currentState)
{
    ENTRY
    VARTRACE(currentState)
    tResult result = MP_NO_ERROR;
    if(m_bServiceAvailable)
    {
        //Create Object of GetDevice Info MethodStart
        videomanager_mainfi_tclMsgAcknowledgeStateMethodStart startMessage;
        startMessage.tVideoSource.enType = videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_DVD;
        startMessage.tVideoState.enType = (videomanager_fi_tcl_e8_vdmSourceState::tenType)currentState ;

        //Create Object of Visitor Message
        fi_tclVisitorMessage oVisitorMsgOutput(startMessage, VIDEOMANAGER_FI_MAJOR_VERSION);
        vInitServiceData (oVisitorMsgOutput,                    // ServiceDataMsg
                0,                                    // CmdCounter
                VIDEOMANAGER_MAINFI_C_U16_ACKNOWLEDGESTATE,  // Function ID
                AMT_C_U8_CCAMSG_OPCODE_METHODSTART);  //OpCode
        ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);

        // Check for Error after posting message
        if (AIL_EN_N_NO_ERROR != enResult)
        {
            ETG_TRACE_ERR (("Unable to send AcknowledgeStateMethodStart ail_tenCommunicationError=%u",(tU32)enResult));
            result = -1;
        }
        else
        {
           //Do nothing.
        }
        startMessage.vDestroy();
    }
    else
    {
        ETG_TRACE_ERR (("Unable to send  AcknowledgeStateMethodStart  , service unavailable"));
        result = -1;
    }
    VARTRACE(result)
    return;
}