/*
 * FC_MediaPlayer_clienthandler_GenTelephone.cpp
 *
 *  Created on: Mar 01, 2017
 *      Author: vvs7cob
 */
/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_CLIENTHANDLER_BTSETTINGS
#include "trcGenProj/Header/FC_MediaPlayer_clienthandler_GenTelephone.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_CLIENTHANDLER_BTSETTINGS
#endif

#include "FC_MediaPlayer_main.h"
#include "FC_MediaPlayer_clienthandler_GenTelephone.h"
#include "MediaPlayerInterface.h"
#include "FunctionTracer.h"
#include "LocalSPM.h"
#include "VarTrace.h"

// Version defines for used service
#define TELEPHONE_FI_MAJOR_VERSION  MOST_TELFI_C_U16_SERVICE_MAJORVERSION
#define TELEPHONE_FI_MINOR_VERSION  MOST_TELFI_C_U16_SERVICE_MINORVERSION

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(fc_mediaplayer_tclClientHandler_GenTelephone, ahl_tclBaseWork)
    ON_MESSAGE_SVCDATA(MOST_TELFI_C_U16_BTDEVICEVOICERECOGNITIONEXTENDED,AMT_C_U8_CCAMSG_OPCODE_STATUS,onBTDeviceVoiceRecognitionExtended)  
END_MSG_MAP()



fc_mediaplayer_tclClientHandler_GenTelephone::
fc_mediaplayer_tclClientHandler_GenTelephone(fc_mediaplayer_tclApp* poMainAppl) //finished: 100%
    : ahl_tclBaseOneThreadClientHandler(
      /* Application Pointer          */ poMainAppl,
      /* ID of used Service           */ CCA_C_U16_SRV_FB_TELEPHONE,
      /* MajorVersion of used Service */ TELEPHONE_FI_MAJOR_VERSION,
      /* MinorVersion of used Service */ TELEPHONE_FI_MINOR_VERSION)
{
    ENTRY
    m_poMainAppInstance = poMainAppl;
    _tclRegisterPair.bAddPair(AMT_C_U32_STATE_OFF, AMT_C_U32_STATE_NORMAL);
    _tclUnregisterPair.bAddPair(AMT_C_U32_STATE_NORMAL, AMT_C_U32_STATE_OFF);

    vAddAutoRegisterForProperty(MOST_TELFI_C_U16_BTDEVICEVOICERECOGNITIONEXTENDED);
}

fc_mediaplayer_tclClientHandler_GenTelephone::~fc_mediaplayer_tclClientHandler_GenTelephone()
{
    ENTRY
    // TODO Auto-generated destructor stub
}

tVoid fc_mediaplayer_tclClientHandler_GenTelephone::onBTDeviceVoiceRecognitionExtended(amt_tclServiceData* poMessage)
{
    ENTRY
    //Create Object of Visitor Message
      fi_tclVisitorMessage oVisitorMsg(poMessage);

      //Create Object of VehicelBTAddress Status
    most_telfi_tclMsgBTDeviceVoiceRecognitionExtendedStatus oFiDataObject;

      //Get Data from Visitor Message
      if( OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObject, TELEPHONE_FI_MAJOR_VERSION))
      {
        MediaPlayerInterface::GetInstance().UpdateVRSessionStatus(oFiDataObject.bBTDeviceVoiceRecActive, (tSiriStatus)oFiDataObject.e8SiriAvailabilityState.enType,oFiDataObject.bBTDeviceVoiceRecSupported);
      }

}

tVoid fc_mediaplayer_tclClientHandler_GenTelephone::vOnServiceAvailable()
{
   ETG_TRACE_USR4((" ENTER :fc_mediaplayer_tclClientHandler_GenTelephone::vOnServiceAvailable entered. AppID = %u.",u16GetServerAppID()));


}

tVoid fc_mediaplayer_tclClientHandler_GenTelephone::vOnServiceUnavailable()
{


  ETG_TRACE_USR2(("fc_mediaplayer_tclClientHandler_GenTelephone: vOnServiceUnavailable() entered. AppID = %u.",u16GetServerAppID()));


}
