/*
 * FC_MediaPlayer_clienthandler_GenBTSettings.cpp
 *
 *  Created on: Nov 7, 2013
 *      Author: din3kor
 */

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_CLIENTHANDLER_BTSETTINGS
#include "trcGenProj/Header/FC_MediaPlayer_clienthandler_GenBTSettings.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_CLIENTHANDLER_BTSETTINGS
#endif

#include "FC_MediaPlayer_main.h"
#include "FC_MediaPlayer_clienthandler_GenBTSettings.h"
#include "MediaPlayerInterface.h"
#include "FunctionTracer.h"
#include "LocalSPM.h"
#include "VarTrace.h"

//#define DISABLE_DTY_BLUETOOTH
//#define IGNORE_DEVICE_NO_CHANGE
#if defined VARIANT_S_FTR_ENABLE_GM || defined VARIANT_S_FTR_ENABLE_JAC || defined VARIANT_S_FTR_ENABLE_CAF
#else
#define USE_BTSETTINGS_FI_EXTENDED
#endif

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/

// Version defines for used service
#define BTSETTINGS_FI_MAJOR_VERSION  MOST_BTSETFI_C_U16_SERVICE_MAJORVERSION
#define BTSETTINGS_FI_MINOR_VERSION  MOST_BTSETFI_C_U16_SERVICE_MINORVERSION

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(fc_mediaplayer_tclClientHandler_GenBTSettings, ahl_tclBaseWork)
#ifdef USE_BTSETTINGS_FI_EXTENDED
ON_MESSAGE_SVCDATA(MOST_BTSETFI_C_U16_DEVICELISTEXTENDED,AMT_C_U8_CCAMSG_OPCODE_STATUS,onDeviceListStatusExtended)
ON_MESSAGE_SVCDATA(MOST_BTSETFI_C_U16_SPPSERVICECONNECTION,AMT_C_U8_CCAMSG_OPCODE_STATUS,onSPPServiceConnection)
ON_MESSAGE_SVCDATA(MOST_BTSETFI_C_U16_CONNECTSPPSERVICE,AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,onConnectSPPServiceMethodResult)
ON_MESSAGE_SVCDATA(MOST_BTSETFI_C_U16_CONNECTSPPSERVICE,AMT_C_U8_CCAMSG_OPCODE_ERROR,onConnectSPPServiceMethodError)
ON_MESSAGE_SVCDATA(MOST_BTSETFI_C_U16_DISCONNECTSPPSERVICE,AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,onDisconnectSPPServiceMethodResult)
ON_MESSAGE_SVCDATA(MOST_BTSETFI_C_U16_DISCONNECTSPPSERVICE,AMT_C_U8_CCAMSG_OPCODE_ERROR,onDisconnectSPPServiceMethodError)
ON_MESSAGE_SVCDATA(MOST_BTSETFI_C_U16_ADDOOBPAIREDDEVICE,AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,onAddOobPairedDeviceMethodResult)
ON_MESSAGE_SVCDATA(MOST_BTSETFI_C_U16_ADDOOBPAIREDDEVICE,AMT_C_U8_CCAMSG_OPCODE_ERROR,onAddOobPairedDeviceMethodError)
#else
ON_MESSAGE_SVCDATA(MOST_BTSETFI_C_U16_DEVICELIST,AMT_C_U8_CCAMSG_OPCODE_STATUS,onDeviceListStatus)
#endif
ON_MESSAGE_SVCDATA(MOST_BTSETFI_C_U16_VEHICLEBTADDRESS,AMT_C_U8_CCAMSG_OPCODE_STATUS,onVehicleBTAddress)
ON_MESSAGE_SVCDATA(MOST_BTSETFI_C_U16_GETDEVICEINFOEXTENDED,AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,onGetDeviceInfoMethodResult)
ON_MESSAGE_SVCDATA(MOST_BTSETFI_C_U16_BLUETOOTHAUDIOSOURCE,AMT_C_U8_CCAMSG_OPCODE_STATUS,onBluetoothAudioSource)
ON_MESSAGE_SVCDATA(MOST_BTSETFI_C_U16_BLUETOOTHLIMITATIONMODE,AMT_C_U8_CCAMSG_OPCODE_STATUS,onBluetoothLimitationMode)
ON_MESSAGE_SVCDATA(MOST_BTSETFI_C_U16_VEHICLEBTFRIENDLYNAME,AMT_C_U8_CCAMSG_OPCODE_STATUS,onVehicleBTFriendlyName)

END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
 *
 * FUNCTION: fc_mediaplayer_tclClientHandler_GenBTSettings::fc_mediaplayer_tclClientHandler_GenBTSettings(fc_mediaplayer_tclApp* poMainAppl)
 *
 * DESCRIPTION: Constructor.
 *
 *              Create an object of the base class
 *              ahl_tclBaseOneThreadClientHandler with a pointer to this
 *              application, the to be used service identifier and the service
 *              version as parameters.
 *
 * PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/
fc_mediaplayer_tclClientHandler_GenBTSettings::
fc_mediaplayer_tclClientHandler_GenBTSettings(fc_mediaplayer_tclApp* poMainAppl) //finished: 100%
: ahl_tclBaseOneThreadClientHandler(
        /* Application Pointer          */ poMainAppl,
        /* ID of used Service           */ CCA_C_U16_SRV_FB_BLUETOOTHSETTINGS,
        /* MajorVersion of used Service */ BTSETTINGS_FI_MAJOR_VERSION,
        /* MinorVersion of used Service */ BTSETTINGS_FI_MINOR_VERSION )
{
    ENTRY
    m_poMainAppInstance = poMainAppl;
    _tclRegisterPair.bAddPair(AMT_C_U32_STATE_OFF, AMT_C_U32_STATE_NORMAL);
    _tclUnregisterPair.bAddPair(AMT_C_U32_STATE_NORMAL, AMT_C_U32_STATE_OFF);

#ifdef USE_BTSETTINGS_FI_EXTENDED
    vAddAutoRegisterForProperty(MOST_BTSETFI_C_U16_DEVICELISTEXTENDED);
    vAddAutoRegisterForProperty(MOST_BTSETFI_C_U16_SPPSERVICECONNECTION);
#else
    vAddAutoRegisterForProperty(MOST_BTSETFI_C_U16_DEVICELIST);
#endif
    vAddAutoRegisterForProperty(MOST_BTSETFI_C_U16_VEHICLEBTADDRESS);
    vAddAutoRegisterForProperty(MOST_BTSETFI_C_U16_BLUETOOTHAUDIOSOURCE);
    vAddAutoRegisterForProperty(MOST_BTSETFI_C_U16_BLUETOOTHLIMITATIONMODE);
    vAddAutoRegisterForProperty(MOST_BTSETFI_C_U16_VEHICLEBTFRIENDLYNAME);
    mOobbtDeviceID = DEVICE_ID_NOT_SET;
}

/*******************************************************************************
 *
 * FUNCTION: fc_mediaplayer_tclClientHandler_GenBTSettings::
 *             ~fc_mediaplayer_tclClientHandler_GenBTSettings(tVoid)
 *
 * DESCRIPTION: Destructor.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/
fc_mediaplayer_tclClientHandler_GenBTSettings::~fc_mediaplayer_tclClientHandler_GenBTSettings(tVoid)  //finished: 100%
{
    ENTRY
}

tVoid fc_mediaplayer_tclClientHandler_GenBTSettings::onVehicleBTAddress(amt_tclServiceData* poMessage)
{
    ENTRY
    //Create Object of Visitor Message
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    //Create Object of VehicelBTAddress Status
    most_btsetfi_tclMsgVehicleBTAddressStatus oFiDataObject;

    //Get Data from Visitor Message
    if( OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObject, BTSETTINGS_FI_MAJOR_VERSION))
    {

        tBTMACAddress address;
        //tUserContext userContext;
        strncpy_r(address, oFiDataObject.sVehicleBTAddress.szValue, sizeof (address));
        VARTRACE(address)
        if (address[0] != '\0')  // store new BT address only if valid
        {
            MediaPlayerInterface::GetInstance().SetVehicleBTAddress(IN address);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    oFiDataObject.vDestroy();
}

tVoid fc_mediaplayer_tclClientHandler_GenBTSettings::onVehicleBTFriendlyName(amt_tclServiceData* poMessage)
{
    ENTRY
    //Create Object of Visitor Message
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    //Create Object of VehicelBTAddress Status
    most_btsetfi_tclMsgVehicleBTFriendlyNameStatus oFiDataObject;

    //Get Data from Visitor Message
    if( OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObject, BTSETTINGS_FI_MAJOR_VERSION))
    {
        tBTVehicleFriendlyName friendlyName;
        strncpy_r(friendlyName, oFiDataObject.sVehicleBTFriendlyName.szValue, sizeof(friendlyName));
        VARTRACE(friendlyName)
        if (friendlyName[0] != '\0')  // store new BT friendly name only if valid
        {
            LocalSPM::GetDataProvider().iPodControlAccessoryInfoBTName = friendlyName;
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    oFiDataObject.vDestroy();
}

#ifdef USE_BTSETTINGS_FI_EXTENDED
tVoid fc_mediaplayer_tclClientHandler_GenBTSettings::onDeviceListStatusExtended(amt_tclServiceData* poMessage)
{
    ENTRY
    bool isKnownDevice = false;
    //Create Object of Visitor Message
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    //Create Object of DeviceList Status
    most_btsetfi_tclMsgDeviceListExtendedStatus oFiDataObject;

    /*  most_btsetfi_tclMsgDeviceListExtendedStatus
     *    1.most_fi_tcl_BTSetDeviceListChangeExtended oDeviceListChange;
     *      1.1 tU8 u8DeviceHandle;
     *      1.2 most_fi_tcl_e8_BTSetDeviceStatus e8DeviceStatus;
     *          enum tenType {
     *                      FI_EN_E8DEVICE_CONNECTED = 0UL,
     *                      FI_EN_E8DEVICE_CONNECTED_OSD = 1UL,
     *                      FI_EN_E8DEVICE_DISCONNECTED = 2UL,
     *                      FI_EN_E8DEVICE_CHANGED_TO_OSD = 3UL,
     *                      FI_EN_E8DEVICE_DELETED = 4UL,
     *                      FI_EN_E8DEVICE_NO_CHANGE = 5UL
     *          };
     *      1.3 most_fi_tcl_e8_BTSetDeviceDisconnectedReason e8DeviceDisconnectedReason;
     *          enum tenType {
     *                      FI_EN_E8NOT_APPLICABLE = 0UL,
     *                      FI_EN_E8DEVICE_REQUEST = 1UL,
     *                      FI_EN_E8MODULE_REQUEST = 2UL,
     *                      FI_EN_E8AUTOMATIC = 3UL,
     *                      FI_EN_E8OUT_OF_RANGE = 4UL,
     *                      FI_EN_E8INTERMEDIATE = 5UL
     *          };
     *
     *    2.tU8 u8NumPairedDevices;
     *    3.most_fi_tcl_BTSetDeviceListExtendedResult oDeviceListExtendedResult;
     *      3.1  most_fi_tcl_BTSetDeviceListResultItem
     *           3.1.1 tU8 u8DeviceHandle;
     *           3.1.2 most_fi_tcl_String sDeviceName;
     *           3.1.3 tBool bDeviceConnectedStatus;
     *           3.1.4 tBool bOutgoingSourceDeviceStatus;
     *           3.1.5 most_fi_tcl_BTSetDateTimeStamp oDateTimeStamp;
     */

    //Get Data from Visitor Message
    if( OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObject, BTSETTINGS_FI_MAJOR_VERSION))
    {
        ETG_TRACE_USR1(("most_btsetfi_tclMsgDeviceListStatus"));

        ETG_TRACE_USR1(("1.most_fi_tcl_BTSetDeviceListChange"));
        ETG_TRACE_USR1(("1.1 u8DeviceHandle : %d , 2 u8NumPairedDevices : %d",oFiDataObject.oDeviceListChange.u8DeviceHandle,oFiDataObject.u8NumPairedDevices));
        switch(oFiDataObject.oDeviceListChange.e8DeviceStatus.enType)
        {
            case most_fi_tcl_e8_BTSetDeviceStatus::FI_EN_E8DEVICE_CONNECTED:
                ETG_TRACE_USR1(("1.2 most_fi_tcl_e8_BTSetDeviceStatus : FI_EN_E8DEVICE_CONNECTED"));
                break;
            case most_fi_tcl_e8_BTSetDeviceStatus::FI_EN_E8DEVICE_CONNECTED_OSD:
                ETG_TRACE_USR1(("1.2 most_fi_tcl_e8_BTSetDeviceStatus : FI_EN_E8DEVICE_CONNECTED_OSD"));
                break;
            case most_fi_tcl_e8_BTSetDeviceStatus::FI_EN_E8DEVICE_DISCONNECTED:
                ETG_TRACE_USR1(("1.2 most_fi_tcl_e8_BTSetDeviceStatus : FI_EN_E8DEVICE_DISCONNECTED"));
                break;
            case most_fi_tcl_e8_BTSetDeviceStatus::FI_EN_E8DEVICE_CHANGED_TO_OSD:
                ETG_TRACE_USR1(("1.2 most_fi_tcl_e8_BTSetDeviceStatus : FI_EN_E8DEVICE_CHANGED_TO_OSD"));
                break;
            case most_fi_tcl_e8_BTSetDeviceStatus::FI_EN_E8DEVICE_DELETED:
                ETG_TRACE_USR1(("1.2 most_fi_tcl_e8_BTSetDeviceStatus : FI_EN_E8DEVICE_DELETED"));
                break;
            case most_fi_tcl_e8_BTSetDeviceStatus::FI_EN_E8DEVICE_NO_CHANGE:
                ETG_TRACE_USR1(("1.2 most_fi_tcl_e8_BTSetDeviceStatus : FI_EN_E8DEVICE_NO_CHANGE"));
                break;
            default:
                break;
        }

#ifdef IGNORE_DEVICE_NO_CHANGE
        if(most_fi_tcl_e8_BTSetDeviceStatus::FI_EN_E8DEVICE_NO_CHANGE == oFiDataObject.oDeviceListChange.e8DeviceStatus.enType)
        {
            ETG_TRACE_USR1(("IGNORING DeviceListStatus Property Update"));
            oFiDataObject.vDestroy();
            return;
        }
#endif

        ETG_TRACE_USR1(("3 most_fi_tcl_BTSetDeviceListExtendedResult"));
        tUInt deviceIter = 0;
        for( deviceIter = 0; deviceIter < oFiDataObject.oDeviceListExtendedResult.oItems.size(); deviceIter++)
        {
            most_fi_tcl_BTSetDeviceListExtendedResultItem& oMostFI_BTDeviceItem = oFiDataObject.oDeviceListExtendedResult.oItems.at(deviceIter);
            ETG_TRACE_USR1(("most_fi_tcl_BTSetDeviceListExtendedResultItem [%d]-> u8DeviceHandle:%d , bDeviceConnectedStatus:%d , bAVP:%d ,bHFP:%d , sDeviceName:%s ",deviceIter,oMostFI_BTDeviceItem.u8DeviceHandle,oMostFI_BTDeviceItem.bDeviceConnectedStatus,oMostFI_BTDeviceItem.oDeviceProfileStatus.bAVP,oMostFI_BTDeviceItem.oDeviceProfileStatus.bHFP,oMostFI_BTDeviceItem.sDeviceName.szValue));
            /*save the device information if not already exists in the known device list*/
            if(mKnownDevices.find(oMostFI_BTDeviceItem.u8DeviceHandle) == mKnownDevices.end())
            {
                tBluetoothDevice btDevice;
                InitBluetoothDevice(btDevice);
                btDevice.deviceHandle = oMostFI_BTDeviceItem.u8DeviceHandle;
                mKnownDevices[oMostFI_BTDeviceItem.u8DeviceHandle] = btDevice;
                isKnownDevice = false;
            }
            else
            {
                isKnownDevice = true;
            }

            /* update the available device information in the known device list*/
            mKnownDevices[oMostFI_BTDeviceItem.u8DeviceHandle].isConnected  = oMostFI_BTDeviceItem.bDeviceConnectedStatus;
            strncpy_r(mKnownDevices[oMostFI_BTDeviceItem.u8DeviceHandle].deviceName, oMostFI_BTDeviceItem.sDeviceName.szValue, sizeof (mKnownDevices[oMostFI_BTDeviceItem.u8DeviceHandle].deviceName));
            strncpy_r(mKnownDevices[oMostFI_BTDeviceItem.u8DeviceHandle].deviceAddress , oMostFI_BTDeviceItem.sDeviceAddress.szValue, sizeof (mKnownDevices[oMostFI_BTDeviceItem.u8DeviceHandle].deviceAddress));
            mKnownDevices[oMostFI_BTDeviceItem.u8DeviceHandle].isAVPConnected = oMostFI_BTDeviceItem.oDeviceProfileStatus.bAVP;
            mKnownDevices[oMostFI_BTDeviceItem.u8DeviceHandle].isHFPConnected = oMostFI_BTDeviceItem.oDeviceProfileStatus.bHFP;
            mKnownDevices[oMostFI_BTDeviceItem.u8DeviceHandle].isSPPProfileSupported = oMostFI_BTDeviceItem.oDeviceSupportedProfiles.bSPPSupport;
            mKnownDevices[oMostFI_BTDeviceItem.u8DeviceHandle].isVendorInfoPresent = (oMostFI_BTDeviceItem.oDeviceInfo.u16VendorIDSource != 0 && oMostFI_BTDeviceItem.oDeviceInfo.u16VendorID != 0 );

            tDisconnectReason disconnectReason = DR_REMOVED;
            switch(oMostFI_BTDeviceItem.e8DeviceDisconnectedReason.enType)
            {
                case most_fi_tcl_e8_BTSetDeviceDisconnectedReason::FI_EN_E8NOT_APPLICABLE:
                    ETG_TRACE_USR1(("1.3 most_fi_tcl_e8_BTSetDeviceDisconnectedReason : FI_EN_E8NOT_APPLICABLE"));
                    disconnectReason = DR_NOT_APPLICABLE;
                    break;
                case most_fi_tcl_e8_BTSetDeviceDisconnectedReason::FI_EN_E8DEVICE_REQUEST:
                    ETG_TRACE_USR1(("1.3 most_fi_tcl_e8_BTSetDeviceDisconnectedReason : FI_EN_E8DEVICE_REQUEST"));
                    disconnectReason = DR_DEVICE_REQUEST;
                    break;
                case most_fi_tcl_e8_BTSetDeviceDisconnectedReason::FI_EN_E8MODULE_REQUEST:
                    ETG_TRACE_USR1(("1.3 most_fi_tcl_e8_BTSetDeviceDisconnectedReason : FI_EN_E8MODULE_REQUEST"));
                    disconnectReason = DR_MODULE_REQUEST;
                    break;
                case most_fi_tcl_e8_BTSetDeviceDisconnectedReason::FI_EN_E8AUTOMATIC:
                    ETG_TRACE_USR1(("1.3 most_fi_tcl_e8_BTSetDeviceDisconnectedReason : FI_EN_E8AUTOMATIC"));
                    disconnectReason = DR_AUTOMATIC;
                    break;
                case most_fi_tcl_e8_BTSetDeviceDisconnectedReason::FI_EN_E8OUT_OF_RANGE:
                    ETG_TRACE_USR1(("1.3 most_fi_tcl_e8_BTSetDeviceDisconnectedReason : FI_EN_E8OUT_OF_RANGE"));
                    disconnectReason = DR_OUT_OF_RANGE;
                    break;
                case most_fi_tcl_e8_BTSetDeviceDisconnectedReason::FI_EN_E8INTERMEDIATE:
                    ETG_TRACE_USR1(("1.3 most_fi_tcl_e8_BTSetDeviceDisconnectedReason : FI_EN_E8INTERMEDIATE"));
                    disconnectReason = DR_INTERNALDISCONNECT;
                    break;
                case most_fi_tcl_e8_BTSetDeviceDisconnectedReason::FI_EN_E8CONNECT_TIMEOUT:
                    ETG_TRACE_USR1(("1.3 most_fi_tcl_e8_BTSetDeviceDisconnectedReason : FI_EN_E8CONNECT_TIMEOUT"));
                    disconnectReason = DR_CONNECT_TIMEOUT;
                    break;
                case most_fi_tcl_e8_BTSetDeviceDisconnectedReason::FI_EN_E8CONNECT_REJECTED:
                    ETG_TRACE_USR1(("1.3 most_fi_tcl_e8_BTSetDeviceDisconnectedReason : FI_EN_E8CONNECT_REJECTED"));
                    disconnectReason = DR_CONNECT_REJECTED;
                    break;
                case most_fi_tcl_e8_BTSetDeviceDisconnectedReason::FI_EN_E8PROTOCOL_NOT_SUPPORTED:
                    ETG_TRACE_USR1(("1.3 most_fi_tcl_e8_BTSetDeviceDisconnectedReason : FI_EN_E8PROTOCOL_NOT_SUPPORTED"));
                    disconnectReason = DR_PROTOCOL_NOT_SUPPORTED;
                    break;
                case most_fi_tcl_e8_BTSetDeviceDisconnectedReason::FI_EN_E8CONNECT_FAILED:
                    ETG_TRACE_USR1(("1.3 most_fi_tcl_e8_BTSetDeviceDisconnectedReason : FI_EN_E8CONNECT_FAILED"));
                    disconnectReason = DR_CONNECT_FAILED;
                    break;
                default:
                    break;
            }

            tDisconnectReason AVPdisconnectReason = DR_REMOVED;
            switch(oMostFI_BTDeviceItem.oDeviceProfileDisconnectedReason.e8AVP.enType)
            {
                case most_fi_tcl_e8_BTSetDeviceDisconnectedReason::FI_EN_E8NOT_APPLICABLE:
                    ETG_TRACE_USR1(("1.4 AVP profile most_fi_tcl_e8_BTSetDeviceDisconnectedReason : FI_EN_E8NOT_APPLICABLE"));
                    AVPdisconnectReason = DR_NOT_APPLICABLE;
                    break;
                case most_fi_tcl_e8_BTSetDeviceDisconnectedReason::FI_EN_E8DEVICE_REQUEST:
                    ETG_TRACE_USR1(("1.4 AVP profile most_fi_tcl_e8_BTSetDeviceDisconnectedReason : FI_EN_E8DEVICE_REQUEST"));
                    AVPdisconnectReason = DR_DEVICE_REQUEST;
                    break;
                case most_fi_tcl_e8_BTSetDeviceDisconnectedReason::FI_EN_E8MODULE_REQUEST:
                    ETG_TRACE_USR1(("1.4 AVP profile most_fi_tcl_e8_BTSetDeviceDisconnectedReason : FI_EN_E8MODULE_REQUEST"));
                    AVPdisconnectReason = DR_MODULE_REQUEST ;
                    break;
                case most_fi_tcl_e8_BTSetDeviceDisconnectedReason::FI_EN_E8AUTOMATIC:
                    ETG_TRACE_USR1(("1.4 AVP profile most_fi_tcl_e8_BTSetDeviceDisconnectedReason : FI_EN_E8AUTOMATIC"));
                    AVPdisconnectReason = DR_AUTOMATIC;
                    break;
                case most_fi_tcl_e8_BTSetDeviceDisconnectedReason::FI_EN_E8OUT_OF_RANGE:
                    ETG_TRACE_USR1(("1.4 AVP profile most_fi_tcl_e8_BTSetDeviceDisconnectedReason : FI_EN_E8OUT_OF_RANGE"));
                    AVPdisconnectReason = DR_OUT_OF_RANGE;
                    break;
                case most_fi_tcl_e8_BTSetDeviceDisconnectedReason::FI_EN_E8INTERMEDIATE:
                    ETG_TRACE_USR1(("1.4 AVP profile most_fi_tcl_e8_BTSetDeviceDisconnectedReason : FI_EN_E8INTERMEDIATE"));
                    AVPdisconnectReason = DR_INTERNALDISCONNECT;
                    break;
                case most_fi_tcl_e8_BTSetDeviceDisconnectedReason::FI_EN_E8CONNECT_TIMEOUT:
                    ETG_TRACE_USR1(("1.4 AVP profile most_fi_tcl_e8_BTSetDeviceDisconnectedReason : FI_EN_E8CONNECT_TIMEOUT"));
                    AVPdisconnectReason = DR_CONNECT_TIMEOUT;
                    break;
                case most_fi_tcl_e8_BTSetDeviceDisconnectedReason::FI_EN_E8CONNECT_REJECTED:
                    ETG_TRACE_USR1(("1.4 AVP profile most_fi_tcl_e8_BTSetDeviceDisconnectedReason : FI_EN_E8CONNECT_REJECTED"));
                    AVPdisconnectReason = DR_CONNECT_REJECTED;
                    break;
                case most_fi_tcl_e8_BTSetDeviceDisconnectedReason::FI_EN_E8PROTOCOL_NOT_SUPPORTED:
                    ETG_TRACE_USR1(("1.4 AVP profile most_fi_tcl_e8_BTSetDeviceDisconnectedReason : FI_EN_E8PROTOCOL_NOT_SUPPORTED"));
                    AVPdisconnectReason = DR_PROTOCOL_NOT_SUPPORTED;
                    break;
                case most_fi_tcl_e8_BTSetDeviceDisconnectedReason::FI_EN_E8CONNECT_FAILED:
                    ETG_TRACE_USR1(("1.4 AVP profile most_fi_tcl_e8_BTSetDeviceDisconnectedReason : FI_EN_E8CONNECT_FAILED"));
                    AVPdisconnectReason = DR_CONNECT_FAILED;
                    break;
                default:
                    break;
            }

            /* set disconnect reason of changed device */
            /* Check AVP profile connection status also. */
            if(oMostFI_BTDeviceItem.bDeviceConnectedStatus && oMostFI_BTDeviceItem.oDeviceProfileStatus.bAVP)
            {
                mKnownDevices[oMostFI_BTDeviceItem.u8DeviceHandle].disconnectReason = DR_REMOVED;
            }
            else
            {
                /* use oDeviceProfileDisconnectedReason, if AVP profile only disconnected */
                if(!oMostFI_BTDeviceItem.bDeviceConnectedStatus)
                {
                    mKnownDevices[oMostFI_BTDeviceItem.u8DeviceHandle].disconnectReason = disconnectReason;
                    mKnownDevices[oMostFI_BTDeviceItem.u8DeviceHandle].sppConnectionStatus = SPP_STATUS_UNKNOWN;
                }
                else
                {
                    mKnownDevices[oMostFI_BTDeviceItem.u8DeviceHandle].disconnectReason = AVPdisconnectReason;
                }
            }

            if(mKnownDevices[oMostFI_BTDeviceItem.u8DeviceHandle].isConnected)
            {
                SendGetDeviceInfoMethod(oMostFI_BTDeviceItem.u8DeviceHandle);
            }
            else if(isKnownDevice)
            {
                ETG_TRACE_USR1(("Update DeviceInfo for device with handle : %d " , oMostFI_BTDeviceItem.u8DeviceHandle));
                UpdateDeviceInfo(oMostFI_BTDeviceItem.u8DeviceHandle);
            }
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    oFiDataObject.vDestroy();
}

#else

tVoid fc_mediaplayer_tclClientHandler_GenBTSettings::onDeviceListStatus(amt_tclServiceData* poMessage)
{
    ENTRY
    //Create Object of Visitor Message
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    most_btsetfi_tclMsgDeviceListStatus oFiDataObject;

    /*  most_btsetfi_tclMsgDeviceListStatus
     *    1.most_fi_tcl_BTSetDeviceListChange oDeviceListChange;
     *      1.1 tU8 u8DeviceHandle;
     *      1.2 most_fi_tcl_e8_BTSetDeviceStatus e8DeviceStatus;
     *          enum tenType {
     *                      FI_EN_E8DEVICE_CONNECTED = 0UL,
     *                      FI_EN_E8DEVICE_CONNECTED_OSD = 1UL,
     *                      FI_EN_E8DEVICE_DISCONNECTED = 2UL,
     *                      FI_EN_E8DEVICE_CHANGED_TO_OSD = 3UL,
     *                      FI_EN_E8DEVICE_DELETED = 4UL,
     *                      FI_EN_E8DEVICE_NO_CHANGE = 5UL
     *          };
     *
     *    2.tU8 u8NumPairedDevices;
     *    3.most_fi_tcl_BTSetDeviceListResult oDeviceListResult;
     *      3.1  most_fi_tcl_BTSetDeviceListResultItem
     *           3.1.1 tU8 u8DeviceHandle;
     *           3.1.2 most_fi_tcl_String sDeviceName;
     *           3.1.3 tBool bDeviceConnectedStatus;
     *           3.1.4 tBool bOutgoingSourceDeviceStatus;
     *           3.1.5 most_fi_tcl_BTSetDateTimeStamp oDateTimeStamp;
     */

    //Get Data from Visitor Messagemost_fi_tcl_BTSetDeviceListExtendedResultItem& oMostFI_BTDeviceItem = oFiDataObject.oDeviceListExtendedResult.oItems.at(deviceIter);
    if( OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObject, BTSETTINGS_FI_MAJOR_VERSION))
    {
        ETG_TRACE_USR1(("most_btsetfi_tclMsgDeviceListStatus"));

        ETG_TRACE_USR1(("1.most_fi_tcl_BTSetDeviceListChange"));
        ETG_TRACE_USR1(("1.1 u8DeviceHandle : %d , 2 u8NumPairedDevices : %d",oFiDataObject.oDeviceListChange.u8DeviceHandle,oFiDataObject.u8NumPairedDevices));
        switch(oFiDataObject.oDeviceListChange.e8DeviceStatus.enType)
        {
            case most_fi_tcl_e8_BTSetDeviceStatus::FI_EN_E8DEVICE_CONNECTED:
                ETG_TRACE_USR1(("1.2 most_fi_tcl_e8_BTSetDeviceStatus : FI_EN_E8DEVICE_CONNECTED"));
                break;
            case most_fi_tcl_e8_BTSetDeviceStatus::FI_EN_E8DEVICE_CONNECTED_OSD:
                ETG_TRACE_USR1(("1.2 most_fi_tcl_e8_BTSetDeviceStatus : FI_EN_E8DEVICE_CONNECTED_OSD"));
                break;
            case most_fi_tcl_e8_BTSetDeviceStatus::FI_EN_E8DEVICE_DISCONNECTED:
                ETG_TRACE_USR1(("1.2 most_fi_tcl_e8_BTSetDeviceStatus : FI_EN_E8DEVICE_DISCONNECTED"));
                break;
            case most_fi_tcl_e8_BTSetDeviceStatus::FI_EN_E8DEVICE_CHANGED_TO_OSD:
                ETG_TRACE_USR1(("1.2 most_fi_tcl_e8_BTSetDeviceStatus : FI_EN_E8DEVICE_CHANGED_TO_OSD"));
                break;
            case most_fi_tcl_e8_BTSetDeviceStatus::FI_EN_E8DEVICE_DELETED:
                ETG_TRACE_USR1(("1.2 most_fi_tcl_e8_BTSetDeviceStatus : FI_EN_E8DEVICE_DELETED"));
                break;
            case most_fi_tcl_e8_BTSetDeviceStatus::FI_EN_E8DEVICE_NO_CHANGE:
                ETG_TRACE_USR1(("1.2 most_fi_tcl_e8_BTSetDeviceStatus : FI_EN_E8DEVICE_NO_CHANGE"));
                break;
            default:
                break;
        }

#ifdef IGNORE_DEVICE_NO_CHANGE
        if(most_fi_tcl_e8_BTSetDeviceStatus::FI_EN_E8DEVICE_NO_CHANGE == oFiDataObject.oDeviceListChange.e8DeviceStatus.enType)
        {
            ETG_TRACE_USR1(("IGNORING DeviceListStatus Property Update"));
            oFiDataObject.vDestroy();
            return;
        }
#endif

        ETG_TRACE_USR1(("3 most_fi_tcl_BTSetDeviceListResult"));
        tUInt deviceIter = 0;
        for( deviceIter = 0; deviceIter < oFiDataObject.oDeviceListResult.oItems.size(); deviceIter++)
        {
            most_fi_tcl_BTSetDeviceListResultItem& oMostFI_BTDeviceItem = oFiDataObject.oDeviceListResult.oItems.at(deviceIter);
            ETG_TRACE_USR1(("most_fi_tcl_BTSetDeviceListResultItem [%d]-> u8DeviceHandle:%d , bDeviceConnectedStatus:%d , bOutgoingSourceDeviceStatus:%d , sDeviceName:%s",deviceIter,oMostFI_BTDeviceItem.u8DeviceHandle,oMostFI_BTDeviceItem.bDeviceConnectedStatus,oMostFI_BTDeviceItem.bOutgoingSourceDeviceStatus,oMostFI_BTDeviceItem.sDeviceName.szValue));

            /*save the device information if not already exists in the known device list*/
            if(mKnownDevices.find(oMostFI_BTDeviceItem.u8DeviceHandle) == mKnownDevices.end())
            {
                tBluetoothDevice btDevice;
                InitBluetoothDevice(btDevice);
                btDevice.deviceHandle = oMostFI_BTDeviceItem.u8DeviceHandle;
                mKnownDevices[oMostFI_BTDeviceItem.u8DeviceHandle] = btDevice;
            }

            /* update the available device information in the known device list*/
            mKnownDevices[oMostFI_BTDeviceItem.u8DeviceHandle].isConnected  = oMostFI_BTDeviceItem.bDeviceConnectedStatus;
            strncpy_r(mKnownDevices[oMostFI_BTDeviceItem.u8DeviceHandle].deviceName, oMostFI_BTDeviceItem.sDeviceName.szValue, sizeof (mKnownDevices[oMostFI_BTDeviceItem.u8DeviceHandle].deviceName));
        }

        /*request for the device info which provides the address and capability of the device whose status is changed*/
        ETG_TRACE_USR1(("Request for DeviceInfo for device with handle : %d " , oFiDataObject.oDeviceListChange.u8DeviceHandle));
        SendGetDeviceInfoMethod(oFiDataObject.oDeviceListChange.u8DeviceHandle);
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    oFiDataObject.vDestroy();
}
#endif

tResult fc_mediaplayer_tclClientHandler_GenBTSettings::SendGetDeviceInfoMethod(tU8 u8DeviceHandle)
{
    ENTRY

    //VARTRACE(tBTDeviceHandle)

    tResult result = MP_NO_ERROR;

    //Create Object of GetDevice Info MethodStart
    most_btsetfi_tclMsgGetDeviceInfoExtendedMethodStart startMessage;
    startMessage.u8DeviceHandle = u8DeviceHandle;

    //Create Object of Visitor Message
    fi_tclVisitorMessage oVisitorMsgOutput(startMessage, BTSETTINGS_FI_MAJOR_VERSION);
    vInitServiceData (oVisitorMsgOutput,                    // ServiceDataMsg
            0,                                    // CmdCounter
            MOST_BTSETFI_C_U16_GETDEVICEINFOEXTENDED,     // Function ID
            AMT_C_U8_CCAMSG_OPCODE_METHODSTART);  //OpCode
    ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);

    // Check for Error after posting message
    if (AIL_EN_N_NO_ERROR != enResult)
    {
        ETG_TRACE_ERR (("Unable to send GetDeviceInfo to BTSettings ail_tenCommunicationError=%u",(tU32)enResult));
        result = -1;
    }
    else
    {
        //Do nothing.
    }
    startMessage.vDestroy();

    //VARTRACE(result)
    return result;
}

tVoid fc_mediaplayer_tclClientHandler_GenBTSettings::onGetDeviceInfoMethodResult(amt_tclServiceData* poMessage) //finished: 100%
{
    ENTRY
    tResult result = MP_NO_ERROR;

    //Create Object of DeviceInfo MethodResult
    most_btsetfi_tclMsgGetDeviceInfoExtendedMethodResult oFiDataObject;

    /*  most_btsetfi_tclMsgGetDeviceInfoMethodResult
     *    1.tU8 u8DeviceHandle;
     *
     *    2.most_fi_tcl_e8_BTSetMajorDeviceClass e8MajorDeviceClass;
     *          enum tenType {
                      FI_EN_E8MAJOR_DEVICE_CLASS_PHONE = 0UL,
                      FI_EN_E8MAJOR_DEVICE_CLASS_AUDIOVIDEO = 1UL,
                      FI_EN_E8MAJOR_DEVICE_CLASS_COMPUTER = 2UL,
                      FI_EN_E8MAJOR_DEVICE_CLASS_LANORNAP = 3UL
                };
     *    3.most_fi_tcl_String sBluetoothDeviceAddress;
     *
     *    4.most_fi_tcl_BTSetBluetoothFeatureSupport oBluetoothFeatureSupport;
     *         4.1 tBool bHandsFreeSupport;
     *         4.2 tBool bPhoneBookSupport;
     *         4.3 tBool bAudioStreamingSupport;
     *         4.4 most_fi_tcl_e8_BTSetAudioStreamingSupportType e8AudioStreamingSupportType;
     *             enum tenType
     *             {
                         FI_EN_E8AVRCP_NO_METADATA = 0UL,
                         FI_EN_E8AVRCP_METADATA = 1UL,
                         FI_EN_E8AVRCP_BROWSING = 2UL,
                         FI_EN_E8AVRCP_MYMEDIA = 3UL
                   };
     *         4.5 tBool bMessagingSupport;
     *         4.6 tBool bInternetAccessSupport;
     *         4.7 most_fi_tcl_e8_BTSetInternetAccessSupportType e8InternetAccessSupportType;
     *             enum tenType {
     *                   FI_EN_E8DUN_SUPPORTED = 0UL,
     *                   FI_EN_E8PAN_SUPPORTED = 1UL,
     *                   FI_EN_E8DUN_PAN_SUPPORTED = 2UL
     *             };
     *         4.8 tBool bPortableNavigationSupport;
     *         4.9 tBool bSerialPortSupport;
     *
     */
    ETG_TRACE_USR1(("most_btsetfi_tclMsgGetDeviceInfoExtendedMethodResult"));

    //Create Object of Visitor Message
    fi_tclVisitorMessage oVisitorMsg(poMessage);
    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObject,BTSETTINGS_FI_MAJOR_VERSION))
    {
        mKnownDevices[oFiDataObject.u8DeviceHandle].isAvrcpBrowsable =
                (oFiDataObject.oBluetoothFeatureSupport.e8AudioStreamingSupportType.enType == most_fi_tcl_e8_BTSetAudioStreamingSupportType::FI_EN_E8AVRCP_BROWSING)||
                (oFiDataObject.oBluetoothFeatureSupport.e8AudioStreamingSupportType.enType == most_fi_tcl_e8_BTSetAudioStreamingSupportType::FI_EN_E8AVRCP_MYMEDIA);

        mKnownDevices[oFiDataObject.u8DeviceHandle].isAppleDevice =
                (oFiDataObject.oDeviceIdentification.u16VendorIDSource == 1 && oFiDataObject.oDeviceIdentification.u16VendorID == 0x004C) ||    //BT
                (oFiDataObject.oDeviceIdentification.u16VendorIDSource == 2 && oFiDataObject.oDeviceIdentification.u16VendorID == 0x05AC);       //USB

        ETG_TRACE_USR1(("1. u8DeviceHandle : %d",oFiDataObject.u8DeviceHandle));
        ETG_TRACE_USR1(("2. e8MajorDeviceClass : %d",oFiDataObject.e8MajorDeviceClass.enType));
        ETG_TRACE_USR1(("3. sBluetoothDeviceAddress : %s",oFiDataObject.sBluetoothDeviceAddress.szValue));
        ETG_TRACE_USR1(("4.1 bHandsFreeSupport : %d",oFiDataObject.oBluetoothFeatureSupport.bHandsFreeSupport));
        ETG_TRACE_USR1(("4.2 bPhoneBookSupport : %d",oFiDataObject.oBluetoothFeatureSupport.bPhoneBookSupport));
        ETG_TRACE_USR1(("4.3 bAudioStreamingSupport : %d",oFiDataObject.oBluetoothFeatureSupport.bAudioStreamingSupport));

        switch(oFiDataObject.oBluetoothFeatureSupport.e8AudioStreamingSupportType.enType)
        {
            case most_fi_tcl_e8_BTSetAudioStreamingSupportType::FI_EN_E8AVRCP_NO_METADATA:
                ETG_TRACE_USR1(("4.4 most_fi_tcl_e8_BTSetAudioStreamingSupportType : FI_EN_E8AVRCP_NO_METADATA"));
                strncpy_r(mKnownDevices[oFiDataObject.u8DeviceHandle].deviceVersion,"1.0" , sizeof(mKnownDevices[oFiDataObject.u8DeviceHandle].deviceVersion));//}
                break;
            case most_fi_tcl_e8_BTSetAudioStreamingSupportType::FI_EN_E8AVRCP_METADATA:
                ETG_TRACE_USR1(("4.4 most_fi_tcl_e8_BTSetAudioStreamingSupportType : FI_EN_E8AVRCP_METADATA"));
                strncpy_r(mKnownDevices[oFiDataObject.u8DeviceHandle].deviceVersion,"1.3" , sizeof(mKnownDevices[oFiDataObject.u8DeviceHandle].deviceVersion));
                break;
            case most_fi_tcl_e8_BTSetAudioStreamingSupportType::FI_EN_E8AVRCP_BROWSING:
                ETG_TRACE_USR1(("4.4 most_fi_tcl_e8_BTSetAudioStreamingSupportType : FI_EN_E8AVRCP_BROWSING"));
                strncpy_r(mKnownDevices[oFiDataObject.u8DeviceHandle].deviceVersion,"1.4" , sizeof(mKnownDevices[oFiDataObject.u8DeviceHandle].deviceVersion));
                break;
            case most_fi_tcl_e8_BTSetAudioStreamingSupportType::FI_EN_E8AVRCP_MYMEDIA:
                ETG_TRACE_USR1(("4.4 most_fi_tcl_e8_BTSetAudioStreamingSupportType : FI_EN_E8AVRCP_MYMEDIA"));
                strncpy_r(mKnownDevices[oFiDataObject.u8DeviceHandle].deviceVersion,"1.4" , sizeof(mKnownDevices[oFiDataObject.u8DeviceHandle].deviceVersion));
                break;
            default:
                ETG_TRACE_ERR(("4.4 e8AudioStreamingSupportType:Invalid Enum Value=%d",oFiDataObject.oBluetoothFeatureSupport.e8AudioStreamingSupportType.enType));
                break;
        }

        ETG_TRACE_USR1(("4.5 bMessagingSupport : %d",oFiDataObject.oBluetoothFeatureSupport.bMessagingSupport));
        ETG_TRACE_USR1(("4.6 bInternetAccessSupport : %d",oFiDataObject.oBluetoothFeatureSupport.bInternetAccessSupport));
        ETG_TRACE_USR1(("4.7 e8InternetAccessSupportType : %d",oFiDataObject.oBluetoothFeatureSupport.e8InternetAccessSupportType.enType));
        ETG_TRACE_USR1(("4.8 bPortableNavigationSupport : %d",oFiDataObject.oBluetoothFeatureSupport.bPortableNavigationSupport));
        ETG_TRACE_USR1(("4.9 bSerialPortSupport : %d",oFiDataObject.oBluetoothFeatureSupport.bSerialPortSupport));
        ETG_TRACE_USR1(("5. AVP Connected : %d",mKnownDevices[oFiDataObject.u8DeviceHandle].isAVPConnected));

        ETG_TRACE_USR1(("VendorIDSource    : %d",oFiDataObject.oDeviceIdentification.u16VendorIDSource));
        ETG_TRACE_USR1(("VendorID          : %d",oFiDataObject.oDeviceIdentification.u16VendorID));
        ETG_TRACE_USR1(("u16ProductID      : %d",oFiDataObject.oDeviceIdentification.u16ProductID));
        ETG_TRACE_USR1(("u16ProductVersion : %d",oFiDataObject.oDeviceIdentification.u16ProductVersion));

        ETG_TRACE_USR1(("isAppleDevice    : %d",mKnownDevices[oFiDataObject.u8DeviceHandle].isAppleDevice));
        ETG_TRACE_USR1(("isAvrcpBrowsable : %d",mKnownDevices[oFiDataObject.u8DeviceHandle].isAvrcpBrowsable));
        ETG_TRACE_USR1(("isSPPProfileSupported : %d",mKnownDevices[oFiDataObject.u8DeviceHandle].isSPPProfileSupported));
        ETG_TRACE_USR1(("sppConnectionStatus : %d",mKnownDevices[oFiDataObject.u8DeviceHandle].sppConnectionStatus));

        //strncpy_r(mKnownDevices[oFiDataObject.u8DeviceHandle].deviceAddress, oFiDataObject.sBluetoothDeviceAddress.szValue, sizeof(mKnownDevices[oFiDataObject.u8DeviceHandle].deviceAddress));

        if(mKnownDevices[oFiDataObject.u8DeviceHandle].isAppleDevice)
        {
            mKnownDevices[oFiDataObject.u8DeviceHandle].productID = oFiDataObject.oDeviceIdentification.u16VendorID;
        }
        /* Chek if IAP over BT is enabled. Then Request SPP connection to get the RFComID for the device */
        if(LocalSPM::GetDataProvider().RequestIAP2SPPConnection()
                && (LocalSPM::GetDataProvider().iPodControlSupportIAP2BT() || LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp())
                && mKnownDevices[oFiDataObject.u8DeviceHandle].isAppleDevice
                && mKnownDevices[oFiDataObject.u8DeviceHandle].isSPPProfileSupported )
        {
            if(LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp())
            {
                //Insert the AVRCP device for Playback in DB.
                result = UpdateDeviceInfo(oFiDataObject.u8DeviceHandle);

            }
            GetSPPServiceConnection();
        }
        else
        {
            /*Call the new function UpdateDeviceInfo which will prepare and inform device information
             * to GMP via generic device notification interface MediaplayerInterface::DeviceChanged
             */
            result = UpdateDeviceInfo(oFiDataObject.u8DeviceHandle);
        }
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }

    if (MP_NO_ERROR != result)
    {
        ETG_TRACE_ERR(("onGetDeviceInfoMethodResult: Device status cannot be set into GMP: %d", result));
    }

    oFiDataObject.vDestroy();
}
tVoid fc_mediaplayer_tclClientHandler_GenBTSettings::onBluetoothAudioSource(amt_tclServiceData* poMessage)
{
    ENTRY

    //Create Object of Visitor Message
    fi_tclVisitorMessage oVisitorMsg(poMessage);
    most_btsetfi_tclMsgBluetoothAudioSourceStatus oFiDataObject;

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObject,BTSETTINGS_FI_MAJOR_VERSION))
    {
        ETG_TRACE_USR1(("u8DeviceHandle : %d " , oFiDataObject.u8DeviceHandle));
        if(oFiDataObject.u8DeviceHandle > 0)
        {
            if(mKnownDevices.find(oFiDataObject.u8DeviceHandle) != mKnownDevices.end())
            {
                if(string( mKnownDevices[oFiDataObject.u8DeviceHandle].deviceVersion) == "1.0")
                {
                    ETG_TRACE_USR1(("Request DeviceInfo for device with handle : %d " , oFiDataObject.u8DeviceHandle));
                    SendGetDeviceInfoMethod(oFiDataObject.u8DeviceHandle);
                }
                else
                {
                    ETG_TRACE_USR1(("No need to request DeviceInfo because the device version updated properly"));
                }
            }
            else
            {
                ETG_TRACE_USR1(("No need to request DeviceInfo because the device is connecting first time"));
            }
        }
        else
        {
            ETG_TRACE_USR1(("No need to request DeviceInfo because invalid device handle"));
        }
    }
}

tVoid fc_mediaplayer_tclClientHandler_GenBTSettings::onBluetoothLimitationMode(amt_tclServiceData* poMessage)
{
    ENTRY

    //Create Object of Visitor Message
    fi_tclVisitorMessage oVisitorMsg(poMessage);
    most_btsetfi_tclMsgBluetoothLimitationModeStatus oFiDataObject;

    if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObject,BTSETTINGS_FI_MAJOR_VERSION))
    {
        bool isValidUpdate = false;
        vector<tBTLimitationMode> btLimitationModeDeviceList;
        //bpstl::vector<most_fi_tcl_BTLimitationModeListItem> btLimitationModeListItems = oFiDataObject.oList.oItems;
    std::vector<most_fi_tcl_BTLimitationModeListItem> btLimitationModeListItems = oFiDataObject.oList.oItems;

        if(btLimitationModeListItems.size() > 0) // not an empty update.
        {
            ETG_TRACE_USR2(("btLimitationModeListItems.size() : %d",btLimitationModeListItems.size()));
            for(int i = 0; i < btLimitationModeListItems.size();i++)  // Print relevant data
            {
                ETG_TRACE_USR1(("btLimitationModeListItems.at(%d).sBdAddress : %s ",i,btLimitationModeListItems.at(i).sBdAddress.szGet()));
                ETG_TRACE_USR1(("btLimitationModeListItems.at(%d).e8ActionState : %i ",i,btLimitationModeListItems.at(i).e8ActionState.enType));
            }
            tBTMACAddress sBTAddressFromConnectivity;
            strncpy_r(sBTAddressFromConnectivity,btLimitationModeListItems.at(0).sBdAddress.szGet(),sizeof(sBTAddressFromConnectivity)); //assuming only one element list in connectivity update.

            if(strlen(sBTAddressFromConnectivity) > 0) //empty btMacAddress updates ignored.
            {
                tBTLimitationModeDeviceList &btLimitationModeDeviceList = LocalSPM::GetDataProvider().getBTLimitationModeDeviceList();

                if(btLimitationModeDeviceList.size() > 0)  //not first time update. check and update accordingly.
                {
                    if(!strcmp(sBTAddressFromConnectivity,btLimitationModeDeviceList.at(0).deviceBTMacAddress)) //existing item, update.
                    {
                        //strncpy_r(btLimitationModeDevice.deviceBTMacAddress,sBTAddressFromConn,sizeof(btLimitationModeDevice.deviceBTMacAddress));
                        if(btLimitationModeDeviceList.at(0).btLimitationActionState != convertBtLimitationActionState(btLimitationModeListItems.at(0).e8ActionState))
                        {
                            btLimitationModeDeviceList.at(0).btLimitationActionState = convertBtLimitationActionState(btLimitationModeListItems.at(0).e8ActionState);
                            isValidUpdate = true;
                        }
                    }
                    else  // seems to be a new address because active device might have changed, so replace existing item in the local list.
                    {
                        tBTLimitationMode newBTLimitationModeDevice;
                        memset(&newBTLimitationModeDevice,0,sizeof(newBTLimitationModeDevice));//CID 184732 : Memset fill value of '0'
                        newBTLimitationModeDevice.btTechnology = BTTECHNOLOGY_INVALID;
                        newBTLimitationModeDevice.btCommunicationChannel = BTCOMMUNICATION_CHANNEL_INVALID;
                        newBTLimitationModeDevice.btLimitationActionState = convertBtLimitationActionState(btLimitationModeListItems.at(0).e8ActionState);
                        strncpy_r(newBTLimitationModeDevice.deviceBTMacAddress,sBTAddressFromConnectivity,sizeof(newBTLimitationModeDevice.deviceBTMacAddress));

                        btLimitationModeDeviceList.at(0) = newBTLimitationModeDevice;
                        isValidUpdate = true;
                    }
                }
                else // empty List, may be a first time connection after startup, insert new item.
                {
                    tBTLimitationMode newBTLimitationModeDevice;
                    memset(&newBTLimitationModeDevice,0,sizeof(newBTLimitationModeDevice));
                    newBTLimitationModeDevice.btTechnology = BTTECHNOLOGY_INVALID;
                    newBTLimitationModeDevice.btCommunicationChannel = BTCOMMUNICATION_CHANNEL_INVALID;
                    newBTLimitationModeDevice.btLimitationActionState = convertBtLimitationActionState(btLimitationModeListItems.at(0).e8ActionState);
                    strncpy_r(newBTLimitationModeDevice.deviceBTMacAddress,sBTAddressFromConnectivity,sizeof(newBTLimitationModeDevice.deviceBTMacAddress));

                    btLimitationModeDeviceList.push_back(newBTLimitationModeDevice);
                    isValidUpdate = true;
                }

            }

            if(isValidUpdate)
            {
                map<tU8, tBluetoothDevice>::iterator it;
                for(it = mKnownDevices.begin(); it != mKnownDevices.end();++it)
                {
                    if(/*it->second.isConnected && it->second.isAppleDevice &&*/ (!strcmp(sBTAddressFromConnectivity,it->second.deviceAddress)) )
                    {
                        ETG_TRACE_USR2(("Found device Handle for BTLimitationMode update : %d",it->first));
                        tBTLimitationActionState btLimitationActionState = convertBtLimitationActionState(btLimitationModeListItems.at(0).e8ActionState);
                        it->second.btLimitationActionState = btLimitationActionState;
                        UpdateDeviceInfo(it->first,true);
                        break;                         //btAddress is unique among all devices. Terminate iteration.
                    }
                }
            }
        }

    }
}

tResult fc_mediaplayer_tclClientHandler_GenBTSettings::GetBTLimitationModeForMountPoint(const tDeviceSerialNumber serialNumber,tBTLimitationActionState& btLimitation)
{
    ENTRY
    VARTRACE(serialNumber);

    tResult result = MP_NO_ERROR;

    tDeviceSerialNumber l_serialNumber;
    tDeviceSerialNumber temp;

    strncpy_r(l_serialNumber,serialNumber,sizeof(l_serialNumber));
    VARTRACE(temp);

    char *pch  = NULL;
    pch = strstr((char*)l_serialNumber,"_mod");
    if(pch)
    {
        *pch = '\0';
    }
    //strncpy_r(l_serialNumber,serialNumber,sizeof(serialNumber));
    VARTRACE(l_serialNumber);

    map<tU8, tBluetoothDevice>::iterator it;
    for(it = mKnownDevices.begin(); it != mKnownDevices.end();++it)
    {
        if(!strcmp(it->second.deviceAddress,l_serialNumber))
        {
            btLimitation = it->second.btLimitationActionState;
            ETG_TRACE_USR3(("Found BTLimitation for device : %s",serialNumber));
            return result;
        }

    }
    return -1;
}

tBTTechnology fc_mediaplayer_tclClientHandler_GenBTSettings::convertBtTechnology(most_fi_tcl_e8_BTTechnology most_btTechnology)
{
    tBTTechnology btTechnology = BTTECHNOLOGY_INVALID;
    switch(most_btTechnology.enType)
    {
        case  most_fi_tcl_e8_BTTechnology::FI_EN_IAP:
        {
            btTechnology = BTTECHNOLOGY_IAP;
            break;
        }
        case most_fi_tcl_e8_BTTechnology::FI_EN_CAR_PLAY:
        {
            btTechnology = BTTECHNOLOGY_CARPLAY;
            break;
        }
        default:
        {
            break;
        }
    }
    return btTechnology;
}

tBTCommunicationChannel fc_mediaplayer_tclClientHandler_GenBTSettings::convertBtCommunicationChannel(most_fi_tcl_e8_BTCommunicationChannel most_btCommunicationChannel)
{
    tBTCommunicationChannel btCommunicationChannel = BTCOMMUNICATION_CHANNEL_INVALID;
    switch(most_btCommunicationChannel.enType)
    {
        case  most_fi_tcl_e8_BTCommunicationChannel::FI_EN_BLUETOOTH:
        {
            btCommunicationChannel = BTCOMMUNICATION_CHANNEL_BLUETOOTH;
            break;
        }
        default:
        {
            break;
        }
    }
    return btCommunicationChannel;
}

tBTLimitationActionState fc_mediaplayer_tclClientHandler_GenBTSettings::convertBtLimitationActionState(most_fi_tcl_e8_BTLimitationActionState most_btLimitationActionState)
{
    tBTLimitationActionState btLimitationActionState = BTLIMITATION_ACTION_STATE_INVALID;
    switch(most_btLimitationActionState.enType)
    {
        case  most_fi_tcl_e8_BTLimitationActionState::FI_EN_IDLE:
        {
            btLimitationActionState = BTLIMITATION_ACTION_STATE_IDLE;
            break;
        }
        case  most_fi_tcl_e8_BTLimitationActionState::FI_EN_PREPARED:
        {
            btLimitationActionState = BTLIMITATION_ACTION_STATE_PREPARED;
            break;
        }
        default:
        {
            break;
        }
    }
    return btLimitationActionState;
}


tResult fc_mediaplayer_tclClientHandler_GenBTSettings::UpdateDeviceInfo(tU8 u8DeviceHandle,bool isIAPBTUpdate)
{
    ENTRY

    VARTRACE(u8DeviceHandle);
    VARTRACE(isIAPBTUpdate);

    tResult result = MP_NO_ERROR;

    vector<tDeviceInfo> deviceInfos;
    tDeviceInfo deviceInfoItem;
    InitDeviceInfo(deviceInfoItem);


    if(mKnownDevices.find(u8DeviceHandle) == mKnownDevices.end())
    {
        ETG_TRACE_USR1(("Device not found in mKnownDevices"));
        return -1;
    }


    deviceInfoItem.connectionType = DCT_BLUETOOTH;
    strncpy_r(deviceInfoItem.serialNumber, mKnownDevices[u8DeviceHandle].deviceAddress, sizeof deviceInfoItem.serialNumber);
    strncpy_r(deviceInfoItem.appleDeviceMACAddress, deviceInfoItem.serialNumber, sizeof deviceInfoItem.appleDeviceMACAddress);
    strncpy_r(deviceInfoItem.deviceName, mKnownDevices[u8DeviceHandle].deviceName, sizeof deviceInfoItem.deviceName);
    strncpy_r(deviceInfoItem.deviceVersion, mKnownDevices[u8DeviceHandle].deviceVersion, sizeof deviceInfoItem.deviceVersion);

    //MAC address to be filled for all bluetooth devices as it will be the unique identifier of the Bluetooth devices across functional components (especially Mediaplayer and connectivity).
    strncpy_r(deviceInfoItem.appleDeviceMACAddress , deviceInfoItem.serialNumber, sizeof deviceInfoItem.appleDeviceMACAddress);

    if(!LocalSPM::GetDataProvider().AVRCPLowerProfileSupported())
    {
        if(mKnownDevices[u8DeviceHandle].isAvrcpBrowsable)
        {
            strncpy_r(deviceInfoItem.deviceVersion, "1.4", sizeof deviceInfoItem.deviceVersion);
        }
        else
        {
            strncpy_r(deviceInfoItem.deviceVersion, "1.3", sizeof deviceInfoItem.deviceVersion);
        }
    }

    ETG_TRACE_USR1(("ConnectionState of device u8DeviceHandle(%d) is : %d",u8DeviceHandle,mKnownDevices[u8DeviceHandle].isConnected));
    ETG_TRACE_USR1(("sppConnectionStatus : %d",mKnownDevices[u8DeviceHandle].sppConnectionStatus));

#ifdef USE_BTSETTINGS_FI_EXTENDED
            /* In LowerProfileSupported projects,If BT Device's AVPConnection Lost not due the INTERNALDISCONNECT(i.e it happens During Ignition OFF),
               If AppleDevice connected over usb,set its DisconnectionReason to DR_CONNECTED_OVER_USB.Else,set its DisconnectionReason to DR_AVP_DISCONNECTED */
            if(LocalSPM::GetDataProvider().AVRCPLowerProfileSupported() && (mKnownDevices[u8DeviceHandle].isConnected) &&
                    ((mKnownDevices[u8DeviceHandle].isAVPConnected == false) && (DR_INTERNALDISCONNECT != mKnownDevices[u8DeviceHandle].disconnectReason )))
            {
                deviceInfoItem.disconnectReason = DR_AVP_DISCONNECTED;
                if(mKnownDevices[u8DeviceHandle].isAppleDevice)
                {
                    tNumberOfDevices numberOfDevices;
                    vector<tDeviceInfo> tempDeviceInfos;

                    result = MediaPlayerInterface::GetInstance().GetMediaplayerDeviceConnections(numberOfDevices,tempDeviceInfos);

                    if(MP_NO_ERROR == result)
                    {
                        for(unsigned int i=0; i<numberOfDevices; i++ )
                        {
                            if( (strcmp(tempDeviceInfos[i].deviceName,mKnownDevices[u8DeviceHandle].deviceName)==0) && tempDeviceInfos[i].connected
                                    && (DCT_USB == tempDeviceInfos[i].connectionType)&& ((DTY_IPHONE == tempDeviceInfos[i].deviceType) || (DTY_IPOD == tempDeviceInfos[i].deviceType)))
                            {
                                deviceInfoItem.disconnectReason = DR_CONNECTED_OVER_USB;
                                mKnownDevices[u8DeviceHandle].isConnectedOverUSB = true;
                                break;
                            }
                        }
                    }
                }
            }
            else
            {
                deviceInfoItem.disconnectReason = mKnownDevices[u8DeviceHandle].disconnectReason;
                mKnownDevices[u8DeviceHandle].isConnectedOverUSB = false;
            }
#else
            deviceInfoItem.disconnectReason = mKnownDevices[u8DeviceHandle].disconnectReason;
#endif


#ifdef USE_BTSETTINGS_FI_EXTENDED
    /*Check the AVP connection status before making the device connection state to CS_ATTACHED */
    if((mKnownDevices[u8DeviceHandle].isConnected)
            &&(((mKnownDevices[u8DeviceHandle].sppConnectionStatus == SPP_CONNECTED ) && LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp()) || (mKnownDevices[u8DeviceHandle].isAVPConnected && (0 < strlen(deviceInfoItem.deviceVersion))))
            && (SPP_DISCONNECTED != mKnownDevices[u8DeviceHandle].sppConnectionStatus ))
#else
        if(mKnownDevices[u8DeviceHandle].isConnected)
#endif
        {
            /*prepare device address in the form dev_aa_bb_cc_dd_ee_ff which acts as mount point for BT Device and used to communicate via B_Daemon dbus interface*/
            strncpy_r(deviceInfoItem.mountPoint, "dev", sizeof deviceInfoItem.mountPoint);
            tUInt iter1,iter2;
            tUInt addressLength = strlen_r(mKnownDevices[u8DeviceHandle].deviceAddress); // it will be 12 allways
            for (iter1 = 0, iter2 = 3; iter1 < addressLength; iter1++, iter2++)
            {
                deviceInfoItem.mountPoint[iter2++] = '_';
                //Device path for Evolution stack is in upper case letters.
                if(LocalSPM::GetDataProvider().UseEvolutionBtStack())
                {
                    deviceInfoItem.mountPoint[iter2++] = toupper(mKnownDevices[u8DeviceHandle].deviceAddress[iter1++]);
                    deviceInfoItem.mountPoint[iter2]   = toupper(mKnownDevices[u8DeviceHandle].deviceAddress[iter1]);
                }
                else
                {
                    deviceInfoItem.mountPoint[iter2++] = mKnownDevices[u8DeviceHandle].deviceAddress[iter1++];
                    deviceInfoItem.mountPoint[iter2]   = mKnownDevices[u8DeviceHandle].deviceAddress[iter1];
                }
            }
            deviceInfoItem.mountPoint[iter2] = '\0';
            ETG_TRACE_USR1(("Prepared mount point for device as  : %s",deviceInfoItem.mountPoint));



            deviceInfoItem.connectionState = CS_ATTACHED;
            deviceInfoItem.disconnectReason = DR_REMOVED;

            if(mKnownDevices[u8DeviceHandle].isAppleDevice &&
                    (LocalSPM::GetDataProvider().iPodControlSupportIAP1BT() ||
                            LocalSPM::GetDataProvider().iPodControlSupportIAP2BT() ||
                            (LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp() && isIAPBTUpdate)))
            {
                /* try BT via IAP, reset back to DTY_BLUTOOTH in iPodControl on error */
                deviceInfoItem.deviceType = DTY_IPHONE;
                deviceInfoItem.btLimitationActionState = mKnownDevices[u8DeviceHandle].btLimitationActionState;

                /*if RFComID available, pass it as accessoryName for iPodControl - For RNAIVI Scope2 */
                if(LocalSPM::GetDataProvider().RequestIAP2SPPConnection())
                {
                    if((mKnownDevices[u8DeviceHandle].sppConnectionStatus == SPP_CONNECTED)&& strlen_r(mKnownDevices[u8DeviceHandle].deviceRFCommID) > 0)
                    {
                        //Fill the DeviceInfoField:accessoryName with mountpoint.
                        strncpy_r(deviceInfoItem.accessoryName , deviceInfoItem.mountPoint, sizeof deviceInfoItem.accessoryName);


                        if(LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp())
                        {

                            mKnownDevices[u8DeviceHandle].isIAP2BTForAPP = true;

                            //Modify the serial number of DTY_IPHONE so that new entry will create in DB.
                            strncat_r(OUT deviceInfoItem.serialNumber, IN "_mod", IN sizeof(deviceInfoItem.serialNumber));
                        }

                        //Fill the DeviceInfoField:mountpoint with RFComID.
                        strncpy_r(deviceInfoItem.mountPoint , mKnownDevices[u8DeviceHandle].deviceRFCommID, sizeof deviceInfoItem.mountPoint);
                    }
                    else
                    {
                        //Change the device type to DTY_BLUETOOTH.Because IAP over BT will not support with out a SPP connection.
                        deviceInfoItem.deviceType = DTY_BLUETOOTH;
                    }
                }

            }
            else
            {
                deviceInfoItem.deviceType = DTY_BLUETOOTH;

                if(!mKnownDevices[u8DeviceHandle].isAVPConnected)
                {
                    deviceInfoItem.connectionState = CS_DISCONNECTED;
                    //Update disonnect reason from mKnownDevices.This is to update AVP disconnect reason(eg DR_INTERNALDISCONNECT) properly.
                    deviceInfoItem.disconnectReason = mKnownDevices[u8DeviceHandle].disconnectReason;
                }

                if(!LocalSPM::GetDataProvider().AVRCPLowerProfileSupported() )
                {
                    /*treat AVRCP bluetooth device as disconnected if it is not AVRCP 1.4 Device*/
                    if(!mKnownDevices[u8DeviceHandle].isAvrcpBrowsable)
                    {
                        ETG_TRACE_USR4(("isAvrcpBrowsable is FALSE.Hence device is updated as CS_DISCONNECTED"));
                        deviceInfoItem.connectionState = CS_DISCONNECTED;
                    }
                }
                if(mKnownDevices[u8DeviceHandle].isAppleDevice)
                {
                    /* NCG3D-12696:Retain the disconnectReason of the device,if isConnectedOverUSB is TRUE.
                       Use Case:Apple Device connected over BT followed by USB.Now,USB connection of the Device is Removed.
                       User Observation:During the Time interval of making its BT Audio available,it remain showing "Connected over USB" */
                    if(mKnownDevices[u8DeviceHandle].isConnectedOverUSB)
                    {
                        deviceInfoItem.disconnectReason = DR_CONNECTED_OVER_USB;
                        mKnownDevices[u8DeviceHandle].isConnectedOverUSB = false;
                    }
                    deviceInfoItem.productID = mKnownDevices[u8DeviceHandle].productID;
                }
            }
        }
        else
        {
            deviceInfoItem.connectionState = CS_DISCONNECTED;

            //On BT device disconnection move both DTY_IPHONE and DTY_BLUTOOTH device added previously to disconnected state.
            /*if RFComID available, pass it as accessoryName for iPodControl - For RNAIVI Scope2 */
            if(LocalSPM::GetDataProvider().RequestIAP2SPPConnection()
                    && mKnownDevices[u8DeviceHandle].isAppleDevice
                    && (strlen(mKnownDevices[u8DeviceHandle].deviceRFCommID) > 0))
            {

                if(LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp())
                {
                    if(SPP_DISCONNECTED == mKnownDevices[u8DeviceHandle].sppConnectionStatus)
                    {
                        mKnownDevices[u8DeviceHandle].isIAP2BTForAPP = false;
                        deviceInfoItem.disconnectReason = DR_SPP_DISCONNECTED;
                        //Update the serial number of DTY_IPHONE
                        strncat_r(OUT deviceInfoItem.serialNumber, IN "_mod", IN sizeof(deviceInfoItem.serialNumber));
                        mKnownDevices[u8DeviceHandle].sppConnectionStatus = SPP_STATUS_UNKNOWN;
                    }
                    else if(mKnownDevices[u8DeviceHandle].isConnected && !mKnownDevices[u8DeviceHandle].isAVPConnected)
                    {
                        //Need to disconnect only the AVRCP device this will handle by default logic.
                    }
                    else if(mKnownDevices[u8DeviceHandle].isIAP2BTForAPP && !mKnownDevices[u8DeviceHandle].isConnected)
                    {
                        tDeviceInfo deviceInfoItemBT;
                        InitDeviceInfo(deviceInfoItemBT);
                        deviceInfoItemBT = deviceInfoItem;
                        deviceInfos.push_back(deviceInfoItemBT);

                        mKnownDevices[u8DeviceHandle].isIAP2BTForAPP = false;
                        //Update the serial number of DTY_IPHONE
                        strncat_r(OUT deviceInfoItem.serialNumber, IN "_mod", IN sizeof(deviceInfoItem.serialNumber));

                    }
                }
                else
                {
                    if(SPP_DISCONNECTED == mKnownDevices[u8DeviceHandle].sppConnectionStatus)
                    {
                        deviceInfoItem.disconnectReason = DR_SPP_DISCONNECTED;
                       // Reset the sppConnectionStatus
                       mKnownDevices[u8DeviceHandle].sppConnectionStatus = SPP_STATUS_UNKNOWN;
                    }
                }
            }
        }
    deviceInfos.push_back(deviceInfoItem);

#ifndef DISABLE_DTY_BLUETOOTH
    tUndervoltage undervoltage = false;
    result = MediaPlayerInterface::GetInstance().DeviceChanged(IN undervoltage, IN deviceInfos);
#else
    ETG_TRACE_USR3(("fc_mediaplayer_tclClientHandler_BTSettings -> skip AVRCP 1.4 BT Device notification to MediaplayerCore"));
#endif

    return result;
}
void fc_mediaplayer_tclClientHandler_GenBTSettings::InitBluetoothDevice(tBluetoothDevice &btDevice)
{
    ENTRY

    strncpy_r(btDevice.deviceAddress, "", sizeof (btDevice.deviceAddress));
    strncpy_r(btDevice.deviceVersion, "", sizeof (btDevice.deviceVersion));
    strncpy_r(btDevice.deviceRFCommID, "", sizeof (btDevice.deviceRFCommID));
    btDevice.disconnectReason = DR_REMOVED;
    btDevice.isAvrcpBrowsable = false;
    btDevice.isAppleDevice = false;
    btDevice.isAVPConnected = false;
    btDevice.isHFPConnected = false;
    btDevice.isConnectedOverUSB = false;
    btDevice.isSPPProfileSupported = false;
    btDevice.isIAP2BTForAPP = false;
    btDevice.btLimitationActionState = BTLIMITATION_ACTION_STATE_INVALID;     //CMG3G-14540. Initial value.
    btDevice.sppConnectionStatus = SPP_STATUS_UNKNOWN;
}

/*-----------------------------------------------------------------------------*
* tVoid vOnServiceAvailable()                                                 *
*-----------------------------------------------------------------------------*/
tVoid fc_mediaplayer_tclClientHandler_GenBTSettings::vOnServiceAvailable()
{
    ETG_TRACE_USR4(("fc_mediaplayer_tclClientHandler_GenBTSettings::vOnServiceAvailable"));
      /*To ge the devicelist status*/
    GetDeviceListExtended();
}

/*-----------------------------------------------------------------------------*
* tVoid vOnServiceUnavailable()                                               *
*-----------------------------------------------------------------------------*/
tVoid fc_mediaplayer_tclClientHandler_GenBTSettings::vOnServiceUnavailable()
{

    ETG_TRACE_USR4(("fc_mediaplayer_tclClientHandler_GenBTSettings::vOnServiceUnavailable"));

}


tVoid fc_mediaplayer_tclClientHandler_GenBTSettings::GetDeviceListExtended()
{
   ENTRY
   most_btsetfi_tclMsgDeviceListExtendedGet oDeviceListExtendedGet;

      //Create Object of Visitor Message
      fi_tclVisitorMessage oVisitorMsgOutput(oDeviceListExtendedGet, BTSETTINGS_FI_MAJOR_VERSION);
      vInitServiceData (oVisitorMsgOutput,                    // ServiceDataMsg
              0,                                              // CmdCounter
              MOST_BTSETFI_C_U16_DEVICELISTEXTENDED,          // Function ID
              AMT_C_U8_CCAMSG_OPCODE_GET);                    // OpCode
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);

      // Check for Error after posting message
      if (AIL_EN_N_NO_ERROR != enResult)
      {
          ETG_TRACE_ERR (("Unable to send GetDeviceListExtended to BTSettings ail_tenCommunicationError=%u",(tU32)enResult));
      }
      else
      {
          //Do nothing.
      }
      oDeviceListExtendedGet.vDestroy();

}

tVoid fc_mediaplayer_tclClientHandler_GenBTSettings::GetSPPServiceConnection()
{
   ENTRY
   most_btsetfi_tclMsgSPPServiceConnectionGet oSPPServiceConnectionGet;

      //Create Object of Visitor Message
      fi_tclVisitorMessage oVisitorMsgOutput(oSPPServiceConnectionGet, BTSETTINGS_FI_MAJOR_VERSION);
      vInitServiceData (oVisitorMsgOutput,                    // ServiceDataMsg
              0,                                              // CmdCounter
              MOST_BTSETFI_C_U16_SPPSERVICECONNECTION,          // Function ID
              AMT_C_U8_CCAMSG_OPCODE_GET);                    // OpCode
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);

      // Check for Error after posting message
      if (AIL_EN_N_NO_ERROR != enResult)
      {
          ETG_TRACE_ERR (("Unable to send GetSPPServiceConnection to BTSettings ail_tenCommunicationError=%u",(tU32)enResult));
      }
      else
      {
          //Do nothing.
      }
      oSPPServiceConnectionGet.vDestroy();
}

tResult fc_mediaplayer_tclClientHandler_GenBTSettings::ConnectSPPService(tU8 u8DeviceHandle,char * uuid)
{
    ENTRY
    tResult result = MP_NO_ERROR;
    most_btsetfi_tclMsgConnectSPPServiceMethodStart startMessage;
    startMessage.u8DeviceHandle = u8DeviceHandle;
    startMessage.szUUID.bSet(uuid,most_fi_tcl_String::FI_EN_UTF8);
    fi_tclVisitorMessage oVisitorMsgOutput(startMessage, BTSETTINGS_FI_MAJOR_VERSION);
    vInitServiceData (oVisitorMsgOutput,                    // ServiceDataMsg
            0,                                    // CmdCounter
            MOST_BTSETFI_C_U16_CONNECTSPPSERVICE,     // Function ID
            AMT_C_U8_CCAMSG_OPCODE_METHODSTART);  //OpCode
    ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);
    if (AIL_EN_N_NO_ERROR != enResult)
    {
        ETG_TRACE_ERR (("Unable to send ConnectSPPService to BTSettings ail_tenCommunicationError=%u",(tU32)enResult));
        result = -1;
    }
    else
    {
    }
    startMessage.vDestroy();
    return result;
}
tVoid fc_mediaplayer_tclClientHandler_GenBTSettings::onConnectSPPServiceMethodResult(amt_tclServiceData* poMessage)
{
    ENTRY
    most_btsetfi_tclMsgConnectSPPServiceMethodResult oFiDataObject;
    fi_tclVisitorMessage oVisitorMsg(poMessage);
    if(OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObject,BTSETTINGS_FI_MAJOR_VERSION))
    {
        std::map <tU8, tBluetoothDevice>::iterator it;
        for(it = mKnownDevices.begin();it != mKnownDevices.end();it++)
        {
            if(SPP_REQUESTED == it->second.sppConnectionStatus)
            {
                ETG_TRACE_USR1((" Device Handle:%d bConnectSPPService : %d",it->first,oFiDataObject.bConnectSPPService));
                /* Set the SPP connection request result */
                if(oFiDataObject.bConnectSPPService)
                {
                    mKnownDevices[it->first].sppConnectionStatus = SPP_RESPONSE_RECEIVED;
                }
                else
                {
                    mKnownDevices[it->first].sppConnectionStatus = SPP_STATUS_UNKNOWN;
                }
                break;
            }
        }
    }
}


tVoid fc_mediaplayer_tclClientHandler_GenBTSettings::onConnectSPPServiceMethodError(amt_tclServiceData* poMessage)
{
    ENTRY
    std::map <tU8, tBluetoothDevice>::iterator it;
    /* Chek in the mKnownDevices for which device the SPP connection requested. */
    for(it = mKnownDevices.begin();it != mKnownDevices.end();it++)
    {
        /* call Update device info for the device, if the SPP connection failed. */
        if(SPP_REQUESTED == it->second.sppConnectionStatus)
        {
            mKnownDevices[it->first].sppConnectionStatus = SPP_STATUS_UNKNOWN;
            if(!LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp())
            {
                UpdateDeviceInfo(it->first);
            }
            break;
        }
    }
}

tVoid fc_mediaplayer_tclClientHandler_GenBTSettings::onSPPServiceConnection(amt_tclServiceData* poMessage)
{
    ENTRY
    fi_tclVisitorMessage oVisitorMsg(poMessage);
    if(LocalSPM::GetDataProvider().RequestIAP2SPPConnection()
            && (LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp() || LocalSPM::GetDataProvider().iPodControlSupportIAP2BT()))
    {
        most_btsetfi_tclMsgSPPServiceConnectionStatus oFiDataObject;
        if( OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObject, BTSETTINGS_FI_MAJOR_VERSION))
        {
            tUInt deviceIter = 0;
            for( deviceIter = 0; deviceIter < oFiDataObject.oSPPServiceConnectionStatusList.oItems.size(); deviceIter++)
            {
                most_fi_tcl_BTSPPServiceConnectionStatusListItem& oMostFI_BTSPPServiceItem = oFiDataObject.oSPPServiceConnectionStatusList.oItems.at(deviceIter);
                ETG_TRACE_USR1(("1. u8DeviceHandle : %d",oMostFI_BTSPPServiceItem.u8DeviceHandle));
                ETG_TRACE_USR1(("2. sUUID   : %s",oMostFI_BTSPPServiceItem.sUUID.szValue));
                ETG_TRACE_USR1(("3. e8SPPConnectionStatus : %d",oMostFI_BTSPPServiceItem.e8SPPConnectionStatus.enType));
                ETG_TRACE_USR1(("4.1 e8SPPDisconnectionReason : %d",oMostFI_BTSPPServiceItem.e8SPPDisconnectionReason.enType));
                ETG_TRACE_USR1(("4.2 sRFCommID : %s",oMostFI_BTSPPServiceItem.sRFCommID.szValue));
                /* Check the UUID is for IAP2 and the connection status is connected. Then Update the RFComID for the device. */
                if((mKnownDevices.find(oMostFI_BTSPPServiceItem.u8DeviceHandle) != mKnownDevices.end()) && mKnownDevices[oMostFI_BTSPPServiceItem.u8DeviceHandle].isAppleDevice)
                {
                    if(!strcmp(LocalSPM::GetDataProvider().iPodControlBTIAP2SPPUUID().c_str(),oMostFI_BTSPPServiceItem.sUUID.szValue))
                    {
                        ETG_TRACE_USR1(("5. mKnownDevices: e8SPPConnectionStatus : %d", mKnownDevices[oMostFI_BTSPPServiceItem.u8DeviceHandle].sppConnectionStatus));

                        if((oMostFI_BTSPPServiceItem.e8SPPConnectionStatus.enType == most_fi_tcl_e8_BTConnectionStatus::FI_EN_E8STATUS_CONNECTED) && (strcmp(oMostFI_BTSPPServiceItem.sRFCommID.szValue,"")))
                        {

                            strncpy_r(mKnownDevices[oMostFI_BTSPPServiceItem.u8DeviceHandle].deviceRFCommID, oMostFI_BTSPPServiceItem.sRFCommID.szValue, sizeof(mKnownDevices[oMostFI_BTSPPServiceItem.u8DeviceHandle].deviceRFCommID));

                            mKnownDevices[oMostFI_BTSPPServiceItem.u8DeviceHandle].sppConnectionStatus = SPP_CONNECTED;
                            if(LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp())
                            {
                                UpdateDeviceInfo(oMostFI_BTSPPServiceItem.u8DeviceHandle,true);
                            }
                            else
                            {
                                UpdateDeviceInfo(oMostFI_BTSPPServiceItem.u8DeviceHandle);
                            }
                        }
                        //SPP connection disconnected for the already connected device
                        else if((mKnownDevices[oMostFI_BTSPPServiceItem.u8DeviceHandle].sppConnectionStatus == SPP_CONNECTED) && (oMostFI_BTSPPServiceItem.e8SPPConnectionStatus.enType == most_fi_tcl_e8_BTConnectionStatus::FI_EN_E8STATUS_DISCONNECTED))
                        {
                            mKnownDevices[oMostFI_BTSPPServiceItem.u8DeviceHandle].sppConnectionStatus = SPP_DISCONNECTED;

                            if(LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp())
                            {
                                UpdateDeviceInfo(oMostFI_BTSPPServiceItem.u8DeviceHandle,true);
                            }
                            else
                            {
                                UpdateDeviceInfo(oMostFI_BTSPPServiceItem.u8DeviceHandle);
                            }
                        }
                        else if((mKnownDevices[oMostFI_BTSPPServiceItem.u8DeviceHandle].sppConnectionStatus == SPP_RESPONSE_RECEIVED) && (oMostFI_BTSPPServiceItem.e8SPPConnectionStatus.enType == most_fi_tcl_e8_BTConnectionStatus::FI_EN_E8STATUS_DISCONNECTED))
                        {

                            //Reset the SPPConnectionStatus.
                            mKnownDevices[oMostFI_BTSPPServiceItem.u8DeviceHandle].sppConnectionStatus = SPP_STATUS_UNKNOWN;
                            //If SPP connection fails update the device as normal AVRCP device for Playback
                            if(!LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp())
                            {
                                //Update AVRCP Device
                                UpdateDeviceInfo(oMostFI_BTSPPServiceItem.u8DeviceHandle);
                            }
                        }

                    }

                    //Request SPP connection for IAPBT UUID
                    if((mKnownDevices[oMostFI_BTSPPServiceItem.u8DeviceHandle].sppConnectionStatus == SPP_STATUS_UNKNOWN)
                            && (mKnownDevices[oMostFI_BTSPPServiceItem.u8DeviceHandle].isAVPConnected
                                    ||(LocalSPM::GetDataProvider().IAPBTConnectionOnlyForSmartApp() && mKnownDevices[oMostFI_BTSPPServiceItem.u8DeviceHandle].isHFPConnected)))
                    {
                        tUUID uuid;
                        strcpy(uuid,LocalSPM::GetDataProvider().iPodControlBTIAP2SPPUUID().c_str());
                        tResult ret = ConnectSPPService(oMostFI_BTSPPServiceItem.u8DeviceHandle,uuid);
                        if(MP_NO_ERROR == ret)
                        {
                            mKnownDevices[oMostFI_BTSPPServiceItem.u8DeviceHandle].sppConnectionStatus = SPP_REQUESTED;
                        }
                    }
                }
            }
        }
    }
}


tResult fc_mediaplayer_tclClientHandler_GenBTSettings::AddOobPairedDevice(const tDeviceID deviceID,const tMACAddress deviceAddress,const tDeviceName deviceName,const tLinkKey linkKey,const tBTOobType oobType)
{
    ENTRY
    tResult result = MP_NO_ERROR;
    most_btsetfi_tclMsgAddOobPairedDeviceMethodStart startMessage;

    mOobbtDeviceID = deviceID;

    startMessage.sBdAddress.bSet(deviceAddress,most_fi_tcl_String::FI_EN_UTF8);
    startMessage.sBdName.bSet(deviceName,most_fi_tcl_String::FI_EN_UTF8);
    startMessage.sLinkKey.bSet(linkKey,most_fi_tcl_String::FI_EN_UTF8);

    if(OOB_APPLE == oobType)
    {
        startMessage.e8OobType.enType = most_fi_tcl_e8_BTOobType::FI_EN_APPLE;
    }
    else
    {
        startMessage.e8OobType.enType = most_fi_tcl_e8_BTOobType::FI_EN_GENERIC;
    }


    fi_tclVisitorMessage oVisitorMsgOutput(startMessage, BTSETTINGS_FI_MAJOR_VERSION);
    vInitServiceData (oVisitorMsgOutput,                    // ServiceDataMsg
            0,                                    // CmdCounter
            MOST_BTSETFI_C_U16_ADDOOBPAIREDDEVICE,     // Function ID
            AMT_C_U8_CCAMSG_OPCODE_METHODSTART);  //OpCode
    ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);
    if (AIL_EN_N_NO_ERROR != enResult)
    {
        ETG_TRACE_ERR (("Unable to send AddOobPairedDevice to BTSettings ail_tenCommunicationError=%u",(tU32)enResult));
        result = -1;
    }

    startMessage.vDestroy();

    return result;
}

tVoid fc_mediaplayer_tclClientHandler_GenBTSettings::onAddOobPairedDeviceMethodResult(amt_tclServiceData* poMessage)
{
    ENTRY
    tBoolean result = false;
    most_btsetfi_tclMsgAddOobPairedDeviceMethodResult oFiDataObject;

    fi_tclVisitorMessage oVisitorMsg(poMessage);
    if(OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObject,BTSETTINGS_FI_MAJOR_VERSION))
    {
        result = oFiDataObject.bResult;
    }
    VARTRACE(result);
    MediaPlayerInterface::GetInstance().AddOobPairedDeviceResult(mOobbtDeviceID,result);
}

tVoid fc_mediaplayer_tclClientHandler_GenBTSettings::onAddOobPairedDeviceMethodError(amt_tclServiceData* poMessage)
{
    ENTRY
    MediaPlayerInterface::GetInstance().AddOobPairedDeviceResult(mOobbtDeviceID,false);
}

tVoid fc_mediaplayer_tclClientHandler_GenBTSettings::onDisconnectSPPServiceMethodResult(amt_tclServiceData* poMessage)
{
    ENTRY;
}

tVoid fc_mediaplayer_tclClientHandler_GenBTSettings::onDisconnectSPPServiceMethodError(amt_tclServiceData* poMessage)
{
    ENTRY;
}

tResult fc_mediaplayer_tclClientHandler_GenBTSettings::DisconnectSPPService(const tMACAddress deviceAddress)
{
    ENTRY;

    tResult result = MP_NO_ERROR;
    map<tU8, tBluetoothDevice>::iterator it;
    tU8 u8DeviceHandle = 0;
    bool bDeviceHandleFound = false;

    for(it = mKnownDevices.begin(); it != mKnownDevices.end(); it++)
    {
        if( 0 == strncmp(it->second.deviceAddress, deviceAddress, sizeof(it->second.deviceAddress) ))
        {
            u8DeviceHandle = it->first;
            bDeviceHandleFound = true;
            break;
        }
    }

    VARTRACE(u8DeviceHandle);

    if(true == bDeviceHandleFound && SPP_CONNECTED == mKnownDevices[u8DeviceHandle].sppConnectionStatus)
    {
        most_btsetfi_tclMsgDisconnectSPPServiceMethodStart startMessage;

        startMessage.u8DeviceHandle = u8DeviceHandle;

        tUUID uuid;
        strcpy(uuid,LocalSPM::GetDataProvider().iPodControlBTIAP2SPPUUID().c_str());
        startMessage.szUUID.bSet(uuid,most_fi_tcl_String::FI_EN_UTF8);

        fi_tclVisitorMessage oVisitorMsgOutput(startMessage, BTSETTINGS_FI_MAJOR_VERSION);

        vInitServiceData (oVisitorMsgOutput,            // ServiceDataMsg
            0,                                          // CmdCounter
            MOST_BTSETFI_C_U16_DISCONNECTSPPSERVICE,    // Function ID
            AMT_C_U8_CCAMSG_OPCODE_METHODSTART);        //OpCode

        ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);
        if (AIL_EN_N_NO_ERROR != enResult)
        {
            ETG_TRACE_ERR ((" Unable to send DisconnectSPPService to BTSettings ail_tenCommunicationError: %u",(tU32)enResult));
            result = MP_ERROR;
        }
        else
        {
            ETG_TRACE_USR4((" DisconnectSPPService posted to BT Settings "));
        }

        startMessage.vDestroy();
    }
    else
    {
        ETG_TRACE_USR4((" Not a known device or SPPService is already disconnected for the device "));
    }

    return result;
}
