/**
 * @author Jörg Wohlgemuth
 *
 * Implentation of AudioRoutingLib support of GenericMediaPlayer
 *
 */

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_SERVICE_MEDIAPLAYER // ToDo: Must be replaced
#include "trcGenProj/Header/FC_MediaPlayer_AudioRoutingHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_SERVICE_MEDIAPLAYER
#endif

#include "FC_MediaPlayer_main.h"
#include "FC_MediaPlayer_AudioRoutingHandler.h"
#include "MediaPlayerInterface.h"
#include "LocalSPM.h"

#include "VarTrace.h"
#include "FunctionTracer.h"


/**
* Constructor of the service class
* @param[in] poMainAppl Pointer to the CCA application
* @return
*/
fc_mediaplayer_tclAudioRoutingHandler::fc_mediaplayer_tclAudioRoutingHandler(fc_mediaplayer_tclApp* poMainApp):arl_tclISource((ahl_tclBaseOneThreadApp*) poMainApp)
{
    ENTRY
    m_poMainAppInstance = poMainApp;
};

/**
* Destructore of the service class
* @return
*/
fc_mediaplayer_tclAudioRoutingHandler::~fc_mediaplayer_tclAudioRoutingHandler()
{
    ENTRY
}

/***************************************************************************
** FUNCTION:  virtual tBool FC_MediaPlayer_tclAudioRoutingHandler::bOnSrcActivity(..
***************************************************************************/
/*!
 * \brief   CALLED BY AUDIO-ROUTING-LIB:
 *          Application specific function on Source Activity start.
 * \param   enSrcNum:  (I) Source Number.
 * \param   SubSource: (I) Sub source ID (deviceID)
 * \param   rfcoSrcActivity: (I) Source Activity
 * \retval  tBool: TRUE, if source activity was successful, FALSE otherwise
 * \date 11.09.2013 \author Jörg Wohlgemuth (BSOT/ENG)
 **************************************************************************/
#ifdef VARIANT_S_FTR_ENABLE_MP_NEXT_POSSIBLE_SOURCE
tBool fc_mediaplayer_tclAudioRoutingHandler::bOnSrcActivity(arl_tenSource enSrcNum, tU16 SubSource, arl_tenSource enPosNextSrc, const arl_tSrcActivity& rfcoSrcActivity)
#else
tBool fc_mediaplayer_tclAudioRoutingHandler::bOnSrcActivity(arl_tenSource enSrcNum, tU16 SubSource, const arl_tSrcActivity& rfcoSrcActivity)
#endif
{
    ENTRY
    tBool bReturn = FALSE;
    tResult result = -1;

    ETG_TRACE_USR1(("bOnSrcActivity: enSrcNum %d  and SubSource ID %d", enSrcNum, SubSource));

    tDeviceInfo deviceInfo;
    //Check for any internal active device - SUZUKI-23052
    result = MediaPlayerInterface::GetInstance().ActiveMediaDeviceGet(OUT deviceInfo);

    if (rfcoSrcActivity.enType == midw_fi_tcl_e8_SrcActivity::FI_EN_ON)
    {
        VARTRACE(LocalSPM::GetDataProvider().GetIpodMuteStatus());
        if(LocalSPM::GetDataProvider().GetIpodMuteStatus())
        {
            LocalSPM::GetDataProvider().SetIpodMuteStatus(false);
            if(IsAppleDevice(deviceInfo.deviceType))
            {
                ETG_TRACE_USR1(("SA_ON because of DEMUTE, sending MediaEngine::Play for IPHONE devices"));
                result = MediaPlayerInterface::GetInstance().SendMediaEnginePlay();
                if(MP_NO_ERROR != result)
                {
                    ETG_TRACE_ERR(("Error in sending MediaEngine::Play for apple device"));
                }
                vSourceActivityResult(enSrcNum, rfcoSrcActivity);
                return TRUE;
            }
        }

        tMediaContext defaultMediaContext = (tMediaContext)LocalSPM::GetDataProvider().DBDefaultMediaContext();

        /* Handle the Static device type BTAUDIO. SubSource is always 0 for source ARL_SRC_BTAUDIO */
        if((LocalSPM::GetDataProvider().UseArlSrcBtAudio()) && (enSrcNum == ARL_SRC_BTAUDIO))
        {

            tBool bDeviceFound = FALSE;
            tNumberOfDevices numberOfDevices = 0;
            vector<tDeviceInfo> deviceInfos;
            result = MediaPlayerInterface::GetInstance().GetMediaplayerDeviceConnections(OUT numberOfDevices, OUT deviceInfos);

            /* Search for the device type DTY_BLUETOOTH and connection type CS_CONNECTED*/
            int i;
            for(i=0; i<(int)deviceInfos.size(); i++)
            {
                if (((DTY_BLUETOOTH == deviceInfos[i].deviceType) || (DCT_BLUETOOTH == deviceInfos[i].connectionType)) && (CS_CONNECTED == deviceInfos[i].connectionState))
                {
                    if(deviceInfo.deviceID != deviceInfos[i].deviceID)
                    {
                        result = MediaPlayerInterface::GetInstance().ActiveMediaDeviceSet(IN deviceInfos[i].deviceID, IN TRUE,defaultMediaContext);
                        m_poMainAppInstance->GetOutputWrapper().SetAudioAllocatedDevice(deviceInfos[i].deviceID);

                        // check return value but ignore it
                        if (MP_NO_ERROR != result)
                            ETG_TRACE_FATAL(("Connected BT device (deviceID: %d) cannot be set to active", deviceInfos[i].deviceID));
                    }
                    bDeviceFound = true;
                    break;
                }
            }

            if (!bDeviceFound)
            {
                if (0 < (int)deviceInfo.deviceID)
                {
                    /* Make the current active device to not active*/
                    result = MediaPlayerInterface::GetInstance().ActiveMediaDeviceSet(IN deviceInfo.deviceID, IN FALSE,defaultMediaContext);

                    if (MP_NO_ERROR != result)
                        ETG_TRACE_FATAL(("Active device (deviceID: %d) cannot be set to not active", deviceInfo.deviceID));
                }

                /* Clear the last source in PlayerManager if the current source is BT Audio and no BT device is connected*/
                MediaPlayerInterface::GetInstance().ClearLastSource();
            }
        }
        else //if ((MP_NO_ERROR != result) || (SubSource != deviceInfo.deviceID))
        {
            // switch to device defined in SubSource

#ifdef VARIANT_S_FTR_ENABLE_MP_AUTOPLAY
            if ((enSrcNum == ARL_SRC_CPRA2 || enSrcNum == ARL_SRC_USB_VIDEO) && (LocalSPM::GetDataProvider().SeparateMediaContent()))
            {
                tMediaContext mediaContext = MC_ALL;
                mediaContext = (ARL_SRC_USB_VIDEO == enSrcNum ) ? MC_VIDEO : MC_AUDIO;
                result = MediaPlayerInterface::GetInstance().ActiveMediaDeviceSet(IN (tDeviceID)SubSource, IN TRUE, IN mediaContext);
            }
            else
            {
                result = MediaPlayerInterface::GetInstance().ActiveMediaDeviceSet(IN (tDeviceID)SubSource, IN TRUE, defaultMediaContext);
            }
#else
            result = MediaPlayerInterface::GetInstance().ActiveMediaDeviceSet(IN (tDeviceID)SubSource, IN TRUE,defaultMediaContext);

#endif
            m_poMainAppInstance->GetOutputWrapper().SetAudioAllocatedDevice((tDeviceID)SubSource);

            // check return value but ignore it
            if (MP_NO_ERROR != result)
                ETG_TRACE_FATAL(("bOnSrcActivity is called by ARL with invalid deviceID: %d", SubSource));
        }

        result = MediaPlayerInterface::GetInstance().SendSourceActivity(SA_ON);

    }
    else if (rfcoSrcActivity.enType == midw_fi_tcl_e8_SrcActivity::FI_EN_PAUSE)
    {
        LocalSPM::GetDataProvider().SetIpodMuteStatus(false);
#ifdef VARIANT_S_FTR_ENABLE_MP_NEXT_POSSIBLE_SOURCE
        VARTRACE(enPosNextSrc);
        if(enPosNextSrc == ARL_SRC_PHONE_VR){

            if(((DTY_IPHONE == deviceInfo.deviceType) || (DTY_IPOD == deviceInfo.deviceType)) && (DCT_BLUETOOTH == deviceInfo.connectionType))
            {
                LocalSPM::GetDataProvider().iPodSiriActivated = 1;
            }
            else if(DTY_BLUETOOTH == deviceInfo.deviceType)
            {
                LocalSPM::GetDataProvider().BTSourcePausedBySIRI = 1;
            }
        }
        else if((enSrcNum != ARL_SRC_BTAUDIO) && (ARL_SRC_NONE == enPosNextSrc) && IsAppleDevice(deviceInfo.deviceType) && (false == LocalSPM::GetDataProvider().GetSPMStandByModeStatus()) )
        {
            LocalSPM::GetDataProvider().SetIpodMuteStatus(true);
        }
#endif
        VARTRACE(LocalSPM::GetDataProvider().GetIpodMuteStatus());
        if(LocalSPM::GetDataProvider().GetIpodMuteStatus())
        {
            ETG_TRACE_USR1(("SA_PAUSE because of MUTE, sending MediaEnine::Stop for IPHONE devices"));
            result = MediaPlayerInterface::GetInstance().SendMediaEngineStop();
        }
        else
        {
            result = MediaPlayerInterface::GetInstance().SendSourceActivity(SA_PAUSE);
            m_poMainAppInstance->GetOutputWrapper().SetAudioAllocatedDevice(DEVICE_ID_NOT_SET);
        }
    }
    else if (rfcoSrcActivity.enType == midw_fi_tcl_e8_SrcActivity::FI_EN_OFF)
    {
        LocalSPM::GetDataProvider().SetIpodMuteStatus(false);
        result = MediaPlayerInterface::GetInstance().SendSourceActivity(SA_OFF);
        m_poMainAppInstance->GetOutputWrapper().SetAudioAllocatedDevice(DEVICE_ID_NOT_SET);
        LocalSPM::GetDataProvider().BTSourcePausedBySIRI = 0;
    }

    if (0 != result)
        bReturn = FALSE;
    else
    {
        vSourceActivityResult(enSrcNum, rfcoSrcActivity);
        bReturn = TRUE;
    }
    return bReturn;
};


/***************************************************************************
** FUNCTION:  virtual tBool FC_MediaPlayer_tclAudioRoutingHandler::bOnAllocate(..
***************************************************************************/
/*!
 * \brief   CALLED BY AUDIO-ROUTING-LIB:
 *          Application specific function after Allocate is processed.
 * \param   [enSrcNum]:  (I) Source Number.
 * \param   rfcoAllocRoute: (I) Reference to Allocate route result
 * \retval  tBool: TRUE, if Application performed operations successfully,
 *          FALSE otherwise
 * \date 11.09.2013 \author Jörg Wohlgemuth (BSOT/ENG)
 **************************************************************************/
tBool fc_mediaplayer_tclAudioRoutingHandler::bOnAllocate(arl_tenSource enSrcNum, const arl_tAllocRouteResult& rfcoAllocRoute)
{
    ENTRY
    tBool bReturn = FALSE;
    tResult result = -1;
    tAudioOutputDevice audioOutDevice;
    if((enSrcNum != ARL_SRC_BTAUDIO) && LocalSPM::GetDataProvider().GetIpodMuteStatus() )
    {
        ETG_TRACE_USR1(("bOnAllocate because of  DEMUTE, Not sending for IPHONE devices"));
        bReturn = TRUE;
    }
    else
    {
        if(rfcoAllocRoute.listOutputDev.strALSADev.size() == 0)     //If empty string, make the audiooutputdevice  to "Dummy_Device"
        {
            strncpy_r(audioOutDevice,"Dummy_Device", sizeof(audioOutDevice));

        }else
        {
            strncpy_r(audioOutDevice, rfcoAllocRoute.listOutputDev.strALSADev[0], sizeof(audioOutDevice));
        }
        result = MediaPlayerInterface::GetInstance().SendAllocate(IN audioOutDevice);

        if (0 != result)
            bReturn = FALSE;
        else
            bReturn = TRUE;

        m_poMainAppInstance->GetOutputWrapper().SetCurrentSourceActive(TRUE);

        /* Set the SourceId as ARL_SRC_BTAUDIO if the allocate is valled for BT Audio */
        if(LocalSPM::GetDataProvider().UseArlSrcBtAudio() && (enSrcNum == ARL_SRC_BTAUDIO))
        {
            m_poMainAppInstance->GetOutputWrapper().SetCurrentSource(enSrcNum);

#if 0 //Will be done later on in bOnSrcActivity
            /* Set the current active device as False*/
            tDeviceInfo deviceInfo;
            result = MediaPlayerInterface::GetInstance().ActiveMediaDeviceGet(deviceInfo);

            if((MP_NO_ERROR == result) && (DTY_BLUETOOTH != deviceInfo.deviceType))
            {
                result = MediaPlayerInterface::GetInstance().ActiveMediaDeviceSet(deviceInfo.deviceID, FALSE);
            }
#endif
        }
        else
            m_poMainAppInstance->GetOutputWrapper().SetCurrentSource(MEDIAPLAYERFBLOCK);
    }

    return bReturn;
};

/***************************************************************************
** FUNCTION:  virtual tBool FC_MediaPlayer_tclAudioRoutingHandler::bOnDeAllocate(
***************************************************************************/
/*!
 * \brief   CALLED BY AUDIO-ROUTING-LIB:
 *          May be overridden by Player App to Release Resources.
 *          Application specific function after DeAllocate is processed.
 * \param   enSrcNum:  (I) Source Number.
 * \retval  tBool: TRUE, if Application performed operations successfully,
 *          FALSE otherwise
 * \date 11.09.2013 \author Jörg Wohlgemuth (BSOT/ENG)
 **************************************************************************/
tBool fc_mediaplayer_tclAudioRoutingHandler::bOnDeAllocate(arl_tenSource enSrcNum)
{
    ENTRY
    tBool bReturn = FALSE;
    tResult result = -1;
    if((enSrcNum != ARL_SRC_BTAUDIO) && LocalSPM::GetDataProvider().GetIpodMuteStatus())
    {
        ETG_TRACE_USR1(("bOnDeAllocate because of  MUTE, Not sending for IPHONE devices"));
        bReturn = TRUE;
    }
    else
    {
        result = MediaPlayerInterface::GetInstance().SendDeAllocate();
        if (0 != result)
            bReturn = FALSE;
        else
            bReturn = TRUE;

        m_poMainAppInstance->GetOutputWrapper().SetCurrentSource(0);
        m_poMainAppInstance->GetOutputWrapper().SetCurrentSourceActive(FALSE);
    }

    return bReturn;
}

tBool fc_mediaplayer_tclAudioRoutingHandler::bOnMuteState(arl_tenSource /*enSrcNum*/, arl_tenMuteState muteState)
{
    ENTRY
    tBool bReturn = FALSE;
    tResult result = -1;
    tMuteState internalMuteState;
    switch (muteState)
    {
        case ARL_EN_MUTESTATE_DEMUTE:
            internalMuteState = MUS_DEMUTED;
            break;
        case ARL_EN_MUTESTATE_MUTE:
            internalMuteState = MUS_MUTED;
            break;
        case ARL_EN_MUTESTATE_DEMUTE_RUNNING:
            internalMuteState = MUS_DEMUTE_RUNNING;
            break;
        default:
            internalMuteState = MUS_DEMUTED;
            ETG_TRACE_FATAL(("Invalid mute state"));
            break;
    }

    result = MediaPlayerInterface::GetInstance().SendMuteStatus(IN internalMuteState);
    if (0 != result)
        bReturn = FALSE;
    else
        bReturn = TRUE;
    return bReturn;
}
