/*
 * FC_MediaPlayer_AudioDbusHandlingProxy.cpp
 *
 *  Created on: Oct 14, 2017
 *  Author: Preethika Sureshbabu
 *
 */


/* ETG definitions */
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_SERVICE_MEDIAPLAYER
#ifdef TARGET_BUILD
#include "trcGenProj/Header/FC_MediaPlayer_AudioDbusHandlingProxy.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_SERVICE_MEDIAPLAYER
#endif
#endif
#include "FunctionTracer.h"
#include "VarTrace.h"

#include "FC_MediaPlayer_AudioDbusHandlingProxy.h"
#include "FC_MediaPlayer_AudioDbusHandlingIpcIF.h"
#include "LocalSPM.h"

#define MAX_AUDIO_VOLUME 40 // Maximum volume given by audio is 40

#define INVALID_VOLUME -1


int AudioDbusHandlingProxy::mCurrentVolumeinAudio = MAX_AUDIO_VOLUME;

AudioDbusHandlingProxy& AudioDbusHandlingProxy::GetInstance(void)
{
    static AudioDbusHandlingProxy instance;
    return instance;
}

AudioDbusHandlingProxy::AudioDbusHandlingProxy()
{
    mSignalHandlers.clear();
    mSignalHandlers["MainSinkSoundPropertyChanged"] = &AudioDbusHandlingProxy::MainSinkSoundPropertyChanged;

    //Property Interface Names
    mInterfacenames.push_back("org.genivi.audiomanager.CommandInterface");
}

AudioDbusHandlingProxy::~AudioDbusHandlingProxy()
{
    // TODO Auto-generated destructor stub
}


bool AudioDbusHandlingProxy::belongs(const char* messageName, const char* params)
{
    //ENTRY
    //Only for applicable signals
    if(!(strcmp(messageName,"MainSinkSoundPropertyChanged")))
    {
        return true;
    }
    return false;
}

bool AudioDbusHandlingProxy::belongs(tU32 serial) //Override for Virtual function in IPCProvider
{
    return false;
}

void AudioDbusHandlingProxy::RouteMethodAnswer(tU32 serial, const char* params)  //Override for Virtual function in IPCProvider
{
    ENTRY

}

void AudioDbusHandlingProxy::RouteMethodRequest(tU32 serial, const char* name, const char* params)  //Override for Virtual function in IPCProvider
{
    (void)serial;
    (void)name;
    (void)params;
}

void AudioDbusHandlingProxy::RouteError(tU32 serial, const char* error)  //Override for Virtual function in IPCProvider
{
    ENTRY
}


void AudioDbusHandlingProxy::RouteSignal(const char* name, const char* params)
{
    //ENTRY

    //ETG_TRACE_USR3(("AudioDbusHandlingProxy signal received %128s:%s",name,params));

    if(!(strcmp(name,"MainSinkSoundPropertyChanged")))
    {
        (this->*mSignalHandlers[name])(params);
    }

}


void AudioDbusHandlingProxy::MainSinkSoundPropertyChanged(const char* params)
{
    ENTRY
    ETG_TRACE_USR3(("AudioDbusHandlingProxy::MainSinkSoundPropertyChanged params %s",params));
    if((LocalSPM::GetDataProvider().AbsoluteVolumeSupportFeatureBT()) &&( LocalSPM::GetDataProvider().AbsoluteVolumeSupportForBTDevice()))
    {
        int literalCount = 0;
        char *ptr = (char*) strchr(params,IPC_DBUS_PARAM_COMMA_DELIMITER_CHAR);
        ETG_TRACE_USR4(("ptr:%p",ptr));
        while (ptr != NULL)
        {
            ptr = strchr(ptr + 1,IPC_DBUS_PARAM_COMMA_DELIMITER_CHAR);
            literalCount++;
        }
        VARTRACE(literalCount);
        std::string strFromChar;
        strFromChar.append(params);
        std::istringstream ss(strFromChar);
        std::string token[literalCount];
        int Volume;
        for (int index = 0; index < literalCount; index++)
        {
            std::getline(ss, token[index], IPC_DBUS_PARAM_COMMA_DELIMITER_CHAR);
            VARTRACE(token[index].c_str());
        }

        if(literalCount >= 3) //MainSinkSoundProperty has minimum three arguments
        {
            if(token[1].compare("26") == 0)//26 is the volume for Entertainment
            {
                sscanf(token[2].c_str(), "%u", &Volume);
                setCurrentVolumeinAudio(Volume);
                //LocalSPM::GetInstance().GetBTControl().SetVolumetoDevice(Volume);
                tAllParameters parameterStringforVolume;
                size_t size1 = sizeof(parameterStringforVolume);
                tDeviceType SMObserver = DTY_BLUETOOTH;
                tResult Result = LocalSPM::GetInstance().GetBTControl().ParameterUPDATE_VOLUME_TO_DEVICE(OUT parameterStringforVolume, IN size1, IN Volume);
                if( MP_NO_ERROR != Result )
                {
                    ETG_TRACE_ERR(("Error while preparing parameter string"));
                }
                else
                {
                    Result = LocalSPM::GetDeviceDispatcher().RouteMessage(IN SMObserver, IN "UPDATE_VOLUME_TO_DEVICE", IN parameterStringforVolume);
                    if( MP_NO_ERROR != Result )
                    {
                        ETG_TRACE_ERR(("Error while sending internal event via SMF"));
                    }
                }
            }
        }
    }
}

void AudioDbusHandlingProxy::UpdateVolume(int Volume)
{
    ENTRY
    ETG_TRACE_USR3(("AudioDbusHandlingProxy::SetVolume Volume is : %d",Volume));
    VARTRACE(Volume);
    if((LocalSPM::GetDataProvider().AbsoluteVolumeSupportFeatureBT()) && (LocalSPM::GetDataProvider().AbsoluteVolumeSupportForBTDevice()) && (Volume != getCurrentVolumeinAudio()))
    {
        bool isError=false;
        int reply_timeout = 4000;
        bool isSystemBus = true;
        string result;

        DbusParam dbusParam1;
        dbusParam1.type = DBUS_TYPE_UINT16;
        dbusParam1.value.append("1");//Default value is 1
        DbusParam dbusParam2;
        dbusParam2.type = DBUS_TYPE_UINT16;
        dbusParam2.value.append("3");//Default value for setting entertainment audio is 3
        DbusParam dbusParam3;
        dbusParam3.type = DBUS_TYPE_INT16;
        stringstream ss;
        ss << Volume;
        string stringVolume = ss.str();
        dbusParam3.value.append(stringVolume);
        DbusParamList dbusParamList;
        dbusParamList.push_back(dbusParam1);
        dbusParamList.push_back(dbusParam2);
        dbusParamList.push_back(dbusParam3);
        const IpcMessageInfo ipcMessageInfo = {IPC_AUDIODBUSHANDLING_SERVICE,IPC_AUDIODBUSHANDLING_OBJECT_PATH,IPC_AUDIODBUSHANDLING_INTERFACE,"SetVolume"};

        LocalSPM::GetIPCProvider().MethodCallWaitForReplyNoOverride(ipcMessageInfo, IN dbusParamList,isSystemBus,reply_timeout,isError,result);
    }
}

int AudioDbusHandlingProxy::getCurrentVolumeinAudio()
{
    Locker locker(&m_MutexForVolume);
    return  mCurrentVolumeinAudio;
}

void AudioDbusHandlingProxy::setCurrentVolumeinAudio(int currentVolumeinAudio)
{
    Locker locker(&m_MutexForVolume);
    mCurrentVolumeinAudio = currentVolumeinAudio;
}

void AudioDbusHandlingProxy::GetCurrentVolumeFromAudio()
{
    ENTRY

    int Volume = INVALID_VOLUME;
    bool isError=false;
    int reply_timeout = 4000;
    bool isSystemBus = true;
    string result;

    DbusParam dbusParam1;
    dbusParam1.type = DBUS_TYPE_UINT16;
    dbusParam1.value.append("1");//Default value is 1
    DbusParamList dbusParamList;
    dbusParamList.push_back(dbusParam1);
    const IpcMessageInfo ipcMessageInfo = {IPC_AUDIODBUSHANDLING_SERVICE,IPC_AUDIODBUSHANDLING_OBJECT_PATH,IPC_AUDIODBUSHANDLING_INTERFACE,"GetListMainSinkSoundProperties"};

    LocalSPM::GetIPCProvider().MethodCallWaitForReplyNoOverride(ipcMessageInfo, IN dbusParamList,isSystemBus,reply_timeout,isError,result);


    if(isError || result.empty())
    {
        ETG_TRACE_USR4(("AudioDbusHandlingProxy::GetCurrentVolumeFromAudio Error in getting current volume from audio"));
    }
    else
    {
        int literalCount = 0;
        const char* tempParam = result.c_str();
        char* ptr = (char*) strchr(tempParam,IPC_DBUS_PARAM_DELIMITER_INT);
        while (ptr != NULL)
        {
            ptr = strchr(ptr + 1,IPC_DBUS_PARAM_DELIMITER_INT);
            literalCount++;
        }
        if(literalCount > 2) //Since the initial Token is Return code and listSoundProperties is an a(nn) [which should have minimum two values
        {
            std::istringstream ss(result);
            std::string token[literalCount];
            for (int index = 0; index < literalCount; index++)
            {
                std::getline(ss, token[index], IPC_DBUS_PARAM_DELIMITER_CHAR);
                ETG_TRACE_USR4(("AudioDbusHandlingProxy::GetCurrentVolumeFromAudio  : Token :%s",token[index].c_str()));
            }
            for (int index = 1; index < literalCount; index++)//index starts with 1 since the first token has return code.
            {
                if (token[index].compare("26") == 0)// 26 is the value for "MSP_VOLUME_ENTERTAINMENT" , the volume that is required to be handled.
                {
                    if((index+1) < literalCount)
                    {
                        sscanf(token[index+1].c_str(), "%d", &Volume);

                        ETG_TRACE_USR4(("AudioDbusHandlingProxy::GetCurrentVolumeFromAudio Volume in device : %d",Volume));
                        //Update the current volume to device.
                        tAllParameters parameterStringforVolume;
                        size_t size1 = sizeof(parameterStringforVolume);
                        tDeviceType SMObserver = DTY_BLUETOOTH;
                        tResult Result = LocalSPM::GetInstance().GetBTControl().ParameterUPDATE_VOLUME_TO_DEVICE(OUT parameterStringforVolume, IN size1, IN Volume);
                        if( MP_NO_ERROR != Result )
                        {
                            ETG_TRACE_ERR(("Error while preparing parameter string"));
                        }
                        else
                        {
                            Result = LocalSPM::GetDeviceDispatcher().RouteMessage(IN SMObserver, IN "UPDATE_VOLUME_TO_DEVICE", IN parameterStringforVolume);
                            if( MP_NO_ERROR != Result )
                            {
                                ETG_TRACE_ERR(("Error while sending internal event via SMF"));
                            }
                        }

                        break;
                    }
                }
                else
                {
                    if((index+1) < literalCount)
                    {
                        index++; //since the the result is a(nn), combination of sound property and its value (eg : 26,16 , where 26 ->"MSP_VOLUME_ENTERTAINMENT" ,16 -> volume value).
                    }
                    else
                    {
                        break;
                    }
                }
            }
        }
        else
        {
            ETG_TRACE_USR4(("AudioDbusHandlingProxy::GetCurrentVolumeFromAudio the result does not have sufficient information, literalCount : %d",literalCount));
        }
    }
}
