
/**
 * @defgroup CCAServiceMediaPlayer CCAServiceMediaPlayer
 * @ingroup MediaPlayer
 * @author Stefan Scherber
 *
 * Public interface for CCAServiceGenricMediaPlayer
 * @{
 */


// Include message framework interface (AMT, msgfw).
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
//Include public FI interface of this service.
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_MEDIAPLAYERFI_FUNCTIONIDS
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_MEDIAPLAYERFI_TYPES
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_MEDIAPLAYERFI_ERRORCODES
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_MEDIAPLAYERFI_SERVICEINFO
//Included for mplay_fi libraries Functions declaration.
#include "mplay_fi_if.h"

//#include "MediaPlayerInterface.h"
#include "TypeDefinitions.h"
#include "Lock.h"

/**
 *  class definitions.
 */
class fc_mediaplayer_tclApp;

/**
 * This class implements the CCAServiceMediaPlayer component.
 */
class fc_mediaplayer_tclService_MediaPlayer:public ahl_tclBaseOneThreadService
{
private:
    Lock mListSearchStringMapLock;             //Lock to protect read,write,access of mapVisitorMsg
    Lock mListSearchStringSerializeLock;       //Lock to serialize creation of searchstring list and its corresponding first message callback
    fc_mediaplayer_tclApp* m_poMainAppInstance;

    tBool bEjectopticalDiscCmdValid;            //marks if valid values are set
    tU16  u16EjectopticalDiscCmdGetSourceAppID; // Target AppID
    tU16  u16EjectopticalDiscCmdGetRegisterID;  // RegisterID
    tU16  u16EjectopticalDiscCmdGetCmdCounter;  // CmdCounter,
    tU16  u16EjectopticalDiscCmdGetFunctionID;  // Function ID


public:

    /**
    * Constructor of the service class
    * @param[in] poMainAppl Pointer to the CCA application
    * @return
    */
    fc_mediaplayer_tclService_MediaPlayer(fc_mediaplayer_tclApp* poMainAppl);

    /**
    * Destructore of the service class
    * @return
    */
    virtual ~fc_mediaplayer_tclService_MediaPlayer();

    void updateClients(tU16 u16FunctionId)
    {
        eUpdateClients(u16FunctionId);
    };

private:


/** message interface for mediaplayer service  */

/** Create list functions */

    /**
    * This function is called when method CreateMediaPlayerQuickPlayList is received
    * Parameter ListType, FilterTag1..4, AutoPlay and DeviceTag are converted and function CreateMediaPlayerQuickPlayList of CustomControl is called.
    *   listType is converted with function ConvertListTypeToInternal
    *   FilterTag1 is casted from unsigned long to tFilterTag1.tag
    *   FilterTag2 is casted from unsigned long to tFilterTag2.tag
    *   FilterTag3 is casted from unsigned long to tFilterTag3.tag
    *   FilterTag4 is casted from unsigned long to tFilterTag4.tag
    *   To convert AutoPlay to tPlayContinuation function ConvertAutoPlayToPlayContinuation is used
    *   To convert DeviceTag function ConvertDeviceTagToInternal is used
    * Function returns listID and listSize. Parameter must be converted ans stored in result message
    *   tListID is casted to unsigned long
    *   tListSize is casted to unsigned long
    * When CreateMediaPlayerQuickPlayList function returns successful the result message is sent back to client
    * Otherwise an error message is sent back
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onCreateMediaPlayerQuickPlayList(amt_tclServiceData* poMessage);

    /**
    * This function is called when method CreateMediaPlayerIndexedList is received
    * Parameter ListType, FilterTag1..3 and Devicetag are converted.
    *   listType is converted with function ConvertListTypeToInternal
    *   FilterTag1 is casted from unsigned long to tFilterTag1.tag
    *   FilterTag2 is casted from unsigned long to tFilterTag2.tag
    *   FilterTag3 is casted from unsigned long to tFilterTag3.tag
    *   To convert DeviceTag function ConvertDeviceTagToInternal is used
    *   Function
    *   tResult CreateMediaPlayerIndexedList(tListID &listID,
    *   tListSize &listSize,
    *   const tListType ListType,
    *   const tFilterTag1 tag1,
    *   const tFilterTag2 tag2,
    *   const tFilterTag3 tag3,
    *   const tDeviceID deviceID);
    *   of ListControl is called
    * Function returns listID and listSize. Parameter are converted ans stored in result message
    *   tListID is casted to unsigned long
    *   tListSize is casted to unsigned long
    * When CreateMediaPlayerQuickPlayList function returns successful the result message is sent back to client.
    * Otherwise ann error message is sent back.
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onCreateMediaPlayerIndexedList(amt_tclServiceData* poMessage);


    /**
    * This function is called when method CreateMediaPlayerIndexedListSearchString is received
    * Parameter are extracted from poMessage:
    *  -u32ListHandleOfParent to
    *  -u32ListHandleOfReplaceableList
    *  -szSearchString
    *
       * Function returns listID and listSize and deviceID. Parameter are converted ans stored in result message
       *   tListID is casted to unsigned long
       *   tListSize is casted to unsigned long
       * When onCreateMediaPlayerIndexedListSearchString function returns successful the result message is sent back to client.
       * Otherwise ann error message is sent back.
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onCreateMediaPlayerListSearchString(amt_tclServiceData* poMessage);  //Roadmap 16014

    /**
    * This function is called when method CreateMediaPlayerFileList is received
    * Paramter are converted:
    *   Convert tU8 (u8DeviceTag) to  tDeviceID using ConvertDeviceTagToInternal
    * Call function CreateMediaPlayerFileList of ListControl
    * Convert return parameters
    *   Cast tListID (listID) to  tU32 (u32ListHandle)
    *   Calculate tU32 (u32ListSize) by adding  numberOfMediaObjects, numberOfPlayLists and numberOfFolders
    *   u8DeviceID will be used friom input message
    *   Calculate u32TotalNumFiles by adding numberOfMediaObjects and numberOfPlayLists
    *   Cast tNumberOfFolders (numberOfFolders) to u32TotalNumFolders
    * When CreateMediaPlayerFileList function returns successful the result message is sent back to client.
    * Otherwise an error message is sent back.
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onCreateMediaPlayerFileList (amt_tclServiceData* poMessage); //Roadmap 13017
    /**
    * This function is called when method CreateMediaPlayerCDList is received
    * Paramter are converted:
    *   Convert tU8 (u8DeviceTag) to  tDeviceID using ConvertDeviceTagToInternal
    * Call function CreateMediaPlayerFileList of ListControl
    * Convert return parameters
    *   Cast tListID (listID) to  tU32 (u32ListHandle)
    *   Calculate tU32 (u32ListSize) by adding  numberOfMediaObjects, numberOfPlayLists and numberOfFolders
    *   u8DeviceID will be used friom input message
    *   Calculate u32TotalNumFiles by adding numberOfMediaObjects and numberOfPlayLists
    *   Cast tNumberOfFolders (numberOfFolders) to u32TotalNumFolders
    * When CreateMediaPlayerFileList function returns successful the result message is sent back to client.
    * Otherwise an error message is sent back.
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onCreateMediaPlayerCDList (amt_tclServiceData* poMessage); //Roadmap 13017

    /**
    * This function is called when method CreateMediaPlayerFileListExt is received
    * Paramter are converted:
    *   Convert tU8 (u8DeviceTag) to  tDeviceID using ConvertDeviceTagToInternal
    * Call function CreateMediaPlayerFileListExt of Interface
    * Convert return parameters
    *   Cast tListID (listID) to  tU32 (u32ListHandle)
    *   Calculate tU32 (u32ListSize) by adding  numberOfMediaObjects, numberOfPlayLists and numberOfFolders
    *   u8DeviceID will be used friom input message
    *   Calculate u32TotalNumFiles by adding numberOfMediaObjects and numberOfPlayLists
    *   Cast tNumberOfFolders (numberOfFolders) to u32TotalNumFolders
    * When CreateMediaPlayerFileListExt function returns successful the result message is sent back to client.
    * Otherwise an error message is sent back.
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onCreateMediaPlayerFileListExt (amt_tclServiceData* poMessage); //finished: 100%

    /**
    * This function is called when method CreateMediaPlayerPlaylistList is received
    * Call function CreateMediaPlayerPlaylistList of ListControl
    * Convert return parameters
    *   Cast tListID (listID) to  tU32 (u32ListHandle)
    *   Cast listSize to tU32 (u32ListSize)
    * When CreateMediaPlayerPlaylistList function returns successful the result message is sent back to client.
    * Otherwise an error message is sent back.
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onCreateMediaPlayerPlaylistList (amt_tclServiceData* poMessage);

/** Reqeust list slice functions */

    /**
    * This function is called when method RequestMediaPlayerIndexedListSlice is received
    * Parameter listID, WindowStart and WindowSize are  converted.
    *   ListHandle: unsigned long is casted to listID
    *   WindowStart: unsigned long is casted to tRowNumber
    *   WindowSize: unsigned word is casted to tRowNumber
    * Function RequestMediaPlayerIndexedListSlice of MediaPlayerInterface is called
    * Function returns a vector of MediaObjects. Each element of the vector is converted to mplay_fi_tcl_MPlayMediaObjectsItem and
    * push_back into the message object.
    *   mplay_mplayfi_tclMsgRequestMediaPlayerIndexedListSliceMethodResult oFiDataObject;
    *   for each mediaObject
    *       mplay_fi_tcl_MPlayMediaObjectsItem mplayMediaObject;
    *       convert parameters using ConvertMediaObjectsItemToMPLAY
    *       call oFiDataObject.oMediaObjects.oItems.push_back(mplayMediaObject);
    *
    * When RequestMediaPlayerIndexedListSlice function returns successful the result message is sent back to client.
    * Otherwise an error message is sent back.
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onRequestMediaPlayerIndexedListSlice (amt_tclServiceData* poMessage);

    /**
    * This function is called when method RequestMediaPlayerQuickPlayListSlice is received
    * Parameter listID, WindowStart and WindowSize are converted.
    *   ListHandle: unsigned long is casted to listID
    *   WindowStart: unsigned long is casted to tRowNumber
    *   WindowSize: unsigned word is casted to tRowNumber
    * Function RequestMediaPlayerIndexedListSlice of MediaPlayerInterface is called
    * Function returns a vector of MediaObjects. Each element of the vector is converted to mplay_fi_tcl_MPlayMediaObjectsItem and
    * push_back into the message object.
    *   mplay_mplayfi_tclMsgRequestMediaPlayerQuickPlayListSliceMethodResult oFiDataObject;
    *   for each mediaObject
    *       mplay_fi_tcl_MPlayMediaObjectsItem mplayMediaObject;
    *       convert parameters using ConvertMediaObjectsItemToMPLAY
    *       call oFiDataObject.oMediaObjects.oItems.push_back(mplayMediaObject);
    *
    * When RequestMediaPlayerIndexedListSlice function returns successful the result message is sent back to client.
    * Otherwise an error message is sent back.
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onRequestMediaPlayerQuickPlayListSlice (amt_tclServiceData* poMessage);

    /**
    * This function is called when method RequestMediaPlayerFileListSlice is received
    * Parameter listID, WindowStart and WindowSize are converted.
    *   ListHandle: unsigned long is casted to listID
    *   WindowStart: unsigned long is casted to tRowNumber
    *   WindowSize: unsigned word is casted to tRowNumber
    * Function RequestMediaPlayerFileListSlice
    * of ListControl is called
    * Function returns a vector of tFiles. Each element of the vector is converted to mplay_fi_tcl_MPlayFileListItem and
    * push_back into the message object.
    *   for each item
    *       mplay_fi_tcl_MPlayFileListItem fileListItem;
    *       convert parameters using ConvertFileItemToMPLAY
    *       call oFiDataObject.oFileList.oItems.push_back(fileListItem);
    *
    * When RequestMediaPlayerFileListSlice function returns successful the result message is sent back to client.
    * Otherwise an error message is sent back.
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onRequestMediaPlayerFileListSlice (amt_tclServiceData* poMessage);

    /**
    * This function is called when method RequestMediaPlayerPlaylistListSlice is received
    * Parameter listID, WindowStart and WindowSize are  converted.
    *   ListHandle: unsigned long is casted to listID
    *   WindowStart: unsigned long is casted to tRowNumber
    *   WindowSize: unsigned word is casted to tRowNumber
    * Function RequestMediaPlayerFileListSlice
    * of ListControl is called
    * Function returns a vector of tFiles. Each element of the vector is converted to mplay_fi_tcl_MPlayFileListItem and
    * push_back into the message object.
    *   for each item
    *       mplay_fi_tcl_MPlayFileListItem fileListItem;
    *       convert parameters using ConvertFileItemToMPLAY
    *       call oFiDataObject.oFileList.oItems.push_back(fileListItem);
    *
    * When RequestMediaPlayerFileListSlice function returns successful the result message is sent back to client.
    * Otherwise an error message is sent back.
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onRequestMediaPlayerPlaylistListSlice (amt_tclServiceData* poMessage);

    /**
    * This function is called when method ReleaseMediaPlayerList is received
    * Parameter listID is converted. Function ReleaseMediaPlayerList of ListControl is called
    * When ReleaseMediaPlayerList function returns successful the result message is sent back to client.
    * Otherwise ann error message is sent back.
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onReleaseMediaPlayerList (amt_tclServiceData* poMessage);

    /**
    * This function is called when method playbackSpeedSet is received
    * Parameter playbackDirection and playbackSpeed are converted.
    *   mplay_fi_tcl_e8_MPlaybackDirection is converted to tPEPlaybackDirection using ConvertPlaybackDirectionToInternal.
    *   mplay_fi_tcl_e8_MPlaybackSpeed is converted to tPlaybackSpeed using ConvertPlaybackSpeedToInternal.
    * Function SendPlaybackSpeed of PlayerManager is called.
    * When SendPlaybackSpeed function returns  the result message is sent back to client. No error message is sent to client
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onPlaybackSpeed(amt_tclServiceData* poMessage);
    /**
    * This function is called when method RequestPlaybackAction is received
    * Parameter playbackAction and nextPrevSkipCounter are converted.
    *   mplay_fi_tcl_e8_MPlayAction is converted to tPlaybackAction using ConvertPlaybackActionToInternal
    *   cast tU8 (u8NextPrevSkipCount) to tNextPrevSkipCount
    * Function SendPlaybackAction of PlayerManager is called.
    * When SendPlaybackAction function returns  the result message is sent back to client. No error message is sent to client
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onRequestPlaybackAction (amt_tclServiceData* poMessage);

    /**
    * This function is called when method SeekTo is received
    * Parameter PlaypointPosition and PlaypointFormat are converted.
    *   cast tU32 (u32PlaypointPosition) tPlaytime (playpointPosition)
    *   convert mplay_fi_tcl_e8_MPlayPlaypointFormat to tPlaypointFormat  using ConvertPlaypointFormatTo Internal
    * Function SendSeekTo of PlayerManager is called.
    * When SendSeekTo function returns  the result message is sent back to client. No error message is sent to client
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onSeekTo (amt_tclServiceData* poMessage);

    /**
    * This function is called when method GetMediaObjectAlbumArtInfo is received
    * This function stores sourceID, registerID, functionID and cmdCounter in a variable of type tUserContext
    * and calls GetMediaObjectAlbumArtInfo of DataProvider with albumArt, sizeX=160, sizeY=160, mimeType=MMT_PNG and the variable with the userContext.
    * The answer message is NOT sent back within this function.
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onGetMediaObjectAlbumArtInfo (amt_tclServiceData* poMessage);

    /**
    * This function is called when method GetMediaObjectAlbumArt is received
    * This function stores sourceID, registerID, functionID and cmdCounter in a variable of type tUserContext
    * and calls GetMediaObjectAlbumArt of DataProvider with albumArt, sizeX=160, sizeY=160, mimeType=MMT_PNG and the variable with the userContext.
    * The answer message is NOT sent back within this function.
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onGetMediaObjectAlbumArt (amt_tclServiceData* poMessage);

    /**
    * This function is called when method QuickSearch is received
    * Parameter listID is converted. Function QuickSearch of ListControl is called, where its arguements are-:
    *     listID = oFiDataObjectMethodStart.u32ListHandle
    *     startposition = oFiDataObjectMethodStart.u32Position
    *     searchstring = oFiDataObjectMethodStart.sSearchChar
    * Function returns a tPosition and tSearchResult, which must be converted to u32Position and oSearchResult(using ConvertQuickSearchResultToMPLAY)
    * and stored in the result message.
    *
    * When QuickSearch function returns successful the result message is sent back to client.
    * Otherwise an error message is sent back.
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onQuickSearch (amt_tclServiceData* poMessage);

    /**
    * This function is called when method SearchKeyboardMediaPlayerList is received
    * Parameter listID is converted. Function SearchKeyboardMediaPlayerList of ListControl is called
    * Function returns a vector<tSearchKeyboard>, which must be converted to SearchKeyboardList and stored in the result message.
    * for each item of the vector
    *   mplay_fi_tcl_MPlaySearchKeyboardListItem mplayItem;
    *   mplayItem.sSearchKeyboardLetter.bSet(item.letter , mplay_fi_tclString::FI_EN_UTF8)
    *   mplayItem.bLetterAvailable = item.available;
    *   mplayItem.u32LetterStartIndex = startIndex;
    *   mplayItem.u32LetterEndIndex = endIndex
    *   oFiDataObject.oSearchKeyboardList.oItems.push_back(mplayItem);
    * When SearchKeyboardMediaPlayerList function returns successful the result message is sent back to client.
    * Otherwise an error message is sent back.
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onSearchKeyboardMediaPlayerList (amt_tclServiceData* poMessage);

    /**
    * This function is called when method GetMediaObject is received
    * Paramters are converted
    *   Cast tU32 (u32Tag) into tObjectID
    *   Convert e8CategoryType to tCategoryType using ConvertCategoryTypeToInternal
    * Call function GetMediaObject of ListControl
    * Function returns a mediaObject. Convert mediaObject using ConvertMediaObjectToMPLAY
    * When GetMediaObject function returns successful the result message is sent back to client.
    * Otherwise an error message is sent back.
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onGetMediaObject (amt_tclServiceData* poMessage);

    /**
    * This function is called when method PlayMediaPlayerObject is received
    * Parameter objectID and autoPlay are converted.
    *   tag is casted to tObjectID (objectID)
    *   AutoPlay ist converted to tPlayContinuation using ConvertAutoPlayToPlayContinuation
    * Function PlayMediaPlayerObject of CustomControl is called
    * Function returns listId and listSize. Parameters are converted and stored in result message.
    *   listID is casted to unsigned long (listHandle)
    *   listSize is casted to unsigend long (ListSize)
    * When PlayMediaPlayerObject function returns successful the result message is sent back to client.
    * Otherwise an error message is sent back.
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onPlayMediaPlayerObject (amt_tclServiceData* poMessage);

    /**
    * This function is called when method PlayItemFromList is received
    * Parameter listID, index and offset are converted.
    * Function PlayItemFromList of PlayerManager is called
    * Function returns listSize. Parameter must be converted and stored in result message.
    * When PlayItemFromList function returns successful the result message is sent back to client.
    * Otherwise an error message is sent back.
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onPlayItemFromList (amt_tclServiceData* poMessage);

    /**
     * This function is called when method PlayItemFromListByTag is received
     * Parameter listID objectID are converted.
     * Function PlayItemFromListByTag of PlayerManager is called
     * Function returns listSize. Parameter must be converted and stored in result message.
     * When PlayItemFromListByTag function returns successful the result message is sent back to client.
     * Otherwise an error message is sent back.
     * @param[in] poMessage Message
     * @return void
     */
    tVoid onPlayItemFromListByTag(amt_tclServiceData* poMessage);

    /**
    * This function is called when method ClearMediaPlayerData is received
    * Function ClearMediaPlayerData of DataProvider is called
    * When ClearMediaPlayerData function returns successful the result message is sent back to client. No error message is sent to client
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onClearMediaPlayerData (amt_tclServiceData* poMessage);

    /**
    * This function is called when method RequestListInformation is received
    * Paramter tListID listID is  converted
    * Function RequestListInformation of ListControl is called
    * Return parameters are converted
    *   tListType (listType) to mplay_fi_tcl_e8_MPlayListType using ConvertListTypeToMPLAY
    *   tListID (parentListID) is casted to tU32 (ParanetListHandle)
    *   tDeviceID &deviceID to tU8 using ConvertDeviceTagToMPLAY
    *   tPosition (position) is casted to tU32 (Position)
    *   tListSize (listSize) is casted to tU32 (ListSize)
    * When RequestListInformation function returns successful the result message is sent back to client.
    * Otherwise an error message is sent back.
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onRequestListInformation (amt_tclServiceData* poMessage);

    /**
    * This function is called when method TransferTagsToDevice is received
    * Parameter are converted
    *   tU8 (u8DeviceTag) is converted to tDeviceTag using ConvertDeviceTagToInternal
    *   for each item of the vector mplay_fi_tcl_MPlayTagTransfer_2 (oTagTransfer)
    *       ConvertTransferTagToInternal is called and return values is stored in vector
    * Function TransferTags of MediaPlayerInterface is called
    * Return values are converted
    *     tTagTransferStatus (transferStatus) is converted to mplay_fi_tcl_e8_MPlayTagTransferStatus using ConvertTransferStatusToMPLAY
    *     for each item of the vector untransferredTags
    *         ConvertUntransferredTagsToMPLAY is called
    * When TransferTags function returns successful the result message is sent back to client.
    * Otherwise an error message is sent back.
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onTransferTagsToDevice (amt_tclServiceData* poMessage);


    /**
    * This function is called when method Umount is received
    * Parameter are converted
    *   tU8 (u8DeviceTag) is converted to tDeviceTag using ConvertDeviceTagToInternal
    * Function Umount of MediaPlayerInterface is called
    * Return values are converted
    *     UmountResult is converted to mplay_fi_tcl_e8_MPlayUmountResult using ConvertUmountResultToMPLAY
    * When Umount function returns successful the result message is sent back to client.
    * Otherwise an error message is sent back.
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onUmount (amt_tclServiceData* poMessage); //Roadmap 13003 SDCard

    /**
    * This function is called when method DiagnosisPlaySong is received
    * Parameter are converted
    *   deviceType is converted to tDeviceTag using ConvertDeviceTypeToInternal
    *   filename ic copied
    * Function DiagnosisPlaySong of MediaPlayerInterface is called
    * When DiagnosePlaySong function returns successful the result message is sent back to client.
    * Otherwise an error message is sent back.
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onDiagnosisPlaySong (amt_tclServiceData* poMessage);

    /**
    * This function is called when method Reindexing is received
    * Parameter are converted
    *   tU8 (u8DeviceTag) is converted to tDeviceTag using ConvertDeviceTagToInternal
    * Function reindexing of MediaPlayerInterface is called
    * When Reindexing function returns successful the result message is sent back to client.
    * Otherwise an error message is sent back.
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onReindexing (amt_tclServiceData* poMessage);

    /**
    * R8976_UC3_LLD3.1_SEQ1
    * This function is called when method CreateinternalFileNamePlaylist is received
    * Parameter are converted
    *   tU8 (u8DeviceTag) is converted to tDeviceTag using ConvertDeviceTagToInternal
    *   sName is copied to playlistName
    * Function CreateInternalFileNamePlaylist of MediaPlayerInterface is called
    * When Reindexing function returns successful the result message is sent back to client.
    *   sPath is copied to sPlaylistPath
    * Otherwise an error message is sent back.
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onCreateInternalFileNamePlaylist (amt_tclServiceData* poMessage);

    /**
    * R8976_UC3_LLD3.1_SEQ2
    * This function is called when method AddFileNameToPlaylist is received
    * Parameter are converted
    *   sPlaylistPath is copied to playlistPath
    *   sFilenamePath is copied to filenamePath
    *   u32position is casted to position
    * Function AddFileNameToPlaylist of MediaPlayerInterface is called
    * When AddFileNameToPlaylist function returns successful the result message is sent back to client.
    * Otherwise an error message is sent back.
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onAddFileNameToPlaylist (amt_tclServiceData* poMessage);




    /**
    * R8976_UC3_LLD3.1_SEQ3
    * This function is called when method DeleteEntryFromPlaylist is received
    * Parameter are converted
    *   sPlaylistPath is copied to playlistPath
    *   u32position is casted to position
    * Function DeleteEntryFromPlaylist of MediaPlayerInterface is called
    * When DeleteEntryFromPlaylist function returns successful the result message is sent back to client.
    * Otherwise an error message is sent back.
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onDeleteEntryFromPlaylist (amt_tclServiceData* poMessage);

    /**
     * R8976_UC3_LLD3.3_SEQ4
    * This function is called when method RenameInternalPlaylist is received
    * Parameter are converted
    *   sPlaylistPath is copied to playlistPath
    *   sName is copied to playlistName
    * Function RenameInternalPlaylist of MediaPlayerInterface is called
    * When RenameInternalPlaylist function returns successful the result message is sent back to client.
    * Otherwise an error message is sent back.
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onRenameInternalPlaylist (amt_tclServiceData* poMessage);

    /**  R8976_UC3_LLD3.2
     *
    * This function is called when method DeleteInternalPlaylist is received
    * Parameter are converted
    *   sPlaylistPath is copied to playlistPath
    * Function DeleteInternalPlaylist of MediaPlayerInterface is called
    * When DeleteInternalPlaylist function returns successful the result message is sent back to client.
    * Otherwise an error message is sent back.
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onDeleteInternalPlaylist (amt_tclServiceData* poMessage);

    /**
     * R8976_UC3_LLD3.5_SEQ5
    * This function is called when method ReorderInternalPlaylist is received
    * Parameter are converted
    *   sPlaylistPath is copied to playlistPath
    * Function onReorderInternalPlaylist of MediaPlayerInterface is called
    * When ReorderInternalPlaylist function returns successful the result message is sent back to client.
    * Otherwise an error message is sent back.
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onReorderInternalPlaylist (amt_tclServiceData* poMessage);//16003 CD Ripping With Gracenote
    /**
    * This function is called when method CreateMediaPlayerInternalPlaylistList is received
    * Parameter are converted
    *   tU8 (u8DeviceTag) is converted to tDeviceTag using ConvertDeviceTagToInternal
    * Function CreateMediaPlayerInternalPlaylistList of MediaPlayerInterface is called
    * When CreateMediaPlayerInternalPlaylistList function returns successful the result message is sent back to client.
    *   listID is casted to u32ListHandle
    *   listSize is casted to u32ListSize
    * Otherwise an error message is sent back.
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onCreateMediaPlayerInternalPlaylistList (amt_tclServiceData* poMessage);

        /**
    * This function is called when method RequestMediaPlayerInternalPlaylistListSlice is received
    * Parameter listID, WindowStart and WindowSize are  converted.
    *   ListHandle: unsigned long is casted to listID
    *   WindowStart: unsigned long is casted to tRowNumber
    *   WindowSize: unsigned word is casted to tRowNumber
    * Function RequestMediaPlayerIndexedListSlice of MediaPlayerInterface is called
    * Function returns a vector of MediaObjects. Each element of the vector is converted to mplay_fi_tcl_MPlayMediaObjectsItem and
    * push_back into the message object.
    *   mplay_mplayfi_tclMsgRequestMediaPlayerInternalPlaylistListSliceMethodResult oFiDataObject;
    *   for each mediaObject
    *       mplay_fi_tcl_MPlayMediaObjectsItem mplayMediaObject;
    *       convert parameters using ConvertMediaObjectsItemToMPLAY
    *       call oFiDataObject.oMediaObjects.oItems.push_back(mplayMediaObject);
    *
    * When RequestMediaPlayerIndexedListSlice function returns successful the result message is sent back to client.
    * Otherwise an error message is sent back.
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onRequestMediaPlayerInternalPlaylistListSlice (amt_tclServiceData* poMessage); //finished: 100%

    /**
    * This function is called when method GetListPositionOfObject is received
    * Parameter listID and objectID are converted.
    * Function GetListPositionOfObject of MediaPlayerInterface is called
    * When GetListPositionOfObject function returns successful the result message is sent back to client.
    * Otherwise an error message is sent back.
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onGetListPositionOfObject(amt_tclServiceData* poMessage); //finished: 100%

    /**
     * This function is called when method StartSlideshow is received
     * Parameter listID and objectID are converted.
     * Function StartSlideshow of MediaPlayerInterface is called
     * When StartSlideshow function returns successful the result message is sent back to client.
     * Otherwise an error message is sent back.
     * @param[in] poMessage Message
     * @return void
     */
    tVoid onStartSlideshow (amt_tclServiceData* poMessage); //finished: 100%

    /**
    * This function is called when method onRequestSlideshowAction is received
    * Parameter playbackAction and nextPrevSkipCounter are converted.
    *   mplay_fi_tcl_e8_MPlayAction is converted to tPlaybackAction using ConvertPlaybackActionToInternal
    *   cast tU8 (u8NextPrevSkipCount) to tNextPrevSkipCount
    * Function SendSlideshowAction of MediaPlayerInterface is called.
    * When SendSlideshowAction function returns  the result message is sent back to client. No error message is sent to client
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onRequestSlideshowAction (amt_tclServiceData* poMessage); //finished: 100%

    /**
         * This function is called if HMI sends eject command
         * @param[in] if eject or insert is demanded
         * @return < 0: error, = 0: OK
         */

    tVoid onEjectOpticalDiscMethodStart(amt_tclServiceData* poMessage); //Roadmap: 15002_CDAudio_DetectionAndDiagnosis

    /**This function is called when method CreateMediaPlayerIndexedImageFolderList is received by media player
    *   @param[in] ListType,
    *   @param[in] path and
    *   @param[in] Devicetag are converted.
    *   listType is converted with function ConvertListTypeToInternalpath is converted using string function
    *   To convert DeviceTag function ConvertDeviceTagToInternal is used.
    *   If ListType is LTY_IMAGE_FOLDER :
    tResult CreateMediaPlayerIndexedImageFolderList (tListID &listID,  tListSize &listSize,const tListType ListType, const tDeviceID deviceID) of mediaPlayerInterface is called
    *   If ListType is LTY_IMAGE_FOLDER_ITEM :
    tResult CreateMediaPlayerIndexedImageFolderItemList (tListID &listID,  tListSize &listSize,const tpath path, const tDeviceID deviceID) of mediaPlayerInterface is called
    *   Both functions returns listID and listSize.
    *   @param[in]  listID
    *   @param[in]  listSize
    *   Return parameters are converted and stored in result message tListID is casted to unsigned long tListSize is casted to unsigned long
    *   @return < 0: error, = 0: OK.
    */
    tVoid onCreateMediaPlayerIndexedImageFolderList(amt_tclServiceData* poMessage);
    /**This function is called when method RequestMediaPlayerIndexedImageFolderListSlice is received by mediaplayer
    *   @param[in] ListHandle
    *   @param[in] WindowStart and
    *   @param[in] WindowSize are converted.
    *   Function RequestMediaPlayerIndexedImageFolderListSlice of mediaPlayerInterface is called
    *   Function returns a vector of ImageObjects. Each element of the vector is converted to mplay_fi_tcl_MPlayImageObjectItem
        and push_back into the message object using ConvertImageObjectItemToMPLAY
    *   If ListType is LTY_IMAGE_FOLDER_ITEM :
    tResult CreateMediaPlayerIndexedImageFolderItemList (tListID &listID,  tListSize &listSize,const tpath path, const tDeviceID deviceID) of mediaPlayerInterface is called
    *   Both functions returns listID and listSize.
    *   @param[in]  listID
    *   @param[in]  listSize
    *   Return parameters are converted and stored in result message tListID is casted to unsigned long tListSize is casted to unsigned long
    *   @return < 0: error, = 0: OK.
    */
    tVoid onRequestMediaPlayerIndexedImageFolderListSlice(amt_tclServiceData* poMessage);

     //-->Internal DVD
     /**
    * This function is called when method RequestDiscOperation is received
    * Parameter DiscOperation is converted.
    * Function sendDiscOperationCommand of MediaPlayerInterface is called
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onRequestDiscOperation(amt_tclServiceData* poMessage);
     /**
    * This function is called when method RequestVCDAudioChannel is received
    * Parameter Audio Channel and selectionType are converted.
    * Function setAudioChannel of MediaPlayerInterface is called with disctype as VCD
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onRequestVCDAudioChannel(amt_tclServiceData* poMessage);
    /**
    * This function is called when method RequestVCDAudioChannel is received
    * Parameter Audio Channel and selectionType are converted.
    * Function setAudioChannel of MediaPlayerInterface is called with disctype as DVD
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onRequestDVDAudioChannel(amt_tclServiceData* poMessage);
    /**
    * This function is called when method SendNavigationKey is received
    * Parameter navigationKey is converted.
    * Function sendNavigationCommand of MediaPlayerInterface is called
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onSendNavigationKey(amt_tclServiceData* poMessage);
    /**
    * This function is called when method SendTouchCommand is received
    * Parameter current x ,y co-ordinates , overall x,y co-ordinates and touch status are converted.
    * Function sendTouchCommand of MediaPlayerInterface is called
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onSendTouchCommand(amt_tclServiceData* poMessage);
    /**
    * This function is called when method RequestDirectSearch is received
    * Parameter related to the File number and folder number are converted.
    * Function setPlayerSettings of MediaPlayerInterface is called
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onRequestDirectSearch(amt_tclServiceData* poMessage);
    /**
    * This function is called when method RequestAngleChange is received
    * Parameter related to the angleNumber and selectionType are converted.
    * Function sendDirectSearchCommand of MediaPlayerInterface is called
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onRequestAngleChange(amt_tclServiceData* poMessage);
    /**
    * This function is called when method SetMenuPlaybackControl is received
    * Parameter related to Menu Type is converted.
    * Function setMenuPlayback of MediaPlayerInterface is called
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onSetMenuPlaybackControl(amt_tclServiceData* poMessage);
    /**
    * This function is called when method SelectDirectNumber is received
    * Parameter equivalent to the direct number is converted.
    * Function selectDirectNumber of MediaPlayerInterface is called
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onSelectDirectNumber(amt_tclServiceData* poMessage);
    /**
    * This function is called when method RequestTitleSearch is received
    * Parameter equivalent to the title/group number is converted.
    * Function selectDirectNumber of MediaPlayerInterface is called
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onRequestTitleSearch(amt_tclServiceData* poMessage);
    /**
    * This function is called when method RequestSubtitleChange is received
    * Parameter equivalent to the subtitle number ,selection type , On/off control is converted.
    * Function setSubtitle of MediaPlayerInterface is called
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onRequestSubtitleChange(amt_tclServiceData* poMessage);
    /**
    * This function is called when method RequestCMSkip is received
    * Parameter equivalent to the skip value is converted.
    * Function sendCMSkipCommand of MediaPlayerInterface is called
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onRequestCMSkip(amt_tclServiceData* poMessage);
    /**
     * This function is called when method RequestDVDTemperature is received
     * ASynchronous Function , Method result will be sent later using userContext
     * Function RequestDVDTemperature of MediaPlayerInterface is called
     * @param[in] poMessage Message
     * @return void
     */
    tVoid onRequestDVDTemperature (amt_tclServiceData* poMessage);
//<--- Internal DVD
    //finished: 100%

    /**
    * This function is called when method ClearLastModePause is received
    * Paramters converted:
    * Convert tU8 (u8DeviceTag) to  tDeviceID using ConvertDeviceTagToInternal
    *
    * This function informs MediaplayerInterface  to Clear/Ignore the lastmode pause for the Device.
    * So,Once device is activated,irrespective of its lastmode pause,playback is resumed.
    * @param[in] poMessage Message
    * @return void
    */
    tVoid OnClearLastModePause (amt_tclServiceData* poMessage);

public:

    /** Function called by OutputWrapper for asynchronous answers

    /**
     * This function is called by MediaPlayer core when the result of GetMediaObjectAlbumArtInfo is calculated
     * The function convert parameters, and sends the answer to the client stored in userContext
     * Convert mimeType enum to string ("image/png", "image/x-ms-bmp", "image/gif", "image/jpeg")
     * @param[in] mimeType MIME image subtype
     * @param[in] size size of image in bytes
     * @param[in] userContext client information
     * @return < 0: error, = 0: OK
     */
    tResult SendGetMediaObjectAlbumArtInfoAnswer(tMimeType mimeType, tImageSize size, tUserContext userContext);


    /**
     * This function is called by MediaPlayer when the result of GetMediaObjectAlbumArt is calculated
     * The function convert parameters, and sends the answer to the client stored in userContext
     * @param[in] imageData image data
     * @param[in] imageSize size of image in bytes
     * @param[in] userContext  client information
     * @return < 0: error, = 0: OK
     */
    tResult SendGetMediaObjectAlbumArtAnswer(tImageData imageData, tImageSize imageSize, tUserContext userContext);



    /**
     * This function is called to send method result to HMI after HMI has send eject to MediaPlayer which has forwarded it to VD_DVM

     * @param[in] holds asynchronous result from eject cmd
     * @return < 0: error, = 0: OK
     */

    tResult SendOpticalDiscEjectMethodResult(tDMOpticalDiscEjectMethodResult entOpticalDiscEjectMethodResult);//Roadmap 15002_CDAudio_DetectionAndDiagnosis

    /**
     * This function is called by MediaPlayer when an error message shall be sent back
     * The function sends an error messgage back to client to the client stored in userContext
     * @param[in] userContext  client information
     * @return < 0: error, = 0: OK
     */
    tResult SendError(tErrorCode errorCode, tUserContext userContext);

   //--->>Roadmap 16014

   /**
     * function to return first method result after fct. onCreateMediaPlayerListSearchString() has been called
     */
    tVoid Send_onCreateMediaPlayerListSearchString_MethodReturnFirst(IN tListID listIDParent, IN tListID listID, IN tListSize listSize, IN tDeviceID deviceID);

   /**
     * function to return method result after fct. onCreateMediaPlayerListSearchString() has been called. This function is to update previous resulled and is thought to be called to show progress
     */
    tVoid Send_onCreateMediaPlayerListSearchString_MethodReturnMiddle(IN tListID listIDParent, tListID listID, IN tListSize listSize, IN tDeviceID deviceID);

    /**
     * function to return method result after fct. onCreateMediaPlayerListSearchString() has been called - returns final result
     */
    tVoid Send_onCreateMediaPlayerListSearchString_MethodReturnLast(IN tListID listIDParent, IN tListID listID, IN tListSize listSize, IN tDeviceID deviceID);

    /**
      * function to return method result after fct. onCreateMediaPlayerListSearchString() has been called - returns in course of abortion
      */
     tVoid Send_onCreateMediaPlayerListSearchString_MethodReturnAbort(IN tListID listIDParent, IN tListID listID, IN tListSize listSize, IN tDeviceID deviceID);


    //<<-----Roadmap 16014



     //>>-----Roadmap 16003

     /**This function is called when method 'DeleteMediaContentByFilterTags' is received by mediaplayer
      *   @param[in] ListType
      *   @param[in] FilterTag1
      *   @param[in] FilterTag2
      *   @param[in] FilterTag3
      *   @param[in] Devicetag are converted.
      *   Function DeleteMediaContent of mediaPlayerInterface is called
      *   Function intern create a temporary thread to delete media content, once the operation is  finished Send_onDeleteMediaContent will be called
      *   @return < 0: error, = 0: OK.
     */
    tVoid onDeleteMediaContentByFilterTags(amt_tclServiceData* poMessage);




     /**This function is called when method 'DeleteMediaContentByMediaObjectTags' is received by mediaplayer
      *   @param[in] oMediaObjectTags list of media object tags to be deleted

      *   @param[in] Devicetag are converted.
      *   Function DeleteMediaContent of mediaPlayerInterface is called
      *   Function intern create a temporary thread to delete media content, once the operation is  finished Send_onDeleteMediaContent will be called
      *   @return < 0: error, = 0: OK.
     */
     tVoid onDeleteMediaContentByMediaObjectTags(amt_tclServiceData* poMessage);


     /**This function is called when method 'DeleteMediaContentByMediaObjectUrls' is received by mediaplayer
      *   @param[in] oMPlayMediaObjectUrls list of media object urls to be deleted

      *   @param[in] Devicetag are converted.
      *   Function DeleteMediaContent of mediaPlayerInterface is called
      *   Function intern create a temporary thread to delete media content, once the operation is  finished Send_onDeleteMediaContent will be called
      *   @return < 0: error, = 0: OK.
     */
     tVoid onDeleteMediaContentByMediaObjectUrls(amt_tclServiceData* poMessage);


     /**
      * This function is called when the delete media content operation is completed.
      * This function calls method return after fi method 'DeleteMediaContentByMediaObjectUrls' or 'DeleteMediaContentByMediaObjectTags' or  'DeleteMediaContentByFilterTags' is called
      * @return < 0: error, = 0: OK
     */
       tResult Send_OnDeleteMediaContentMethodResult(IN tDeleteMediaContentType deleteMediaContentType, IN tFileOperationErrorCodes tFileOperationErrorCodes, IN tU16 numofFilesDeleted);



       /**This function is called when method 'EditMetaDataByMediaObjectTag' is received by mediaplayer
        *   @param[in] u32Tag is the mediaobject unique 'tag'
        *   @param[in] sTagGenre is the new 'Genre' field to be added
        *   @param[in] sTagAlbum is the new 'Album" field to be added
        *   @param[in] sTagArtist is the new 'Artist' field to be added
        *   @param[in] sTagTitleist is the new 'Title' field to be added
        *   @param[in] sTagComposer is the new 'Composer' field to be added
        *   @param[in] TagYear is the new 'Year' field to be added
        *   @param[in] Devicetag are converted.
        *   Function EditMetaData of mediaPlayerInterface is called
        *   Function intern create a temporary thread to edit metadata , once the operation is  finished Send_OnEditMetaDataMethodResult will be called
        *   @return < 0: error, = 0: OK.
       */
       tVoid onEditMetaDataByMediaObjectTag(amt_tclServiceData* poMessage);

       /**This function is called when method 'EditMetaDataByMediaObjectURL' is received by mediaplayer
        *   @param[in] sMediaObjectUrl is the mediaobject 'url'
        *   @param[in] sTagGenre is the new 'Genre' field to be added
        *   @param[in] sTagAlbum is the new 'Album" field to be added
        *   @param[in] sTagArtist is the new 'Artist' field to be added
        *   @param[in] sTagTitleist is the new 'Title' field to be added
        *   @param[in] sTagComposer is the new 'Composer' field to be added
        *   @param[in] TagYear is the new 'Year' field to be added
        *   @param[in] Devicetag are converted.
        *   Function EditMetaData of mediaPlayerInterface is called
        *   Function intern create a temporary thread to edit metadata , once the operation is  finished Send_OnEditMetaDataMethodResult will be called
        *   @return < 0: error, = 0: OK.
       */
       tVoid onEditMetaDataByMediaObjectUrl(amt_tclServiceData* poMessage);

       /**
        * This function is called when the edit metadata  operation is completed.
        * This function calls method return after fi method 'EditMetaDataByMediaObjectTag' or 'EditMetaDataByMediaObjectUrl is called
        * @return < 0: error, = 0: OK
        */
       tResult Send_OnEditMetaDataMethodResult(IN tEditMetadatatType editMetadatatType, IN tFileOperationErrorCodes tFileOperationErrorCodes);


       /**
        * R6392_UC1_LLD2
        * This function is called when the ExtractGracenoteMetadata method is invoked
        * This function calls the method ExtractGracenoteMetadata
        * @return < 0: error, = 0: OK
        */
       tVoid onExtractGracenoteMetadata(amt_tclServiceData* poMessage);
       tVoid onStartRipping(amt_tclServiceData* poMessage);
       tVoid onStopRipping(amt_tclServiceData* poMessage);

       /**
        * This function is called when the AddFileNameToPlaylist  operation is completed.
        * This function calls method return after fi method 'AddFileNameToPlaylist' is called
        * @return < 0: error, = 0: OK
        */
       tVoid Send_OnAddFileNameToPlaylistMethodResult (IN tResult playListOperationErrorCodes);

       /**
        * This function is called when the deleteentryfromplaylist  operation is completed.
        * This function calls method return after fi method 'DeleteEntryFromPlaylist' is called
        * @return < 0: error, = 0: OK
        */
       tVoid Send_OnDeleteEntryFromPlaylistMethodResult(IN tResult playListOperationErrorCodes);


      //>--Roadmap CMG3G-10221 : 'Scene Recorder '
      /**This function is called when method 'onSetFilePermissionByMediaObjectTags' is received by mediaplayer
      *   @param[in] oFilePermissionObjectTags list of media object tags along with file mode to be set
      *   @param[in] Devicetag are converted.
      *   Function SetFilePermissions of mediaPlayerInterface is called
      *   Function intern create a temporary thread Change file contents , once the operation is  finished Send_onFilePermissionStatus will be called
      *   @return < 0: error, = 0: OK.
     */
     tVoid onSetFilePermissionByMediaObjectTags(amt_tclServiceData* poMessage);
     /**This function is called when method 'onRequestMediaplayerFolderInfo' is received by mediaplayer
      *   @param[in] onRequestMediaplayerFolderInfo list of media object tags along with file mode to be set
      *   @param[in] Devicetag are converted.
      *   @param[in] path selected
      *   @param[in] file type selected
      *   once the operation is  finished RequestMediaplayerFolderInfo will return
      *   Total Size and total count of the file content available in the path
      *   @return < 0: error, = 0: OK.
      */
     tVoid onRequestMediaplayerFolderInfo(amt_tclServiceData* poMessage);
    /**
     * This function is called when the edit media metadata operation is completed.
     * This function calls method return after fi method 'Send_SetfilePermissionByMediaobjectTagsMethodResult'
     * @param [IN] fileOperationErrorCodes is type of set file permission result code
     * @param [IN] numofFiles is stype of set file permission result code
     * @return < 0: error, = 0: OK
     */
     tResult Send_SetfilePermissionByMediaobjectTagsMethodResult(IN tResult filePermissionError, IN tU16 numofFiles);
     //<--Roadmap CMG3G-10221 : 'Scene Recorder '

     //>>-----Roadmap 16003
     /**
      * R8976_UC3_LLD3.1_SEQ2
      * This function is called when method 'AddFilenameToInternalPlaylistByTags' is received by mediaplayer
      *   @param[in] ListType
      *   @param[in] FilterTag1
      *   @param[in] FilterTag2
      *   @param[in] FilterTag3
      *   @param[in] PlaylistPath
      *   @param[in] Devicetag are converted.
      *   Function AddFileNamesToPlayListByTag of mediaPlayerInterface is called
      *   Function intern create a temporary thread to delete media content, once the operation is  finished Send_OnAddFileNameToPlaylistMethodResult will be called
      *   @return < 0: error, = 0: OK.
     */
     tVoid onAddFilenameToInternalPlaylistByTags(amt_tclServiceData* poMessage);
     //<<-----Roadmap 16003

     //>>-----Roadmap 17001
     /**This function is called when method 'StorePersonalizedFavorite' is received by mediaplayer
      *   @param[in]  ObjectID
      *   @param[in]  UserID
      *   @param[out] FavoriteID
      *   Function StorePersonalizedFavorite of mediaPlayerInterface is called      *
      *   @return < 0: error, = 0: OK.
     */
     tVoid onStorePersonalizedFavorite(amt_tclServiceData* poMessage);
     //<<-----Roadmap 17001

     //>>-----Roadmap 17001
     /**This function is called when method 'DeletePersonalizedFavorite' is received by mediaplayer
      *   @param[in] ObjectID
      *   @param[in] UserID
      *   Function DeletePersonalizedFavorite of mediaPlayerInterface is called
      *   @return < 0: error, = 0: OK.
     */
     tVoid onDeletePersonalizedFavorite(amt_tclServiceData* poMessage);

     //<<-----Roadmap 17001
     /** Function called by OutputWrapper for asynchronous answers

         /**
          * This function is called by MediaPlayer core when the result of RequestDVDTemperature is calculated
          * The function convert parameters, and sends the answer to the client stored in userContext
          * @param[in] temperature
          * @param[in] userContext client information
          * @return < 0: error, = 0: OK
          */
     tVoid SendRequestDVDTemperatureAnswer(tU16 temperature , tUserContext userContext);

     /**
      * This function is called by HMI For playback actions PLAY, PAUSE, NEXT, PREV, RANDOM, REPEAT, FFWD
      * @param[in] playback HID command
      * @param[in] Button Key Event
      * @return < 0: error, = 0: OK
     */

     tVoid onSendAppleHIDCommand (amt_tclServiceData* poMessage);
protected:


    std::map<tListID,tUserContext> mapVisitorMsg;//Roadmap 16014

    std::map<tDeleteMediaContentType, tUserContext> mapVisitorMsgDeleteMediaContent;//Roadmap 16003

    std::map<tEditMetadatatType,tUserContext> mapVisitorEditMetadataMsg;//Roadmap 16003

    tUserContext m_pAddFileNamesToPlaylistByTagUserContext;//Roadmap 16003
    tUserContext m_pAddFileNamesToPlaylistByUrlsUserContext;//Roadmap 16003
    tUserContext m_pDeleteEntryFromPlaylistUserContext;//Roadmap 16003






    /** convert functions */

    /**
     * function converts mplay_fi_tcl_MPlayTagTransferItem_2 to tTagTransfer
     */
    void ConvertTransferTagToInternal(tTagTransfer &tagTransfer, mplay_fi_tcl_MPlayTagTransferItem_2 &transferTagMPLAY);

    /**
    * function converts tTagTransferStatus to mplay_fi_tcl_e8_MPlayTagTransferStatus
    * with switch case statement
    */
    void ConvertTransferStatusToMPLAY(mplay_fi_tcl_e8_MPlayTagTransferStatus &transferStatusMPLAY, const tTagTransferStatus transferStatus);

    /**
    * function converts tUntransferredTag to mplay_fi_tcl_MPlayUntransferredTagStreamItem
    */
    void ConvertUntransferredTagsToMPLAY(mplay_fi_tcl_MPlayUntransferredTagStreamItem &untransferredTagMPLAY, const tUntransferredTag &untransferredTag);

    /**
    * function converts tErrorCode to mplay_fi_tcl_e8_MPlayUmountResult
    * with switch case statement
    */
    void ConvertUmountResultToMPLAY(mplay_fi_tcl_e8_MPlayUmountResult &umountResultMPLAY, const tErrorCode umountResult);

    /**
     * function converts tMimeType to mplay_fi_tclString
     *  MMT_PNG -> "image/png"
    */
    void ConvertMimeTypeToMPLAY(mplay_fi_tclString &mimeTypeMPLAY, const tMimeType mimeType);

    /**
    * function converts tFiles to mplay_fi_tcl_MPlayFileListItem
    */
    void ConvertFileItemToMPLAY(mplay_fi_tcl_MPlayFileListItem &mplayFileItem, const tFiles item); //Roadmap 13012

    /**
    * function converts mplay_fi_tcl_e8_MPlayPlaypointFormat to tPlaypointFormat
    * with switch case statement
    */
    void ConvertPlaypointFormatToInternal(tPlaypointFormat &internalPlaypointFormat, const mplay_fi_tcl_e8_MPlayPlaypointFormat playpointFormat);

    /**
    * function converts mplay_fi_tcl_e8_MPlayListType to tListType
    * with switch case statement
    */
    void ConvertListTypeToInternal(tListType &internalListType, const mplay_fi_tcl_e8_MPlayListType listType);

    /**
    * function converts tListType mplay_fi_tcl_e8_MPlayListType
    * with switch case statement
    */
    void ConvertListTypeToMPlay(mplay_fi_tcl_e8_MPlayListType &mplayListType, const tListType listType);

    /**
    * function converts tListChangeType to mplay_fi_tcl_e8_MPlayChange
    * with switch case statement
    */

    void ConvertListChangeTypeToMPlay(mplay_fi_tcl_e8_MPlayChange &mplayListType, const tListChangeType listChangeType);

    /**
    * function convert tBool to tPlayContinuation
    * FALSE -> NO_REPEAT
    * TRUE -> STEPUP_ONE_LEVEL
    */
    void ConvertAutoPlayToPlayContinuation(tPlayContinuation &playContinuation, const tBool autoPlay);

    /**
    * function convert tIndexingMode to mplay_fi_tcl_e8_MPlayDeviceIndexedState
    * with switch case statement
    *
    * IDS_NOT_SUPPORTED -> FI_EN_E8IDS_NOT_SUPPORTED
    * IDS_NOT_STARTED -> FI_EN_E8IDS_NOT_STARTED
    * IDS_PARTIAL -> FI_EN_E8IDS_PARTIAL
    * IDS_COMPLETE -> FI_EN_E8IDS_COMPLETE
    * IDS_CONTINUE -> FI_EN_E8IDS_PARTIAL
    * IDS_COMPLETE_FULL_DB -> FI_EN_E8IDS_COMPLETE
    */
    void ConvertIndexingStateToMPLAY(mplay_fi_tcl_e8_MPlayDeviceIndexedState &mplayIndexingState,  const tIndexingState indexedState);


    void ConvertIndexingStateResultToMPLAY(mplay_fi_tcl_MPlayIndexingStateResultItem &mplayIndexingStateResult, const tIndexingStateResult indexingStateResult);

    /**
     * function converts tFileType to mplay_fi_tcl_e8_MPlayFileType
     */
    void ConvertFileTypeToMPLAY(mplay_fi_tcl_e8_MPlayFileType&, tFileType);

    /**
     * function converts mplay_fi_tcl_e8_MPlayFileTypeSelection to tFileTypeSelection
     */
    void ConvertFileTypeToInternal(tFileTypeSelection &filetypeSelection, mplay_fi_tcl_e8_MPlayFileTypeSelection mplayFiletypeSelection);

    /**
     * function converts tFileType to mplay_fi_tcl_e8_MPlayFileType
     */
    void ConvertListTypeToMPLAY(mplay_fi_tcl_e8_MPlayListType &mplayListType, const tListType listType);

    /**
    * function converts tU8 to tDeviceID
    */
    void ConvertDeviceTagToInternal(tDeviceID &deviceID, const tU8 u8DeviceTag);

    /**
    * function converts tDeviceID to tU8
    * if deviceID does not fit into a unsinged byte call NORMAL_ASSERT
    */
    void ConvertDeviceTagToMPLAY(tU8 &deviceTag, const tDeviceID deviceID);

    /**
    * function converts tDeviceInformation to mplay_fi_tcl_MPlayDeviceInfoItem to mplayDeviceInfo
    *   convert tDeviceID deviceID to tU8 u8DeviceTag using ConvertDeviceTagToMPLAY
    *   cast tDeviceName deviceName to mplay_fi_tclString sDeviceName
    *   convert tDeviceType deviceType to mplay_fi_tcl_e8_MPlayDeviceType e8DeviceType using ConvertDeviceTypeToMPLAY
    *   cast tDeviceSerialNumber serialNumber to mplay_fi_tclString sDeviceSerialNumber
    *   cast tDeviceConnected connected to tBool bDeviceConnected
    *   convert tIndexingMode indexedState to mplay_fi_tcl_e8_MPlayDeviceIndexedState e8DeviceIndexedState using ConvertIndexingStateToMPLAY
    *   cast tDeviceActiveSource activeSource to tBool bDeviceActiveSource
    */
    void ConvertDeviceInfoToMPLAY(mplay_fi_tcl_MPlayDeviceInfoItem &mplayDeviceInfo ,const tDeviceInfo &deviceInfo);


    /**
    * function converts tMediaObject to mplay_fi_tcl_MPlayMediaObjectsItem
    *   mplayMediaObject.sAlbumArt.bSet(mediaObject.albumArt, mplay_fi_tclString::FI_EN_UTF8)
    *   convert category Type from tCategoryType to mplay_fi_tcl_e8_MPlayCategoryType with function ConvertCategoryTypeToMPLAY
    *   convert tDeviceID to tU8 (deviceTag) using ConvertDeviceTagToMPLAY
    *   convert tDeviceType to mplay_fi_tcl_e8_MPlayDeviceType using ConvertDeviceTypeToMPLAY
    *   mplayMediaObject.sDeviceVersion.bSet(mediaObject.deviceVersion, mplay_fi_tclString::FI_EN_UTF8)
    *   convert tFileFormat to mplay_fi_tcl_e8_MPlayFileFormat using ConvertDeviceFileFormatToMPLAY
    *   mplayMediaObject.sFilename.bSet(mediaObject.fileName, mplay_fi_tclString::FI_EN_UTF8)
    *   cast tIsPlaying to tBool (isPlaying)
    *   convert tMediaType into mplay_fi_tcl_e8_MPlayMediaType using ConvertMediaTypeToMPLAY
    *   mplayMediaObject.sMetaDataField1.bSet(mediaObject.metaData1, mplay_fi_tclString::FI_EN_UTF8)
    *   mplayMediaObject.sMetaDataField2.bSet(mediaObject.metaData2, mplay_fi_tclString::FI_EN_UTF8)
    *   mplayMediaObject.sMetaDataField3.bSet(mediaObject.metaData3, mplay_fi_tclString::FI_EN_UTF8)
    *   mplayMediaObject.sMetaDataField4.bSet(mediaObject.metaData4, mplay_fi_tclString::FI_EN_UTF8)
    *   cast all 4 metadataTags: mplayMediaObject.u32MetaDataTag1 = mediaObject.metaDataTag1.tag
    *   cast tObjectID (objectID) to tU32 (u32Tag)
    *   cast totalPlaytime (position) to tU32 (u32TotalPlaytime)
    *   convert tTrackNumber (trackNumber) to tU8 (u8TrackNumber); if (trackNumber > 255 ) set u8TrackNumber to 255
    */
    void ConvertMediaObjectsItemToMPLAY(mplay_fi_tcl_MPlayMediaObjectsItem &mplayMediaObject, tMediaObject mediaObject); //Roadmap 13012, 13002, 13001
    void MapTagsFromGenMP2GM(tMediaObject &mediaObject, tMetadata &resolution);
    void AddMountPointToFileName(tURL &fileName, tMountPoint mountPoint);
    void MapTagsFromGM2GenMP(const tListType listType, tFilterTag1 &tag1, tFilterTag2 &tag2, tFilterTag3 &tag3, tFilterTag4 &tag4);

    /**
    * function converts tMediaObject to mplay_fi_tcl_MPlayMediaObject
    *   mplayMediaObject.sAlbumArt.bSet(mediaObject.albumArt, mplay_fi_tclString::FI_EN_UTF8)
    *   convert category Type from tCategoryType to mplay_fi_tcl_e8_MPlayCategoryType with function ConvertCategoryTypeToMPLAY
    *   convert tDeviceID to tU8 (deviceTag) using ConvertDeviceTagToMPLAY
    *   convert tDeviceType to mplay_fi_tcl_e8_MPlayDeviceType using ConvertDeviceTypeToMPLAY
    *   mplayMediaObject.sDeviceVersion.bSet(mediaObject.deviceVersion, mplay_fi_tclString::FI_EN_UTF8)
    *   convert tFileFormat to mplay_fi_tcl_e8_MPlayFileFormat using ConvertDeviceFileFormatToMPLAY
    *   mplayMediaObject.sFilename.bSet(mediaObject.fileName, mplay_fi_tclString::FI_EN_UTF8)
    *   cast tIsPlaying to tBool (isPlaying)
    *   convert tMediaType into mplay_fi_tcl_e8_MPlayMediaType using ConvertMediaTypeToMPLAY
    *   mplayMediaObject.sMetaDataField1.bSet(mediaObject.metaData1, mplay_fi_tclString::FI_EN_UTF8)
    *   mplayMediaObject.sMetaDataField2.bSet(mediaObject.metaData2, mplay_fi_tclString::FI_EN_UTF8)
    *   mplayMediaObject.sMetaDataField3.bSet(mediaObject.metaData3, mplay_fi_tclString::FI_EN_UTF8)
    *   mplayMediaObject.sMetaDataField4.bSet(mediaObject.metaData4, mplay_fi_tclString::FI_EN_UTF8)
    *   cast all 4 metadataTags: mplayMediaObject.u32MetaDataTag1 = mediaObject.metaDataTag1.tag
    *   cast tObjectID (objectID) to tU32 (u32Tag)
    *   cast totalPlaytime (position) to tU32 (u32TotalPlaytime)
    *   convert tTrackNumber (trackNumber) to tU8 (u8TrackNumber); if (trackNumber > 255 (0xFF) ) set u8TrackNumber to 0
    *   convert tTrackNumber (trackNumber) to tU16 (u16ExtendedTrackNumber); if (trackNumber > 0xFFFF) set u16ExtendedTrackNumber to 0xFFFF
    */
    void ConvertMediaObjectToMPLAY(mplay_fi_tcl_MPlayMediaObject &mplayMediaObject, tMediaObject& mediaObject); //Roadmap 13012, 13002, 13001

    /**
    * function converts tCategoryType to mplay_fi_tcl_e8_MPlayCategoryType
    * with switch case statement
    */
    void ConvertCategoryTypeToMPLAY(mplay_fi_tcl_e8_MPlayCategoryType &mplayCategoryType, const tCategoryType categoryType);

    /**
    * function converts mplay_fi_tcl_e8_MPlayCategoryType to tCategoryType
    * with switch case statement
    */
    void ConvertCategoryTypeToInternal(tCategoryType &categoryType, const mplay_fi_tcl_e8_MPlayCategoryType mplayCategoryType);

     /**
    * function converts tDeviceType to mplay_fi_tcl_e8_MPlayDeviceType
    * with switch case statement
    * DTY_UNKNOWN -> FI_EN_E8DTY_UNKNOWN
      DTY_USB -> FI_EN_E8DTY_USB
      DTY_IPOD FI_EN_E8DTY_IPOD
      DTY_SD -> FI_EN_E8DTY_SD
      DTY_BLUETOOTH -> FI_EN_E8DTY_BLUETOOTH
      DTY_IPHONE -> FI_EN_E8DTY_IPHONE
      DTY_MTP -> FI_EN_E8DTY_UNKNOWN
      DTY_MSZUNE -> FI_EN_E8DTY_UNKNOWN
    */
    void ConvertDeviceTypeToMPLAY(mplay_fi_tcl_e8_MPlayDeviceType &mplayDeviceType, const tDeviceType deviceType);

    /**
       * function converts tConnectionState to mplay_fi_tcl_e8_MPlayDeviceConnectionState
       * with switch case statement
        CS_CONNECTED -> FI_EN_E8CS_CONNECTED
        CS_ATTACHED -> FI_EN_E8CS_ATTACHED
        CS_DISCONNECTED -> FI_EN_E8CS_DISCONNECTED
        CS_HW_MALFUNCTION -> FI_EN_E8CS_HW_MALFUNCTION
        CS_UNDERVOLTAGE  -> FI_EN_E8CS_UNDERVOLTAGE
        CS_UNSUPPORTED   -> FI_EN_E8CS_UNSUPPORTED
        CS_OVERTEMP  -> FI_EN_E8CS_OVERTEMP
        CS_ON_HOLD  -> FI_EN_E8CS_ON_HOLD
        CS_UNDEFINED  -> FI_EN_E8CS_UNDEFINED

       */
    void ConvertConnectionStateToMPLAY(mplay_fi_tcl_e8_MPlayConnectionState &mplayDeviceConnectionState, const tConnectionState connectionState);

    /**
      * function converts quicksearchresult to mplay_fi_tcl_e8_QuickSearchResult
      * with switch case statement
      * FOUND -> FI_EN_E8FOUND
        FOLLOWING -> FI_EN_E8FOLLOWING
        ENDOFLIST -> FI_EN_E8ENDOFLIST
        NOTSUPPORTED -> FI_EN_E8NOTSUPPORTED
      */
    void ConvertQuickSearchResultToMPLAY(mplay_fi_tcl_e8_QuickSearchResult &QuickSearchResult, const tSearchResult quicksearchresult);

     /**
    * function converts  tConnectionType to mplay_fi_tcl_e8_MPlayConnectionType
    * with switch case statement
    */
    void ConvertConnectionTypeToMPLAY(mplay_fi_tcl_e8_MPlayConnectionType &mplayConnectionType, const tConnectionType connectionType);

     /**
    * function converts  mplay_fi_tcl_e8_MPlayDeviceType to tDeviceType
    * with switch case statement
    */
    void ConvertDeviceTypeToInternal(tDeviceType &deviceType, const mplay_fi_tcl_e8_MPlayDeviceType mplayDeviceType);

    /**
    * function converts tFileFormat to mplay_fi_tcl_e8_MPlayFileFormat
    * with switch case statement
    */
    void ConvertDeviceFileFormatToMPLAY(mplay_fi_tcl_e8_MPlayFileFormat &mplayFileFormat, const tFileFormat fileFormat);

    /**
    * function converts tMediaType to mplay_fi_tcl_e8_MPlayMediaType
    * with switch case statement
    */
    void ConvertMediaTypeToMPLAY(mplay_fi_tcl_e8_MPlayMediaType &mplayMediaType, const tMediaType mediaType);

    /**
    * function converts mplay_fi_tcl_e8_MPlayAction to tPlaybackAction
    * with switch case statement
    */
    void ConvertPlaybackActionToInternal(tPlaybackAction &internalPlaybackAction, const mplay_fi_tcl_e8_MPlayAction playbackAction);

    /**
    * function converts mplay_fi_tcl_e8_MPlaybackDirection to tPEPlaybackDirection
    * with switch case statement
    */
    void ConvertPlaybackDirectionToInternal(tPEPlaybackDirection &internalPlaybackDirection, const mplay_fi_tcl_e8_MPlaybackDirection playbackDirection);
    /**
    * function converts tPEPlaybackDirection to mplay_fi_tcl_e8_MPlaybackDirection
    * with switch case statement
    */
    void ConvertPlaybackDirectionToMPLAY(mplay_fi_tcl_e8_MPlaybackDirection &mPlaybackDirection,const tPEPlaybackDirection playbackDirection);
    /**
    * function converts mplay_fi_tcl_e8_MPlaybackSpeed to playbackSpeed
    * with switch case statement
    */
    void ConvertPlaybackSpeedToInternal(tPlaybackSpeed &internalPlaybackSpeed, const mplay_fi_tcl_e8_MPlaybackSpeed playbackSpeed);
    /**
    * function converts tPlaybackSpeed to mplay_fi_tcl_e8_MPlaybackSpeed
    * with switch case statement
    */
    void ConvertPlaybackSpeedToMPLAY(mplay_fi_tcl_e8_MPlaybackSpeed &mPlaybackSpeed, const tPlaybackSpeed playbackSpeed);

    /**
    * function converts tNowPlayingState to mplay_fi_tcl_e8_MPlayNowPlayingState
    * with switch case statement
    */
    void ConvertNowPlayingStateToMPLAY(mplay_fi_tcl_e8_MPlayNowPlayingState &mplayNowPlayingState, const tNowPlayingState nowPlayingState);

    /**
    * function converts tHMIPlaybackState to mplay_fi_tcl_e8_MPlayState
    * with switch case statement
    */
    void ConvertPlaybackStateToMPLAY(mplay_fi_tcl_e8_MPlayState &mplayPlaybackstate, const tHMIPlaybackState playbackState);

    /**
    * function converts tPlaybackMode to mplay_fi_tcl_e8_MPlayMode
    * with switch case statement
    */
    void ConvertPlaybackModeToMPLAY(mplay_fi_tcl_e8_MPlayMode &mplayPlaybackMode, const tPlaybackMode playbackMode);

    /**
    * function converts mplay_fi_tcl_e8_MPlayMode to tPlaybackMode
    * with switch case statement
    */
    void ConvertPlaybackModeToInternal(tPlaybackMode &playbackMode, const mplay_fi_tcl_e8_MPlayMode mplayPlaybackMode);

        /**
    * function converts tRepeatMode to mplay_fi_tcl_e8_MPlayRepeat
    * with switch case statement
    */
    void ConvertRepeatModeToMPLAY(mplay_fi_tcl_e8_MPlayRepeat &mplayRepeatMode, const tRepeatMode repeatMode);

    /**
    * function converts mplay_fi_tcl_e8_MPlayRepeat to tRepeatMode
    * with switch case statement
    */
    void ConvertRepeatModeToInternal(tRepeatMode &repeatMode, const mplay_fi_tcl_e8_MPlayRepeat mplayRepeatMode);

    /**
    * function converts tFileSystemType to mplay_fi_tcl_e8_MPlayFileSystemType
    * with switch case statement
    */
    void ConvertFileSystemTypeToMPLAY(mplay_fi_tcl_e8_MPlayFileSystemType &mplayFileSystemType,  const tFileSystemType fileSystemType);

    /**
    * function converts tDisconnectReason to mplay_fi_tcl_e8_MPlayDisconnectReason
    * with switch case statement
    */
    void ConvertDisconnectReasonToMPLAY(mplay_fi_tcl_e8_MPlayDisconnectReason &mplayDisconnectReason, const tDisconnectReason disconnectReason);

    /**
    * function converts tDeviceState to mplay_fi_tcl_e8_MPlayDeviceStatus
    * with switch case statement
    */
    void ConvertDeviceStateToMPLAY(mplay_fi_tcl_e8_MPlayDeviceStatus &mplayDeviceStatus,  const tDeviceState deviceState);

    /**
    * function converts tNotPlayable to mplay_fi_tcl_e8_MPlayPlayableStatus
    * with switch case statement
    */
    void ConvertPlayableStatusToMPLAY(mplay_fi_tcl_e8_MPlayPlayableStatus &mplayPlayableStatus, const tNotPlayable playable);

    /**
    * function converts tAudioChannelFormat to mplay_fi_tcl_e8_MPlayAudioChannelFormat
    * with switch case statement
    */
    void ConvertAudioChannelFormatToMPLAY(mplay_fi_tcl_e8_MPlayAudioChannelFormat &mplayAudioChannelFormat, const tAudioChannelFormat audioChannelFormat);

    void ConvertLanguageTypeToInternal(tLanguageType &internalLanguageType, const mplay_fi_tcl_e8_MPlayLanguage languageType);

    /**
    * function converts tLanguageType to mplay_fi_tcl_e8_MPlayLanguage
    * with switch case statement
    */
    void ConvertLanguageTypeToMPLAY(mplay_fi_tcl_e8_MPlayLanguage &mplayLanguage, tLanguageType language); //finished: 100%

    /**
    * function converts tDMOpticalDiscSlotState to mplay_fi_tcl_e8_SlotStateOpticalDiscType
    * with switch case statement
    */
    void  ConvertDiscSlotStateToMPLAY(OUT mplay_fi_tcl_e8_SlotStateOpticalDiscType &e8SlotStateOpticalDisc , IN const tDMOpticalDiscSlotState enOpticalDiscSlotState);//Roadmap: 15002_CDAudio_DetectionAndDiagnosis
    /**
    * function converts tDiscType to mplay_fi_tcl_e8_MDiscType
    */
    void  ConvertDiscTypeToMPLAY(mplay_fi_tcl_e8_MDiscType &mplayDiscType, const tDiscType discType);
    /**
    * function converts tImageObject to mplay_fi_tcl_MPlayImageObjectItem
    */
#if USE_IMAGE_OBJECT
    void  ConvertImageObjectItemToMPLAY(mplay_fi_tcl_MPlayImageObjectItem &mplayImageObjectItem, tImageObject &ImageObject);
#else
    void  ConvertImageObjectItemToMPLAY(mplay_fi_tcl_MPlayImageObjectItem &mplayImageObjectItem, tMediaObject &mediaObject);
#endif
    /**
    * function gets total image count in the device
    */
    tVoid GetImageFileCount(mplay_fi_tcl_MPlayDeviceInfoItem &mplayDeviceInfo, const tDeviceInfo &deviceInfo);

    /**
    * function converts tenOpticalDeviceState to mplay_fi_tcl_e8DeviceState
    * with switch case statement
    */
    void  ConvertOpticalDeviceStateToMPLAY(OUT mplay_fi_tcl_e8DeviceState &e8DeviceState , IN const tenOpticalDeviceState OpticalDeviceState); //CD Info

    /**
    * function converts result of playlist operation to mplay_fi_tcl_e8_MPlayInternalPlaylistTaskResult
    * with switch case statement
    */
    void ConvertInternalPlaylistTaskResultToMplay(OUT mplay_fi_tcl_e8_MPlayInternalPlaylistTaskResult &e8TaskResult,IN const int result );

    /**
    * function converts result of deletemediacontent operation to mplay_fi_tcl_e8_MPlayDeleteMediaContentTaskResult
    * with switch case statement
    */
    void ConvertDeleteMediaContentErrorTypeToMPlay(mplay_fi_tcl_e8_MPlayDeleteMediaContentTaskResult &mplayDeleteMediaContentTaskResult, IN const tFileOperationErrorCodes fileOperationErrorCodes);

    /**
    * function converts result of editmetadata operation to mplay_fi_tcl_e8_MPlayEditMetaDataTaskResult
    * with switch case statement
    */
    void ConvertEditMetaDataErrorTypeToMPlay(mplay_fi_tcl_e8_MPlayEditMetaDataTaskResult &mplayEditMetaDataTaskResult, IN const tFileOperationErrorCodes fileOperationErrorCodes);

    /**
     * function converts result of encoding quality of ripping to mplay_fi_tcl_e8_MPlayEncodingQuality
     * with switch case statement
     */
    void ConvertEncodingQualityTypeToMPlay(OUT mplay_fi_tcl_e8_MPlayEncodingQuality &mplayEditMetaDataTaskResult, IN const tEncodingQuality rippingEncodingQuality);

    /**
      * function converts result of mplay_fi_tcl_e8_MPlayEncodingQuality to  internal type ripping encoding quality
      * with switch case statement
      */
    void ConvertMplayTypeToEncodingQuality(OUT tEncodingQuality &rippingEncodingQuality, IN const mplay_fi_tcl_e8_MPlayEncodingQuality mplayEditMetaDataTaskResult );

    void ConvertPlaybackHIDCommandToInternal(tPlaybackHIDCommand &internalPlaybackHIDCommand, const mplay_fi_tcl_e_MPlayHIDCommand mplayHIDCommand);

    void ConvertKeyEventToInternal(tBTButtonEvent &internalKeyEvent, const mplay_fi_tcl_e_MPlayKeyEvent mplayKeyEvent);


protected:

    /**
    * This function is called by the framework when the service is available
    * Call function vSetSrcAvailable of IIL with paramter TRUE
    * @return void
    */
    virtual tVoid vOnServiceAvailable();

    /**
    * This function is called by the framework when the service is unavailable
    * Call function vSetSrcAvailable of IIL with paramter FALSE
    * @return void
    */
    virtual tVoid vOnServiceUnavailable();


    /**
    * This function shall be called when an error is sent inside a handler function
    * @param[in] rServiceMethodStart Reference to the received message
    * @param[in] errorCode  Error code
    * @return void
    */
    tVoid vPostError(amt_tclServiceData &rServiceMethodStart);

    /**
    * This function shall be called when an answer message is sent inside a handler function
    * @param[in] rBaseMessage    Reference to teh message related FI data object. All message specific parameters are already set
    *                            The parameters of the CCA header are set inside this functions. This function also deletes
    *                            the FI data object.
    * @param[in] rServiceMethodStart Reference to the received message
    * @param[in] u8Opcode to offer sending also other opcodes - see also //Roadmap 16014 'Full text search'
    * @return void
    */
    tVoid vPostResult(mplay_mediaplayerfi_tclMsgBaseMessage &rBaseMessage, IN amt_tclServiceData &rServiceMethodStart, IN tU8 u8Opcode = AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);


    /**
    * This function shall be called when an answer message is sent inside a handler function
    * @param[in] rBaseMessage    Reference to teh message related FI data object. All message specific parameters are already set
    *                            The parameters of the CCA header are set inside this functions. This function also deletes
    *                            the FI data object.
    * @param[in] tUserContext info about the received message
    * @param[in] u8Opcode to offer sending also other opcodes - see also //Roadmap 16014 'Full text search'
    * @return void
    */
    tVoid vPostResult(mplay_mediaplayerfi_tclMsgBaseMessage &rBaseMessage, IN tUserContext &userContext, IN tU8 u8Opcode = AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);
    /**
    * This function is called by the CCA framework to request ANY
    * property which is offered by this service. For each property
    * accessed via parameter 'u16FunctionId' the user has to prepare
    * the corresponding FI data object which is then copied to the
    * referenced parameter 'roOutMsg'.
    *   NowPlaying:
    *       Call function tResult GetNowPlaying(tNowPlaying &nowPlaying) of PlayerManager
    *       Convert return parameter
    *           tListID listID is casted to  tU32 u32ListHandle
    *           tNowPlayingState state is converted to mplay_fi_tcl_e8_MPlayNowPlayingState e8NowPlayingState using ConvertNowPlayingStateToMPLAY
    *           tPosition position is casted to tU32 u32Position
    *           tObjectID objectID is casted to tU32 u32Tag
    *           tMediaObject object is converted to mplay_fi_tcl_MPlayMediaObject using ConvertMediaObjectToMPLAY
    *   Playtime:
    *       Call function     tResult GetPlaytime(tPlaytime &elapsedPlaytime, tPlaytime &totalPlaytime); of PlayManager
    *       Convert return parameters
    *           Cast tPlaytime elapsedPlaytime to tU32 u32ElapsedPlaytime
    *           Cast tPlaytime totalPlaytime to    tU32 u32TotalPlaytime
    *   PlaybackState:
    *       Call function     tResult GetPlaybackState(tHMIPlaybackState &playbackState); of PlayerManager
    *       Convert return parameter
    *           Convert tHMIPlaybackState playbackState to mplay_fi_tcl_e8_MPlayState using ConvertPlaybackStateToMPLAY
    *   PlaybackMode
    *       Call function     tResult GetPlaybackMode(tPlaybackMode &playbackMode) of ListControl
    *       Convert return parameter
    *           Convert tPlaybackMode playbackMode to mplay_fi_tcl_e8_MPlayMode using ConvertPlaybackModeToMPLAY
    *   RepeatMode
    *       Call function      tResult GetRepeatMode(tRepeatMode &repeatMode) of ListControl
    *       Convert return parameter
    *           Convert tRepeatMode repeatMode to mplay_fi_tcl_e8_MPlayRepeat using ConvertRepeatModeToMPLAY
    *   IndexingState
    *       Call function GetIndexingState of DataProvider
    *       Convert all parameters
    *           For each entry of vector:
    *           Convert tDeviceID to tU8 (u8DeviceTag) using ConvertDeviceTagToMPLAY
    *           Convert tIndexingMode indexedState to mplay_fi_tcl_e8_MPlayDeviceIndexedState using ConvertIndexingStateToMPLAY
    *           Cast tUInt tIndexingPercentComplete to  tU8 u8IndexingPercentComplete
    *   ActiveMediaDevice
    *       Call function     tResult ActiveMediaDeviceGet(tDeviceInformation &deviceInfo) of CustomControl
    *       Convert return parameter
    *           Convert tDeviceInfo deviceInfo to mplay_fi_tcl_MPlayDeviceInfoItem using ConvertDeviceInfoToMPLAY.
    *           Only one item ist set
    *   MediaPlayerListChange
    *       Call function tResult GetMediaPlayerListChanged(tListID &listID, tListSize &listSize) of OutputWrapper
    *       Convert return parameters
    *           Cast tListID listID to tU32 u32ListHandle
    *           Cast tListSize &listSize to tU32 u32ListSize
    *           set mplay_fi_tcl_e8_MPlayChange e8Change to FI_EN_E8LCH_CONTENT_CHANGED
    *           set tU8 u8NumItems to 0
    *           does not set mplay_fi_tcl_MPlayItems oItems
    *   MediaPlayerDeviceConnections
    *       Call function tResult GetMediaplayerDeviceConnections(tNumberOfDevices &numberOfDevices, vector<tDeviceInformation> &deviceInformation) of DataProvider
    *       Convert return parameters
    *           Cast tNumberOfDevices numberOfDevices to tU8 u8NumDevices. If numberOfDevices > 255 set u8NumDevices to 255
    *           For each item convert tDeviceInformation to mplay_fi_tcl_MPlayDeviceInfoItemmplayDeviceInfo using  ConvertDeviceInfoToMPLAY
    *   MyMediaSupported
    *       ToDO
     * @param[in] u16FunctionId = Function ID of the requested property.
    * @param[out] roOutMsg = Reference to the service data object to which the content of the prepared FI data object should be copied to.
    * @param[in] poInMsg = Selector message which is used to select dedicated content to be copied to 'roOutMsg' instead of updating the entire FI data object.
    * @return: TRUE = Status message for property successfully generated. FALSE = Failed to generate status message for property.
    */
    virtual tBool bStatusMessageFactory(tU16 u16FunctionId, amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg);

    /**
    * This function is called by the CCA framework when it has
    * received a message for a property with Opcode 'SET' or 'PURESET'
    * and there is no dedicated handler function defined in the
    * message map for this pair of FID and opcode. The user has to
    * set the application specific property to the requested value
    * and the CCA framework then cares about informing the requesting
    * client as well as other registered clients.
    *
    *   PlaybackMode
    *       Convert parameter
    *           Convert mplay_fi_tcl_e8_MPlayMode to tPlaybackMode using ConvertPlaybackModeToInternal
    *       Call SetPlaybackMode of ListControl
    *   RepeatMode
    *       Convert parameter
    *           Convert mplay_fi_tcl_e8_MPlayRepeat to tRepeatMode using ConvertRepeatModeToInternal
    *       Call SetRepeatMode of ListControl
    *   ActiveMediaDevice
    *       Convert Parameter
    *           Convert tU8 u8DeviceTag to tDeviceID using ConvertDeviceTagToInternal
    *           Cast tBool bDeviceActiveSource to tBool
    *        Call ActiveMediaDeviceSet(const tDeviceID deviceID, const tBool activeSource) of CustomControl
    * @param[in] poMessage = Property to be set.
    * @param[out] bPropertyChanged = Property changed flag to be set to TRUE if property has changed. Otherwise to be set to FALSE (default).
    * @param[out] u16Error = Error code to be set if a CCA error occurs, otherwise don't touch.
    *
    * @return: TRUE = Send 'STATUS' message to the requesting client if opcode
    *                 was 'SET'. Send 'STATUS' message to other registered
    *                 clients as well if [OUT] parameter 'bPropertyChanged'
    *                 is set to TRUE.
    *                  FALSE = Send an error message to the requesting client.
    */
    virtual tBool bProcessSet(amt_tclServiceData* poMessage, tBool& bPropertyChanged, tU16& u16Error);

   /**
    * Message map definition macro
    */
    DECLARE_MSG_MAP(fc_mediaplayer_tclService_MediaPlayer)


};
/**
 * This function is a helper function that fills the usercontext from visitor message
 * @param[in] poMessage     Reference to teh message related FI data object. All message specific parameters are already set
 *                            The parameters of the CCA header are set inside this functions. This function also deletes
 *                            the FI data object.
 * @param[in] tUserContext info about the received message
 * @return void
 */
void fillUserContext(IN amt_tclServiceData* poMessage,OUT tUserContext &userContext);

/** @} */
