
#ifndef __FC_MEDIAPLAYER_CLIENTHANDLER_SPI_H__
#define __FC_MEDIAPLAYER_CLIENTHANDLER_SPI_H__

/**
 * @defgroup CCAClientHandlerSPI CCAClientHandlerSPI
 * @ingroup MediaPlayer
 * @author Stefan Scherber
 * 
 * Public interface for CCAClientHandlerSPI
 * @{
 */

// Include Application Help Library.
#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"

// Include message framework interface (AMT, msgfw)
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
//Include public FI interface of this service.
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_SMARTPHONEINTFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_SMARTPHONEINTFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_SMARTPHONEINTFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_SMARTPHONEINTFI_SERVICEINFO
#include "midw_fi_if.h"

#include "MediaPlayerInterface.h"

class ahl_tclBaseOneThreadClientHandler;

/** 
 * This class implements the CCAClientHandlerAVManager component. 
 */
class fc_mediaplayer_tclClientHandler_SPI:public ahl_tclBaseOneThreadClientHandler
{

public:

	/** 
	* Constructor of the service class
	* _tclRegisterPair.bAddPair(AMT_C_U32_STATE_OFF, AMT_C_U32_STATE_NORMAL) and
	* _tclUnregisterPair.bAddPair(AMT_C_U32_STATE_NORMAL, AMT_C_U32_STATE_OFF) must be called.
    * vAddAutoRegisterForProperty(MOST_GMLNGWFI_C_U16_LANGUAGESELECTION) mus be called
	* @param[in] poMainAppl Pointer to the CCA application
	* @return  
	*/
    fc_mediaplayer_tclClientHandler_SPI(fc_mediaplayer_tclApp* poMainAppl);

	/** 
	* Destructore of the service class
	* @return  
	*/
    virtual ~fc_mediaplayer_tclClientHandler_SPI();

    virtual tVoid vOnServiceAvailable();
    virtual tVoid vOnServiceUnavailable();

    /**
    * Send message MOST_DEVPRJFI_C_U16_DIPOROLESWITCHREQUIRED with parameter devieID to SPI 
    *
    * @param[in] deviceID Unique identifier of the device.
    * @param[in] USBSerialNumber Usb serial number of apple device.
    * @return < 0: error, = 0: OK
    */
    tResult SendDIPORoleSwitchRequired(const tDeviceID deviceID,const tMountPoint USBSerialNumber,const tBool DeviceCarplayCapability);
    tResult SendGetWiFiCredentials(const tDeviceID deviceId,const tMACAddress appleDeviceMACAddress);

private:	

    /**
    * Function is called when MOST_DEVPRJFI_C_U16_DIPOROLESWITCHREQUIRED MethodResult is received
    * Function extracts parameter and calls MediaPlayerInterface::DiPORoleSwitchRequiredResult
    * @param[in] poMessage message.
    * @return < 0: error, = 0: OK
    */
    tVoid onDIPORoleSwitchRequiredResult(amt_tclServiceData* poMessage);

    /**
    * Function is called when MOST_DEVPRJFI_C_U16_DIPOROLESWITCHREQUIRED Error is received
    * Function ecalls MediaPlayerInterface::DiPORoleSwitchRequiredResult with parameter DIPO_ROLE_SWITCH_NOT_REQUIRED
    * @param[in] poMessage message.
    * @return < 0: error, = 0: OK
    */
    tVoid onDIPORoleSwitchRequiredError(amt_tclServiceData* poMessage);

    /**
    * Function is called when MIDW_SMARTPHONEINTFI_C_U16_WIFICREDENTIALS Property update is received
    * @param[in] poMessage message.
    * @return < 0: error, = 0: OK
    */
    tVoid onNotifyAccessoryWifiAPCredentials(amt_tclServiceData* poMessage);


    tVoid onGetWiFiCredentialsResult(amt_tclServiceData* poMessage);

    tDeviceID lastDeviceID;
    tDeviceID deviceIDforWIFICredential;

protected:

    void ConvertDiPOSwitchReqResponseToInternal(tDiPOSwitchReqResponse &diPOSwitchReqResponseInternal, const midw_fi_tcl_e8_DiPOSwitchReqResponse diPOSwitchReqResponse);
    void ConvertAccessoryCredentialsToInternal(tWiFiAPCredentials &wifiCredentials, const midw_fi_tcl_WiFiAPCredentials accessoryWiFiAPCredentials);
    void ConvertAppInfoToInternal(tAppInfo &appInfo, const midw_fi_tcl_EAPAppInfo info);
   /**
    * Message map definition macro
    */
   DECLARE_MSG_MAP(fc_mediaplayer_tclClientHandler_SPI)


    tBoolean isSPIServiceAvailable;
};

/** @} */


#endif // __FC_MEDIAPLAYER_CLIENTHANDLER_SPI_H__
