/**
 * @author Jörg Wohlgemuth
 *
 * Implentation of AudioRoutingLib support of GenericMediaPlayer
 *
 */

#ifndef FC_MEDIAPLAYER_AUDIOROUTING_HANDLER_H
#define FC_MEDIAPLAYER_AUDIOROUTING_HANDLER_H

#define ARL_S_IMPORT_INTERFACE_GENERIC
#include "audio_routing_lib.h"

/**
 *  class definitions.
 */
class fc_mediaplayer_tclApp;

/**
 * This class implements the AudioRoutingLib support of GenericMediaPlayer.
 */
class fc_mediaplayer_tclAudioRoutingHandler : public arl_tclISource
{
private:
    fc_mediaplayer_tclApp* m_poMainAppInstance;

public:

    /**
    * Constructor of the service class
    * @param[in] poMainAppl Pointer to the CCA application
    * @return
    */
    fc_mediaplayer_tclAudioRoutingHandler(fc_mediaplayer_tclApp* const poMainApp);

    /**
    * Destructor of the service class
    * @return
    */
    virtual ~fc_mediaplayer_tclAudioRoutingHandler(tVoid);


    /***************************************************************************
    ** FUNCTION:  virtual tBool FC_MediaPlayer_tclAudioRoutingHandler::bOnSrcActivity(..
    ***************************************************************************/
    /*!
     * \brief   CALLED BY AUDIO-ROUTING-LIB:
     *          Application specific function on Source Activity start.
     * \param   enSrcNum:  (I) Source Number.
     * \param   SubSource: (I) Sub source ID (deviceID)
     * \param   rfcoSrcActivity: (I) Source Activity
     * \retval  tBool: TRUE, if source activity was successful, FALSE otherwise
     * \date 11.09.2013 \author Jörg Wohlgemuth (BSOT/ENG)
     **************************************************************************/
#ifdef VARIANT_S_FTR_ENABLE_MP_NEXT_POSSIBLE_SOURCE
    virtual tBool bOnSrcActivity(arl_tenSource enSrcNum,  tU16 SubSource, arl_tenSource enPosNextSrc, const arl_tSrcActivity& rfcoSrcActivity);
#else
    virtual tBool bOnSrcActivity(arl_tenSource enSrcNum,  tU16 SubSource, const arl_tSrcActivity& rfcoSrcActivity);
#endif


    /***************************************************************************
    ** FUNCTION:  virtual tBool FC_MediaPlayer_tclAudioRoutingHandler::bOnAllocate(..
    ***************************************************************************/
    /*!
     * \brief   CALLED BY AUDIO-ROUTING-LIB:
     *          Application specific function after Allocate is processed.
     * \param   [enSrcNum]:  (I) Source Number.
     * \param   rfcoAllocRoute: (I) Reference to Allocate route result
     * \retval  tBool: TRUE, if Application performed operations successfully,
     *          FALSE otherwise
     * \date 11.09.2013 \author Jörg Wohlgemuth (BSOT/ENG)
     **************************************************************************/
    virtual tBool bOnAllocate(arl_tenSource enSrcNum, const arl_tAllocRouteResult& rfcoAllocRoute);

    /***************************************************************************
    ** FUNCTION:  virtual tBool FC_MediaPlayer_tclAudioRoutingHandler::bOnDeAllocate(
    ***************************************************************************/
    /*!
     * \brief   CALLED BY AUDIO-ROUTING-LIB:
     *          May be overridden by Player App to Release Resources.
     *          Application specific function after DeAllocate is processed.
     * \param   enSrcNum:  (I) Source Number.
     * \retval  tBool: TRUE, if Application performed operations successfully,
     *          FALSE otherwise
     * \date 11.09.2013 \author Jörg Wohlgemuth (BSOT/ENG)
     **************************************************************************/
    virtual tBool bOnDeAllocate(arl_tenSource enSrcNum);

    /***************************************************************************
    ** FUNCTION:  virtual tBool FC_MediaPlayer_tclAudioRoutingHandler::bOnMuteState
    ***************************************************************************/
    /*!
     * \brief   CALLED BY AUDIO-ROUTING-LIB:
     * \param   enSrcNum:  (I) Source Number.
     * \retval  tBool: TRUE, if Application performed operations successfully,
     *          FALSE otherwise
     **************************************************************************/
    virtual tBool bOnMuteState(arl_tenSource enSrcNum, arl_tenMuteState muteState);

};
#endif // FC_MEDIAPLAYER_AUDIOROUTING_HANDLER_H
