/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_VersionInfoConfig.h
  * @brief        
  * @copyright    (C) 2013 - 2018 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */
#ifndef __SPM_VERSIONINFOCONFIG_H
#define __SPM_VERSIONINFOCONFIG_H

// -----------------------------------------------------------------------------
// includes
// -----------------------------------------------------------------------------

// -----------------------------------------------------------------------------
// defines
// -----------------------------------------------------------------------------

// -----------------------------------------------------------------------------
// class definition
// -----------------------------------------------------------------------------

#include "spm_VersionInfo.h"

/*!
  *  \class spm_tclVersionInfo
  *  \brief This class reads the configuration data and writes it to the FFD if changed .
   It also updates error memory version and stores versions information like build version , customer version.

   The ISpmFactory object creates an instance of this class.
  */
class spm_tclVersionInfoConfig : public spm_tclVersionInfo
{
public:
spm_tclVersionInfoConfig( const ISpmFactory& factory );
virtual ~spm_tclVersionInfoConfig( );

protected:
virtual tVoid vStoreProjectVersionInfoInEmTrace( );
virtual tVoid vAdditionalCheck();

virtual tVoid vCheckForConfigRegistry();

tBool   _bDoConfigEntry;

};


#endif // __SPM_VERSIONINFOCONFIG_H

