/*!
  * \file spm_VersionInfo.cpp
  *  \brief
  *    Reads configuration data and writes it to the ffd if changed
  *
  *  \note
  *  \b PROJECT: NextGen \n
   \b SW-COMPONENT: FC SPM \n
   \b COPYRIGHT:    (c) 2011 Robert Bosch GmbH, Hildesheim \n
  *  \see
  *  \version
  * Date      | Author            | Modification
  * 11.08.11  | TMS Petroglou     | initial version
  ******
  */

// -----------------------------------------------------------------------------
// includes
// -----------------------------------------------------------------------------

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#include <sstream>

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_spm_if.h"
#include "dp_generic_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_FFD_DEF
#define SYSTEM_S_IMPORT_INTERFACE_KDS_DEF
#include "system_pif.h"

#include "spm_Config.h"

#include "spm_VersionInfoConfig.h"
#include "spm_ISystemPowerManager.h"
#include "spm_IFactory.h"
#include "spm_GlobDefs.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS SPM_TRACE_CLASS_SPM_SSH_PRJ
#include "trcGenProj/Header/spm_VersionInfoConfig.cpp.trc.h"
#endif
// has to come after etg include because redefinition of macros takes place
// to meet special spm requirements of blocking early spm traces
#include "spm_trace.h"

// -----------------------------------------------------------------------------
// defines
// -----------------------------------------------------------------------------
// #define SPM_TRACE_FILE_ID  SPM_FILE_VERSIONINFO


spm_tclVersionInfoConfig::spm_tclVersionInfoConfig( const ISpmFactory& factory ) : spm_tclVersionInfo( factory ){
    _bDoConfigEntry = FALSE;
}

spm_tclVersionInfoConfig::~spm_tclVersionInfoConfig( ){
}

tVoid spm_tclVersionInfoConfig::vStoreProjectVersionInfoInEmTrace( ){

   ETG_TRACE_FATAL( ( "spm_tclVersionInfoConfig::vStoreProjectVersionInfoInEmTrace(): called" ) );

   tChar                              strVariant[100] = { 0 };
   tChar                              strTarget[100]  = { 0 };

   dp_tclregVersionsPrjVariantVersion oPrjVariant;
   oPrjVariant.u8GetData( strVariant, 100 );

   dp_tclregVersionsPrjTargetVersion  oPrjTarget;
   oPrjTarget.u8GetData( strTarget, 100 );

   std::string                        strEntry = "VERSIONINFO: ProjectInfo:        ";

   strEntry += "TARGET: '";
   strEntry += strTarget;
   strEntry += "', VARIANT: '";
   strEntry += strVariant;
   strEntry += "'";

   ISpmSystemPowerManager *poclSystemPowerManager = dynamic_cast < ISpmSystemPowerManager* >( _crfFactory.getSpmObjHandler( "ISpmSystemPowerManager" ) );
   SPM_NULL_POINTER_CHECK( poclSystemPowerManager );

   poclSystemPowerManager->vWriteErrmem( U16_M_ERRMEM_SPM_ERROR( SPM_U8_ERRMEM_TYPE_STRING ), (tU8*)strEntry.c_str( ), strEntry.size( ) ); //lint !e1773 Attempt to cast away const


   tChar strSerialNb[100]  = { 0 };
   tChar strPartNb[100]    = { 0 };

   dp_tclKdsECUSerialNumber oSerialNumber;
   oSerialNumber.u8GetECUSerialNumber((tU8*)strSerialNb, 100);

   dp_tclKdsCustomerECUPartNumber oPartNb;
   oPartNb.u8GetECUPartNumber((tU8*)strPartNb, 100);

   strEntry = "VERSIONINFO: Part / Serial Nb:   ";
   strEntry += "'";
   strEntry += strPartNb;
   strEntry += "' / '";
   strEntry += strSerialNb;
   strEntry += "'";

   poclSystemPowerManager->vWriteErrmem( U16_M_ERRMEM_SPM_ERROR( SPM_U8_ERRMEM_TYPE_STRING ), (tU8*)strEntry.c_str( ), strEntry.size( ) ); //lint !e1773 Attempt to cast away const

   _bDoConfigEntry = TRUE;
   vCheckForConfigRegistry();
} // spm_tclVersionInfoConfig::vStoreProjectVersionInfoInEmTrace

tVoid spm_tclVersionInfoConfig::vAdditionalCheck() {
    vCheckForConfigRegistry();
}

tVoid spm_tclVersionInfoConfig::vCheckForConfigRegistry() {

    if (_bDoConfigEntry) {
        tU8 dpRet;
        tChar strProductionConfig[100]  = { 0 };
        tChar strCustomerDefaultConfig[100]  = { 0 };
        tChar strCustomerConfig[100]  = { 0 };
        tChar strBluetoothVersion[100]  = { 0 };

        dp_tclSpmDpRnAiviProductionConfigId oProdConfigId;
        dpRet = oProdConfigId.u8GetData(strProductionConfig, 100);
        ETG_TRACE_FATAL( ( "spm_tclStartupSystem::vCheckForConfigRegistry(): Read PD (%d) '%s'.", dpRet, strProductionConfig ) );

        if (dpRet == DP_U8_ELEM_STATUS_INITVAL) {
            //currently not in registry --> try later again
            return;
        }
        dp_tclSpmDpRnAiviCustomerDefConfigId oCustomerDefConfigId;
        dpRet = oCustomerDefConfigId.u8GetData(strCustomerDefaultConfig, 100);
        ETG_TRACE_FATAL( ( "spm_tclStartupSystem::vCheckForConfigRegistry(): Read CD DEF (%d) '%s'.", dpRet, strCustomerDefaultConfig ) );
        if (dpRet == DP_U8_ELEM_STATUS_INITVAL) {
            //currently not in registry --> try later again
            return;
        }
        dp_tclSpmDpRnAiviCustomerConfigId oCustomerConfigId;
        dpRet = oCustomerConfigId.u8GetData(strCustomerConfig, 100);
        ETG_TRACE_FATAL( ( "spm_tclStartupSystem::vCheckForConfigRegistry(): Read CD (%d) '%s'.", dpRet, strCustomerConfig ) );
        if (dpRet == DP_U8_ELEM_STATUS_INITVAL) {
            //currently not in registry --> try later again
            return;
        }
        dp_tclSpmDpRnAiviBluetoothVersion oBluetoothVersion;
        dpRet = oBluetoothVersion.u8GetData(strBluetoothVersion, 100);
        ETG_TRACE_FATAL( ( "spm_tclStartupSystem::vCheckForConfigRegistry(): Read Bluetooth version (%d) '%s'.", dpRet, strBluetoothVersion ) );
        if (dpRet == DP_U8_ELEM_STATUS_INITVAL) {
            //currently not in registry --> try later again
            return;
        }



        ISpmSystemPowerManager *poclSystemPowerManager = dynamic_cast < ISpmSystemPowerManager* >( _crfFactory.getSpmObjHandler( "ISpmSystemPowerManager" ) );
        SPM_NULL_POINTER_CHECK( poclSystemPowerManager );

        std::stringstream  strPdEntry;
        strPdEntry << "VERSIONINFO: PD CONFIG ID:       " << strProductionConfig;
        poclSystemPowerManager->vWriteErrmem( U16_M_ERRMEM_SPM_ERROR( SPM_U8_ERRMEM_TYPE_STRING ), (tU8*)strPdEntry.str( ).c_str(), strPdEntry.str().size( ) ); //lint !e1773 Attempt to cast away const

        std::stringstream  strCdDefEntry;
        strCdDefEntry << "VERSIONINFO: CD DEF CONFIG ID:   " << strCustomerDefaultConfig;
        poclSystemPowerManager->vWriteErrmem( U16_M_ERRMEM_SPM_ERROR( SPM_U8_ERRMEM_TYPE_STRING ), (tU8*)strCdDefEntry.str( ).c_str(), strCdDefEntry.str().size( ) ); //lint !e1773 Attempt to cast away const

        std::stringstream  strCdEntry;
        strCdEntry << "VERSIONINFO: CD CONFIG ID:       " << strCustomerConfig;
        poclSystemPowerManager->vWriteErrmem( U16_M_ERRMEM_SPM_ERROR( SPM_U8_ERRMEM_TYPE_STRING ), (tU8*)strCdEntry.str( ).c_str(), strCdEntry.str().size( ) ); //lint !e1773 Attempt to cast away const

        std::stringstream  strBluetoothEntry;
        strBluetoothEntry << "VERSIONINFO: BLUETOOTH VERSION:  " << strBluetoothVersion;
        poclSystemPowerManager->vWriteErrmem( U16_M_ERRMEM_SPM_ERROR( SPM_U8_ERRMEM_TYPE_STRING ), (tU8*)strBluetoothEntry.str( ).c_str(), strBluetoothEntry.str().size( ) ); //lint !e1773 Attempt to cast away const

        _bDoConfigEntry = FALSE;
    }
}

