/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_SystemStateManagerConfig.h
  * @brief        
  * @copyright    (C) 2013 - 2018 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */
#ifndef __SPM_SYSTEMSTATEMANAGERCONFIG_H
#define __SPM_SYSTEMSTATEMANAGERCONFIG_H

#include "spm_SystemStateManager.h"

#define SPM_U32_SYSTEM_STATE_ACTIVATE_AUTOMATIC                (tU32)0x00080001
#define SPM_U32_SYSTEM_STATE_DEACTIVATE_AUTOMATIC              (tU32)0x00080002
#define SPM_U32_SYSTEM_STATE_ACTIVATE_ROLLER_RIG               (tU32)0x00080003
#define SPM_U32_SYSTEM_STATE_SET_TIMER_QUICK_SLEEP             (tU32)0x00080004
#define SPM_U32_SYSTEM_STATE_RESET_TIMER                       (tU32)0x00080005


class spm_tclFactory;


/*!
  *  \class spm_tclSystemStateManagerConfig
  *  \brief This generic class handles different parts of statemachine. It checks entry point of system state transitions.
          It sets transition to new system state.

        The spm_tclFactory object creates an instance of this class.

  */
class spm_tclSystemStateManagerConfig : public spm_tclSystemStateManager
{

public:
spm_tclSystemStateManagerConfig( const spm_tclFactory& factory );
virtual ~spm_tclSystemStateManagerConfig( );

virtual tVoid vSetStateTime( tU32 u32State,
                             tU32 u32Time ) const;

protected:
// ISpmBase interface functions
// used from base class -> virtual tVoid vHandleTraceMessage(const tUChar* puchData);
virtual tVoid vStartCommunication( );

virtual tVoid vGetReferences( );

virtual const tChar*getName( ) const { return( "spm_tclSystemStateManagerConfig" ); }

static spm_tclSystemStateManagerConfig *_poMyRef;

static T_SYSTEM_STATE_ENTRY             _arStateTable[];
static TStateTransitionElement          _aSysStateTransitionTable[];

virtual tVoid                           vStateNoTransition( tVoid );

virtual tBool bActStateReached( tU32 u32SystemState ) const;

virtual tVoid vHandleMessage( tU32 u32Message,
                              tU32 u32Param = 0 );

virtual tVoid vCheckNewStateTransition( );

virtual tU32 u32GetNumberOfTransitionTableEntries( ) const;

virtual tU32 u32GetNumberOfStateEntries( ) const;

virtual tVoid vSetQrsTiming( );

virtual tVoid vResetQrsTiming( );

// gen code start
#define SPM_SYSTEM_STATE_VERSION    "MIB2_Powermanagement_StateMachine_V193F_20133010_Bosch_V01"

static tVoid vStateEntryPrepareshutdown( tVoid );
static tVoid vStateReachedPrepareshutdown( tVoid );
static tVoid vStateExitPrepareshutdown( tVoid );

static tVoid vStateEntryShutdown( tVoid );
static tVoid vStateReachedShutdown( tVoid );
static tVoid vStateExitShutdown( tVoid );

static tVoid vStateEntryBackground( tVoid );
static tVoid vStateReachedBackground( tVoid );
static tVoid vStateExitBackground( tVoid );

static tVoid vStateEntryMmistandby( tVoid );
static tVoid vStateReachedMmistandby( tVoid );
static tVoid vStateExitMmistandby( tVoid );

static tVoid vStateEntryMmion( tVoid );
static tVoid vStateReachedMmion( tVoid );
static tVoid vStateExitMmion( tVoid );

static tVoid vStateEntryMmistandbyrestricted( tVoid );
static tVoid vStateReachedMmistandbyrestricted( tVoid );
static tVoid vStateExitMmistandbyrestricted( tVoid );

static tVoid vStateEntryMmiondiag( tVoid );
static tVoid vStateReachedMmiondiag( tVoid );
static tVoid vStateExitMmiondiag( tVoid );

static tVoid vStateEntryMmiontel( tVoid );
static tVoid vStateReachedMmiontel( tVoid );
static tVoid vStateExitMmiontel( tVoid );

static tVoid vStateEntryMmionswdl( tVoid );
static tVoid vStateReachedMmionswdl( tVoid );
static tVoid vStateExitMmionswdl( tVoid );

static tVoid vStateEntryMmistandbycustomerswdl( tVoid );
static tVoid vStateReachedMmistandbycustomerswdl( tVoid );
static tVoid vStateExitMmistandbycustomerswdl( tVoid );

static tVoid vStateEntryMmistandbypwrsave( tVoid );
static tVoid vStateReachedMmistandbypwrsave( tVoid );
static tVoid vStateExitMmistandbypwrsave( tVoid );
// gen code stop

};

#endif // __SPM_SYSTEMSTATEMANAGERCONFIG_H

