/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_SubStateHandlerConfig.h
  * @brief        This is header file contains project specific interface functions for SubStateHandler.
  * @copyright    (C) 2012 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

#include "spm_SubStateHandler.h"

/*!
  *  \class spm_tclSubStateHandlerConfig
  *  \brief This generic class checks for ignition source and fast shutdown reasons.

        The spm_tclFactory object creates an instance of this class.
  */
class spm_tclSubStateHandlerConfig : public spm_tclSubStateHandler
{
protected:
tBool _bCurrentIgnitionState;

public:
spm_tclSubStateHandlerConfig( const ISpmFactory& factory,
                              tU16               u16AppId = CCA_C_U16_APP_SPM );
virtual ~spm_tclSubStateHandlerConfig( );

virtual const tChar*getName( ) const { return( "spm_tclSubStateHandlerConfig" ); }
virtual tVoid vGetReferences( );

protected:
tVoid vCheckIgnitionSource( );

virtual tBool bCheckForFastShutdown( tU32 u32FastShutdownReason );

virtual tVoid vPrjSubStateType( tU32  u32SubStateType,
                                tBool bSubStateData );

};

