/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_ISubStateDebounce.h
  * @brief        definition of states to be debounced
  * @copyright    (C) 2016 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_config.h must be included!
#endif

#include "spm_baseClass.h"
#include "spm_ISpmBase.h"

// //////////////////////////////////////////////////////////////////////////////
// Base class for all SPM Classes

/*!
  *  \class ISpmSubStateDebounce
  *  \brief This abstract class provides interfaces to handle hardware signals.
   This also supplies pure virtual function to set test mode .

  */
class ISpmSubStateDebounce : public ISpmBase
   , public spm_tclActive
{
public:
typedef enum
{
   eGpioTipper,
   eGpioEject,
   eGpioAcc,
   eGpioIgnition,
   eGpioMax
} eMbxResult;

ISpmSubStateDebounce( const ISpmFactory& factory ) : ISpmBase( factory ){}
virtual ~ISpmSubStateDebounce( ){}

virtual tVoid vTraceSignals( )                             = 0;

virtual tVoid vCheckSignals( )                             = 0;

virtual tVoid vSetTestMode( tBool bTstMode )               = 0;

virtual tBool bUpdateSubState( tU32  u32Substate,
                               tBool bActive )             = 0;

virtual tVoid vDisableSubstateDebounce( tU32 u32Substate ) = 0;

virtual tVoid vEnableSubstateDebounce( tU32 u32Substate )  = 0;


virtual const tChar*getInterfaceName( ) const { return( "ISpmSubStateDebounce" ); }
};

