
/*!
  * \file  spm_SystemPowerManagerConfig_trace.cpp
  *  \brief
  *    Method definitions for testing via trace purposes.
  *               This list is generated.
  *
  *  \note
  *  PROJECT: NextGen
  *  SW-COMPONENT: FC SPM
  *  COPYRIGHT:    (c) 2011 Robert Bosch GmbH, Hildesheim 

  *  \see
  *  \version
  *
  ******
  */

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "spm_Config.h"

// Trace specific includes can be put here
// spm_tclSystemPowerManagerConfig_include_ext: user specific code start
#include "spm_SystemPowerManagerConfig.h"
#include "spm_IOsalProxy.h"
// spm_tclSystemPowerManagerConfig_include_ext: user specific code end


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS SPM_TRACE_CLASS_SPM
#include "trcGenProj/Header/spm_SystemPowerManagerConfig_trace.cpp.trc.h"
#endif

// has to come after etg include because redefinition of macros takes place
// to meet special spm requirements of blocking early spm traces
#include "spm_trace.h"

// Spm trace specific code can be put here
// spm_tclSystemPowerManagerConfig_include_spm: user specific code start
// spm_tclSystemPowerManagerConfig_include_spm: user specific code end


tVoid spm_tclSystemPowerManagerConfig::vHandleTraceMessage(const tUChar *puchData){
/*!
  * \fn
  *  \brief
  *    Interface function for the tracechannel.
  *
  *  \param
  *  \note
  *  \bug
  *    no bugs known
  *  \todo
  *    nothing left
  *  \version
  *    1.0   - Initial
  ******
  */
   tU32 u32MsgCode = ( puchData[1] << 8 ) | puchData[2];

   switch (u32MsgCode){
   
   case SPM_SPMSHUTDOWNBEHAVIOUR:
   {
            tU32 param1 = (puchData[3]<<24) | (puchData[4]<<16) | (puchData[5] << 8) | puchData[6];

      // SpmShutdownBehaviour: user specific code start
         (tVoid)param1;
      // SpmShutdownBehaviour: user specific code end
   }
   break;

   case SPM_SPMTHREADINFO:
   {
      // Trace out spm thread info and dump to emtrace.

      // SpmThreadInfo: user specific code start
         TRACE_SPM_ERROR_MY_THREAD(this);
      // SpmThreadInfo: user specific code end
   }
   break;

      default:
         //nothing to do
         break;
   } //lint !e764: switch statement possibly does not have a case --> generated trace command function
  // spm_tclSystemPowerManagerConfigFunction: user specific code start
   spm_tclSystemPowerManager::vHandleTraceMessage(puchData);
  // spm_tclSystemPowerManagerConfigFunction: user specific code end
    
   return;
} // vHandleTraceMessage

// Trace specific code can be put here
// spm_tclSystemPowerManagerConfigFile: user specific code start
// spm_tclSystemPowerManagerConfigFile: user specific code end

