/*!
  * \file spm_SystemPowerManagerConfig.cpp
  *  \brief
  *    Project specific shutdown and write error memory handling.
  *
  *  \note
  *  \b PROJECT: NextGen \n
   \b SW-COMPONENT: FC SPM \n
   \b COPYRIGHT:    (c) 2011 Robert Bosch GmbH, Hildesheim \n
  *  \see
  *  \version
  * Date      | Author             | Modification
  * 29.09.11  | TMS Fischer        | initial version
  ******
  */

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_spm_if.h"

// -----------------------------------------------------------------------------
// includes
// -----------------------------------------------------------------------------
#include "spm_Config.h"

#include "spm_SystemPowerManagerConfig.h"

#include "spm_IFactory.h"
#include "spm_IPrjFactoryHelper.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS SPM_TRACE_CLASS_SPM
 #include "trcGenProj/Header/spm_SystemPowerManagerConfig.cpp.trc.h"
#endif
// has to come after etg include because redefinition of macros takes place
// to meet special spm requirements of blocking early spm traces
#include "spm_trace.h"

// -----------------------------------------------------------------------------
// defines
// -----------------------------------------------------------------------------
// #define SPM_TRACE_FILE_ID   SPM_FILE_SYSTEMPOWERMANAGERCONFIG

spm_tclSystemPowerManagerConfig::spm_tclSystemPowerManagerConfig( const ISpmFactory& factory )
   : spm_tclSystemPowerManager( factory ){
}

spm_tclSystemPowerManagerConfig::~spm_tclSystemPowerManagerConfig( ){
}

tVoid spm_tclSystemPowerManagerConfig::vGetReferences( ){
   // get all needed references now -> all SPM objects are now available
   spm_tclSystemPowerManager::vGetReferences( );
}

tVoid spm_tclSystemPowerManagerConfig::vWriteProjectSpecificShutdownInfoToErrMem( tU32 u32ShutdownOption ){
   spm_tclSystemPowerManager::vWriteProjectSpecificShutdownInfoToErrMem( u32ShutdownOption );
} // vWriteProjectSpecificShutdownInfoToErrMem


tVoid spm_tclSystemPowerManagerConfig::vShutdownSystem( tU32 u32ShutdownOption ){
   ISpmPrjFactoryHelper* poclFactoryHelper = dynamic_cast < ISpmPrjFactoryHelper* >( _crfFactory.getSpmObjHandler("ISpmPrjFactoryHelper") );
   SPM_NULL_POINTER_CHECK(poclFactoryHelper);

   ISpmSystemStateManager* poclSystemStateManager = poclFactoryHelper->oStartSystemStateManager();
   if (poclSystemStateManager == NULL) {
       ETG_TRACE_FATAL( ( "!!!!!!!!!!! FAILED to (re)start SystemStateManager !!!!!!!" ) );
   }


   spm_tclSystemPowerManager::vShutdownSystem( u32ShutdownOption );
}
