/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_security.h
  * @brief        This is header file contains functions to handle security states.
  * @copyright    (C) 2012 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once
// -----------------------------------------------------------------------------
// includes
// -----------------------------------------------------------------------------

#define AHL_S_IMPORT_INTERFACE_FSM
#include "ahl_if.h"

#include "spm_ISecurity.h"

class ISpmWorkerServer;
class ISpmSystemPowerManager;
class ISpmCsmService;

// -----------------------------------------------------------------------------
// defines
// -----------------------------------------------------------------------------
#define SPM_U32_SECURITY_STATE_TO           (tU32)( SPM_U32_SPM_WORKER_SEC_ID + 1 )
#define SPM_U32_SECURITY_MASTER_NEW         (tU32)( SPM_U32_SPM_WORKER_SEC_ID + 2 )
#define SPM_U32_SECURITY_CHECKSUM_FAULT     (tU32)( SPM_U32_SPM_WORKER_SEC_ID + 3 )
#define SPM_U32_SECURITY_LEN_FAULT          (tU32)( SPM_U32_SPM_WORKER_SEC_ID + 4 )
#define SPM_U32_SECURITY_REQUEST_TIMEDOUT   (tU32)( SPM_U32_SPM_WORKER_SEC_ID + 5 )
#define SPM_U32_SECURITY_REQUEST_ID         (tU32)( SPM_U32_SPM_WORKER_SEC_ID + 6 )
#define SPM_U32_SECURITY_ID_RECEIVED        (tU32)( SPM_U32_SPM_WORKER_SEC_ID + 7 )

typedef enum
{
   eSecFsmIdle    = 0,

   eSecFsmMax,
   eSecFsmInvalid = 0xFFFF
}tenSecFsmState;

// -----------------------------------------------------------------------------
// class definition
// -----------------------------------------------------------------------------

/*!
  *  \class spm_tclSecurity
  *  \brief This generic class handles security related operations. It sets security modes.
          This class uses class spm_tclWorkerServerConfig to add and remove clients for security operations.

        The spm_tclFactory object creates an instance of this class.

  */
class spm_tclSecurity : public ahl_tclFsmBase
   , public ISpmSecurity
{

private:
private:
// references
ISpmWorkerServer        *_poWorkerSrv;
ISpmSystemPowerManager  *_poclSystemPowerManager;
ISpmCsmService          *_poCsm;

static TStateTransitions _aFsmStateTransitionTable[];
static TFsmStateConf     _aFsmStateTable[eSecFsmMax];
tenSecurityState         tSecState;

public:
virtual tenSecurityState tGetSecLockType( ) const { return( tSecState ); }

/*---------------------------------------------------------------------*/
spm_tclSecurity( const ISpmFactory& factory ); // Lint requested default constructor
virtual ~spm_tclSecurity( void );              // destructor
/*---------------------------------------------------------------------*/

virtual tVoid vSecurityInfo( );

virtual tVoid vSetSecurityMode( tBool bEnabled ) const;

virtual tVoid vSetFactoryDef( ) const;

virtual tVoid vSecurityIdReceived( tU8 *pu8Data,
                                   tU8  u8Len );

// ISpmBase methods
virtual tVoid vGetReferences( );

virtual tVoid vStartCommunication( );

virtual tVoid vHandleTraceMessage( const tUChar */*puchData*/ ){} //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used
virtual const tChar*getName( ) const { return( "spm_tclSecurity" ); }

// ISpmWorkerClient methods
virtual tVoid vStart( );

virtual tVoid vHandleMessage( tU32 u32Message,
                              tU32 u32Parm = 0 );

virtual tBool bHandleSynchrounousCall( tU32   /*u32Message*/,
                                       tVoid */*args*/ ){ return( FALSE ); }  //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used
};

