/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_OsalProxyConfig.h
  * @brief        
  * @copyright    (C) 2013 - 2018 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */
#ifndef _SPM_OSALPROXY_G2CONFIG_H_
#define _SPM_OSALPROXY_G2CONFIG_H_

#ifndef _SPM_CONFIG_H
    #error spm_config.h must be included!
#endif

#include "spm_OsalProxy.h"

/*!
  *  \class spm_tclOsalProxyConfig
  *  \brief This class encapsulates project specific extensions of the platform here. It sets calibrated critical voltage parameters and handles
          project specific critical voltage management.

        it uses class spm_tclOsLinux to get thread and process info and class spm_tclApplicationDatabase to access and release application database.

        The ISpmFactory object creates an instance of this class. Class spm_tclSupervisionManager, spm_tclSystemPowerManager and spm_tclLocalApplicationManager
        use this class for time Out warning operation.
  */
class spm_tclOsalProxyConfig : public spm_tclOsalProxy
{
public:
spm_tclOsalProxyConfig( const ISpmFactory& factory,
                        tU32                  u32AppId );

virtual ~spm_tclOsalProxyConfig( );

protected:
// ISpmBase interface functioms
virtual tVoid vStartCommunication( );

virtual tVoid vGetReferences( );

virtual const tChar*getName( ) const { return( "spm_tclOsalProxyConfig" ); }
};

#endif // _SPM_OSALPROXY_G2CONFIG_H_

