/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_IHwSigs.h
  * @brief        This is header file contains interfaces to handle hardware signals.
  * @copyright    (C) 2012 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_config.h must be included!
#endif

#include "spm_baseClass.h"
#include "spm_ISpmBase.h"

// //////////////////////////////////////////////////////////////////////////////
// Base class for all SPM Classes

/*!
  *  \class ISpmHwSigs
  *  \brief This abstract class provides interfaces to handle hardware signals.
          This also supplies pure virtual function to set test mode .

  */
class ISpmHwSigs : public ISpmBase
   , public spm_tclActive
{
public:
ISpmHwSigs( const ISpmFactory& factory ) : ISpmBase( factory ){}
virtual ~ISpmHwSigs( ){}

virtual tVoid vTraceSignals( )               = 0;

virtual tVoid vCheckSignals( )               = 0;

virtual tVoid vSetTestMode( tBool bTstMode ) = 0;

virtual const tChar*getInterfaceName( ) const { return( "ISpmHwSigs" ); }
};

