/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_gpio.h
  * @brief        This is header file contains functions to reads and updates GPIO signals.
  * @copyright    (C) 2012 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

// -----------------------------------------------------------------------------
// includes
// -----------------------------------------------------------------------------
#include "spm_IHwSigs.h"

// -----------------------------------------------------------------------------
// defines
// -----------------------------------------------------------------------------

#define SPM_HWGPIO_THREAD_PRIO        50
#define SPM_HWGPIO_THREAD_STACKSIZE   8192

#define SPM_HWGPIO_IDLE      0
#define SPM_HWGPIO_WAITING   1
#define SPM_HWGPIO_SEND      2

#define SPM_HWGPIO_DELAY_POLLING      100
#define SPM_HWGPIO_DELAY_IDLE         1000
#define SPM_HWGPIO_DELAY_BLOCK        1000
#define SPM_HWGPIO_DELAY_DEBOUNCING   1

#define SPM_HWGPIO_TO_INVALID     0xffffffff

// -----------------------------------------------------------------------------
// class definition
// -----------------------------------------------------------------------------

class ISpmOsalProxy;
class ISpmSubStateClient;

/*!
  *  \class spm_tclHwSig
  *  \brief This generic class handles general input/output(GPIO) hardware signals.
          It reads and updates GPIO signals.

          The spm_tclFactory object creates an instance of this class.
     class spm_tclSubStateHandler uses this class to check GPIO signals.
  */
class spm_tclHwSig : public ISpmHwSigs
{

private:
static spm_tclHwSig *_pMyStaticRef;
static tVoid vCallbackHdl( tVoid *pvArg );

OSAL_tMQueueHandle _hGpioQueueHandle;
tBool bPostMessage( tU32 u32Msg );

// implementation of spm_tclActive
virtual tVoid vOnStart( );

virtual tVoid vOnTerminate( );

virtual tVoid main( );

typedef enum
{
   eGpioWdOff,
   eGpioMax
} eMbxResult;

struct TGpioCfg
{
   tU32 u32GpioId;
   tU32 u32TriggerType;
   tBool bLevel;
   tU32 u32DebounceLowTime;
   tU32 u32DebounceHighTime;
   tU32 u32LastChange;
   tBool bDebouncedState;
   tBool bHwState;
   tU32 u32ChangeIntervall;
   tU32 u32MaxCount;
   tU32 u32ChangeCount;
   tU32 u32StartCountingTime;
   tBool bBlocked;
   tU32 u32BlockTime;
};

TGpioCfg _tGpioCfg[eGpioMax];

tVoid vReadGpio( tU32 u32GpioId );

tU8 u8UpdateGpio( tU32  u32GpioId,
                  tBool bForce = FALSE );

tVoid vCheckCount( tU32 u32GpioId );

tBool          _bTestMode;
tBool          _bPollingActive;
ISpmOsalProxy *_poclOsalProxy;

tU32                _u32ThreadWaitingDelay;
ISpmSubStateClient *_poclSubStateHandler;

public:
/* +++
   Enter your public Data and functions here
 +++ */
/*---------------------------------------------------------------------*/
spm_tclHwSig( const ISpmFactory& factory ); // constructor
virtual ~spm_tclHwSig( void );              // destruktor
/*---------------------------------------------------------------------*/

virtual tVoid vGetReferences( );

virtual tVoid vStartCommunication( );

virtual tVoid vHandleTraceMessage(const tUChar *puchData);
virtual const tChar*getName( ) const { return( "spm_tclHwSig" ); }

virtual tVoid vTraceSignals( );

virtual tVoid vCheckSignals( );

virtual tVoid vSetTestMode( tBool bTstMode );
};

