/*******************************************************************************
 * FILE        :  spm_CcaServiceHandlerConfig_trace.cpp
 * DESCRIPTION :  Generated/Updated trace command message handler file
 *******************************************************************************/

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#include "spm_Config.h"

// spm_tclCcaServiceHandlerConfigInclude: user specific code start
#include "spm_CcaServiceHandlerConfig.h"
// spm_tclCcaServiceHandlerConfigInclude: user specific code end


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS SPM_TRACE_CLASS_SPM
 #include "trcGenProj/Header/spm_CcaServiceHandlerConfig_trace.cpp.trc.h"
#endif

#include "spm_trace.h"

tVoid spm_tclCcaServiceHandlerConfig::vHandleTraceMessage(const tUChar *puchData){
   tU32 u32MsgCode = ( puchData[1] << 8 ) | puchData[2];

   switch (u32MsgCode){

      case SPM_SPMTRIGGERHMISTATE:
      {
         tU32                            param1 = ( puchData[3] << 24 ) | ( puchData[4] << 16 ) | ( puchData[5] << 8 ) | puchData[6];

         // SpmTriggerHmiState: user specific code start
         spm_corefi_tclMsgHmiStateStatus hmistatus;

         hmistatus.HmiState.enType = (spm_fi_tcl_SPM_e32_HMI_STATE::tenType)param1;
         vUpdateProperty(SPM_COREFI_C_U16_HMISTATE, &hmistatus);
         // SpmTriggerHmiState: user specific code end
      }
      break;

      case SPM_SPMTRIGGERDIMSTATE:
      {
         tU32                            param1 = ( puchData[3] << 24 ) | ( puchData[4] << 16 ) | ( puchData[5] << 8 ) | puchData[6];

         // SpmTriggerDimState: user specific code start
         spm_corefi_tclMsgDimStateStatus dimstatus;

         dimstatus.DimState.enType = (spm_fi_tcl_SPM_e32_DIM_STATE::tenType)param1;
         vUpdateProperty(SPM_COREFI_C_U16_DIMSTATE, &dimstatus);
         // SpmTriggerDimState: user specific code end
      }
      break;

      case SPM_SPMTRIGGERSYSSTATE:
      {
         tU32 param1 = ( puchData[3] << 24 ) | ( puchData[4] << 16 ) | ( puchData[5] << 8 ) | puchData[6];

         // SpmTriggerSysState: user specific code start
         param1++;
         (tVoid)param1;
         // SpmTriggerSysState: user specific code end
      }
      break;

      case SPM_SPMTRIGGERRVCSTATE:
      {
         tU32 param1 = puchData[3];

         // SpmTriggerRVCState: user specific code start
         param1++;
         (tVoid)param1;
         // SpmTriggerRVCState: user specific code end
      }
      break;

      case SPM_SPMTRIGGERMOSTREMOTERESET:
      {

         // SpmTriggerMostRemoteReset: user specific code start
         // SpmTriggerMostRemoteReset: user specific code end
      }
      break;

      default:
         // nothing to do
         break;
   } // switch
     // spm_tclCcaServiceHandlerConfigFunction: user specific code start
   spm_tclCcaServiceHandler::vHandleTraceMessage(puchData);
   // spm_tclCcaServiceHandlerConfigFunction: user specific code end

   return;
} // vHandleTraceMessage

// spm_tclCcaServiceHandlerConfigFile: user specific code start
// spm_tclCcaServiceHandlerConfigFile: user specific code end

