#ifndef __SPM_CCASERVICEHANDLERCONFIG_H
   #define __SPM_CCASERVICEHANDLERCONFIG_H

#ifndef _SPM_CONFIG_H
    #error spm_config.h must be included!
#endif

#include "spm_CcaServiceHandler.h"
#include "spm_ISystemInfoClient.h"

#include "spm_CcaServiceHandlerAccessConfig.h"

class ISpmWorkerServer;

// //////////////////////////////////////////////////////////////////////////////
// project specific configuration class for spm_tclCcaServiceHandler
//

/*!
  *  \class spm_tclCcaServiceHandlerConfig
  *  \brief Project specific configuration class for spm_tclCcaServiceHandler. Configuration file for cca service handling which includes
          all property and method variables and project specific functions.

        The ISpmFactory object creates an instance of this class.
  */
class spm_tclCcaServiceHandlerConfig : public spm_tclCcaServiceHandler
   {
public:
   spm_tclCcaServiceHandlerConfig(const ISpmFactory& factory);
   virtual ~spm_tclCcaServiceHandlerConfig();

   tVoid vInitPropertiesConfig();

   tVoid vInitMethodsConfig();

   // trace handling
   virtual tVoid vHandleTraceMessage(const tUChar *puchData);

   virtual tVoid vTraceInfo();

protected:
   // Implementation of interface ISpmSystemInfoClient
   virtual tVoid vHandleIgnitionCycleEvent(tU32 u32IgnitionCycleEvent);

   virtual tVoid vHandleSysPwrModeEvent(tU32 u32SysPwrModeEvent);

   virtual tVoid vHandleTriggerMostRemoteReset();

   virtual const tChar*getName() const { return( "spm_tclCcaServiceHandlerConfig" ); }
   virtual tVoid vGetReferences();

   virtual tVoid vStartCommunication();

private:
   #ifndef LCM_UNIT_TESTS
// include generated parts of the configured CcaServiceHandler
#include "spm_CcaServiceHandlerFiParamConfig.h"
   #endif

   };

#endif // __SPM_CCASERVICEHANDLERCONFIG_H

