/*!
  * \file spm_CcaServiceHandlerConfig.cpp
  *  \brief
  *    Configuration file for cca service handling which includes all property and method variables and project specific
  *    functions.
  *
  *  \note
  *  \b PROJECT: NextGen \n
   \b SW-COMPONENT: FC SPM \n
   \b COPYRIGHT:    (c) 2011 Robert Bosch GmbH, Hildesheim \n
  *  \see
  *  \version
  * Date      | Author            | Modification
  * 11.08.11  | TMS Fischer       | initial version
  ******
  */

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_spm_if.h"

// -----------------------------------------------------------------------------
// includes FC SPM
// -----------------------------------------------------------------------------

#include "spm_Config.h"

#include "spm_CcaServiceHandlerConfig.h"

#include "spm_IFactory.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS SPM_TRACE_CLASS_SPM_PRJ
#include "trcGenProj/Header/spm_CcaServiceHandlerConfig.cpp.trc.h"
#endif

// has to come after etg include because redefinition of macros takes place
// to meet special spm requirements of blocking early spm traces
#include "spm_trace.h"

/******************************************************************************
  | local #define (scope: module-local)
  |-----------------------------------------------------------------------*/
// #define SPM_TRACE_FILE_ID   SPM_FILE_CCASERVICEHANDLERCONFIG

spm_tclCcaServiceHandlerConfig::spm_tclCcaServiceHandlerConfig(const ISpmFactory& factory)
   : spm_tclCcaServiceHandler(factory){
   vInitPropertiesConfig();
   vInitMethodsConfig();
}

spm_tclCcaServiceHandlerConfig::~spm_tclCcaServiceHandlerConfig(){
}

tVoid spm_tclCcaServiceHandlerConfig::vGetReferences(){
   spm_tclCcaServiceHandler::vGetReferences();
}

tVoid spm_tclCcaServiceHandlerConfig::vStartCommunication( ){
   spm_tclCcaServiceHandler::vStartCommunication( );
}

tVoid spm_tclCcaServiceHandlerConfig::vTraceInfo(){
   //ETG_TRACE_FATAL( ( "CCA property SPM_COREFI_C_U16_EJECTSTATE:      %u", ETG_ENUM(CFC_FI_SPM_CD_EJECT_STATE, (tU32)_ejectState.getProperty().EjectState.enType) ) );


   spm_tclCcaServiceHandler::vTraceInfo();
}

tVoid spm_tclCcaServiceHandlerConfig::vHandleIgnitionCycleEvent(tU32 u32IgnitionCycleEvent){
   ETG_TRACE_USR4( ( "vHandleIgnitionCycleEvent: %d", u32IgnitionCycleEvent ) );

}

tVoid spm_tclCcaServiceHandlerConfig::vHandleSysPwrModeEvent(tU32 u32SysPwrModeEvent){
   ETG_TRACE_USR4( ( "vHandleSysPwrModeEvent: %d", u32SysPwrModeEvent ) );

}

tVoid spm_tclCcaServiceHandlerConfig::vHandleTriggerMostRemoteReset(){
}

