/*****************************************************************************
 * FILE:         spm_factory.cpp
 * PROJECT:      NextGen
 * SW-COMPONENT: FC SPM
 **----------------------------------------------------------------------------
 *
 * DESCRIPTION:  Create the component SPM and the startup process
 *
 **----------------------------------------------------------------------------
 * COPYRIGHT:    (c) 2012 Robert Bosch GmbH, Hildesheim
 * HISTORY:
 * Date      | Author            | Modification
 * 28.12.12  | CM-AI/VW32 kollai | Init version
 *****************************************************************************/
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"
#include "dp_spm_if.h"
#include "dp_generic_if.h"

#include "spm_Config.h"
#include "spm_service_csm.h"
#include "spm_OsalProxyConfig.h"
#include "spm_prjFactoryHelper.h"
#include "spm_SystemStateManagerInf4cv.h"
#include "spm_SubStateDebounce.h"
#include "spm_StartupInvestigation.h"
#include "spm_IStartupSystemVariant.h"
#include "spm_WdgAccSupervisor.h"
#include "spm_UnballastSupervisor.h"
#include "spm_cvm_LowVoltage_handler.h"
#include "spm_gpio.h"

#include "spm_VdDiagLogCcaServiceHandler.h"

#include "spm_ISubStateClient.h"

#include "spm_factory_config.h"

#include "spm_security.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS SPM_TRACE_CLASS_SPM_PRJ
#include "trcGenProj/Header/spm_factory_config.cpp.trc.h"
#endif

#include "spm_trace.h"

#include "spm_ClientHandlerBase.h"
#include "spm_AnimationServiceHandler.h"
#include "spm_SpmDbusServiceHandler.h"

spm_tclFactoryConfig::spm_tclFactoryConfig( ) : spm_tclFactory( ){
    /*!
     * \fn
     *  \brief spm_tclFactoryConfig constructor.
     *
     *  \param
     *  \note
     *  \version
     ******
     */

}

spm_tclFactoryConfig::~spm_tclFactoryConfig( ){
    /*!
     * \fn
     *  \brief spm_tclFactoryConfig destructor.
     *
     *  \param
     *  \note
     *  \version
     ******
     */
	 }
tVoid spm_tclFactoryConfig::vCreatePrjComponents(){
   spm_tclStartupItem item;

   SPM_STARTUPINVEST_INIT_TIME;

   spm_tclPrjFactoryHelper *poFactoryHelper = new spm_tclPrjFactoryHelper(* this);
   SPM_NULL_POINTER_CHECK(poFactoryHelper);
   vAddFactoryClient(poFactoryHelper);
   
      {
      spm_tclClientHandlerBase *poClient = new spm_tclAnimationServiceHandler(* this);
      SPM_NULL_POINTER_CHECK(poClient);
      vAddFactoryClientHandler(poClient);
   } // lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list

	SPM_STARTUPINVEST_SET_STARTTIME;
   {
	spm_tclCsmIf *poCsmService = new spm_tclCsmIf( * this );
	SPM_NULL_POINTER_CHECK( poCsmService );
	vAddFactoryClient( poCsmService );
    } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list

	SPM_STARTUPINVEST_CHECK_TIME_MEASURE( "FC SPM: spm_tclCsmIf created." ); 

   
   SPM_STARTUPINVEST_SET_STARTTIME;
   {
      spm_tclCvmHandler9000mV *poLowVoltService = new spm_tclCvmHandler9000mV(* this);
      SPM_NULL_POINTER_CHECK(poLowVoltService);
      vAddFactoryClient(poLowVoltService);
   } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
   SPM_STARTUPINVEST_CHECK_TIME_MEASURE("FC SPM: spm_tclCvmHandler9000mV created.");

   SPM_STARTUPINVEST_SET_STARTTIME;
   {
      spm_tclSubStateDebounce *poSubStateDebounce = new spm_tclSubStateDebounce(* this);
      SPM_NULL_POINTER_CHECK(poSubStateDebounce);
      vAddFactoryClient(poSubStateDebounce);
   } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
   SPM_STARTUPINVEST_CHECK_TIME_MEASURE("FC SPM: spm_tclSubStateDebounce created.");


   SPM_STARTUPINVEST_SET_STARTTIME;
	_poSystemStateManager = new spm_tclSystemStateManagerInf4cv(*this);
	SPM_NULL_POINTER_CHECK(_poSystemStateManager);
	vAddFactoryClient(_poSystemStateManager);
	_poclTrace->vAddTraceClient(_poSystemStateManager);

   //_poSystemStateManager = poFactoryHelper->oStartSystemStateManager();
   SPM_STARTUPINVEST_CHECK_TIME_MEASURE("FC SPM: project SystemStateManager created.");

   SPM_STARTUPINVEST_SET_STARTTIME;
   {
	   spm_tclHwSig *poHwSig = new spm_tclHwSig(*this);
	   SPM_NULL_POINTER_CHECK(poHwSig);
	   vAddFactoryClient(poHwSig);
   } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
   SPM_STARTUPINVEST_CHECK_TIME_MEASURE("FC SPM: spm_tclHwSig created.");
   
   SPM_STARTUPINVEST_SET_STARTTIME;
   {
	   spm_tclVdDiagLogServiceHandler *poDialog = new spm_tclVdDiagLogServiceHandler(*this);
	   SPM_NULL_POINTER_CHECK(poDialog);
	   vAddFactoryClientHandler(poDialog);
   } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
   SPM_STARTUPINVEST_CHECK_TIME_MEASURE("FC SPM: spm_tclVdDiagLogCcaServiceHandler created.");

} // vCreatePrjComponents

tVoid spm_tclFactoryConfig::vCreateClientHandling(){
		spm_tclClientHandlerBase *poClient = new spm_tclSpmDBusServiceHandler(* this);   
		SPM_NULL_POINTER_CHECK(poClient);
		vAddFactoryClientHandler(poClient);
}    //lint !e1762  Member function 'spm_tclFactory::vCreateClientHandling(void)' could be made const

tVoid spm_tclFactoryConfig::vStartPrjComponents(){

    ISpmSubStateDebounce* poSubStateDebounce = dynamic_cast < ISpmSubStateDebounce* >( _crfFactory.getSpmObjHandler("ISpmSubStateDebounce") );
    SPM_NULL_POINTER_CHECK(poSubStateDebounce);
    poSubStateDebounce->vStartThread("SpmSubDebounce", 56, 4096);

} //lint !e1762  Member function 'spm_tclFactory::vStartPrjComponents(void)' could be made const

tVoid spm_tclFactoryConfig::vPrePrjStart(){

} //lint !e1762  Member function 'spm_tclFactory::vPrePrjStart(void)' could be made const

tVoid spm_tclFactoryConfig::vPostPrjStart(){

} //lint !e1762  Member function 'spm_tclFactory::vPostPrjStart(void)' could be made const

tVoid spm_tclFactoryConfig::vShowSystemInformationPrj(){
/*!
  * \fn
  *  \brief Shows system information.
  *
  *  \param
  *  \note
  *  \version
  ******
  */
    ETG_TRACE_FATAL( ( "SYSTEM Information for Inf4cv:" ) );

   #if 0
      // GetSystemConfiguration: user specific code start
      ETG_TRACE_FATAL( ( "SystemConfiguration: %d", ETG_ENUM(SPM_SYSCONF, _dp->u32GetData(SPM_DATAPOOL_SYSTEM_CONFIGURATION) ) ) );
      ETG_TRACE_FATAL( ( "Marketing Region:    %d", ETG_ENUM(SPM_MARKETING_REGION, _dp->u32GetData(SPM_DATAPOOL_MARKETING_REGION) ) ) );
      ETG_TRACE_FATAL( ( "Vehicle Brand:       %d", ETG_ENUM(SPM_BRAND, _dp->u32GetData(SPM_DATAPOOL_VEHICLE_BRAND) ) ) );
   #endif
}

tVoid spm_tclFactoryConfig::vPreStartEvaluateProcessStartup(){
} //lint !e1762  Member function 'spm_tclFactory::vPostPrjStart(void)' could be made const

//EOF

