/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_ISpmCvmUserClient.h
  * @brief        This is header file contains interface functions for SpmCvmUserClient.
  * @copyright    (C) 2013 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_config.h must be included!
#endif

// -----------------------------------------------------------------------------
// includes
// -----------------------------------------------------------------------------
#include "spm_ISpmBase.h"
#include "spm_IFactory.h"

class ISpmCvmUserClient : public ISpmBase
{
public:
ISpmCvmUserClient( const ISpmFactory& factory ) : ISpmBase( factory ){
}

virtual ~ISpmCvmUserClient( ){
}

virtual tVoid vVoltageLevelOverrun( )  = 0;

virtual tVoid vVoltageLevelUnderrun( ) = 0;

virtual const tChar*getName( ) const   = 0;

virtual const tChar*getInterfaceName( ) const { return( "ISpmCvmUserClient" ); }
};

