/*****************************************************************************
 * FILE:         spm_SpmDbusServiceHandler.h
 * PROJECT:      GEN3
 * SW-COMPONENT:
 ****----------------------------------------------------------------------------
 *
 * DESCRIPTION:
 *
 ****----------------------------------------------------------------------------
 * COPYRIGHT:    (c) 2012 Robert Bosch GmbH, Hildesheim
 * HISTORY:
 * Date      | Author            | Modification
 * 23.05.12  | CM-AI/VW32 kollai | Initial version for NISSAN LCN2 KAI
 *
 *****************************************************************************/
#ifndef spm_SpmDbusServiceHandler_H
#define spm_SpmDbusServiceHandler_H

#ifndef _SPM_CONFIG_H
#error spm_config.h must be included!
#endif

#include "spm_ClientHandlerBase.h"
#include "spm_ISubStateClient.h"
#include "spm_SubStateHandler.h"
#include "spm_SubStateDefines.h"
#include "spm_IWorkerClient.h"

/******************************************************************************
  | local #define (scope: module-local)
  |-----------------------------------------------------------------------*/

#define SPM_SPMDBUSSRV_FI_MAJOR_VERSION 1
#define SPM_SPMDBUSSRV_FI_MINOR_VERSION 0
#define SPM_SPMDBUSSRV_FI_PATCH_VERSION 0

#define VOLTAGE_LEVEL_UNDEFINED 0x0000
#define VOLTAGE_LEVEL_OVERCRITICAL 0x0001
#define VOLTAGE_LEVEL_OVERWARNING 0x0002
#define VOLTAGE_LEVEL_NORMAL 0x0003
#define VOLTAGE_LEVEL_UNDERWARNING 0x0004
#define VOLTAGE_LEVEL_UNDERCRITICAL 0x0005

#define THERMAL_LEVEL_UNDEFINED 0x0000
#define THERMAL_LEVEL_OVER_CRITICAL 0x0001
#define THERMAL_LEVEL_CRITICAL_HIGH 0x0002
#define THERMAL_LEVEL_HIGH 0x0003
#define THERMAL_LEVEL_NORMAL 0x0004
#define THERMAL_LEVEL_LOW 0x0005
#define THERMAL_LEVEL_CRITICAL_LOW 0x0006
#define THERMAL_LEVEL_UNDER_CRITICAL_LOW 0x0007


#define ETHERNET_ERROR_INACTIVE 0x0000
#define ETHERNET_ERROR_ACTIVE 0x0001



   class ISpmSubStateClient;
// service handler requests ---------------------------------------
class spm_tclLamAppManagerConfig;
class ISpmWorkerServer;
class spm_tclCsmIf;

class spm_tclSpmDBusServiceHandler : public spm_tclClientHandlerBase
{
private :
	ISpmSubStateClient *_poclSubStateHandler;
	spm_tclLamAppManagerConfig *_poclSpm_tclLamAppManagerConfig;
	ISpmWorkerServer *_poclWorkerServer;
	tBool _bServiceAvailable;
	tBool _bSPMDbusClientAvailable;
	tU8 _U8PNMGRP10SignalState;
protected:
	// ISpmBase interface functions
	virtual tVoid vHandleTraceMessage(const tUChar *puchData){ (void)puchData ;}
	virtual const tChar*getName() const { return( "spm_tclSpmDBusServiceHandler" ); }
	virtual tVoid vGetReferences();

	// virtual tVoid vStartCommunication(); parent method used

public:
	spm_tclSpmDBusServiceHandler(const ISpmFactory& factory);
	virtual ~spm_tclSpmDBusServiceHandler();
	virtual tVoid vOnFirstServiceStateAvailable( );

	virtual tVoid vRegisterFids();

	virtual tVoid vOnCurrentAudioState(amt_tclServiceData *poMessage);
	virtual tVoid vOnNanoMsgState(amt_tclServiceData *poMessage);
	virtual tVoid vOnVoltageLevelState(amt_tclServiceData *poMessage);
	virtual tVoid vOnCockpitmodeState(amt_tclServiceData *poMessage);
	virtual tVoid vOnThermalLevelState(amt_tclServiceData *poMessage);
	virtual tVoid vOnDoorUnlockState(amt_tclServiceData *poMessage);
	tS32 vPNMGRP10SignalstateUpdate(tU8 bPNMGRP10SignalState);

	DECLARE_MSG_MAP(spm_tclSpmDBusServiceHandler)

};

#endif // SPM_HEATCONTROLSERVICEHANDLER_H




