/*****************************************************************************
 * FILE:         spm_SpmDbusServiceHandler.cpp
 * PROJECT:      GEN3
 * SW-COMPONENT:
 ****----------------------------------------------------------------------------
 *
 * DESCRIPTION:  Evaluation of messages coming from the FC METER.
 *
 ****----------------------------------------------------------------------------
 * COPYRIGHT:    (c) 2012 Robert Bosch GmbH, Hildesheim
 * HISTORY:
 * Date      | Author            | Modification
 * 23.05.12  | CM-AI/VW32 kollai | Initial version for NISSAN LCN2 KAI
 *****************************************************************************/
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define LCMDBUSCLIENT_FI_S_IMPORT_INTERFACE_LCMDBUSCLIENT_MAINFI_STDVISITORS
#define LCMDBUSCLIENT_FI_S_IMPORT_INTERFACE_LCMDBUSCLIENT_MAINFI_FUNCTIONIDS
#include "lcmdbusclient_fi_if.h"

// SPM  configuration
#include "spm_Config.h"

// my class header
#include "spm_SpmDbusServiceHandler.h"
#include "spm_LamAppManagerConfig.h"

// spm class definitions
#include "spm_ICcaServiceServer.h"
#include "spm_ISubStateClient.h"
// interfaces class definitions

#include "spm_IFactory.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS SPM_TRACE_CLASS_SPM_PRJ
#include "trcGenProj/Header/spm_SpmDbusServiceHandler.cpp.trc.h"
#endif

// has to come after etg include because redefinition of macros takes place
// to meet special spm requirements of blocking early spm traces
#include "spm_trace.h"

/*
   --------------------------------------------------------------------------
   MSG MAP
   --------------------------------------------------------------------------
 */
BEGIN_MSG_MAP(spm_tclSpmDBusServiceHandler, spm_tclClientHandlerBase)
ON_MESSAGE(LCMDBUSCLIENT_MAINFI_C_U16_CURRENTSOURCE, vOnCurrentAudioState)
ON_MESSAGE(LCMDBUSCLIENT_MAINFI_C_U16_NANOMSGSTATUS, vOnNanoMsgState)
ON_MESSAGE(LCMDBUSCLIENT_MAINFI_C_U16_VOLTAGELEVELSTATUS, vOnVoltageLevelState)
ON_MESSAGE(LCMDBUSCLIENT_MAINFI_C_U16_COCKPITMODESTATUS, vOnCockpitmodeState)
ON_MESSAGE(LCMDBUSCLIENT_MAINFI_C_U16_THERMALLEVELSTATUS, vOnThermalLevelState)
ON_MESSAGE(LCMDBUSCLIENT_MAINFI_C_U16_DOORUNLOCKSTATUS, vOnDoorUnlockState)
END_MSG_MAP() 

spm_tclSpmDBusServiceHandler::spm_tclSpmDBusServiceHandler(const ISpmFactory& factory)
: spm_tclClientHandlerBase(factory,
        CCA_C_U16_APP_LCM_DBUS_CLIENT,
        CCA_C_U16_SRV_LCM_DBUS_CLIENT,
        SPM_SPMDBUSSRV_FI_MAJOR_VERSION,
        SPM_SPMDBUSSRV_FI_MINOR_VERSION)
{
	_poclSubStateHandler = NULL;
	_poclWorkerServer = NULL;
	_bSPMDbusClientAvailable = FALSE;
	_U8PNMGRP10SignalState = 1;

}

spm_tclSpmDBusServiceHandler::~spm_tclSpmDBusServiceHandler()
{
	_poclSubStateHandler = NULL;
	_poclWorkerServer = NULL;

}

tVoid spm_tclSpmDBusServiceHandler::vGetReferences()
{
	spm_tclClientHandlerBase::vGetReferences();
	_poclSubStateHandler = dynamic_cast < ISpmSubStateClient* >( _crfFactory.getSpmObjHandler("ISpmSubStateClient") );
	SPM_NULL_POINTER_CHECK(_poclSubStateHandler);
	SPM_GET_IF_REFERENCE_USE_VAR(_poclSpm_tclLamAppManagerConfig,spm_tclLamAppManagerConfig);
	SPM_GET_IF_REFERENCE_USE_VAR(_poclSpm_tclLamAppManagerConfig,spm_tclLamAppManagerConfig);
	SPM_GET_IF_REFERENCE_USE_VAR( _poclWorkerServer,ISpmWorkerServer );
	SPM_NULL_POINTER_CHECK(_poclWorkerServer);
}

tVoid spm_tclSpmDBusServiceHandler::vRegisterFids()
{
	vUpRegFid(LCMDBUSCLIENT_MAINFI_C_U16_CURRENTSOURCE);
	vUpRegFid(LCMDBUSCLIENT_MAINFI_C_U16_NANOMSGSTATUS);
	vUpRegFid(LCMDBUSCLIENT_MAINFI_C_U16_VOLTAGELEVELSTATUS);
	vUpRegFid(LCMDBUSCLIENT_MAINFI_C_U16_COCKPITMODESTATUS);
	vUpRegFid(LCMDBUSCLIENT_MAINFI_C_U16_THERMALLEVELSTATUS);
	vUpRegFid(LCMDBUSCLIENT_MAINFI_C_U16_DOORUNLOCKSTATUS);
}

tVoid spm_tclSpmDBusServiceHandler::vOnFirstServiceStateAvailable()
{
	_bServiceAvailable = TRUE ;
	_poclWorkerServer->bPostMessage("ISpmLamAppManager",SPM_U32_DBUSSERVICE_HANDLER_UP);
	if(!_bSPMDbusClientAvailable)
	{
		_bSPMDbusClientAvailable =TRUE;
		vPNMGRP10SignalstateUpdate(_U8PNMGRP10SignalState);
	}
	ETG_TRACE_USR1( ( "spm_tclSpmDBusServiceHandler::vOnFirstServiceStateAvailable" ) );
}

tVoid spm_tclSpmDBusServiceHandler::vOnCurrentAudioState(amt_tclServiceData *poMessage)
{
   fi_tclVisitorMessage oVisitorMsg( poMessage );
   lcmdbusclient_mainfi_tclMsgCurrentSourceStatus   oCurrentAudioSource;
   if (oVisitorMsg.s32GetData(oCurrentAudioSource, SPM_SPMDBUSSRV_FI_MAJOR_VERSION) != OSAL_ERROR)
   {
		ETG_TRACE_USR1( ( "spm_tclSpmDBusServiceHandler::vOnCurrentAudioState(): Received msg from LcmDbusClient with ID 'LCMDBUSCLIENT_MAINFI_C_U16_CURRENTSOURCE' -> %s!", oCurrentAudioSource.strSourceName.szValue ) );
   }
} // vOnCurrentAudioState

tVoid spm_tclSpmDBusServiceHandler::vOnNanoMsgState(amt_tclServiceData *poMessage)
{
	ETG_TRACE_FATAL( ( "spm_tclSpmDBusServiceHandler::vOnNanoMsgState(): Received msg from LcmDbusClient with ID 'LCMDBUSCLIENT_MAINFI_C_U16_NANOMSGSTATUS':") );	
	fi_tclVisitorMessage oVisitorMsg( poMessage );
	lcmdbusclient_mainfi_tclMsgNanomsgStatusStatus obNanomsgStatusStatus;
	if (oVisitorMsg.s32GetData(obNanomsgStatusStatus, SPM_SPMDBUSSRV_FI_MAJOR_VERSION) != OSAL_ERROR)
	{
		tBool bNanomsgStateval  = obNanomsgStatusStatus.Nanomsgconstate;
		ETG_TRACE_FATAL( ( "spm_tclSpmDBusServiceHandler::vOnNanoMsgState(): Received msg from LcmDbusClient with ID 'LCMDBUSCLIENT_MAINFI_C_U16_NANOMSGSTATUS'->%d",obNanomsgStatusStatus.Nanomsgconstate) );
		if(bNanomsgStateval == TRUE )
		{
			if (!_poclSubStateHandler->bIsTriggerSet(SPM_U32_SUBSTATE_DISPLAY_REQUEST))
			_poclSubStateHandler->vSetSubStateType(SPM_U32_SUBSTATE_DISPLAY_REQUEST,TRUE);
		}
		else if( bNanomsgStateval == FALSE )
		{
			if (_poclSubStateHandler->bIsTriggerSet(SPM_U32_SUBSTATE_DISPLAY_REQUEST))
			_poclSubStateHandler->vSetSubStateType(SPM_U32_SUBSTATE_DISPLAY_REQUEST,FALSE); 
		}
		else
		{
			ETG_TRACE_FATAL(( "spm_tclSpmDBusServiceHandler::vOnNanoMsgState: No handling DISPLAY_REQUEST trigger"));
		}
	}//vNanomsgSetSubstateUpdate
}
tVoid spm_tclSpmDBusServiceHandler::vOnVoltageLevelState(amt_tclServiceData *poMessage)
{
	ETG_TRACE_FATAL( ( "spm_tclSpmDBusServiceHandler::vOnVoltagelevelMsgState(): Received msg from LcmDbusClient with ID 'LCMDBUSCLIENT_MAINFI_C_U16_VOLTAGELEVELSTATUS':") );	
	fi_tclVisitorMessage oVisitorMsg( poMessage );
	lcmdbusclient_mainfi_tclMsgVoltagelevelStatusStatus   obVoltagelevelStatusStatus;
	if (oVisitorMsg.s32GetData(obVoltagelevelStatusStatus, SPM_SPMDBUSSRV_FI_MAJOR_VERSION) != OSAL_ERROR)
	{
		tBool bVoltagelevelStateval  = obVoltagelevelStatusStatus.Voltagelevelconstate;
		ETG_TRACE_FATAL(( "spm_tclSpmDBusServiceHandler::vOnVoltagelevelMsgState(): Received msg from LcmDbusClient with ID 'LCMDBUSCLIENT_MAINFI_C_U16_VOLTAGELEVELSTATUS'->%d",obVoltagelevelStatusStatus.Voltagelevelconstate));
		switch(bVoltagelevelStateval)
		{
			case VOLTAGE_LEVEL_UNDEFINED:
			{
				ETG_TRACE_FATAL(( "spm_tclSpmDBusServiceHandler::vOnVoltageLevelState: VOLTAGE_LEVEL_UNDEFINED"));
			}
			break;
			case VOLTAGE_LEVEL_NORMAL:
			{
				if (_poclSubStateHandler->bIsTriggerSet(SPM_U32_SUBSTATE_SAFE))
				{
					_poclSubStateHandler->vSetSubStateType(SPM_U32_SUBSTATE_SAFE,FALSE);
				}
				if (_poclSubStateHandler->bIsTriggerSet(SPM_U32_SUBSTATE_Q_CRITICAL))
				{
					_poclSubStateHandler->vSetSubStateType(SPM_U32_SUBSTATE_Q_CRITICAL,FALSE);
				}
			}
			break;
			case VOLTAGE_LEVEL_OVERCRITICAL:
			{
				if (!_poclSubStateHandler->bIsTriggerSet(SPM_U32_SUBSTATE_SAFE))
				{
					_poclSubStateHandler->vSetSubStateType(SPM_U32_SUBSTATE_SAFE,TRUE); 
				}
			}
			break;
			case VOLTAGE_LEVEL_OVERWARNING:
			{
				if (!_poclSubStateHandler->bIsTriggerSet(SPM_U32_SUBSTATE_SAFE))
				{
					_poclSubStateHandler->vSetSubStateType(SPM_U32_SUBSTATE_SAFE,TRUE);
				}
			}
			break;
			case VOLTAGE_LEVEL_UNDERWARNING:
			{
				if (!_poclSubStateHandler->bIsTriggerSet(SPM_U32_SUBSTATE_Q_CRITICAL))
				{
					_poclSubStateHandler->vSetSubStateType(SPM_U32_SUBSTATE_Q_CRITICAL,TRUE);
				}
				if (_poclSubStateHandler->bIsTriggerSet(SPM_U32_SUBSTATE_SAFE))
				{
					_poclSubStateHandler->vSetSubStateType(SPM_U32_SUBSTATE_SAFE,FALSE);
				}
				
			}
			break;
			case VOLTAGE_LEVEL_UNDERCRITICAL:
			{
				if (!_poclSubStateHandler->bIsTriggerSet(SPM_U32_SUBSTATE_SAFE))
				{
					_poclSubStateHandler->vSetSubStateType(SPM_U32_SUBSTATE_SAFE,TRUE);
				}
				if (_poclSubStateHandler->bIsTriggerSet(SPM_U32_SUBSTATE_Q_CRITICAL))
				{
					_poclSubStateHandler->vSetSubStateType(SPM_U32_SUBSTATE_Q_CRITICAL,FALSE);
				}
			}
			break;
			default:
			{
				ETG_TRACE_FATAL(( "spm_tclSpmDBusServiceHandler::vOnVoltageLevelState: No handling SAFE trigger"));
			}
			break;
		}
   }//vOnVolagelevelUpdate
}
tVoid spm_tclSpmDBusServiceHandler::vOnCockpitmodeState(amt_tclServiceData *poMessage)
{
	ETG_TRACE_FATAL( ( "spm_tclSpmDBusServiceHandler::vOnCockpitmodeState(): Received msg from LcmDbusClient with ID 'LCMDBUSCLIENT_MAINFI_C_U16_COCKPITMODESTATUS':") );	
	fi_tclVisitorMessage oVisitorMsg( poMessage );
	lcmdbusclient_mainfi_tclMsgCockpitmodeStatusStatus obCockpitmodeStatusStatus;
	if (oVisitorMsg.s32GetData(obCockpitmodeStatusStatus, SPM_SPMDBUSSRV_FI_MAJOR_VERSION) != OSAL_ERROR)
	{
		tBool bCockpitmodeStateval  = obCockpitmodeStatusStatus.Cockpitmodeconstate;
		ETG_TRACE_FATAL(( "spm_tclSpmDBusServiceHandler::vOnCockpitmodeState(): Received msg from LcmDbusClient with ID 'LCMDBUSCLIENT_MAINFI_C_U16_COCKPITMODESTATUS'->%d",obCockpitmodeStatusStatus.Cockpitmodeconstate));
		switch(bCockpitmodeStateval)
		{
			case ETHERNET_ERROR_ACTIVE:
			{
				if (!_poclSubStateHandler->bIsTriggerSet(SPM_U32_SUBSTATE_DARK_SCREEN_REQ))
				_poclSubStateHandler->vSetSubStateType(SPM_U32_SUBSTATE_DARK_SCREEN_REQ,TRUE);
			}
			break;
			case ETHERNET_ERROR_INACTIVE:
			{
				if(_poclSubStateHandler->bIsTriggerSet(SPM_U32_SUBSTATE_DARK_SCREEN_REQ))
				_poclSubStateHandler->vSetSubStateType(SPM_U32_SUBSTATE_DARK_SCREEN_REQ,FALSE); 
			}
			break;
			default:
			{
				ETG_TRACE_FATAL(( "spm_tclSpmDBusServiceHandler::vOnVoltageLevelState: No handling DARK_SCREEN_REQ trigger"));
			}
			break;
		}
   }//vOnCockpitmodelUpdate
}
tVoid spm_tclSpmDBusServiceHandler::vOnThermalLevelState(amt_tclServiceData *poMessage)
{
	ETG_TRACE_FATAL( ( "spm_tclSpmDBusServiceHandler::vOnThermallevelMsgState(): Received msg from LcmDbusClient with ID 'LCMDBUSCLIENT_MAINFI_C_U16_THERMALLEVELSTATUS':") );	
	fi_tclVisitorMessage oVisitorMsg( poMessage );
	lcmdbusclient_mainfi_tclMsgThermallevelStatusStatus   obThermallevelStatusStatus;
	if (oVisitorMsg.s32GetData(obThermallevelStatusStatus, SPM_SPMDBUSSRV_FI_MAJOR_VERSION) != OSAL_ERROR)
	{
		tBool bThermallevelStateval  = obThermallevelStatusStatus.Thermallevelconstate;
		ETG_TRACE_FATAL(( "spm_tclSpmDBusServiceHandler::vOnThermallevelMsgState(): Received msg from LcmDbusClient with ID 'LCMDBUSCLIENT_MAINFI_C_U16_THERMALLEVELSTATUS'->%d",obThermallevelStatusStatus.Thermallevelconstate));
		switch(bThermallevelStateval)
		{
			case THERMAL_LEVEL_UNDEFINED:
			{
				ETG_TRACE_FATAL(( "spm_tclSpmDBusServiceHandler::vOnThermalLevelState: THERMAL_LEVEL_UNDEFINED"));
			}
			break;
			case THERMAL_LEVEL_NORMAL:
			{
				if (_poclSubStateHandler->bIsTriggerSet(SPM_U32_SUBSTATE_SAFE))
				{
					_poclSubStateHandler->vSetSubStateType(SPM_U32_SUBSTATE_SAFE,FALSE);
				}
			}
			break;
			case THERMAL_LEVEL_OVER_CRITICAL:
			{
				if (!_poclSubStateHandler->bIsTriggerSet(SPM_U32_SUBSTATE_SAFE))
				{
					_poclSubStateHandler->vSetSubStateType(SPM_U32_SUBSTATE_SAFE,TRUE);
				}
			}
			break;
			case THERMAL_LEVEL_CRITICAL_HIGH:
			{
				/*
				if (_poclSubStateHandler->bIsTriggerSet(SPM_U32_SUBSTATE_SAFE))
				{
					_poclSubStateHandler->vSetSubStateType(SPM_U32_SUBSTATE_SAFE,FALSE);
				}
				*/
			}
			break;
			case THERMAL_LEVEL_HIGH:
			{
				if (_poclSubStateHandler->bIsTriggerSet(SPM_U32_SUBSTATE_SAFE))
				{
					_poclSubStateHandler->vSetSubStateType(SPM_U32_SUBSTATE_SAFE,FALSE);
				}
			}
			break;
			case THERMAL_LEVEL_CRITICAL_LOW:
			{
				/*
				if (_poclSubStateHandler->bIsTriggerSet(SPM_U32_SUBSTATE_SAFE))
				{
					_poclSubStateHandler->vSetSubStateType(SPM_U32_SUBSTATE_SAFE,FALSE);
				}
				*/
			}
			break;
			case THERMAL_LEVEL_UNDER_CRITICAL_LOW:
			{
				if (!_poclSubStateHandler->bIsTriggerSet(SPM_U32_SUBSTATE_SAFE))
				{
					_poclSubStateHandler->vSetSubStateType(SPM_U32_SUBSTATE_SAFE,TRUE);
				}
			}
			break;
			case THERMAL_LEVEL_LOW:
			{
				if (_poclSubStateHandler->bIsTriggerSet(SPM_U32_SUBSTATE_SAFE))
				{
					_poclSubStateHandler->vSetSubStateType(SPM_U32_SUBSTATE_SAFE,FALSE);
				}
			}
			break;
			default:
			{
				ETG_TRACE_FATAL(( "spm_tclSpmDBusServiceHandler::vOnThermalLevelState: No handling SAFE trigger"));
			}
			break;
		}
   }//vOnThermallevelUpdate
}
tVoid spm_tclSpmDBusServiceHandler::vOnDoorUnlockState(amt_tclServiceData *poMessage)
{
	ETG_TRACE_FATAL( ( "spm_tclSpmDBusServiceHandler::vOnDoorUnlockState(): Received msg from LcmDbusClient with ID 'LCMDBUSCLIENT_MAINFI_C_U16_DOORUNLOCKSTATUS':") );	
	fi_tclVisitorMessage oVisitorMsg( poMessage );
	lcmdbusclient_mainfi_tclMsgDoorUnlockStatusStatus obDoorUnlockStatusStatus;
	if (oVisitorMsg.s32GetData(obDoorUnlockStatusStatus, SPM_SPMDBUSSRV_FI_MAJOR_VERSION) != OSAL_ERROR)
	{
		tBool bDoorUnlockStateval  = obDoorUnlockStatusStatus.DoorUnlockconstate;
		ETG_TRACE_FATAL( ( "spm_tclSpmDBusServiceHandler::vOnDoorUnlockState(): Received msg from LcmDbusClient with ID 'LCMDBUSCLIENT_MAINFI_C_U16_DOORUNLOCKSTATUS'->%d",obDoorUnlockStatusStatus.DoorUnlockconstate) );
		if(bDoorUnlockStateval == TRUE )
		{
			if (!_poclSubStateHandler->bIsTriggerSet(SPM_U32_SUBSTATE_DOORLOCK))
			_poclSubStateHandler->vSetSubStateType(SPM_U32_SUBSTATE_DOORLOCK,TRUE);
		}
		else if( bDoorUnlockStateval == FALSE )
		{
			if (_poclSubStateHandler->bIsTriggerSet(SPM_U32_SUBSTATE_DOORLOCK))
			_poclSubStateHandler->vSetSubStateType(SPM_U32_SUBSTATE_DOORLOCK,FALSE); 
		}
		else
		{
			ETG_TRACE_FATAL(( "spm_tclSpmDBusServiceHandler::vOnDoorUnlockState: No handling DOORLOCK trigger"));
		}
	}//vDoorUnlockSetSubstateUpdate
}
tS32 spm_tclSpmDBusServiceHandler::vPNMGRP10SignalstateUpdate(tU8 bPNMGRP10SignalState) 
{
	tBool retval = TRUE;
	ETG_TRACE_USR1( ( "spm_tclSpmDBusServiceHandler::vPNMGRP10SignalstateUpdate bPNMGRP10SignalState=%d",bPNMGRP10SignalState) );
	SPM_NULL_POINTER_CHECK_VAL(_poclCcaMsgHandler);
	if( _bServiceAvailable == TRUE ) 
	{ 
		lcmdbusclient_mainfi_tclMsgPNMGRP10SignalStatusSet  onPNMGRP10Signalstate;
		onPNMGRP10Signalstate.PNMGRP10Signalstate = bPNMGRP10SignalState;
		fi_tclVisitorMessage oVisitorMsg(onPNMGRP10Signalstate,SPM_SPMDBUSSRV_FI_MAJOR_VERSION);
		oVisitorMsg.vInitServiceData( CCA_C_U16_APP_SPM,
                                _u16AppId,
                                AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,
                                0,
                                _u16RegID,
                                0,
                                _u16SrvId,
                                LCMDBUSCLIENT_MAINFI_C_U16_PNMGRP10SIGNALSTATUS,
                                AMT_C_U8_CCAMSG_OPCODE_SET);
		retval = _poclCcaMsgHandler->bPostMessage(&oVisitorMsg);
		if(retval == FALSE)
		{
			ETG_TRACE_USR1( ( "spm_tclSpmDBusServiceHandler::vPNMGRP10SignalstateUpdate property set failed ") );
		}
	}
	else
	{
		_bSPMDbusClientAvailable = FALSE;
		_U8PNMGRP10SignalState = bPNMGRP10SignalState;
		ETG_TRACE_USR1( ( "spm_tclSpmDBusServiceHandler::vPNMGRP10SignalstateUpdate() _bServiceAvailable = %d ",_bServiceAvailable) );
	}
}//vPNMGRP10SignalstateUpdate

// EOF




