/*****************************************************************************
 * FILE:         spm_AnimationServiceHandler.h
 * PROJECT:      NISSAN LCN2KAI
 * SW-COMPONENT:
 *****----------------------------------------------------------------------------
 *
 * DESCRIPTION:
 *
 *****----------------------------------------------------------------------------
 * COPYRIGHT:    (c) 2012 Robert Bosch GmbH, Hildesheim
 * HISTORY:
 * Date      | Author            | Modification
 * 23.05.12  | CM-AI/VW32 kollai | Initial version for NISSAN LCN2 KAI
 *
 *****************************************************************************/
#ifndef SPM_ANIMATIONSERVICEHANDLER_H
   #define SPM_ANIMATIONSERVICEHANDLER_H

#ifndef _SPM_CONFIG_H
#error spm_config.h must be included!
#endif

#include "spm_ClientHandlerBase.h"

/******************************************************************************
  | local #define (scope: module-local)
  |-----------------------------------------------------------------------*/

   #define SPM_U8_START_NO_ANIMATION      (tU8)0xff
   #define SPM_U8_ANIMATION_INTERVAL      120000 // in ms


   class ISpmStartupInvestigationServer;
   class ISpmSubStateClient;

// service handler requests ---------------------------------------

   class spm_tclAnimationServiceHandler : public spm_tclClientHandlerBase
   {
private:
   tBool                           _bStartUpAnimationTriggered;
   tBool                           _bStartUpAnimationSent;
   tU8                             _u8AnimationType;
   tU32                            _u32LastAnimationTrigger;
   tBool                           _bAnimationAlreadyTriggered;

   ISpmStartupInvestigationServer  *_poclStartupInvest;
   ISpmSubStateClient              *_poclSubStateHandler;

protected:
   // ISpmBase interface functions
   virtual tVoid vHandleTraceMessage(const tUChar *puchData){} // lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used
   virtual const tChar*getName() const { return( "spm_tclAnimationServiceHandler" ); }
   virtual tVoid vGetReferences();

   virtual tVoid vStartCommunication();

public:
   spm_tclAnimationServiceHandler(const ISpmFactory& factory);
   virtual ~spm_tclAnimationServiceHandler();

   virtual tVoid vRegisterFids();

   tVoid vStartAnimation(tU8   u8StartType,
                         tBool bForce = FALSE);

   tVoid vOnAnimationStatus(amt_tclServiceData *poMessage);

   tVoid vRestartInterval(){ _u32LastAnimationTrigger = OSAL_ClockGetElapsedTime(); }

public:
   DECLARE_MSG_MAP(spm_tclAnimationServiceHandler)
   };

#endif // SPM_STARTUPANIMATIONSERVICEHANDLER_H

