/*****************************************************************************
 * FILE:         spm_AnimationServiceHandler.cpp
 * PROJECT:      NISSAN LCN2KAI
 * SW-COMPONENT:
 *****----------------------------------------------------------------------------
 *
 * DESCRIPTION:  Evaluation of messages coming from the FC STARTUP ANIMATION.
 *
 *****----------------------------------------------------------------------------
 * COPYRIGHT:    (c) 2012 Robert Bosch GmbH, Hildesheim
 * HISTORY:
 * Date      | Author            | Modification
 * 23.05.12  | CM-AI/VW32 kollai | Initial version for NISSAN LCN2 KAI
 *****************************************************************************/
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define SYNCDISPLAY_FI_S_IMPORT_INTERFACE_SYNCDISPLAY_MAINFI_STDVISITORS
#define SYNCDISPLAY_FI_S_IMPORT_INTERFACE_SYNCDISPLAY_MAINFI_FUNCTIONIDS
#include "syncdisplay_fi_if.h"

// SPM  configuration
#include "spm_Config.h"

// my class header
#include "spm_AnimationServiceHandler.h"

// spm class definitions

// interfaces class definitions
#include "spm_IStartupInvestigationServer.h"
#include "spm_ICcaServiceServer.h"
#include "spm_ISubStateClient.h"

#include "spm_IFactory.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS SPM_TRACE_CLASS_SPM_PRJ
#include "trcGenProj/Header/spm_AnimationServiceHandler.cpp.trc.h"
#endif

// has to come after etg include because redefinition of macros takes place
// to meet special spm requirements of blocking early spm traces
#include "spm_trace.h"

/******************************************************************************
  | local #define (scope: module-local)
  |-----------------------------------------------------------------------*/
#define SPM_FEATURE_ENABLE_ANIMATION_ONCE    1
   #define ANIMATION_FI_MAJOR_VERSION 1
   #define ANIMATION_FI_MINOR_VERSION 0
/*
   --------------------------------------------------------------------------
   MSG MAP
   --------------------------------------------------------------------------
  */
BEGIN_MSG_MAP(spm_tclAnimationServiceHandler, spm_tclClientHandlerBase)
ON_MESSAGE(SYNCDISPLAY_MAINFI_C_U16_EARLYVIDEOLAYERSTATUS, vOnAnimationStatus)
END_MSG_MAP() spm_tclAnimationServiceHandler::spm_tclAnimationServiceHandler(const ISpmFactory& factory)
   : spm_tclClientHandlerBase(factory,
                              CCA_C_U16_APP_DRVASS_VIDEO,
                              CCA_C_U16_SRV_SYNC_DISPLAY,
                              ANIMATION_FI_MAJOR_VERSION,
                              ANIMATION_FI_MINOR_VERSION){
   _poclStartupInvest          = NULL;
   _poclSubStateHandler        = NULL;

   _bStartUpAnimationSent      = FALSE;
   _bStartUpAnimationTriggered = FALSE;
   _u8AnimationType            = 0;
   _u32LastAnimationTrigger    = 0xffffffff;
   _bAnimationAlreadyTriggered = FALSE;
}

spm_tclAnimationServiceHandler::~spm_tclAnimationServiceHandler(){
   _poclStartupInvest       = NULL;
   _poclSubStateHandler     = NULL;
}

tVoid spm_tclAnimationServiceHandler::vStartCommunication(){
   spm_tclClientHandlerBase::vStartCommunication();
}

tVoid spm_tclAnimationServiceHandler::vGetReferences(){
   spm_tclClientHandlerBase::vGetReferences();

   // get all needed references now -> all SPM objects are now available
   _poclStartupInvest   = dynamic_cast < ISpmStartupInvestigationServer* >( _crfFactory.getSpmObjHandler("spm_tclStartupInvestigation") );
   _poclSubStateHandler = dynamic_cast < ISpmSubStateClient* >( _crfFactory.getSpmObjHandler("ISpmSubStateClient") );

   SPM_NULL_POINTER_CHECK(_poclStartupInvest);
   SPM_NULL_POINTER_CHECK(_poclSubStateHandler);
}

tVoid spm_tclAnimationServiceHandler::vRegisterFids(){
   vUpRegFid(SYNCDISPLAY_MAINFI_C_U16_EARLYVIDEOLAYERSTATUS);
   if (_bStartUpAnimationTriggered){
      vStartAnimation(_u8AnimationType);
   }
}

tVoid spm_tclAnimationServiceHandler::vStartAnimation(tU8   u8StartType,
                                                      tBool bForce){

   tU32 u32CurTime = OSAL_ClockGetElapsedTime();

   _bStartUpAnimationTriggered = TRUE;
   _u8AnimationType            = u8StartType;

   if (bForce) {
       //trigger animation in anycase
       _bAnimationAlreadyTriggered = FALSE;
   }

   SPM_NULL_POINTER_CHECK(_poclCcaMsgHandler);

   #ifdef SPM_FEATURE_ENABLE_ANIMATION_ONCE
      if (!_bAnimationAlreadyTriggered){
   #endif
            ETG_TRACE_USR1( ( "spm_tclAnimationServiceHandler::vStartAnimation(): Start animation called (Last trigger: %d, current time: %d)!", _u32LastAnimationTrigger, u32CurTime ) );
   if ( _u8SrvState == AMT_C_U8_SVCSTATE_AVAILABLE){
      // connected to Animation service
      if ( ( bForce ) || ( u32CurTime > ( _u32LastAnimationTrigger + SPM_U8_ANIMATION_INTERVAL ) ) || ( _u32LastAnimationTrigger == 0xffffffff ) ){
         // send message only if animation should be triggered (no animation after reset)
         if (SPM_U8_START_NO_ANIMATION != _u8AnimationType){
            // msg to FC ANIMATION
            syncdisplay_mainfi_tclMsgSetAnimationRunMethodStart oAnimation;
            oAnimation.T_tU8_PlayRun = u8StartType;
            fi_tclVisitorMessage                              oAnimationMsg(oAnimation);

            ETG_TRACE_USR1( ( "spm_tclAnimationServiceHandler::vStartAnimation: Send trigger to FC Animation to show Animation (Nb: %d)!!!!!!!", _u8AnimationType ) );
            oAnimationMsg.vInitServiceData( CCA_C_U16_APP_SPM,
                                            _u16AppId,
                                            AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,
                                            0,
                                            _u16RegID,
                                            0,
                                            _u16SrvId,
                                            SYNCDISPLAY_MAINFI_C_U16_SETANIMATIONRUN,
                                            AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

            (tVoid)_poclCcaMsgHandler->bPostMessage(&oAnimationMsg);

            _bStartUpAnimationTriggered = FALSE;
            _u32LastAnimationTrigger    = u32CurTime;
            _bAnimationAlreadyTriggered = TRUE;

            {
               SPM_NULL_POINTER_CHECK(_poclStartupInvest);

               spm_tclStartupItem item;
               item._context = "MISC   ";
               item._name    = "Send trigger to show Animation.";
               _poclStartupInvest->vAddStartupItem(item);
            }

         }
      }
   }
   #ifdef SPM_FEATURE_ENABLE_ANIMATION_ONCE
} else {
   ETG_TRACE_USR1( ( "spm_tclAnimationServiceHandler::vStartAnimation(): Animation trigger ignored! Already send once (SPM_FEATURE_ENABLE_ANIMATION_ONCE)" ) );
}
   #endif
}

tVoid spm_tclAnimationServiceHandler::vOnAnimationStatus(amt_tclServiceData *poMessage){
   fi_tclVisitorMessage                                   oVisitorMsg( poMessage );
   syncdisplay_mainfi_tclMsgEarlyVideoLayerStatusStatus   oAnimationStatus;

   SPM_NULL_POINTER_CHECK(_poclSubStateHandler);

   if (oVisitorMsg.s32GetData(oAnimationStatus, ANIMATION_FI_MAJOR_VERSION) != OSAL_ERROR){
      ETG_TRACE_USR1( ( "spm_tclAnimationServiceHandler::vOnAnimationStatus(): Received msg from DisplayVideoController with ID 'SYNCDISPLAY_MAINFI_C_U16_EARLYVIDEOLAYERSTATUS' -> %d!", (tU32)oAnimationStatus.eEarlyVideoLayerStatus.enType ) );
      if (oAnimationStatus.eEarlyVideoLayerStatus.enType == syncdisplay_fi_tcl_e8_EarlyVideoLayer_Status::FI_EN_VIDEOLAYER_ANIMATION){
         _poclSubStateHandler->vSetSubStateType(SPM_U32_SUBSTATE_ANIMATION, TRUE);
      } else {
          if (_poclSubStateHandler->bIsTriggerSet(SPM_U32_SUBSTATE_ANIMATION)) _poclSubStateHandler->vSetSubStateType(SPM_U32_SUBSTATE_ANIMATION, FALSE);
      }
   }
} // vOnPowerState

// EOF

