/************************************************************************
  * FILE:         ICcaDiaglogProxy.h
  * PROJECT:      NextGen
  * SW-COMPONENT: fc_spm
  * ----------------------------------------------------------------------
  *
  * DESCRIPTION: Interface definition for the Linux specific calls
  *
  * ----------------------------------------------------------------------
  * COPYRIGHT:    (c) 2015 Robert Bosch GmbH, Hildesheim
  * HISTORY:
  * Date        | Author                           | Modification
  * 13.01.2015  | PJ-VW32 Klaus-Peter Kollai       | initial version
  *
  *************************************************************************/

#pragma once

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define SPM_S_IMPORT_INTERFACE_GENERIC
#include "spm_if.h"

#define VD_DIAGLOG_S_IMPORT_INTERFACE_MSG
#include "vd_diaglog_if.h"

#include "spm_ClientHandlerBase.h"

#define SPM_U8_CCAPROXY_DIAGLOG_PASSED          (tU8)0
#define SPM_U8_CCAPROXY_DIAGLOG_FAILED          (tU8)1
#define SPM_U8_CCAPROXY_DIAGLOG_NORESULT        (tU8)2
#define SPM_U8_CCAPROXY_DIAGLOG_DIAG_PASSED     (tU8)3
#define SPM_U8_CCAPROXY_DIAGLOG_DIAG_FAILED     (tU8)4
#define SPM_U8_CCAPROXY_DIAGLOG_DIAG_NORESULT   (tU8)5
#define SPM_U8_CCAPROXY_DIAGLOG_DISABLED        (tU8)6
#define SPM_U8_CCAPROXY_DIAGLOG_ENABLED         (tU8)7

#ifndef VDL_ITC_SPM_UNDER_VOLTAGE
   #define VDL_ITC_SPM_UNDER_VOLTAGE                  ITC_SPM_VOLTAGE_BELOW_THRESHOLD
   #define VDL_ITC_SPM_HIGH_VOLTAGE                   ITC_SPM_VOLTAGE_ABOVE_THRESHOLD
   #define VDL_ITC_SPM_CRITICAL_UNDER_VOLTAGE         ITC_SPM_VOLTAGE_CRITICAL_BELOW_THRESHOLD
   #define VDL_ITC_SPM_CRITICAL_HIGH_VOLTAGE          ITC_SPM_VOLTAGE_CRITICAL_ABOVE_THRESHOLD
#endif

#define DIAGLOG_FI_MAJOR_VERSION 1
#define DIAGLOG_FI_MINOR_VERSION 0

// //////////////////////////////////////////////////////////////////////////////
// Base class for all SPM Classes
class ICcaDiaglogProxy : public spm_tclClientHandlerBase
{
public:
ICcaDiaglogProxy( const ISpmFactory& factory ) : spm_tclClientHandlerBase( factory,
                                                                              CCA_C_U16_APP_DIAGLOG,
                                                                              CCA_C_U16_SRV_DIAGLOG,
                                                                              DIAGLOG_FI_MAJOR_VERSION,
                                                                              DIAGLOG_FI_MINOR_VERSION ){}
virtual ~ICcaDiaglogProxy( ){}

virtual const tChar*getInterfaceName( ) const { return( "ICcaDiaglogProxy" ); }
virtual tVoid vAddItc( tU16 itc,
                       tU8  u8Result = SPM_U8_CCAPROXY_DIAGLOG_PASSED ) = 0;

virtual tVoid vSetItcError( tU16 u16ItcType,
                            tU8  u8Result )                             = 0;

};

