/*****************************************************************************
 * FILE:         spm_LamAppManagerConfig.h
 * PROJECT:      NextGen
 * SW-COMPONENT: FC SPM
 * ----------------------------------------------------------------------------
 *
 * DESCRIPTION:
 *
 * ----------------------------------------------------------------------------
 * COPYRIGHT:    (c) 2011 Robert Bosch GmbH, Hildesheim
 * HISTORY:
 * Date      | Author            | Modification
 * 07.09.11  | TMS Fischer       | initial version
 *
 *****************************************************************************/
#ifndef __SPM_LAMAPPMANAGERCONFIG_H
   #define __SPM_LAMAPPMANAGERCONFIG_H

// FI-zone starts
   #define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_STDVISITORS
   #define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_FUNCTIONIDS
#include "spm_fi_if.h"

#ifndef _SPM_CONFIG_H
    #error spm_config.h must be included!
#endif
#include "spm_SubStateDefines.h"

#include "spm_ILamAppManager.h"

#define SPM_U32_DBUSSERVICE_HANDLER_UP						    (tU32)0x00090004

   class ISpmSubStateClient;
   class ISpmCcaServiceServer;
//class ISpmSecurity;

//class spm_tclApplicationConfigurationConfig;

/*!
  *  \class spm_tclLamAppManagerConfig
  *  \brief This project specific class updates HMI states and process system states. It also trigger new application states.

        The ISpmFactory object creates an instance of this class. Class spm_tclGlobalApplicationManager uses this class to process
        all DIM and HMI substates.
  */
   class spm_tclLamAppManagerConfig : public ISpmLamAppManager
   {
public:
   spm_tclLamAppManagerConfig(const ISpmFactory& factory);

private:
   ISpmWorkerServer                      *_poclWorkerServer;
   ISpmSubStateClient                    *_poclSubStateHandler;
   ISpmCcaServiceServer                  *_poclCcaServiceHandler;

   virtual tVoid vUpdateHmiState(spm_corefi_tclMsgHmiStateStatus *pStateToSend);
   virtual tVoid vUpdateDimState();
   tBool                                 _bSwitchedOffByCriticalLow;
   tBool                                 _bSwitchedOffByHigh;
public:
   virtual ~spm_tclLamAppManagerConfig();
  
   virtual tVoid vNewSubState(TTriggerMsg *tNewTrigger);

   virtual tVoid vProcessSystemState(tU32 u32NewSystemState,
                                     tU32 u32SystemStateReached);

   virtual tVoid vAppStateAcknowledge(tU32 u32AppId,
                                      tU32 u32AppState){} //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used

   virtual tVoid vNewAppStateReached();

   virtual tVoid vAllSubStatesProcessed();

   virtual tVoid vTraceRemainingTime();
protected:
   // ISpmBase interface functions
   virtual tVoid vHandleTraceMessage(const tUChar *puchData){} //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used
   virtual const tChar*getName() const { return( "spm_tclLamAppManagerConfig" ); }
   virtual tVoid vGetReferences();

   virtual tVoid vStartCommunication();

   // Implementation of interface ISpmWorkerClient
   virtual tVoid vHandleMessage(tU32 u32Message,
                                tU32 u32Parm = 0);
   virtual tBool bHandleSynchrounousCall(tU32   u32Message,
                                         tVoid *args){
      return( FALSE );
   }  //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used

   };


#endif // __SPM_LAMAPPMANAGERCONFIG_H

