/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_ApplicationConfigurationConfig.h
  * @brief        This is header file contains functions for reading application information.
  * @copyright    (C) 2012 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

#include "spm_ApplicationConfiguration.h"

/*!
  *  \class spm_tclApplicationConfigurationConfig
  *  \brief This generic class reads application information.

        The spm_tclFactory object creates an instance of this class. Class spm_tclLocalApplicationManager uses this class to print
        application information.
  */
class spm_tclApplicationConfigurationConfig : public spm_tclApplicationConfiguration
{

public:
spm_tclApplicationConfigurationConfig( const ISpmFactory& factory );
virtual ~spm_tclApplicationConfigurationConfig( );

virtual tVoid vPrintAppInfo( tU32 u32AppId );

virtual const tChar*getName( ) const { return( "spm_tclApplicationConfigurationConfig" ); }
};

