
/*****************************************************************************
 * @file:        spm_ApplicationConfigurationConfig.cpp
 * PROJECT:      NextGen
 * SW-COMPONENT: FC SPM
 * ----------------------------------------------------------------------------
 *
 * @brief:  Project specific generation of system states and default
 *          application states. This list is generated.
 *
 * ----------------------------------------------------------------------------
 * @copyright   (C) 2017-2020 Robert Bosch GmbH.
 *              The reproduction, distribution and utilization of this file as
 *              well as the communication of its contents to others without express
 *              authorization is prohibited. Offenders will be held liable for the
 *              payment of damages. All rights reserved in the event of the grant
 *              of a patent, utility model or design.
 *****************************************************************************/

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_STDVISITORS
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_FUNCTIONIDS
#include "spm_fi_if.h"

#include "IDbusProxy.h"

#include "spm_Config.h"
#include "spm_GlobDefs.h"
#include "spm_ApplicationConfigurationConfig.h"
#include "spm_IFactory.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS SPM_TRACE_CLASS_SPM_LAM_PRJ
   #include "trcGenProj/Header/spm_ApplicationConfigurationConfig.cpp.trc.h"
#endif
// has to come after etg include because redefinition of macros takes place
// to meet special spm requirements of blocking early spm traces
#include "spm_trace.h"


/*****************************************************************************
 * local #define (scope: module-local)
 *****************************************************************************/


spm_tclApplicationConfigurationConfig::spm_tclApplicationConfigurationConfig(const ISpmFactory& factory)
   : spm_tclApplicationConfiguration(factory){
   // set the default configuration for this system

    _tDefaultConf[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_BACKGROUND] = AMT_C_U32_STATE_NORMAL;
    _tDefaultConf[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_PREPARE_SHUTDOWN] = AMT_C_U32_STATE_OFF;
    _tDefaultConf[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_SHUTDOWN] = AMT_C_U32_STATE_OFF;
    _tDefaultConf[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_SUSPEND] = AMT_C_U32_STATE_OFF;
    _tDefaultConf[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_STANDBY] = AMT_C_U32_STATE_NORMAL;
    _tDefaultConf[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_OFF] = AMT_C_U32_STATE_OFF;
    _tDefaultConf[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_DOWNLOAD] = AMT_C_U32_STATE_OFF;
    _tDefaultConf[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_ON] = AMT_C_U32_STATE_NORMAL;
    _tDefaultConf[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_DOOR_OPEN] = AMT_C_U32_STATE_NORMAL;
    _tDefaultConf[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_IGNITION] = AMT_C_U32_STATE_NORMAL;
    _tDefaultConf[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_DIAGNOSIS] = AMT_C_U32_STATE_NORMAL;
    _tDefaultConf[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_STATE_PROFILE] = AMT_C_U32_STATE_NORMAL;
    _tDefaultConf[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1] = AMT_C_U32_STATE_NORMAL;
    _tDefaultConf[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_2] = AMT_C_U32_STATE_OFF;
    _tDefaultConf[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_STANDBY] = AMT_C_U32_STATE_NORMAL;
    _tDefaultConf[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_ON] = AMT_C_U32_STATE_NORMAL;
    _tDefaultConf[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_STANDBY_RESTRICTED] = AMT_C_U32_STATE_OFF;
    _tDefaultConf[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_ON_DIAG] = AMT_C_U32_STATE_NORMAL;
    _tDefaultConf[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_ON_TEL] = AMT_C_U32_STATE_NORMAL;
    _tDefaultConf[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_ON_SWDL] = AMT_C_U32_STATE_OFF;
    _tDefaultConf[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_STANDBY_CUSTOMER_SWDL] = AMT_C_U32_STATE_OFF;
    _tDefaultConf[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_STANDBY_PWR_SAVE] = AMT_C_U32_STATE_OFF;
    _tDefaultConf[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_OVERTEMP] = AMT_C_U32_STATE_OFF;
    _tDefaultConf[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_SAFE] = AMT_C_U32_STATE_NORMAL;

    _tDefaultConfLcm[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_BACKGROUND] = SPM_U32_LCM_SHUTDOWNTYPE_RUNUP;
    _tDefaultConfLcm[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_PREPARE_SHUTDOWN] = SPM_U32_LCM_SHUTDOWNTYPE_NORMAL;
    _tDefaultConfLcm[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_SHUTDOWN] = SPM_U32_LCM_SHUTDOWNTYPE_NORMAL;
    _tDefaultConfLcm[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_SUSPEND] = SPM_U32_LCM_SHUTDOWNTYPE_NORMAL;
    _tDefaultConfLcm[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_STANDBY] = SPM_U32_LCM_SHUTDOWNTYPE_RUNUP;
    _tDefaultConfLcm[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_OFF] = SPM_U32_LCM_SHUTDOWNTYPE_NORMAL;
    _tDefaultConfLcm[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_DOWNLOAD] = SPM_U32_LCM_SHUTDOWNTYPE_RUNUP;
    _tDefaultConfLcm[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_ON] = SPM_U32_LCM_SHUTDOWNTYPE_RUNUP;
    _tDefaultConfLcm[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_DOOR_OPEN] = SPM_U32_LCM_SHUTDOWNTYPE_RUNUP;
    _tDefaultConfLcm[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_IGNITION] = SPM_U32_LCM_SHUTDOWNTYPE_RUNUP;
    _tDefaultConfLcm[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_DIAGNOSIS] = SPM_U32_LCM_SHUTDOWNTYPE_RUNUP;
    _tDefaultConfLcm[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_STATE_PROFILE] = SPM_U32_LCM_SHUTDOWNTYPE_RUNUP;
    _tDefaultConfLcm[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1] = SPM_U32_LCM_SHUTDOWNTYPE_RUNUP;
    _tDefaultConfLcm[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_2] = SPM_U32_LCM_SHUTDOWNTYPE_RUNUP;
    _tDefaultConfLcm[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_STANDBY] = SPM_U32_LCM_SHUTDOWNTYPE_RUNUP;
    _tDefaultConfLcm[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_ON] = SPM_U32_LCM_SHUTDOWNTYPE_RUNUP;
    _tDefaultConfLcm[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_STANDBY_RESTRICTED] = SPM_U32_LCM_SHUTDOWNTYPE_RUNUP;
    _tDefaultConfLcm[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_ON_DIAG] = SPM_U32_LCM_SHUTDOWNTYPE_RUNUP;
    _tDefaultConfLcm[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_ON_TEL] = SPM_U32_LCM_SHUTDOWNTYPE_RUNUP;
    _tDefaultConfLcm[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_ON_SWDL] = SPM_U32_LCM_SHUTDOWNTYPE_RUNUP;
    _tDefaultConfLcm[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_STANDBY_CUSTOMER_SWDL] = SPM_U32_LCM_SHUTDOWNTYPE_RUNUP;
    _tDefaultConfLcm[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_STANDBY_PWR_SAVE] = SPM_U32_LCM_SHUTDOWNTYPE_RUNUP;
    _tDefaultConfLcm[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_OVERTEMP] = SPM_U32_LCM_SHUTDOWNTYPE_RUNUP;
    _tDefaultConfLcm[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_SAFE] = SPM_U32_LCM_SHUTDOWNTYPE_RUNUP;

   _mapAppStateNames["NORMAL"]                  = AMT_C_U32_STATE_NORMAL;
   _mapAppStateNames["OFF"]                     = AMT_C_U32_STATE_OFF;
   _mapAppStateNames["DIAGNOSIS"]               = AMT_C_U32_STATE_DIAGNOSIS;
   _mapAppStateNames["PAUSE"]                   = AMT_C_U32_STATE_PAUSE;
   _mapAppStateNames["NOT"]                  = SPM_U32_LCM_SHUTDOWNTYPE_NOT;
   _mapAppStateNames["NORMAL"]               = SPM_U32_LCM_SHUTDOWNTYPE_NORMAL;
   _mapAppStateNames["FAST"]                 = SPM_U32_LCM_SHUTDOWNTYPE_FAST;
   _mapAppStateNames["RUNUP"]                = SPM_U32_LCM_SHUTDOWNTYPE_RUNUP;

   _mapSystemStateNames["BACKGROUND"]   = spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_BACKGROUND;
   _mapSystemStateNames["PREPARE_SHUTDOWN"]   = spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_PREPARE_SHUTDOWN;
   _mapSystemStateNames["SHUTDOWN"]   = spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_SHUTDOWN;
   _mapSystemStateNames["SUSPEND"]   = spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_SUSPEND;
   _mapSystemStateNames["STANDBY"]   = spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_STANDBY;
   _mapSystemStateNames["OFF"]   = spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_OFF;
   _mapSystemStateNames["DOWNLOAD"]   = spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_DOWNLOAD;
   _mapSystemStateNames["ON"]   = spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_ON;
   _mapSystemStateNames["DOOR_OPEN"]   = spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_DOOR_OPEN;
   _mapSystemStateNames["IGNITION"]   = spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_IGNITION;
   _mapSystemStateNames["DIAGNOSIS"]   = spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_DIAGNOSIS;
   _mapSystemStateNames["STATE_PROFILE"]   = spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_STATE_PROFILE;
   _mapSystemStateNames["MMI_STANDBY_PWR_SAVE_1"]   = spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1;
   _mapSystemStateNames["MMI_STANDBY_PWR_SAVE_2"]   = spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_2;
   _mapSystemStateNames["MMI_STANDBY"]   = spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_STANDBY;
   _mapSystemStateNames["MMI_ON"]   = spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_ON;
   _mapSystemStateNames["MMI_STANDBY_RESTRICTED"]   = spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_STANDBY_RESTRICTED;
   _mapSystemStateNames["MMI_ON_DIAG"]   = spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_ON_DIAG;
   _mapSystemStateNames["MMI_ON_TEL"]   = spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_ON_TEL;
   _mapSystemStateNames["MMI_ON_SWDL"]   = spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_ON_SWDL;
   _mapSystemStateNames["MMI_STANDBY_CUSTOMER_SWDL"]   = spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_STANDBY_CUSTOMER_SWDL;
   _mapSystemStateNames["MMI_STANDBY_PWR_SAVE"]   = spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_STANDBY_PWR_SAVE;
   _mapSystemStateNames["OVERTEMP"]   = spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_OVERTEMP;
   _mapSystemStateNames["SAFE"]   = spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_SAFE;

   _mapSystemStateNamesReverse[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_BACKGROUND] = "BACKGROUND";
   _mapSystemStateNamesReverse[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_PREPARE_SHUTDOWN] = "PREPARE_SHUTDOWN";
   _mapSystemStateNamesReverse[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_SHUTDOWN] = "SHUTDOWN";
   _mapSystemStateNamesReverse[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_SUSPEND] = "SUSPEND";
   _mapSystemStateNamesReverse[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_STANDBY] = "STANDBY";
   _mapSystemStateNamesReverse[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_OFF] = "OFF";
   _mapSystemStateNamesReverse[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_DOWNLOAD] = "DOWNLOAD";
   _mapSystemStateNamesReverse[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_ON] = "ON";
   _mapSystemStateNamesReverse[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_DOOR_OPEN] = "DOOR_OPEN";
   _mapSystemStateNamesReverse[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_IGNITION] = "IGNITION";
   _mapSystemStateNamesReverse[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_DIAGNOSIS] = "DIAGNOSIS";
   _mapSystemStateNamesReverse[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_STATE_PROFILE] = "STATE_PROFILE";
   _mapSystemStateNamesReverse[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1] = "MMI_STANDBY_PWR_SAVE_1";
   _mapSystemStateNamesReverse[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_2] = "MMI_STANDBY_PWR_SAVE_2";
   _mapSystemStateNamesReverse[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_STANDBY] = "MMI_STANDBY";
   _mapSystemStateNamesReverse[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_ON] = "MMI_ON";
   _mapSystemStateNamesReverse[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_STANDBY_RESTRICTED] = "MMI_STANDBY_RESTRICTED";
   _mapSystemStateNamesReverse[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_ON_DIAG] = "MMI_ON_DIAG";
   _mapSystemStateNamesReverse[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_ON_TEL] = "MMI_ON_TEL";
   _mapSystemStateNamesReverse[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_ON_SWDL] = "MMI_ON_SWDL";
   _mapSystemStateNamesReverse[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_STANDBY_CUSTOMER_SWDL] = "MMI_STANDBY_CUSTOMER_SWDL";
   _mapSystemStateNamesReverse[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_STANDBY_PWR_SAVE] = "MMI_STANDBY_PWR_SAVE";
   _mapSystemStateNamesReverse[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_OVERTEMP] = "OVERTEMP";
   _mapSystemStateNamesReverse[spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_SAFE] = "SAFE";

   _tDefaultConfChangeable = _tDefaultConf;
   _tDefaultConfChangeableLcm = _tDefaultConfLcm;

   //and now set project specific configuration
   vSetValue(CCA_C_U16_APP_SPM_SLV, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_PREPARE_SHUTDOWN, AMT_C_U32_STATE_NORMAL);//lint !e1506 Call to virtual function
   vSetValue(CCA_C_U16_APP_SPM_SLV, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_SHUTDOWN, AMT_C_U32_STATE_NORMAL);//lint !e1506 Call to virtual function
   vSetValue(CCA_C_U16_APP_SPM_SLV, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_OFF, AMT_C_U32_STATE_NORMAL);//lint !e1506 Call to virtual function
   vSetValue(CCA_C_U16_APP_SPM_SLV, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_DOWNLOAD, AMT_C_U32_STATE_NORMAL);//lint !e1506 Call to virtual function
   vSetValue(CCA_C_U16_APP_SPM_SLV, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_DIAGNOSIS, AMT_C_U32_STATE_NORMAL);//lint !e1506 Call to virtual function
   vSetValue(CCA_C_U16_APP_SPM_SLV, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_STATE_PROFILE, AMT_C_U32_STATE_NORMAL);//lint !e1506 Call to virtual function
   vSetValue(CCA_C_U16_APP_DIAGDEBUG, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_DIAGNOSIS, AMT_C_U32_STATE_NORMAL);//lint !e1506 Call to virtual function
   vSetValue(CCA_C_U16_APP_UI, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_DOWNLOAD, AMT_C_U32_STATE_NORMAL);//lint !e1506 Call to virtual function
   vSetValue(CCA_C_U16_APP_DIAGLOG, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_DOWNLOAD, AMT_C_U32_STATE_NORMAL);//lint !e1506 Call to virtual function
   vSetValue(CCA_C_U16_APP_VD_CLOCK, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_DOWNLOAD, AMT_C_U32_STATE_NORMAL);//lint !e1506 Call to virtual function
   vSetValue(CCA_C_U16_APP_VD_DIMMING, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_DOWNLOAD, AMT_C_U32_STATE_NORMAL);//lint !e1506 Call to virtual function
   vSetValue(CCA_C_U16_APP_AUDIO, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_BACKGROUND, AMT_C_U32_STATE_PAUSE);//lint !e1506 Call to virtual function
   vSetValue(CCA_C_U16_APP_AUDIO, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_IGNITION, AMT_C_U32_STATE_NORMAL);//lint !e1506 Call to virtual function
   vSetValue(CCA_C_U16_APP_AUDIO, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_STANDBY, AMT_C_U32_STATE_PAUSE);//lint !e1506 Call to virtual function
   vSetValue(CCA_C_U16_APP_AUDIO, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_DIAGNOSIS, AMT_C_U32_STATE_NORMAL);//lint !e1506 Call to virtual function
   vSetValue(CCA_C_U16_APP_STREAMROUTER, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_BACKGROUND, AMT_C_U32_STATE_PAUSE);//lint !e1506 Call to virtual function
   vSetValue(CCA_C_U16_APP_STREAMROUTER, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_IGNITION, AMT_C_U32_STATE_PAUSE);//lint !e1506 Call to virtual function
   vSetValue(CCA_C_U16_APP_STREAMROUTER, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_STANDBY, AMT_C_U32_STATE_PAUSE);//lint !e1506 Call to virtual function
   vSetValue(CCA_C_U16_APP_STREAMROUTER, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_DIAGNOSIS, AMT_C_U32_STATE_NORMAL);//lint !e1506 Call to virtual function
   vSetValue(CCA_C_U16_APP_FC_AUDIO_ROUTE_MGR, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_BACKGROUND, AMT_C_U32_STATE_PAUSE);//lint !e1506 Call to virtual function
   vSetValue(CCA_C_U16_APP_FC_AUDIO_ROUTE_MGR, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_IGNITION, AMT_C_U32_STATE_PAUSE);//lint !e1506 Call to virtual function
   vSetValue(CCA_C_U16_APP_FC_AUDIO_ROUTE_MGR, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_STANDBY, AMT_C_U32_STATE_PAUSE);//lint !e1506 Call to virtual function
   vSetValue(CCA_C_U16_APP_FC_AUDIO_ROUTE_MGR, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_DIAGNOSIS, AMT_C_U32_STATE_NORMAL);//lint !e1506 Call to virtual function
   vSetValue(CCA_C_U16_APP_BLUETOOTH, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_BACKGROUND, AMT_C_U32_STATE_PAUSE);//lint !e1506 Call to virtual function
   vSetValue(CCA_C_U16_APP_BLUETOOTH, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_IGNITION, AMT_C_U32_STATE_NORMAL);//lint !e1506 Call to virtual function
   vSetValue(CCA_C_U16_APP_BLUETOOTH, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_STANDBY, AMT_C_U32_STATE_PAUSE);//lint !e1506 Call to virtual function
   vSetValue(CCA_C_U16_APP_BLUETOOTH, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_DIAGNOSIS, AMT_C_U32_STATE_NORMAL);//lint !e1506 Call to virtual function
   vSetValue(CCA_C_U16_APP_TELEFON, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_BACKGROUND, AMT_C_U32_STATE_PAUSE);//lint !e1506 Call to virtual function
   vSetValue(CCA_C_U16_APP_TELEFON, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_IGNITION, AMT_C_U32_STATE_NORMAL);//lint !e1506 Call to virtual function
   vSetValue(CCA_C_U16_APP_TELEFON, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_STANDBY, AMT_C_U32_STATE_PAUSE);//lint !e1506 Call to virtual function
   vSetValue(CCA_C_U16_APP_TELEFON, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_DIAGNOSIS, AMT_C_U32_STATE_NORMAL);//lint !e1506 Call to virtual function
   vSetValue(CCA_C_U16_APP_PHONEBOOK, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_BACKGROUND, AMT_C_U32_STATE_OFF);//lint !e1506 Call to virtual function
   vSetValue(CCA_C_U16_APP_PHONEBOOK, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_IGNITION, AMT_C_U32_STATE_NORMAL);//lint !e1506 Call to virtual function
   vSetValue(CCA_C_U16_APP_PHONEBOOK, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_DIAGNOSIS, AMT_C_U32_STATE_NORMAL);//lint !e1506 Call to virtual function
   vSetValue(CCA_C_U16_APP_MESSAGING, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_BACKGROUND, AMT_C_U32_STATE_OFF);//lint !e1506 Call to virtual function
   vSetValue(CCA_C_U16_APP_MESSAGING, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_IGNITION, AMT_C_U32_STATE_NORMAL);//lint !e1506 Call to virtual function
   vSetValue(CCA_C_U16_APP_MESSAGING, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_DIAGNOSIS, AMT_C_U32_STATE_NORMAL);//lint !e1506 Call to virtual function

}

spm_tclApplicationConfigurationConfig::~spm_tclApplicationConfigurationConfig(){
}

tVoid spm_tclApplicationConfigurationConfig::vPrintAppInfo(tU32 u32AppId){
   ETG_TRACE_FATAL(("ApplicationConfiguration:"));
    ETG_TRACE_FATAL(("BACKGROUND                               %u", ETG_ENUM(SPM_APPSTATE_DEF, u32GetValue(u32AppId, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_BACKGROUND))));
    ETG_TRACE_FATAL(("PREPARE_SHUTDOWN                         %u", ETG_ENUM(SPM_APPSTATE_DEF, u32GetValue(u32AppId, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_PREPARE_SHUTDOWN))));
    ETG_TRACE_FATAL(("SHUTDOWN                                 %u", ETG_ENUM(SPM_APPSTATE_DEF, u32GetValue(u32AppId, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_SHUTDOWN))));
    ETG_TRACE_FATAL(("SUSPEND                                  %u", ETG_ENUM(SPM_APPSTATE_DEF, u32GetValue(u32AppId, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_SUSPEND))));
    ETG_TRACE_FATAL(("STANDBY                                  %u", ETG_ENUM(SPM_APPSTATE_DEF, u32GetValue(u32AppId, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_STANDBY))));
    ETG_TRACE_FATAL(("OFF                                      %u", ETG_ENUM(SPM_APPSTATE_DEF, u32GetValue(u32AppId, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_OFF))));
    ETG_TRACE_FATAL(("DOWNLOAD                                 %u", ETG_ENUM(SPM_APPSTATE_DEF, u32GetValue(u32AppId, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_DOWNLOAD))));
    ETG_TRACE_FATAL(("ON                                       %u", ETG_ENUM(SPM_APPSTATE_DEF, u32GetValue(u32AppId, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_ON))));
    ETG_TRACE_FATAL(("DOOR_OPEN                                %u", ETG_ENUM(SPM_APPSTATE_DEF, u32GetValue(u32AppId, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_DOOR_OPEN))));
    ETG_TRACE_FATAL(("IGNITION                                 %u", ETG_ENUM(SPM_APPSTATE_DEF, u32GetValue(u32AppId, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_IGNITION))));
    ETG_TRACE_FATAL(("DIAGNOSIS                                %u", ETG_ENUM(SPM_APPSTATE_DEF, u32GetValue(u32AppId, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_DIAGNOSIS))));
    ETG_TRACE_FATAL(("STATE_PROFILE                            %u", ETG_ENUM(SPM_APPSTATE_DEF, u32GetValue(u32AppId, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_STATE_PROFILE))));
    ETG_TRACE_FATAL(("MMI_STANDBY_PWR_SAVE_1                   %u", ETG_ENUM(SPM_APPSTATE_DEF, u32GetValue(u32AppId, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1))));
    ETG_TRACE_FATAL(("MMI_STANDBY_PWR_SAVE_2                   %u", ETG_ENUM(SPM_APPSTATE_DEF, u32GetValue(u32AppId, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_2))));
    ETG_TRACE_FATAL(("MMI_STANDBY                              %u", ETG_ENUM(SPM_APPSTATE_DEF, u32GetValue(u32AppId, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_STANDBY))));
    ETG_TRACE_FATAL(("MMI_ON                                   %u", ETG_ENUM(SPM_APPSTATE_DEF, u32GetValue(u32AppId, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_ON))));
    ETG_TRACE_FATAL(("MMI_STANDBY_RESTRICTED                   %u", ETG_ENUM(SPM_APPSTATE_DEF, u32GetValue(u32AppId, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_STANDBY_RESTRICTED))));
    ETG_TRACE_FATAL(("MMI_ON_DIAG                              %u", ETG_ENUM(SPM_APPSTATE_DEF, u32GetValue(u32AppId, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_ON_DIAG))));
    ETG_TRACE_FATAL(("MMI_ON_TEL                               %u", ETG_ENUM(SPM_APPSTATE_DEF, u32GetValue(u32AppId, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_ON_TEL))));
    ETG_TRACE_FATAL(("MMI_ON_SWDL                              %u", ETG_ENUM(SPM_APPSTATE_DEF, u32GetValue(u32AppId, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_ON_SWDL))));
    ETG_TRACE_FATAL(("MMI_STANDBY_CUSTOMER_SWDL                %u", ETG_ENUM(SPM_APPSTATE_DEF, u32GetValue(u32AppId, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_STANDBY_CUSTOMER_SWDL))));
    ETG_TRACE_FATAL(("MMI_STANDBY_PWR_SAVE                     %u", ETG_ENUM(SPM_APPSTATE_DEF, u32GetValue(u32AppId, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_STANDBY_PWR_SAVE))));
    ETG_TRACE_FATAL(("OVERTEMP                                 %u", ETG_ENUM(SPM_APPSTATE_DEF, u32GetValue(u32AppId, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_OVERTEMP))));
    ETG_TRACE_FATAL(("SAFE                                     %u", ETG_ENUM(SPM_APPSTATE_DEF, u32GetValue(u32AppId, spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_SAFE))));

} // vPrintAppInfo

