#ifndef __LCMDBUSCLIENT_lcmdbusclientAsfComponent_H
#define __LCMDBUSCLIENT_lcmdbusclientAsfComponent_H

/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file          lcmdbusclientAsfComponent.h
  * @PROJECT:      CMD project
  * @SW-COMPONENT: lcmdbusclient
  * @Template:     AsfClient.h.tpl
  * ----------------------------------------------------------------------------
  *
  * @brief         generated file
  *                create the ASF component
  *
  *                Do manual changes only inside tags
  *
  *                //......................: user specific code start 
  *                //......................: user specific code end 
  *
  * ----------------------------------------------------------------------------
  * @copyright     (c) 2019 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#include <iostream>

#include "asf/core/BaseComponent.h"
#include "asf/core/Logger.h"

#include "asf/stream/MemoryStream.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "lcmdbusclient_AppMain.h"

namespace org { namespace bosch { namespace cm { namespace lcmdbusclient {

    using namespace::asf::core;
    using namespace::asf::stream;
    using namespace::asf::core;
    using namespace::org::bosch::cm::lcmdbusclient;

    void vProxyStarter(lcmdbusclient_tclAppMain *poServer);

    class CcaSrvProxy;

    class LcmdbusclientAsfComponent : public BaseComponent
    {
    private:
        lcmdbusclient_tclAppMain  *_poCcaServer;
        CcaSrvProxy           *_poCcaSrvProxy;

        DECLARE_CLASS_LOGGER();

    public:
        LcmdbusclientAsfComponent();
        virtual ~LcmdbusclientAsfComponent();
    };

}}}} // namespace org { namespace bosch { namespace cm { namespace lcmdbusclient {

#endif // ifndef __LCMDBUSCLIENT_lcmdbusclientAsfComponent_H
