/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          lcmdbusclient_ServiceLcmDbusClientCallbackIF.h
  * @PROJECT:      CMD project
  * @SW-COMPONENT: lcmdbusclient
  * @Template:     serviceCallbackIf.h.tpl
  * ----------------------------------------------------------------------------
  *
  * @brief         generated file
  *                service callback interface
  *
  *                Do here client specific implementation
  *                Changes possible only inside tags
  *
  *                //......................: user specific code start 
  *                //......................: user specific code end
  *
  * ----------------------------------------------------------------------------
  * @copyright     (c) 2019 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#ifndef __lcmdbusclient_main_fi_CALLBACKIF_H_
#define __lcmdbusclient_main_fi_CALLBACKIF_H_

class lcmdbusclient_tclServiceLcmDbusClientCallbackIF
{
   public:
       virtual ~lcmdbusclient_tclServiceLcmDbusClientCallbackIF() {};

       virtual tVoid onServiceAvailable() = 0;
       virtual tVoid onServiceUnavailable() = 0;
	   
       virtual tBool onNanomsgStatusSet(tBool Nanomsgconstate, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
       virtual tBool onVoltagelevelStatusSet(tU8 Voltagelevelconstate, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
	   virtual tBool onCockpitmodeStatusSet(tU8 Cockpitmodeconstate, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
	   virtual tBool onSubsystemerrorStatusSet(lcmdbusclient_fi_tclheSubsystemList Subsystemerrorconstate, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
	   virtual tBool onThermallevelStatusSet(tU16 Thermallevelconstate, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
	   virtual tBool onDoorUnlockStatusSet(tBool DoorUnlockconstate, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;


};

#endif //__lcmdbusclient_main_fi_CALLBACKIF_H_




