/*****************************************************************************
* FILE:         lcmdbusclient_ServiceLcmDbusClient.h
* PROJECT:      G3G project
* SW-COMPONENT: lcmdbusclient
* Template:     ServiceHandler.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2019 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __lcmdbusclient_ServiceLcmDbusClient_H_
#define __lcmdbusclient_ServiceLcmDbusClient_H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "I_lcmdbusclient_ServiceLcmDbusClient.h"
#include "lcmdbusclient_AppMain.h"

// lcmdbusclient_tclServiceLcmDbusClient_Include: user specific code start
// lcmdbusclient_tclServiceLcmDbusClient_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class lcmdbusclient_tclServiceLcmDbusClientCallbackIF;

class lcmdbusclient_tclServiceLcmDbusClient : public Ilcmdbusclient_tclServiceLcmDbusClient
{
protected:
   class tclMethodResultManager {
   public:

      // Constructors and destructors
      tclMethodResultManager(){
         _bPending = 0;
         _u16SourceAppID = 0;
         _u16RegisterID = 0;
         _u16CmdCounter = 0;
         _u16FctID = 0;      
      };
      ~tclMethodResultManager(){};

      tVoid vInit(tVoid){
         _bPending = 0;
         _u16SourceAppID = 0;
         _u16RegisterID = 0;
         _u16CmdCounter = 0;
         _u16FctID = 0;      
      };

      tVoid vMemorize(tBool bPending, tU16 u16SourceAppID, tU16 u16RegisterID, tU16 u16CmdCounter,  tU16 u16FctID) {
         _bPending = bPending;
         _u16SourceAppID = u16SourceAppID;
         _u16RegisterID = u16RegisterID;
         _u16CmdCounter = u16CmdCounter;
         _u16FctID = u16FctID;

      }

      tBool bIsPending(tVoid) const {return _bPending;};    
      tVoid vSetPending(tVoid) {_bPending = TRUE;};
      tVoid vSetPendingValue(tBool _bPendingValue){_bPending = _bPendingValue;};
      tVoid vClearPending(tVoid){_bPending = FALSE;};
      tBool bGetPending(tVoid) const {return _bPending;};    

      tU16 u16GetSourceAppID(tVoid) const {return _u16SourceAppID;};    
      tU16 u16GetRegisterID(tVoid) const {return _u16RegisterID;};    
      tU16 u16GetCMDCounter(tVoid) const {return _u16CmdCounter;};    
      tU16 u16GetFctID(tVoid) const {return _u16FctID;};    

   private:                    
      tBool _bPending;
      tU16 _u16SourceAppID;
      tU16 _u16RegisterID;
      tU16 _u16CmdCounter;    
      tU16 _u16FctID; 
   };

public:

   lcmdbusclient_tclServiceLcmDbusClient(tVoid); 
   lcmdbusclient_tclServiceLcmDbusClient(lcmdbusclient_tclAppMain* poMainAppl);
   virtual ~lcmdbusclient_tclServiceLcmDbusClient();

   virtual tVoid vSetCallbackIf(lcmdbusclient_tclServiceLcmDbusClientCallbackIF* poCallback) {
      _poCallbackIf = poCallback;
   }

   // lcmdbusclient_tclServiceLcmDbusClientDeclarations: user specific code start
   // lcmdbusclient_tclServiceLcmDbusClientDeclarations: user specific code end

   /**************************************************************************
   * Assingment Operater, will not be implemented.
   * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class 
   * 'lcmdbusclient_tclServiceLcmDbusClient' which has no assignment operator.
   * NOTE: This is a technique to disable the assignment operator for this
   * class. So if an attempt for the assignment is made compiler complains.
   **************************************************************************/
   lcmdbusclient_tclServiceLcmDbusClient& operator = (const lcmdbusclient_tclServiceLcmDbusClient &oClientHandler);

   /***************************************************************************
   * Overriding ahl_tclBaseOneThreadClientHandler methods.
   ***************************************************************************/
   virtual tVoid vOnServiceAvailable();
   virtual tVoid vOnServiceUnavailable();
   
   virtual tBool bStatusMessageFactory(tU16 u16FunctionId,
                                        amt_tclServiceData& roOutMsg,
                                        amt_tclServiceData* poInMsg);
   virtual tBool bProcessSet(amt_tclServiceData* poMessage,
                              tBool& bPropertyChanged,
                              tU16& u16Error);
public:
   virtual const tChar* getName() const { return "lcmdbusclient_tclServiceLcmDbusClient"; };
   
   virtual tVoid vHandleMessage(lcmdbusclient_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();
   
private:
   lcmdbusclient_tclServiceLcmDbusClientCallbackIF* _poCallbackIf;

public:



    /***************************************************************************
    * Application specific methods.
    ***************************************************************************/
   virtual tVoid sendCurrentSourceStatus(lcmdbusclient_fi_tclString strSourceName);
   //Nanomsg
   virtual tVoid sendNanomsgStatusStatus(tBool Nanomsgconstate);
   virtual tBool onNanomsgStatusSet(tBool Nanomsgconstate, tBool& bPropertyChanged, tU16& u16ErrorCode);

   virtual tVoid sendVoltagelevelStatusStatus(tU8 Voltagelevelconstate);
   virtual tBool onVoltagelevelStatusSet(tU8 Voltagelevelconstate, tBool& bPropertyChanged, tU16& u16ErrorCode);
   
   virtual tVoid sendCockpitmodeStatusStatus(tU8 Cockpitmodeconstate);
   virtual tBool onCockpitmodeStatusSet(tU8 Cockpitmodeconstate, tBool& bPropertyChanged, tU16& u16ErrorCode);
   
   virtual tVoid sendSubsystemerrorStatusStatus(lcmdbusclient_fi_tclheSubsystemList Subsystemerrorconstate);
   virtual tBool onSubsystemerrorStatusSet(lcmdbusclient_fi_tclheSubsystemList Subsystemerrorconstate, tBool& bPropertyChanged, tU16& u16ErrorCode);
   
   virtual tVoid sendThermallevelStatusStatus(tU16 Thermallevelconstate);
   virtual tBool onThermallevelStatusSet(tU16 Thermallevelconstate, tBool& bPropertyChanged, tU16& u16ErrorCode);

   //DoorUnlock
   virtual tVoid sendDoorUnlockStatusStatus(tBool DoorUnlockconstate);
   virtual tBool onDoorUnlockStatusSet(tBool DoorUnlockconstate, tBool& bPropertyChanged, tU16& u16ErrorCode);
   
   virtual void vGetCurrentSourceMsg(lcmdbusclient_mainfi_tclMsgCurrentSourceStatus& oStatus) {
      oStatus.strSourceName = _tCurrentSource_strSourceName;
   }
   
   virtual void vGetNanomsgStatusMsg(lcmdbusclient_mainfi_tclMsgNanomsgStatusStatus& oStatus) {
      oStatus.Nanomsgconstate = _tNanomsgStatus_Nanomsgconstate;
   }
   virtual void vGetVoltagelevelStatusMsg(lcmdbusclient_mainfi_tclMsgVoltagelevelStatusStatus& oStatus) {
      oStatus.Voltagelevelconstate = _tVoltagelevelStatus_Voltagelevelconstate;
   }
   
   virtual void vGetCockpitmodeStatusMsg(lcmdbusclient_mainfi_tclMsgCockpitmodeStatusStatus& oStatus) {
      oStatus.Cockpitmodeconstate = _tCockpitmodeStatus_Cockpitmodeconstate;
   }
   virtual void vGetSubsystemerrorStatusMsg(lcmdbusclient_mainfi_tclMsgSubsystemerrorStatusStatus& oStatus) {
      oStatus.Subsystemerrorconstate = _tSubsystemerrorStatus_Subsystemerrorconstate;
   }
   virtual void vGetThermallevelStatusMsg(lcmdbusclient_mainfi_tclMsgThermallevelStatusStatus& oStatus) {
      oStatus.Thermallevelconstate = _tThermallevelStatus_Thermallevelconstate;
   }
   virtual void vGetDoorUnlockStatusMsg(lcmdbusclient_mainfi_tclMsgDoorUnlockStatusStatus& oStatus) {
      oStatus.DoorUnlockconstate = _tDoorUnlockStatus_DoorUnlockconstate;
   }
   virtual tVoid vHandlePNMGRP10SignalStatus(amt_tclServiceData *poMessage);
private:
   // Add status information properties.
   lcmdbusclient_fi_tclString _tCurrentSource_strSourceName;
   tBool _tNanomsgStatus_Nanomsgconstate;
   tU8 _tVoltagelevelStatus_Voltagelevelconstate;
   tU8 _tCockpitmodeStatus_Cockpitmodeconstate;
   lcmdbusclient_fi_tclheSubsystemList _tSubsystemerrorStatus_Subsystemerrorconstate;
   tU16 _tThermallevelStatus_Thermallevelconstate;
   tBool _tDoorUnlockStatus_DoorUnlockconstate;
   /***************************************************************************
   * Message map definition macro
   ***************************************************************************/

   DECLARE_MSG_MAP(lcmdbusclient_tclServiceLcmDbusClient) 

// lcmdbusclient_tclServiceLcmDbusClientDeclarationsPart2: user specific code start
// lcmdbusclient_tclServiceLcmDbusClientDeclarationsPart2: user specific code end

};

#endif // __lcmdbusclient_ServiceLcmDbusClient_H_






