/**************************************************************************************
* @file         : <XMLReader.cpp>
* @author       : <Madhuree> <ECG> <INF4CV>
* @brief        :
* @copyright    : (C) 2018 Robert Bosch GmbH
*                 (C) 2018 Robert Bosch Engineering and Business Solutions Limited
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/



#include <sstream>
#include <stdlib.h>
/*
#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"
*/

#include "XMLReader.h"
/*
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS  TR_CLASS_LCMDBUSCLIENT_SERVER_LCMDBUSCLIENT
#include "trcGenProj/Header/XMLReader.cpp.trc.h"
#endif

*/


const char* AVROUTINGAPDAPTER_XML = "/usr/lib/avdecc/plugins/AVRoutingAdapter.xml";

using namespace std;


const char* NAME_AMP = "CMA";
const char* NAME_CAMPORT = "CMP";
const char* NAME_GLASSES = "CMG";
const char* TAG_ENTITY = "tENTITY";
const char* TAG_NAME = "name";
const char* ATTR_EID = "eId";
const char* ATTR_IP = "IP";
const char* ATTR_MAC = "mac";
//const char* ATTR_DEVID = "DevId";
//const char* ATTR_DEVNR = "DevNr";

 XMLReader * XMLReader::m_XMLReader = NULL;
//std::vector<stEntityDetails> XMLReader::entityDetails = {};

/******************************************************************************
*NAME        :XMLReader
*SWFL        :NA
*DESCRIPTION :Constructor
******************************************************************************/
XMLReader::XMLReader() :
   _xmlDoc(AVROUTINGAPDAPTER_XML),
   m_lastAttri(NULL)
{
    m_entityData.clear();
   //ETG_TRACE_USR4(("XMLReader::XMLReader()"));
   parsed = false;
   
}

/******************************************************************************
*NAME        :XMLReader
*SWFL        :NA
*DESCRIPTION :Returns singleton instance
******************************************************************************/
XMLReader* XMLReader::GetInstance()
{
	//ETG_TRACE_USR4(("XMLReader::GetInstance()"));
	if (NULL ==m_XMLReader)
	{
		m_XMLReader = new XMLReader();
	}
   
   return m_XMLReader;
}

/******************************************************************************
*NAME        :XMLReader
*SWFL        :NA
*DESCRIPTION :Destructor
******************************************************************************/
XMLReader::~XMLReader()
{
   //ETG_TRACE_USR4(("XMLReader::~XMLReader()"));
}

/******************************************************************************
*NAME        :GetInfo
*SWFL        :NA
*DESCRIPTION :For Extracting information from XML doc
******************************************************************************/
void XMLReader::GetInfo(TiXmlNode* pParent)
{
   //ETG_TRACE_USR4(("XMLReader::GetInfo()"));
   TiXmlNode* pChild;
   TiXmlText* pText;
   TiXmlComment* pComment;
   TiXmlElement* pElement;
   uint8_t NodeType = pParent->Type();

   switch (NodeType)
      {
         case TiXmlNode::TINYXML_ELEMENT:
         {
            const char* TagName = pParent->Value();
            if ((strcmp(TAG_ENTITY, TagName) == 0))
            {
               //ETG_TRACE_USR4(("XMLReader::GetInfo() TagName:%s", TagName));	   
               ExtractInfo(pParent->ToElement());
            }
         }
         break;
         case TiXmlNode::TINYXML_COMMENT:
         {
            /*Do nothing*/
         }
         break;
         default:
         {
            /*Do nothing*/
         }
         break;
      }
      for (pChild = pParent->FirstChild(); pChild != 0; pChild = pChild->NextSibling())
      {
         GetInfo(pChild);
      }
}

/******************************************************************************
*NAME        :processNameAndID
*SWFL        :NA
*DESCRIPTION :Entityname and EntityID are saved based on pAttribValue
******************************************************************************/
void XMLReader::processNameAndID(const char* pAttribValue)
{
   //ETG_TRACE_USR4(("XMLReader processNameAndID() pAttribValue %s", pAttribValue));
    char* p = NULL;
    m_entityId = (uint64_t)strtoull(pAttribValue, &p, 16);  //string to hex convert
	if(NULL != m_lastAttri)
	{
	  if(strcmp(m_lastAttri, NAME_AMP) == 0)
      {
	    m_entityName.assign(COACHMEDIA_AMPLIFIER);  //store entity name
		m_devId = 0x02;
	  }
	  else if(strcmp(m_lastAttri, NAME_CAMPORT) == 0)
      {
		m_entityName.assign(COACHMEDIA_CAMERAPORT_1);
		m_devId = 0x05;
	  }
	 
	  else if(strcmp(m_lastAttri, NAME_GLASSES) == 0)
      {
		m_entityName.assign(COACHMEDIA_GLASS);
		m_devId = 0x06;
	  }
	  
    }
	  else
	{
		 //ETG_TRACE_USR4(("XMLReader processAttributeName(): m_lastAttri is NULL "));
	}
	
}

void XMLReader::processDevNr(std::string ip)
{
   //ETG_TRACE_USR4(("XMLReader processDevNr()"));
   //ETG_TRACE_USR4(("m_entityIp ip is : %s",ip.c_str()));
   char lastByte[10];
   char ipBytes[16];
   for (int x=0;x<ip.length()+1;x++ )
   {
	   ipBytes[x]= ip[x];
   }
   //ETG_TRACE_USR4(("XMLReader processDevNr() ipBytes : %s",ipBytes));
   int i=0;
   int count=0;
   while(count<3 && ipBytes[i]!='\0'){
	   if(ipBytes[i] == '.')
	   {
	   count++;
	   }
	   i++;
   };
   if(ipBytes[i]!='\0')
   {
	  strcpy(lastByte,(ipBytes+i));
   }
   else{
	   //ETG_TRACE_USR4(("ipBytes is not ip address"));
   }
   // ETG_TRACE_USR4(("XMLReader processDevNr() lastByte : %s",lastByte));
   m_devNr=(uint8_t)atoi(lastByte);
   //ETG_TRACE_USR4(("XMLReader processDevNr() m_devNr : %d",m_devNr));
   
}

/******************************************************************************
*NAME        :storeEntity
*SWFL        :NA
*DESCRIPTION :each entity details are pushed to vector
******************************************************************************/

void XMLReader::storeEntity()
{
	 //ETG_TRACE_USR4(("XMLReader::storeEntity()"));
	EntityData* pEntityData = new EntityData();
	if(NULL != pEntityData)
	{
		pEntityData->SetEntityName(m_entityName);
		pEntityData->SetMac(m_entityMac);
		pEntityData->SetIP(m_entityIp);
		pEntityData->SetEntityId(m_entityId);
		pEntityData->SetDevId(m_devId);
		pEntityData->SetDevNr(m_devNr);
	}
	m_entityData.push_back(pEntityData);	
}

/******************************************************************************
*NAME        :ExractInfo
*SWFL        :NA
*DESCRIPTION :For Extracting information from XML doc
******************************************************************************/
void XMLReader::ExtractInfo(TiXmlElement* pElement)
{
   //ETG_TRACE_USR4(("XMLReader ExtractInfo is called"));

   if (!pElement)
      {
         return;
      }

      TiXmlAttribute* pAttrib = pElement->FirstAttribute();
	  
      while (pAttrib)
      {
         const char* pAttribName = pAttrib->Name();
         const char* pAttribValue = pAttrib->Value();
		 if (strcmp(TAG_NAME, pAttribName) == 0)   //TAG_NAME = "name"
		 {
			 m_lastAttri = pAttribValue;
			 //ETG_TRACE_USR4(("XMLReader::ExtractInfo() : m_lastAttri value is %s", m_lastAttri));
			 
		 }
         else if (strcmp(ATTR_EID, pAttribName) == 0) //ATTR_NAME = "eId"
         {
            processNameAndID(pAttribValue);
         }
		 else if (strcmp(ATTR_IP, pAttribName) == 0) //ATTR_NAME = "IP"
         {
            m_entityIp.assign(pAttribValue);
			//ETG_TRACE_USR4(("m_entityIp : %s", m_entityIp.c_str()));
			processDevNr(m_entityIp);
			
         }
		 else if (strcmp(ATTR_MAC, pAttribName) == 0) //ATTR_NAME = "mac"
         {
			m_entityMac.assign(pAttribValue);
			//ETG_TRACE_USR4(("m_entityMac : %s", m_entityMac.c_str()));
			storeEntity();
			
         }
         else
         {
            /*Do nothing*/
         }
		 
         pAttrib = pAttrib->Next();
      }
	  //ETG_TRACE_USR4(("XMLReader ExtractInfo end"));

}

/******************************************************************************
*NAME        :printVector
*SWFL        :NA
*DESCRIPTION :print saved vector which contains each entity's details like IP,MAC,EntityId,EntityNamec
******************************************************************************/
void XMLReader::printVector()
{
	 //ETG_TRACE_USR4(("XMLReader::printVector() : size of vector %d ",m_entityData.size()))
#if 0		
	if((m_entityData.size()) > 0)
      {
		 for (auto iter : m_entityData )
         {
		   //ETG_TRACE_USR4(("XMLReader::printVector()  Ename %s", iter->GetEntityName().c_str() ));
           //ETG_TRACE_USR4(("XMLReader::printVector()  Eid %lx ", iter->GetEntityId() ));
		   //ETG_TRACE_USR4(("XMLReader::printVector() DevId %d", iter->GetDevId() ));
		   //ETG_TRACE_USR4(("XMLReader::printVector() DevNr %d", iter->GetDevNr() ));
		   //ETG_TRACE_USR4(("XMLReader::printVector() entityIp %s", iter->GetIP().c_str() ));
		   //ETG_TRACE_USR4(("XMLReader::printVector() entityMac %s", iter->GetMac().c_str() ));
		   
		   
         }
	 }	 
#endif
}


/******************************************************************************
*NAME        :getParsed
*SWFL        :NA
*DESCRIPTION :To know that parsing has happened before
******************************************************************************/
bool XMLReader::getParsed()
{
	return parsed;
}

/******************************************************************************
*NAME        :FetchResults
*SWFL        :NA
*DESCRIPTION :Loads the xml for information extraction
******************************************************************************/
bool XMLReader::FetchResults()
{
   //ETG_TRACE_USR4(("XMLReader::FetchResults() - Enter"));

   bool result = _xmlDoc.LoadFile();

   if (result)
   {
      //ETG_TRACE_USR4(("XMLReader::FetchResults() - XML load Successful"));
      GetInfo(&_xmlDoc);
   }
   else
   {
      //ETG_TRACE_ERR(("XMLReader::FetchResults() - XML load Failed %s", _xmlDoc.ErrorDesc()));
   }

  //ETG_TRACE_USR4(("XMLReader::FetchResults() - Exit"));
  parsed = true;  
  printVector();
  return result;
}

