/****************************************************************************
* Copyright (C) Robert Bosch Car Multimedia GmbH, 2015
* This software is property of Robert Bosch GmbH. Unauthorized
* duplication and disclosure to third parties is prohibited.
*
* FILE                : 
* COMPONENT Name      : 
* DESCRIPTION         : 
* AUTHOR              : 
* Revision History    : 0.1
* Date 06.02.2020     : Initial version
****************************************************************************/
#ifndef NANO_CLIENT_HANDLER_H
#define NANO_CLIENT_HANDLER_H
/*****************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------*/
#define OSAL_S_IMPORT_INTERFACE_UTIL
#include "osal_if.h"
#include <asf/core/Types.h>
#include "asf/core/Timer.h"
//#include "cfc_spm_fi_types.h"
//state machine
#include <iostream>
#include <string>
#include <vector>
#include <map>
#include "lcmdbusclient_ServiceLcmDbusClient.h"



/*****************************************************************
| includes
|----------------------------------------------------------------*/
//#include "Project_Trace.h"

#include "NanoMsgLCMInterface.h"
#include "asf/core/BaseComponent.h"
#include "NanoMsgLCMInterfaceClientBase.h"
#include "NanoMsgLCMInterfaceConst.h"
#include "NanoMsgLCMInterfaceDBus.h"
#include "NanoMsgLCMInterfaceJson.h"
#include "NanoMsgLCMInterfaceJsonPrivate.h"
#include "NanoMsgLCMInterfaceProxy.h"
#include "INanomsgClienthandler.h"
#include "NanoMsgGenericInterface.h"
#include "NanoMsgGenericInterfaceClientBase.h"
#include "NanoMsgGenericInterfaceConst.h"
#include "NanoMsgGenericInterfaceDBus.h"
#include "NanoMsgGenericInterfaceJson.h"
#include "NanoMsgGenericInterfaceJsonPrivate.h"
#include "NanoMsgGenericInterfaceProxy.h"
#include "NanoMsgGenericInterfaceStub.h"

#include "XMLReader.h"
#include "EntityData.h"
#include "AVRoutingParser.h"

#include "SPM_CORE_FIProxy.h"

using namespace std;
 class XMLReader;
 class tclAvRoutingParser;
namespace org { namespace bosch { namespace cm { namespace lcmdbusclient {
using namespace ::asf::core;
using namespace ::bosch::cm::di::NanoMsgLCMInterface;
using namespace ::bosch::cm::di::NanoMsgGenericInterface;

/*****************************************************************
| Structures and enums
|----------------------------------------------------------------*/
#define USE_DIGITALINPUT

//Used for value assignment
#define FLAG_CLEAR 				0x00
#define FLAG_SET 				0x01

//Used for condition check
#define NOT_SET 				0x00
#define SET 					0x01

//Wakeup flags
#define LCM_MSG_GETWAKEUPREASON_FLAG 0x00000001

//PNM 
#define PNM_LOW_VOLT_ACTIVE		0x00
#define PNM_LOW_VOLT_INACTIVE 	0x01

#define LCM_SHUTDOWN_TIMER 		50  //time in seconds. This value is sent to CM-A to indicate that safe shutdown time of CM-C. 
									//When IGN removed, system is in Standby for 10 seconds. CM-A should wait wait for this time for safe shutdown of CM-C.

#define HEALTHCARE_RESPONSE		0
#define EVENT_PWRMODE_CHANGE	1

#define HEALTHCARE_MAX_COUNT 		12		//Healthcare maximum retry count
#define LCM_BASE_TIMER_MS 				1000	//1000 milli second or 1 second

#define LCM_5s_TIMER 			(5)
#define LCM_10s_TIMER 			(10)
#define LCM_120s_TIMER         (120)

#define ETHERNET_ERROR_INACTIVE 0x0000
#define ETHERNET_ERROR_ACTIVE 	0x0001

#define RECEIVED				1
#define NOT_RECEIVED			0

#define MAX_SUBSYSTEM			50		//Maximum number of sub-systems can be connected. This is a hardcoded value and needs to be updated when more sub-systems are planned

#define IGN_ACTIVE				1
#define IGN_INACTIVE			0
#define DOORUNLOCK_ACTIVE		1
#define DOORUNLOCK_INACTIVE		0

#define DEV_NAME_CMA 			"CMA"
#define DEV_NAME_CMP 			"CMP"
#define DEV_NAME_CMG 			"CMG"
#define DEV_NAME_CMR 			"CMR"

//Nanomessage ID's
#define MSG_ID_ReqSetPowerMode    		0x0003
#define MSG_ID_ReqGetWakeupReason 		0x0008
#define MSG_ID_ReqShutdown        		0x0010
#define MSG_ID_ReqGetPowerMode    		0x0005
#define MSG_ID_ReqGetDigitalInput 		0x0016
#define MSG_ID_ReqGetVoltage      		0x0013
#define MSG_ID_ReqCMGSvivelPosition 		0x0064
#define MSG_ID_ReqHealthCare      		0x0030

//Mask for updating the error structure to HMI
#define MASK_NANOMSG_ERR 				0xFFFC
#define MASK_AVDECCMSG_ERR 				0xFFF3
#define MASK_ETHERNET_ERR 				0xFFCF
#define MASK_VOLTAGE_ERR 				0xFE3F
#define MASK_THERMAL_ERR 				0xF1FF
#define MASK_PNM_ERR 					0x8FFF
#define MASK_HOURLOGIC_END 				0x7FFF

#define DEFAULT_CONDITION 				0x0000
#define NANOMSG_EVALUATING 				0x0000
#define NANOMSG_NO_ERR 					0x0001
#define NANOMSG_ERR 					0x0002
#define AVDECC_EVALUATING 				0x0000
#define AVDECC_NO_ERR 					0x0004
#define AVDECC_ERR 						0x0008
#define ETHERNET_EVALUATING 			0x0000
#define ETHERNET_NO_ERR 				0x0010
#define ETHERNET_ERR 					0x0020
#define VOLTAGE_EVALUATING 				0x0000
#define VOLTAGE_NO_ERR 					0x0040
#define VOLTAGE_OVER_WARNING 			0x0080
#define VOLTAGE_OVER_CRITICAL 			0x00C0
#define VOLTAGE_UNDER_WARNING 			0x0100
#define VOLTAGE_UNDER_CRITICAL 			0x0140
#define THERMAL_EVALUATINGL 			0x0000
#define THERMAL_NO_ERR 					0x0200
#define THERMAL_HIGH 					0x0400
#define THERMAL_CRITICAL_HIGH 			0x0600
#define THERMAL_OVER 					0x0800
#define THERMAL_LOW 					0x0A00
#define THERMAL_CRITICAL_LOW 			0x0C00
#define THERMAL_UNDER					0x0E00
#define PNM_UNDEFINED 					0x0000
#define PNM_NO_ERROR 					0x1000    
#define PNM_ERROR 						0x2000
     
#define SUBSYSTEM_PWRMODE_EVALUATING 	0x0000
#define SUBSYSTEM_PWRMODE_ON 			0x1000
#define SUBSYSTEM_PWRMODE_USEROFF 		0x2000
#define SUBSYSTEM_PWRMODE_PROTECTEDOFF 	0x3000
#define SUBSYSTEM_PWRMODE_SWUPDATE 		0x4000
#define SUBSYSTEM_PWRMODE_DIAGNOSIS 	0x5000
#define SUBSYSTEM_PWRMODE_STARTUP 		0x6000
#define SUBSYSTEM_PWRMODE_HOURLOGIC 	0x7000


#define HOURLOGIC_END_INACTIVE 			0x0000
#define HOURLOGIC_END_ACTIVE 			0x8000



//Enum for system states defined as per the interface
typedef enum T_SPM_e32_SYSTEM_STATES 
{
	T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_BACKGROUND 					= 5u,
	T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_PREPARE_SHUTDOWN			= 16u,
	T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_SHUTDOWN					= 17u,
	T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_SUSPEND 					= 0u,
	T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_STANDBY 					= 1u,
	T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_OFF 						= 2u,
	T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_DOWNLOAD 					= 3u,
	T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_ON 							= 4u,
	T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_DOOR_OPEN 					= 6u,
	T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_IGNITION 					= 7u,
	T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_DIAGNOSIS 					= 8u,
	T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_STATE_PROFILE 				= 9u,
	T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1 		= 32u,
	T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_2 		= 33u,
	T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_MMI_STANDBY 				= 34u,
	T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_MMI_ON 						= 35u,
	T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_MMI_STANDBY_RESTRICTED 		= 36u,
	T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_MMI_ON_DIAG 				= 37u,
	T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_MMI_ON_TEL 					= 38u,
	T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_MMI_ON_SWDL 				= 39u,
	T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_MMI_STANDBY_CUSTOMER_SWDL 	= 40u,
	T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_MMI_STANDBY_PWR_SAVE 		= 41u,
	T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_OVERTEMP 					= 42u,
	T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_SAFE 						= 43u,
	T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_STATE_MAX 					= 44u,
	T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_STATE_UNKNOWN 				= 255u,
	T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_STATE_INVALID 				= 65535u
};


//Error Values
typedef enum ErrorValue
{
	DEV_EVALUATING					= 0,
	DEV_NO_ERROR,
	DEV_ERROR,
	DEV_OVER_WARNING_VOLTAGE		= 2,
	DEV_OVER_CRITICAL_VOLTAGE,
	DEV_UNDER_WARNING_VOLTAGE,
	DEV_UNDER_CRITICAL_VOLTAGE,
	DEV_HIGH_THERMAL				= 2,
	DEV_CRITICAL_THERMAL,
	DEV_OVER_CRITICAL_THERMAL,
	DEV_LOW_THERMAL,
	DEV_CRITICAL_LOW_THERMAL,
	DEV_UNDER_CRITICAL_LOW_THERMAL,
	DEV_PNM_ERROR_POWER_MODE_UNDEFINED = 0,
	DEV_POWER_MODE_ON,
	DEV_POWER_MODE_USEROFF,
	DEV_POWER_MODE_PROCTECTED_OFF,
	DEV_POWER_MODE_SWUPDATE,
	DEV_POWER_MODE_DIAGNOSIS,
	DEV_POWER_MODE_STARTUP,
	DEV_POWER_MODE_HOUR_LOGIC,	
	HOURLOGIC_INACTIVE				= 0,
	HOURLOGIC_ACTIVE
};

//Error Type
typedef enum ErrorType
{
	ERR_NANO_MSG			= 0,
	ERR_AVDECC,
	ERR_ETHERNET,
	ERR_VOLTAGE,
	ERR_THERMAL,
	ERR_PNM_GRP10,
	ERR_HOUR_LOGIC,
	POWER_MODE_SUBSYSTEM
};

//A structure which holds all the data of sub-system
typedef struct stSubSystemStatus	
{
	enDevID DeviceID;
	uint8 DeviceNumber;
	std::string DeviceIPAddress;
	unsigned char IPLastByte;
	entPowerMode ExpectedPwrMode;
	entPowerMode ReceivedPwrMode;
	uint8 u8HealthcareReqCount;		// This shall be increased when Health care request is sent and set to zero when response is received from sub-system
	uint8 u8PWRModeMismatchCount;	// If powermode received from sub-system is not matching with the expected power mode, this counter shall be increased.
	uint8 u8SelfProtectionFlg;		// Can this be used for Checking the protected off condition of the indivudual sub-system? If this is set, don't send other system state update to sub-system
	uint8 u8ThermProtOffFlg;		//Protected off due to thermal condition of the respective sub-system
	uint8 u8VoltProtOffFlg;			//Protected off due to voltage condition of the respective sub-system
	uint16 u16VoltageState;
	uint16 u16VoltageValue;
	uint16 u16ThermalState;
	uint16 u16ThermalValue;
}stSubSystemStatus;

enum CMCPwrMode
{
	CMCPwrMode_OFF,
	CMCPwrMode_ON,
	CMCPwrMode_BACKGROUND,
	CMCPwrMode_STANDBY,
	CMCPwrMode_STATE_PROFILE,
	CMCPwrMode_PREPARE_SHUTDOWN,
	CMCPwrMode_SHUTDOWN,
	CMCPwrMode_IGNITION,
	CMCPwrMode_DOOR_OPEN,
	CMCPwrMode_SAFE,
	CMCPwrMode_MMI_STANDBY,
	CMCPwrMode_DIAGNOSIS,
	CMCPwrMode_DOWNLOAD,
	CMCPwrMode_MMI_ON,
	CMCPwrMode_MMI_ON_TEL,
	CMCPwrMode_MMI_STANDBY_PWR_SAVE_2,
	CMCPwrMode_MMI_ON_SWDL,
	CMCPwrMode_MAX
};

enum CISPwrMode
{
	CISPwrMode_OFF = 1,
	CISPwrMode_STANDBY,
	CISPwrMode_USEROFF,
	CISPwrMode_STARTUP,
	CISPwrMode_ON,
	CISPwrMode_HOUR_LOGIC,
	CISPwrMode_DIAGNOSIS,
	CISPwrMode_SW_UPDTAE,
	CISPwrMode_PROTECTED_OFF,
	CISPwrMode_UNDEFINED = 0xff
};



typedef enum DeviceID
{
	DEV_NO_SUBSYSTEM,
	DEV_MediaCenter,
	DEV_MediaAmplifier,
	DEV_MediaRouter, 
	DEV_MediaHDTV,
	DEV_CameraPort,
	DEV_MediaGlass, 
	DEV_MediaControlPanel,
	DEV_Intercom,
	DEV_SwivelHolder,
	DEV_TestBed,	
	DEV_Type_MAX	
};

class NanomsgClienthandler : public INanomsgClienthandler
	,public ::asf::core::ServiceAvailableIF
	,public ReqGetPowerModeCallbackIF
	,public ReqGetWakeupReasonCallbackIF
	,public ReqSetPowerModeCallbackIF
	,public ReqShutdownCallbackIF
	,public Sig_EventPowerModeChangeCallbackIF
	,public Sig_RspGetWakeupReasonCallbackIF
	,public Sig_RspSetPowerModeCallbackIF
	,public Sig_RspShutdownCallbackIF
	,public Sig_RspGetPowerModeCallbackIF
	,private TimerCallbackIF
	,public Sig_EventDigitalInputCallbackIF
	,public Sig_RspGetDigitalInputCallbackIF
	,public ReqGetDigitalInputCallbackIF
	,public ReqGetVoltageCallbackIF
	,public EventVoltageCallbackIF
	,public RspGetVoltageCallbackIF
	,public ReqCMGSvivelPositionCallbackIF
	,public Sig_RspCMGSvivelPositionCallbackIF
	,public RspGetThermalStateCallbackIF
	,public ReqGetThermalStateCallbackIF
	,public EventThermalStateCallbackIF
	,public ReqHealthCareCallbackIF
	,public Sig_RspHealthCareCallbackIF
   {
	private:
		Timer      _NanomsgTimer;
		uint32     _NanomsgTimeMSec;
		uint32     _u32RxMsgStatus;
		bool       _bIgnitionStatus;	//To hold the CM-A ignition status (Active/inactive)
		bool	   _bDoorUnlockStatus;	//To hold the CM-A DOOR Unlock status (Active/inactive)
		uint8      _u8MaxNumOfSubSystem;
		//Error handling
		lcmdbusclient_fi_tclheSubsystemList Subsystemerrorconstate;  

	public:
		virtual ~NanomsgClienthandler();
		virtual void onExpired(asf::core::Timer & timer, boost::shared_ptr <asf::core::TimerPayload> payload);	
		virtual void onReqGetPowerModeError(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqGetPowerModeError >& error);
		virtual void onReqGetPowerModeResponse(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqGetPowerModeResponse >& response);
		virtual void onReqGetWakeupReasonError(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqGetWakeupReasonError >& error);
		virtual void onReqGetWakeupReasonResponse(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqGetWakeupReasonResponse >& response);
		virtual void onReqSetPowerModeError(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqSetPowerModeError >& error);
		virtual void onReqSetPowerModeResponse(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqSetPowerModeResponse >& response);
		virtual void onReqShutdownError(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqShutdownError >& error);
		virtual void onReqShutdownResponse(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqShutdownResponse >& response);
		virtual void onSig_EventPowerModeChangeError(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_EventPowerModeChangeError >& error);
		virtual void onSig_EventPowerModeChangeSignal(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_EventPowerModeChangeSignal >& signal);
		virtual void onSig_RspGetPowerModeError(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspGetPowerModeError >& error);
		virtual void onSig_RspGetPowerModeSignal(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspGetPowerModeSignal >& signal);
		virtual void onSig_RspGetWakeupReasonError(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspGetWakeupReasonError >& error);
		virtual void onSig_RspGetWakeupReasonSignal(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspGetWakeupReasonSignal >& signal);
		virtual void onSig_RspSetPowerModeError(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspSetPowerModeError >& error);
		virtual void onSig_RspSetPowerModeSignal(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspSetPowerModeSignal >& signal);
		virtual void onSig_RspShutdownError(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspShutdownError >& error);
		virtual void onSig_RspShutdownSignal(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspShutdownSignal >& signal);
		virtual void onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
		virtual void onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);

		virtual void onSig_EventDigitalInputError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_EventDigitalInputError >& error);
		virtual void onSig_EventDigitalInputSignal(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_EventDigitalInputSignal >& signal);
		virtual void onReqGetDigitalInputError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqGetDigitalInputError >& error);
		virtual void onReqGetDigitalInputResponse(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqGetDigitalInputResponse >& response) ;
		virtual void onSig_RspGetDigitalInputError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspGetDigitalInputError >& error);
		virtual void onSig_RspGetDigitalInputSignal(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspGetDigitalInputSignal >& signal);
		virtual void onReqCMGSvivelPositionError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqCMGSvivelPositionError >& error);
		virtual void onReqCMGSvivelPositionResponse(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqCMGSvivelPositionResponse >& response);
		virtual void onSig_RspCMGSvivelPositionError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspCMGSvivelPositionError >& error);
		virtual void onSig_RspCMGSvivelPositionSignal(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspCMGSvivelPositionSignal >& signal);

		virtual void onEventVoltageError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< EventVoltageError >& error);
		virtual void onEventVoltageSignal(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< EventVoltageSignal >& signal);
		virtual void onReqGetVoltageError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqGetVoltageError >& error);
		virtual void onReqGetVoltageResponse(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqGetVoltageResponse >& response);
		virtual void onRspGetVoltageError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< RspGetVoltageError >& error);
		virtual void onRspGetVoltageSignal(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< RspGetVoltageSignal >& signal);

		virtual void onReqGetThermalStateError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqGetThermalStateError >& error);
		virtual void onReqGetThermalStateResponse(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqGetThermalStateResponse >& response);
		virtual void onEventThermalStateError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< EventThermalStateError >& error);
		virtual void onEventThermalStateSignal(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< EventThermalStateSignal >& signal);
		virtual void onRspGetThermalStateError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< RspGetThermalStateError >& error);
		virtual void onRspGetThermalStateSignal(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< RspGetThermalStateSignal >& signal);

		virtual void onReqHealthCareError(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqHealthCareError >& error);
		virtual void onReqHealthCareResponse(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqHealthCareResponse >& response);
		virtual void onSig_RspHealthCareError(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspHealthCareError >& error);
		virtual void onSig_RspHealthCareSignal(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspHealthCareSignal >& signal);	

		virtual const tChar* getName() const { return "NanoMsgLCMInterface"; }
		virtual tVoid vHandleMessage(lcmdbusclient_tclBaseIf::TMsg* pMsg){}
		virtual tVoid vHandleTraceMessage(const tUChar* /*puchData*/) {}
		virtual tVoid vGetReferences(){}
		virtual tVoid vStartCommunication(){}
		virtual tVoid vTraceInfo(){}

		/* start of Statemachine Handling Functions*/
	public: 
		void vSendPowerMode(uint8 u8CMCPwrMode);
		void vOnTimerExpiry(void);
		uint8 u8GetID(enDevID eDevID);
		uint8 u8SendPowerModeDBUS(enDevID eDevID, uint8 u8DevNr, std::string sIPAddr, entPowerMode ePowerMode);
		uint8 u8GetSubSystemIndex(std::string sIPAddr);
		uint8 MappingOfReceivedPModeForHMI (entPowerMode CISPMode);
		//Error Handling
		void initSubsystemerrorState(uint8 u8DevIP, uint8 u8DevID);
		lcmdbusclient_fi_tclheSubsystemList getSubsystemerrorState()
		{
			return Subsystemerrorconstate;
		}
		void UpdateError(uint8 devIndex , uint8 Error, uint8 Value);
		void InitDevError(uint8 NumOfSubSystem);
		entPowerMode eGetcIsState(enDevID eDevID, uint8 u8IntPwrMode);
		void vHandleReceivedPowerMode(enDevID eDevID, uint8 u8DevNr,  std::string sIPAddr, entPowerMode ePowerMode, tBool bIsEvent = false);//NewCode		
		const char* THERMAL_LEVEL(int TEMP);
		const char* VOLT_LEVEL(int VOLT);
		const char* WAKEUP_REASON(int REASON);
		const char* POWER_MODE(int MODE);
		uint8 _u8NanomsgErrorflag;
		uint8 _u8PNMGRP10Statusflag;
		/* End of Statemachine Handling Functions*/

		//spm states
		virtual void vHandleSystemStates(uint8 systemState);
		virtual void vHandlePNMGRP10status(uint8 PNMGRP10status);

		NanomsgClienthandler(lcmdbusclient_tclAppMain* baseRef);
	private:
		tBool _bSrvAvailable;
		::boost::shared_ptr< NanoMsgLCMInterfaceProxy > m_poLCMDBUSProxy;
		::boost::shared_ptr< NanoMsgGenericInterfaceProxy > m_poGenericDBUSProxy;
		void vSendWakeupReason(uint32 u32wakeReason);
		tclEntityInfo *m_pEntityInfo;
		bool m_bParseState;
		void vRspGetVoltageSignal(uint8 u8Idx, entVoltageLevel eVoltageLevel);
		void vRspGetThermalSignal(uint8 u8Idx, entThermalState eTemperatureLevel);

		/********************* WORK-AROUND for converting Device Number ******************************/
		uint8 enGetDeviceNumber(enDevID eDevID);
		uint8 u8GetDeviceID(const std::string Devname);
		uint8 GetIPLastByte(std::string DevIP);
		//uint8 enGetDeviceID(enDevID eDevID);
	};
   
}}}}


#endif



