/****************************************************************************
* Copyright (C) Robert Bosch Car Multimedia GmbH, 2015
* This software is property of Robert Bosch GmbH. Unauthorized
* duplication and disclosure to third parties is prohibited.
*
* FILE                : 
* COMPONENT Name      : 
* DESCRIPTION         : 
* AUTHOR              : kad3cob
* Revision History    : 2.0
* Date 06.01.2023     : 
****************************************************************************/
//#include "asf/core/ThreadBridge.h"
#include "stdio.h"
#include <iostream>
#include <string>
#include <list>
#include<map>
// Include common fi interface

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

// lcmdbusclient_NanomsgIncludePart: user specific code start
#include "I_lcmdbusclient_ServiceLcmDbusClientIf.h"
#include "NanomsgClienthandler.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_LCMDBUSCLIENT_SERVER_LCMDBUSCLIENT
#include "trcGenProj/Header/NanomsgClienthandler.cpp.trc.h"
#endif

namespace org { namespace bosch { namespace cm { namespace lcmdbusclient {
using namespace::asf::stream;
using namespace ::bosch::cm::di::NanoMsgLCMInterface;
using namespace ::bosch::cm::di::NanoMsgGenericInterface;


uint8 u8CMCPwrMode		= 0;				//CM-C power mode used in mapping table for sub-systems
tU32 u32GlobalTick		= 0;
uint8 u8Index_CMC 		= 0x00;				//This variable hold the index of the CM-C, it contains always 0x00   
uint8 u8Idx_CMA_PRIMARY = 1;				//This variable hold the index of the CM-A. Default it initialized with 1. Later this will be updated during parsing 

uint8 u8FlagWakeupReason = NOT_RECEIVED;	//This flag varibale shall be used identify whether wakeup reason is received or not.
uint8 u8FlagVoltageState = NOT_RECEIVED;	//This flag varibale shall be used identify whether voltage state is received or not.

struct stSubSystemStatus SubSystemData[MAX_SUBSYSTEM];

const uint8 caubSubsystemMap[DEV_Type_MAX][CMCPwrMode_MAX] =
{
        //       	OFF                                 ON                       		        BACKGROUND                  		      STANDBY               		     STATEPROFILE        			      PREPARESHUTDOWN              			        SHUTDOWN                            IGNITION                             DOOR_OPEN                                        SAFE                      		        MMI_STANDBY                                  DIAGNOSIS                                DOWNLOAD                                	MMI_ON                              MMI_ON_TEL                         MMI_STANDBY_PWR_SAVE_2			   MMI_ON_SWDL
	{entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_Undefined,		entPowerMode__enPowerMode_Undefined,		entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined},	/* NO-SUBSYSTEM Assigned */
	{entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined,  	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_Undefined, 		entPowerMode__enPowerMode_Undefined,		entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined},	/* enDevID__enDevID_Media_Center */
    {entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_ON,        	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_User_Off,	    entPowerMode__enPowerMode_ON,		    entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_User_Off,  	entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_Protected_Off,	entPowerMode__enPowerMode_ON,			    entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_ON,           entPowerMode__enPowerMode_ON,		    entPowerMode__enPowerMode_OFF, 		    entPowerMode__enPowerMode_User_Off},	/*enDevID__enDevID_Media_Apm */
    {entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_ON,        	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_User_Off,  	entPowerMode__enPowerMode_User_Off,  	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_User_Off,  	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Protected_Off,	entPowerMode__enPowerMode_Undefined,		entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_User_Off,	    entPowerMode__enPowerMode_ON,		    entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_User_Off},	/* enDevID__enDevID_Media_Router */
    {entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_ON,        	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_User_Off,  	entPowerMode__enPowerMode_User_Off,  	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_User_Off,  	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Protected_Off,	entPowerMode__enPowerMode_Undefined,		entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_User_Off,	    entPowerMode__enPowerMode_ON,		    entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_User_Off}, 	/* enDevID__enDevID_Media_HDTV */
    {entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_ON,        	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_User_Off,  	entPowerMode__enPowerMode_ON,        	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_User_Off,  	entPowerMode__enPowerMode_Undefined,    entPowerMode__enPowerMode_Protected_Off,	entPowerMode__enPowerMode_ON,			    entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_ON,		    entPowerMode__enPowerMode_ON,		    entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_User_Off}, 	/*enDevID__enDevID_Media_CamPort*/
    {entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_ON,        	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_User_Off,  	entPowerMode__enPowerMode_User_Off,  	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_User_Off,  	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Protected_Off,	entPowerMode__enPowerMode_Undefined,		entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_User_Off,	    entPowerMode__enPowerMode_ON,		    entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_User_Off},	/*enDevID__enDevID_Media_Glass*/
	{entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined,		entPowerMode__enPowerMode_Undefined,		entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined}, 	/* enDevID__enDevID_Media_ControlPanel */
	{entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined,		entPowerMode__enPowerMode_Undefined,		entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined}, 	/* enDevID__enDevID_Intercom */
	{entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined,		entPowerMode__enPowerMode_Undefined,		entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined}, 	/* enDevID__enDevID_Swivel_Holder */
	{entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined,		entPowerMode__enPowerMode_Undefined,		entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_Undefined,	entPowerMode__enPowerMode_Undefined, 	entPowerMode__enPowerMode_Undefined} 	/* enDevID__enDevID_TestBed */
};


/************************************************
Function 	: Constructor
Parameters 	:
Description : This function is called when list request is called
SYSFL/SWFL : CRQ-createProxy
************************************************/

NanomsgClienthandler::NanomsgClienthandler(lcmdbusclient_tclAppMain* baseRef)
:INanomsgClienthandler(baseRef)
,_bSrvAvailable(FALSE)
,_NanomsgTimeMSec(LCM_BASE_TIMER_MS)
,m_poLCMDBUSProxy(NanoMsgLCMInterfaceProxy::createProxy("NanoMsgLCMPort",*this))
,m_poGenericDBUSProxy(NanoMsgGenericInterfaceProxy::createProxy("NanoMsgGenericPort",*this))
{
	ETG_TRACE_USR4(("NanomsgClienthandler Constructor is called"));
	if(m_poGenericDBUSProxy == NULL)
	{
		ETG_TRACE_FATAL( ( "ERROR: m_poGenericDBUSProxy is NULL"));
	}
	if(m_poLCMDBUSProxy == NULL)
	{
		ETG_TRACE_FATAL( ( "ERROR: m_poLCMDBUSProxy is NULL"));
	}
	
	_u8MaxNumOfSubSystem	= 0;
	m_bParseState			= false;
	u8CMCPwrMode			= CMCPwrMode_OFF;
	m_pEntityInfo			= tclAvRoutingParser::pGetInstance();
	if (m_pEntityInfo != NULL)
	{
		ETG_TRACE_USR4(("tclAvRoutingParser instance available"));
		uint8 u8Index = 0;
		m_bParseState = m_pEntityInfo->bParseXml();
		if(m_bParseState)
		{
			std::multimap<std::string,std::string>DeviceList = m_pEntityInfo->mapGetCompleteDeviceList();
			std::multimap<std::string,std::string>::iterator itList;
			
			initSubsystemerrorState(0, enDevID__enDevID_Media_Center);
			
			for(itList=DeviceList.begin();(_u8MaxNumOfSubSystem < MAX_SUBSYSTEM)&& (itList != DeviceList.end());itList++)
			{
				uint8 u8DevID 			= u8GetDeviceID(itList->first);
				uint8 u8DevIP_LastByte	= GetIPLastByte(itList->second);
				if(u8DevID != 0xFF)
				{
					SubSystemData[u8Index].DeviceID					= (enDevID)u8DevID;
					SubSystemData[u8Index].DeviceIPAddress			= itList->second;
					SubSystemData[u8Index].IPLastByte				= u8DevIP_LastByte;
					SubSystemData[u8Index].ExpectedPwrMode			= (entPowerMode)0;
					SubSystemData[u8Index].ReceivedPwrMode			= (entPowerMode)0;
					SubSystemData[u8Index].u8HealthcareReqCount		= 0;
					SubSystemData[u8Index].u8PWRModeMismatchCount	= 0;
					SubSystemData[u8Index].u8SelfProtectionFlg		= FLAG_CLEAR;
					SubSystemData[u8Index].u8ThermProtOffFlg		= FLAG_CLEAR;
					SubSystemData[u8Index].u8VoltProtOffFlg			= FLAG_CLEAR;
					SubSystemData[u8Index].u16VoltageState			= 0;
					SubSystemData[u8Index].u16VoltageValue			= 0;
					SubSystemData[u8Index].u16ThermalState			= 0;
					SubSystemData[u8Index].u16ThermalValue			= 0;
					
					initSubsystemerrorState(u8DevIP_LastByte, u8DevID);
					
					_u8MaxNumOfSubSystem++;
					ETG_TRACE_USR4(("NanomsgClienthandler::NanomsgClienthandler eDevID = %d  IP = %s",SubSystemData[u8Index].DeviceID, SubSystemData[u8Index].DeviceIPAddress.c_str()));
					u8Index++;
				}
				else
				{
					ETG_TRACE_USR4(("Error: Device ID NOT found. Device name %s",std::string(itList->first ))); 
				}
			}
			u8Idx_CMA_PRIMARY  = u8GetID(enDevID__enDevID_Media_Apm);
			ETG_TRACE_USR4(("NanomsgClienthandler::NanomsgClienthandler _u8MaxNumOfSubSystem = %d",_u8MaxNumOfSubSystem));
		}
		else
		{
			ETG_TRACE_FATAL(("ERROR: AvRoutingParser failed"));
		}
	} 
	else
	{
		ETG_TRACE_FATAL(("ERROR: tclAvRoutingParser instance NOT available"));
	}

	_u32RxMsgStatus 			= FLAG_CLEAR;
	_u8NanomsgErrorflag			= FLAG_CLEAR;
	_bIgnitionStatus			= IGN_INACTIVE;
	_bDoorUnlockStatus			= DOORUNLOCK_INACTIVE;
	_u8PNMGRP10Statusflag 		= PNM_LOW_VOLT_INACTIVE;   //when PNMGRP10 signal is active value is 0 and if PNMGRP10 signal is inactive value is 1
}

NanomsgClienthandler::~NanomsgClienthandler()
{
	ETG_TRACE_USR4(("NanomsgClienthandler Destructor is called"));
}

//This function Send the wakeup reason received from CM-A through Nanomessage to LCM statemachine
void NanomsgClienthandler::vSendWakeupReason(uint32 u32wakeReason)
{
	ETG_TRACE_USR4(("NanomsgClienthandler::vSendWakeupReason wakeUpReason = %s", WAKEUP_REASON(u32wakeReason)));
	Ilcmdbusclient_tclServiceLcmDbusClientIf* pSrv = dynamic_cast<Ilcmdbusclient_tclServiceLcmDbusClientIf*>(_cpoMain->getHandler("Ilcmdbusclient_tclServiceLcmDbusClientIf"));
	if (!pSrv)
	{
		ETG_TRACE_FATAL(( "ERROR: NanomsgClienthandler::vSendWakeupReason LCMDbusClient interface is NULL"));
	}

	bool bIgnStatus_New = u32wakeReason & entWakeupReason__entWakeupReason_IGN_In;
	if (_bIgnitionStatus != bIgnStatus_New) // Check whether Ignition status changed
	{
		_bIgnitionStatus = bIgnStatus_New;	
		pSrv->sendNanomsgStatusStatus(_bIgnitionStatus);
		ETG_TRACE_USR4(("NanomsgClienthandler::vSendWakeupReason CM-A Ignition: %d", _bIgnitionStatus));
	}
	bool bDoorUnlockStatus_New = u32wakeReason & entWakeupReason__entWakeupReason_Door_status;
	if (_bDoorUnlockStatus != bDoorUnlockStatus_New)	// Check whether Door Unlock status changed
	{
		_bDoorUnlockStatus = bDoorUnlockStatus_New;
		pSrv->sendDoorUnlockStatusStatus(_bDoorUnlockStatus);
		ETG_TRACE_USR4(("NanomsgClienthandler::vSendWakeupReason CM-A DoorUnlock: %d", _bDoorUnlockStatus));
	}
	
	m_poGenericDBUSProxy->sendReqGetVoltageRequest(*this, enDevID__enDevID_Media_Apm, 40, MSG_ID_ReqGetVoltage, entVoltageSensor__entVoltageSensor_BatterySensor, SubSystemData[u8Idx_CMA_PRIMARY].DeviceIPAddress);
	ETG_TRACE_USR4(("NanomsgClienthandler::onSig_RspGetWakeupReasonSignal sending sendReqGetVoltageRequest"));
}

void NanomsgClienthandler::onReqGetPowerModeError(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqGetPowerModeError >& error){}
void NanomsgClienthandler::onReqGetPowerModeResponse(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqGetPowerModeResponse >& response){}
void NanomsgClienthandler::onReqGetWakeupReasonError(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqGetWakeupReasonError >& error){}
void NanomsgClienthandler::onReqGetWakeupReasonResponse(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqGetWakeupReasonResponse >& response){}
void NanomsgClienthandler::onReqSetPowerModeError(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqSetPowerModeError >& error){}
void NanomsgClienthandler::onReqSetPowerModeResponse(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqSetPowerModeResponse >& response){}
void NanomsgClienthandler::onReqShutdownError(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqShutdownError >& error){}
void NanomsgClienthandler::onReqShutdownResponse(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqShutdownResponse >& response){}
void NanomsgClienthandler::onSig_EventPowerModeChangeError(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_EventPowerModeChangeError >& error){}
void NanomsgClienthandler::onReqGetDigitalInputError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqGetDigitalInputError >& error){}
void NanomsgClienthandler::onReqGetDigitalInputResponse(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqGetDigitalInputResponse >& response){}
void NanomsgClienthandler::onSig_EventDigitalInputError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_EventDigitalInputError >& error){}
void NanomsgClienthandler::onSig_EventDigitalInputSignal(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_EventDigitalInputSignal >& signal)
{
	ETG_TRACE_USR4(("NanomsgClienthandler::onSig_EventDigitalInputSignal"));
	if (signal != NULL)
	{	
		u8FlagWakeupReason = RECEIVED;
		uint32 u32WakeUpReasonData = signal->getDigitalInput();
		vSendWakeupReason(u32WakeUpReasonData);
	}
	else
	{
		ETG_TRACE_FATAL(( "ERROR: NanomsgClienthandler::onSig_EventDigitalInputSignal signal"));		
	}	
}
void NanomsgClienthandler::onSig_RspGetDigitalInputError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspGetDigitalInputError >& error){}
void NanomsgClienthandler::onSig_RspGetDigitalInputSignal(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspGetDigitalInputSignal >& signal)
{
	ETG_TRACE_USR4(("NanomsgClienthandler::onSig_RspGetDigitalInputSignal"));
	if (signal != NULL)
	{		
		u8FlagWakeupReason = RECEIVED;
		uint32 u32WakeUpReasonData = signal->getDigitalInput();
		vSendWakeupReason(u32WakeUpReasonData);
	}
	else
	{
		ETG_TRACE_FATAL(( "ERROR: NanomsgClienthandler::onSig_RspGetDigitalInputSignal signal"));		
	}	
}
void NanomsgClienthandler::onSig_EventPowerModeChangeSignal(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_EventPowerModeChangeSignal >& signal)
{	
	if (signal != NULL)
	{
		enDevID eDevID = signal->getDev_ID();
		uint8 u8DevNr = signal->getDev_Nr();
		std::string sIPAddr = signal->getRecevedIP();
		entPowerMode ePowerMode = signal->getPowerMode();
		ETG_TRACE_USR4(("NanomsgClienthandler::onSig_EventPowerModeChangeSignal eDevID = %d, u8DevNr = %d, CISPwrMode = %d, IP = %s", eDevID, u8DevNr, ePowerMode,sIPAddr.c_str()));
		vHandleReceivedPowerMode(eDevID,  u8DevNr,  sIPAddr, ePowerMode, EVENT_PWRMODE_CHANGE );
	}
	else
	{
		ETG_TRACE_FATAL(( "ERROR: NanomsgClienthandler::onSig_EventPowerModeChangeSignal signal"));		
	}
}

void NanomsgClienthandler::onSig_RspGetPowerModeError(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspGetPowerModeError >& error){}
void NanomsgClienthandler::onSig_RspGetPowerModeSignal(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspGetPowerModeSignal >& signal){}
void NanomsgClienthandler::onSig_RspGetWakeupReasonError(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspGetWakeupReasonError >& error){}
void NanomsgClienthandler::onSig_RspGetWakeupReasonSignal(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspGetWakeupReasonSignal >& signal)
{
	ETG_TRACE_USR4(("NanomsgClienthandler::onSig_RspGetWakeupReasonSignal"));
	if (signal != NULL)
	{	
		u8FlagWakeupReason = RECEIVED;
		uint32 u32WakeUpReasonData = signal->getWakeupReason();
		vSendWakeupReason(u32WakeUpReasonData);
	}
	else
	{
		ETG_TRACE_FATAL(( "ERROR: NanomsgClienthandler::onSig_RspGetWakeupReasonSignal"));		
	}	
}

void NanomsgClienthandler::onSig_RspSetPowerModeError(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspSetPowerModeError >& error){}
void NanomsgClienthandler::onSig_RspSetPowerModeSignal(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspSetPowerModeSignal >& signal)
{
	if (signal != NULL)
	{
		uint16 u16MsgID = signal->getMsg_ID();
		enDevID eDevID = signal->getDev_ID();
		uint8 u8DevNr = signal->getDev_Nr();
		std::string sIPAddr = signal->getRecevedIP();
		uint16 u16Status = signal->getStatus();
		if(u16Status == eniRet__eniRet_Ok)
		{
			ETG_TRACE_USR4(("NanomsgClienthandler::onSig_RspSetPowerModeSignal Status = SUCCESS eDevID = %d, u8DevNr = %d, IP = %s", eDevID, u8DevNr, sIPAddr.c_str()));
		}
		else{
			ETG_TRACE_USR4(("NanomsgClienthandler::onSig_RspSetPowerModeSignal Status = ERROR eDevID = %d, u8DevNr = %d, IP = %s", eDevID, u8DevNr, sIPAddr.c_str()));
		}
		
	}
	else
	{
		ETG_TRACE_FATAL(( "ERROR: NanomsgClienthandler::onSig_RspSetPowerModeSignal signal"));		
	}
}
void NanomsgClienthandler::onSig_RspShutdownError(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspShutdownError >& error){}
void NanomsgClienthandler::onSig_RspShutdownSignal(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspShutdownSignal >& signal)
{
	if (signal != NULL)
	{
		uint16 u16MsgID = signal->getMsg_ID();
		enDevID eDevID = signal->getDev_ID();
		uint8 u8DevNr = signal->getDev_Nr();
		std::string sIPAddr = signal->getRecevedIP();
		uint16 u16Status = signal->getStatus();
	}
	else
	{
		ETG_TRACE_FATAL(( "ERROR: NanomsgClienthandler::onSig_RspShutdownSignal signal"));		
	}
}
void NanomsgClienthandler::onReqCMGSvivelPositionError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqCMGSvivelPositionError >& error){}
void NanomsgClienthandler::onReqCMGSvivelPositionResponse(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqCMGSvivelPositionResponse >& response){}
void NanomsgClienthandler::onSig_RspCMGSvivelPositionError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspCMGSvivelPositionError >& error){}
void NanomsgClienthandler::onSig_RspCMGSvivelPositionSignal(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspCMGSvivelPositionSignal >& signal){}
void NanomsgClienthandler::onEventVoltageError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< EventVoltageError >& error){}
void NanomsgClienthandler::onEventVoltageSignal(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< EventVoltageSignal >& signal)
{
	if (signal != NULL)
	{
		std::string sIPAddr = signal->getReceivedIP();
		uint8 u8Idx = u8GetSubSystemIndex(sIPAddr);

		if(SubSystemData[u8Idx].DeviceID == DEV_MediaAmplifier)
			u8FlagVoltageState = RECEIVED;

		ETG_TRACE_USR4(("NanomsgClienthandler::onEventVoltageSignal u8VoltageValueData = %d, eVoltageLevel = %d, eVoltageSensor = %d, eDevID = %d, IP = %s  ", signal->getVoltageValue(),signal->getVoltageLevel(),signal-> getVoltageSensor(),SubSystemData[u8Idx].DeviceID,sIPAddr.c_str()));
		vRspGetVoltageSignal(u8Idx, signal->getVoltageLevel());
	}
	else
	{
		ETG_TRACE_FATAL(( "ERROR: NanomsgClienthandler::onEventVoltageSignal signal"));		
	}
}
void NanomsgClienthandler::onReqGetVoltageError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqGetVoltageError >& error){}
void NanomsgClienthandler::onReqGetVoltageResponse(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqGetVoltageResponse >& response){}
void NanomsgClienthandler::onRspGetVoltageError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< RspGetVoltageError >& error){}
void NanomsgClienthandler::onRspGetVoltageSignal(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< RspGetVoltageSignal >& signal)
{
	if (signal != NULL)
	{
		std::string sIPAddr = signal->getReceivedIP(); 
		uint8 u8Idx = u8GetSubSystemIndex(sIPAddr);
		if(SubSystemData[u8Idx].DeviceID == DEV_MediaAmplifier)
		u8FlagVoltageState = RECEIVED;
		ETG_TRACE_USR4(("NanomsgClienthandler::onRspGetVoltageSignal u8VoltageValueData = %d, eVoltageLevel = %d, eVoltageSensor=%d, eDevID = %d, IP = %s ", signal->getVoltageValue(),signal->getVoltageLevel(),signal-> getVoltageSensor(),SubSystemData[u8Idx].DeviceID,sIPAddr.c_str()));
		vRspGetVoltageSignal(u8Idx, signal->getVoltageLevel());
	}
	else
	{
		ETG_TRACE_FATAL(( "ERROR: NanomsgClienthandler::onRspGetVoltageSignal signal"));		
	}
}
void NanomsgClienthandler::onReqGetThermalStateError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqGetThermalStateError >& error){}
void NanomsgClienthandler::onReqGetThermalStateResponse(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqGetThermalStateResponse >& response){}
void NanomsgClienthandler::onEventThermalStateError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< EventThermalStateError >& error){}
void NanomsgClienthandler::onEventThermalStateSignal(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< EventThermalStateSignal >& signal)
{
	if (signal != NULL)
	{
		std::string sIPAddr = signal->getReceivedIP();
		uint8 u8Idx = u8GetSubSystemIndex(sIPAddr);
		uint16 u16TemperatureValueData = signal->getTemperature();
		entThermalState eTemperatureLevel = signal->getThermalState();
		entThermalSensorID eThermalSensor = signal-> getThermalSensorID();
		ETG_TRACE_USR4(("NanomsgClienthandler::onEventThermalStateSignal u16TemperatureValueData = %d, eTemperatureLevel = %d, eThermalSensor = %d, eDevID = %d, IP = %s", u16TemperatureValueData,eTemperatureLevel,eThermalSensor,SubSystemData[u8Idx].DeviceID,sIPAddr.c_str()));
		vRspGetThermalSignal(u8Idx, eTemperatureLevel);
	}
	else
	{
		ETG_TRACE_FATAL(( "ERROR: NanomsgClienthandler::onEventThermalStateSignal signal"));		
	}
}
void NanomsgClienthandler::onRspGetThermalStateError(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< RspGetThermalStateError >& error){}
void NanomsgClienthandler::onRspGetThermalStateSignal(const ::boost::shared_ptr< NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< RspGetThermalStateSignal >& signal)
{
	if (signal != NULL)
	{
		std::string sIPAddr = signal->getReceivedIP();
		uint8 u8Idx = u8GetSubSystemIndex(sIPAddr);
		uint16 u16TemperatureValueData = signal->getTemperature();
		entThermalState eTemperatureLevel = signal->getThermalState();
		entThermalSensorID eThermalSensor = signal-> getThermalSensorID();
		ETG_TRACE_USR4(("NanomsgClienthandler::onRspGetThermalStateSignal u16TemperatureValueData = %d, eTemperatureLevel = %d, eThermalSensor = %d, eDevID = %d, IP = %s", u16TemperatureValueData,eTemperatureLevel,eThermalSensor,SubSystemData[u8Idx].DeviceID,sIPAddr.c_str()));
		vRspGetThermalSignal(u8Idx, eTemperatureLevel);
	}			
	else
	{
		ETG_TRACE_FATAL(( "ERROR: NanomsgClienthandler::onRspGetThermalStateSignal signal"));		
	}
}

void NanomsgClienthandler::vRspGetVoltageSignal(uint8 u8Idx, entVoltageLevel eVoltageLevel)
{
	ETG_TRACE_USR4(("NanomsgClienthandler::vRspGetVoltageSignal Voltagelevel = %s",VOLT_LEVEL(eVoltageLevel)));
	Ilcmdbusclient_tclServiceLcmDbusClientIf* pSrv = dynamic_cast<Ilcmdbusclient_tclServiceLcmDbusClientIf*>(_cpoMain->getHandler("Ilcmdbusclient_tclServiceLcmDbusClientIf"));
	if(!pSrv)
	{
		ETG_TRACE_FATAL(("ERROR: NanomsgClienthandler::vRspGetVoltageSignal" ));
		return;
	}	
	
	switch(eVoltageLevel)
	{
		case entVoltageLevel__entVoltage_Undefined:
		break;
			
		case entVoltageLevel__entVoltage_OverCritical_1:		//Voltage range above 36V
		{
			SubSystemData[u8Idx].u8VoltProtOffFlg = FLAG_SET;
			UpdateError(u8Idx+1,(uint8)ERR_VOLTAGE,(uint8)DEV_OVER_CRITICAL_VOLTAGE);
			if(SubSystemData[u8Idx].DeviceID == enDevID__enDevID_Media_Apm)
			{
				pSrv->sendVoltagelevelStatusStatus(eVoltageLevel);
			}
			pSrv->sendSubsystemerrorStatusStatus(getSubsystemerrorState());
		}
		break;
		
		case entVoltageLevel__entVoltage_OverWarning_2:			//Voltage range 32V-36V
		{
			SubSystemData[u8Idx].u8VoltProtOffFlg = FLAG_SET;
			UpdateError(u8Idx+1,(uint8)ERR_VOLTAGE,(uint8)DEV_OVER_WARNING_VOLTAGE);
			if(SubSystemData[u8Idx].DeviceID == enDevID__enDevID_Media_Apm)
			{				
				pSrv->sendVoltagelevelStatusStatus(eVoltageLevel);
			}
			pSrv->sendSubsystemerrorStatusStatus(getSubsystemerrorState());
		}
		break;
			
		case entVoltageLevel__entVoltage_Normal:			//Voltage range 17V-32V
		{
			SubSystemData[u8Idx].u8VoltProtOffFlg = FLAG_CLEAR;
			UpdateError(u8Idx+1,(uint8)ERR_VOLTAGE,(uint8)DEV_NO_ERROR);
			if(SubSystemData[u8Idx].DeviceID == enDevID__enDevID_Media_Apm)
			{		
				pSrv->sendVoltagelevelStatusStatus(eVoltageLevel);
			}
			pSrv->sendSubsystemerrorStatusStatus(getSubsystemerrorState());
		}
		break;
		
		case entVoltageLevel__entVoltage_UnderWarning_3:		//Voltage range 14V-17V
		{
			SubSystemData[u8Idx].u8VoltProtOffFlg = FLAG_CLEAR;
			UpdateError(u8Idx+1,(uint8)ERR_VOLTAGE,(uint8)DEV_UNDER_WARNING_VOLTAGE);
			if(SubSystemData[u8Idx].DeviceID == enDevID__enDevID_Media_Apm)
			{		
				pSrv->sendVoltagelevelStatusStatus(eVoltageLevel);
			}
			pSrv->sendSubsystemerrorStatusStatus(getSubsystemerrorState());
		}
		break;
		case entVoltageLevel__entVoltage_UnderCritical:			//Voltage range less than 14V
		{
			SubSystemData[u8Idx].u8VoltProtOffFlg = FLAG_SET;
			UpdateError(u8Idx+1,(uint8)ERR_VOLTAGE,(uint8)DEV_UNDER_CRITICAL_VOLTAGE);
			if(SubSystemData[u8Idx].DeviceID == enDevID__enDevID_Media_Apm)
			{		
				pSrv->sendVoltagelevelStatusStatus(eVoltageLevel);
			}
			pSrv->sendSubsystemerrorStatusStatus(getSubsystemerrorState());
		}
		break;
		default:
		{
			ETG_TRACE_USR4(("NanomsgClienthandler::vRspGetVoltageSignal:No action for voltage handling"));
	
		}
		break;
	}
	if((SubSystemData[u8Idx].u8ThermProtOffFlg == NOT_SET)&&(SubSystemData[u8Idx].u8VoltProtOffFlg == NOT_SET))
	{
		SubSystemData[u8Idx].u8SelfProtectionFlg = FLAG_CLEAR;
	}
}


void NanomsgClienthandler::vRspGetThermalSignal(uint8 u8Idx, entThermalState eTemperatureLevel)
{
	ETG_TRACE_USR4(("NanomsgClienthandler::vRspGetThermalSignal Thermallevel = %s",THERMAL_LEVEL(eTemperatureLevel)));
	Ilcmdbusclient_tclServiceLcmDbusClientIf* pSrv = dynamic_cast<Ilcmdbusclient_tclServiceLcmDbusClientIf*>(_cpoMain->getHandler("Ilcmdbusclient_tclServiceLcmDbusClientIf"));
	if(!pSrv)
	{
		ETG_TRACE_FATAL(("ERROR: NanomsgClienthandler::vRspGetThermalSignal" ));
		return;
	}
	switch(eTemperatureLevel)
	{
		case entThermalState__entUndefined:
		break;
		
		case entThermalState__entOver:
		{
			UpdateError(u8Idx+1,(uint8)ERR_THERMAL,(uint8)DEV_OVER_CRITICAL_THERMAL);
			SubSystemData[u8Idx].u8ThermProtOffFlg = FLAG_SET;
			if(SubSystemData[u8Idx].DeviceID == enDevID__enDevID_Media_Apm)
			{
				pSrv->sendThermallevelStatusStatus(eTemperatureLevel);	
			}
			pSrv->sendSubsystemerrorStatusStatus(getSubsystemerrorState());
		}
		break;
		
		case entThermalState__entCritical_High:
		{
			UpdateError(u8Idx+1,(uint8)ERR_THERMAL,(uint8)DEV_CRITICAL_THERMAL);
			if(SubSystemData[u8Idx].u8ThermProtOffFlg != SET) //Flag should be cleared only when thermal goes to High. (Hysterisis)
			{
				SubSystemData[u8Idx].u8ThermProtOffFlg = FLAG_CLEAR;
			}
			if(SubSystemData[u8Idx].DeviceID == enDevID__enDevID_Media_Apm)
			{
				pSrv->sendThermallevelStatusStatus(eTemperatureLevel);	
			}
			pSrv->sendSubsystemerrorStatusStatus(getSubsystemerrorState());
		}
		break;
		
		case entThermalState__entHigh:
		{
			UpdateError(u8Idx+1,(uint8)ERR_THERMAL,(uint8)DEV_HIGH_THERMAL);
			SubSystemData[u8Idx].u8ThermProtOffFlg = FLAG_CLEAR;
			if(SubSystemData[u8Idx].DeviceID == enDevID__enDevID_Media_Apm)
			{
				pSrv->sendThermallevelStatusStatus(eTemperatureLevel);	
			}
			pSrv->sendSubsystemerrorStatusStatus(getSubsystemerrorState());
		}
		break;
		
		case entThermalState__entNormal:
		{
			UpdateError(u8Idx+1,(uint8)ERR_THERMAL,(uint8)DEV_NO_ERROR);
			SubSystemData[u8Idx].u8ThermProtOffFlg = FLAG_CLEAR;
			if(SubSystemData[u8Idx].DeviceID == enDevID__enDevID_Media_Apm)
			{
				pSrv->sendThermallevelStatusStatus(eTemperatureLevel);	
			}
			pSrv->sendSubsystemerrorStatusStatus(getSubsystemerrorState());
		}
		break;
		
		case entThermalState__entLow:
		{
			UpdateError(u8Idx+1,(uint8)ERR_THERMAL,(uint8)DEV_LOW_THERMAL);
			SubSystemData[u8Idx].u8ThermProtOffFlg = FLAG_CLEAR;
			if(SubSystemData[u8Idx].DeviceID == enDevID__enDevID_Media_Apm)
			{
				pSrv->sendThermallevelStatusStatus(eTemperatureLevel);	
			}
			pSrv->sendSubsystemerrorStatusStatus(getSubsystemerrorState());
		}
		break;
		
		case entThermalState__entCritical_low:
		{
			UpdateError(u8Idx+1,(uint8)ERR_THERMAL,(uint8)DEV_CRITICAL_LOW_THERMAL);
			if(SubSystemData[u8Idx].u8ThermProtOffFlg != SET) //Flag should be cleared only when thermal goes to High. (Hysterisis)
			{
				SubSystemData[u8Idx].u8ThermProtOffFlg = FLAG_CLEAR;
			}
			if(SubSystemData[u8Idx].DeviceID == enDevID__enDevID_Media_Apm)
			{
				pSrv->sendThermallevelStatusStatus(eTemperatureLevel);	
			}
			pSrv->sendSubsystemerrorStatusStatus(getSubsystemerrorState());
		}
		break;
		
		case entThermalState__entUnder:
		{
			UpdateError(u8Idx+1,(uint8)ERR_THERMAL,(uint8)DEV_UNDER_CRITICAL_LOW_THERMAL);
			SubSystemData[u8Idx].u8ThermProtOffFlg = FLAG_SET;
			if(SubSystemData[u8Idx].DeviceID == enDevID__enDevID_Media_Apm)
			{
				pSrv->sendThermallevelStatusStatus(eTemperatureLevel);	
			}
			pSrv->sendSubsystemerrorStatusStatus(getSubsystemerrorState());
		}
		break;
		
		default:
		{
			ETG_TRACE_USR4(("NanomsgClienthandler::vRspGetThermalSignal:No action for Thermal handling"));
		}
		break;
	}
	if((SubSystemData[u8Idx].u8ThermProtOffFlg == NOT_SET)&&(SubSystemData[u8Idx].u8VoltProtOffFlg == NOT_SET))
	{
		SubSystemData[u8Idx].u8SelfProtectionFlg = FLAG_CLEAR;
	}
}

void NanomsgClienthandler::onReqHealthCareError(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqHealthCareError >& error){}
void NanomsgClienthandler::onReqHealthCareResponse(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqHealthCareResponse >& response){}
void NanomsgClienthandler::onSig_RspHealthCareError(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspHealthCareError >& error){}
void NanomsgClienthandler::onSig_RspHealthCareSignal(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspHealthCareSignal >& signal)
{
	if (signal != NULL)
	{		
		enDevID eDevID = signal->getDev_ID();
		uint8 u8DevNr = signal->getDev_Nr();
		std::string sIPAddr = signal->getRecevedIP();
		uint8 u8Idx = u8GetSubSystemIndex(sIPAddr);
		entPowerMode ePowerMode = signal->getPowerMode();
		ETG_TRACE_USR4(("NanomsgClienthandler::onSig_RspHealthCareSignal eDevID = %d, u8DevNr = %d, CISPwrMode = %d, IP=%s", eDevID, u8DevNr, ePowerMode,sIPAddr.c_str()));
		vHandleReceivedPowerMode(eDevID, u8DevNr, sIPAddr, ePowerMode, HEALTHCARE_RESPONSE);
		SubSystemData[u8Idx].u8HealthcareReqCount = 0;	//If healthcare message is not received for some time, that also needs to be considered as Nanomessag error.
	}
	else
	{
		ETG_TRACE_FATAL(( "ERROR: NanomsgClienthandler::onSig_RspHealthCareSignal signal"));		
	}
	
}	 
void NanomsgClienthandler::onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange)
{
	if (m_poLCMDBUSProxy == proxy)
	{
		ETG_TRACE_USR4(("NanomsgClienthandler::onAvailable m_poLCMDBUSProxy"));
		_bSrvAvailable = TRUE;
		_NanomsgTimer.start(*this, _NanomsgTimeMSec, 0);//TODO:: To be started in Background Mode??
		Ilcmdbusclient_tclServiceLcmDbusClientIf* pSrv = dynamic_cast<Ilcmdbusclient_tclServiceLcmDbusClientIf*>(_cpoMain->getHandler("Ilcmdbusclient_tclServiceLcmDbusClientIf"));
		if(!pSrv)
		{
			ETG_TRACE_FATAL(("ERROR: NanomsgClienthandler::onAvailable" ));
			return;
		}
		/* Register for the interested property */
		m_poLCMDBUSProxy->sendSig_RspSetPowerModeRegister(*this);
		m_poLCMDBUSProxy->sendSig_EventPowerModeChangeRegister(*this);
		m_poLCMDBUSProxy->sendSig_RspGetWakeupReasonRegister(*this);
		m_poLCMDBUSProxy->sendSig_RspShutdownRegister(*this);
		m_poLCMDBUSProxy->sendSig_RspHealthCareRegister(*this);
	}
	if(m_poGenericDBUSProxy==proxy)
	{
		ETG_TRACE_USR4(("NanomsgClienthandler::onAvailable: m_poGenericDBUSProxy"));
		m_poGenericDBUSProxy->sendSig_EventDigitalInputRegister(*this);
		m_poGenericDBUSProxy->sendSig_RspGetDigitalInputRegister(*this);
		m_poGenericDBUSProxy->sendRspGetVoltageRegister(*this);
		m_poGenericDBUSProxy->sendEventVoltageRegister(*this);
		m_poGenericDBUSProxy->sendSig_RspCMGSvivelPositionRegister(*this);
		m_poGenericDBUSProxy->sendRspGetThermalStateRegister(*this);
		m_poGenericDBUSProxy->sendEventThermalStateRegister(*this);
	}		
   _u32RxMsgStatus = FLAG_CLEAR;
	if (u8FlagWakeupReason == NOT_RECEIVED)
	{
#ifdef USE_DIGITALINPUT
		Ilcmdbusclient_tclServiceLcmDbusClientIf* pSrv = dynamic_cast<Ilcmdbusclient_tclServiceLcmDbusClientIf*>(_cpoMain->getHandler("Ilcmdbusclient_tclServiceLcmDbusClientIf"));
		ETG_TRACE_USR4(("NanomsgClienthandler::onAvailable sendReqGetDigitalInputRequest requested IP = %s", SubSystemData[u8Idx_CMA_PRIMARY].DeviceIPAddress.c_str()));
		m_poGenericDBUSProxy->sendReqGetDigitalInputRequest(*this, enDevID__enDevID_Media_Apm, 40, MSG_ID_ReqGetDigitalInput, SubSystemData[u8Idx_CMA_PRIMARY].DeviceIPAddress);
#else
		ETG_TRACE_USR4(("NanomsgClienthandler::onAvailable sendReqGetWakeupReasonRequest requested IP = %s", SubSystemData[u8Idx_CMA_PRIMARY].DeviceIPAddress.c_str()));
		m_poLCMDBUSProxy->sendReqGetWakeupReasonRequest(*this, enDevID__enDevID_Media_Apm, 40, MSG_ID_ReqGetWakeupReason, SubSystemData[u8Idx_CMA_PRIMARY].DeviceIPAddress);
#endif
		InitDevError(_u8MaxNumOfSubSystem);
		ETG_TRACE_USR4(("NanomsgClienthandler::onAvailable Upadate to HMI for Evaluating and No_Error"));			
		pSrv->sendSubsystemerrorStatusStatus(getSubsystemerrorState());  
	}
}

void NanomsgClienthandler::onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange)
{
	(void)stateChange;    //To avoid lint warning
	if (m_poLCMDBUSProxy == proxy) 
	{
		ETG_TRACE_USR4(( "NanomsgClienthandler::onUnavailable : m_poLCMDBUSProxy" ));
	}
	if(m_poGenericDBUSProxy == proxy)
	{
		ETG_TRACE_USR4(("NanomsgClienthandler::onUnavailable: m_poGenericDBUSProxy"));
	}
	_bSrvAvailable = FALSE;
}

//Error Handling
void NanomsgClienthandler::initSubsystemerrorState(uint8 u8DevIP, uint8 u8DevID)
{
	ETG_TRACE_USR4(("NanomsgClienthandler::initSubsystemerrorState for DevID = %d  IP_LastByte = %d",u8DevID,u8DevIP));
	lcmdbusclient_fi_tclheDevInfo mDevInfo;
	mDevInfo.devId = u8DevID;
	mDevInfo.devIP= u8DevIP;
	//Initialize all error type to No error by setting appropriate bits
	mDevInfo.devError =  DEFAULT_CONDITION;   //Evaluating/Undefined condition for all errors
	Subsystemerrorconstate.SubsystemList .push_back (mDevInfo);
}
// TimerCallbackIF
void NanomsgClienthandler::onExpired(asf::core::Timer& timer, boost::shared_ptr <asf::core::TimerPayload> payload)
{
	(tVoid)timer;	//To avoid lint warning
	(tVoid)payload;	//To avoid lint warning
	ETG_TRACE_USR4(("NanomsgClienthandler::onExpired"));
	vOnTimerExpiry();
}	

/****************************************************************************
 Function       : vHandleSystemStates
 Description    : To handle SystemState
 Parameters     : System State
 Return Value   : None
 HISTORY:
 Date			 | Author			    | Modification
 	 | 
 ***************************************************************************/
void NanomsgClienthandler::vHandleSystemStates(uint8 systemState)
{
	ETG_TRACE_USR4(("NanomsgClienthandler::vHandleSystemStates() System State is %d",(uint8)systemState));
	Ilcmdbusclient_tclServiceLcmDbusClientIf* pSrv = dynamic_cast<Ilcmdbusclient_tclServiceLcmDbusClientIf*>(_cpoMain->getHandler("Ilcmdbusclient_tclServiceLcmDbusClientIf"));
	if(!pSrv)
	{
		ETG_TRACE_FATAL(("ERROR: NanomsgClienthandler::vHandleSystemStates" ));
		return;
	}
	switch(systemState)
	{
		case T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_BACKGROUND:
		{						
			ETG_TRACE_USR4(("NanomsgClienthandler::vHandleSystemStates() Background"));
    		if (u8FlagWakeupReason == NOT_RECEIVED)
			{
#ifdef USE_DIGITALINPUT
				ETG_TRACE_USR4(("NanomsgClienthandler::vHandleSystemStates() sendReqGetDigitalInputRequest requested IP=%s", SubSystemData[u8Idx_CMA_PRIMARY].DeviceIPAddress.c_str()));
				m_poGenericDBUSProxy->sendReqGetDigitalInputRequest(*this, enDevID__enDevID_Media_Apm, 40, MSG_ID_ReqGetDigitalInput, SubSystemData[u8Idx_CMA_PRIMARY].DeviceIPAddress);
#else
				ETG_TRACE_USR4(("NanomsgClienthandler::vHandleSystemStates() sendReqGetWakeupReasonRequest requested"));
				m_poLCMDBUSProxy->sendReqGetWakeupReasonRequest(*this, enDevID__enDevID_Media_Apm, 40, MSG_ID_ReqGetWakeupReason, SubSystemData[u8Idx_CMA_PRIMARY].DeviceIPAddress);
#endif
			}
			u8CMCPwrMode = CMCPwrMode_BACKGROUND;
			vSendPowerMode(CMCPwrMode_BACKGROUND);
		}
		break;
		case T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_ON:
		{	
			uint8 u8Idx = 0;
			ETG_TRACE_USR4(("NanomsgClienthandler::vHandleSystemStates() ON"));
			u8CMCPwrMode = CMCPwrMode_ON;
			vSendPowerMode(CMCPwrMode_ON);
		}
		break;
		case T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_IGNITION:
		{
			ETG_TRACE_USR4(("NanomsgClienthandler::vHandleSystemStates() Ignition /user-Off"));
			u8CMCPwrMode = CMCPwrMode_IGNITION;
			vSendPowerMode(CMCPwrMode_IGNITION);
		}
		break;
    	case T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_PREPARE_SHUTDOWN:
		{						
			ETG_TRACE_USR4(("NanomsgClienthandler::vHandleSystemStates() Prepare Shutdown"));
			/*u8CMCPwrMode = CMCPwrMode_PREPARE_SHUTDOWN;
-			vSendPowerMode(CMCPwrMode_PREPARE_SHUTDOWN);don't do anything here */
		}
		break;
    	case T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_SHUTDOWN:
		{						
			ETG_TRACE_USR4(("NanomsgClienthandler::vHandleSystemStates() Shutdown"));
			u8CMCPwrMode = CMCPwrMode_SHUTDOWN;
			vSendPowerMode(CMCPwrMode_SHUTDOWN);
       		//Clear the Condition flag of the End Station....
			for (uint8 u8Idx = 0; u8Idx < _u8MaxNumOfSubSystem; u8Idx++)
			{
				SubSystemData[u8Idx].u8SelfProtectionFlg = FLAG_CLEAR;
			}
			_NanomsgTimer.stop();
		}
		break;
    	case T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_STANDBY:
		{
			ETG_TRACE_USR4(("NanomsgClienthandler::vHandleSystemStates() Standby"));
			
			for (uint8 u8Idx = 0; u8Idx < _u8MaxNumOfSubSystem; u8Idx++)
			{
				if(SubSystemData[u8Idx].DeviceID == enDevID__enDevID_Media_Glass)
				{
					ETG_TRACE_USR4(("NanomsgClienthandler::vHandleSystemStates() Standby: Closing swivel"));
					m_poGenericDBUSProxy->sendReqCMGSvivelPositionRequest(*this,entSvivelRequest__entSvivelRequest_Close,SubSystemData[u8Idx].DeviceID,SubSystemData[u8Idx].DeviceNumber,MSG_ID_ReqCMGSvivelPosition,SubSystemData[u8Idx].DeviceIPAddress.c_str());
				}
			}
			u8CMCPwrMode = CMCPwrMode_STANDBY;
			vSendPowerMode(CMCPwrMode_STANDBY);
			InitDevError(_u8MaxNumOfSubSystem);			
			pSrv->sendSubsystemerrorStatusStatus(getSubsystemerrorState());  
			_NanomsgTimer.stop();//new
		}
		break;
		case T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_STATE_PROFILE:
		{	
			ETG_TRACE_USR4(("NanomsgClienthandler::vHandleSystemStates() State Profile"));
			u8CMCPwrMode = CMCPwrMode_STATE_PROFILE;
			vSendPowerMode(CMCPwrMode_STATE_PROFILE);
		}
		break;
		case T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_SAFE:
		{
			ETG_TRACE_USR4(("NanomsgClienthandler::vHandleSystemStates() Safe"));
			u8CMCPwrMode = CMCPwrMode_SAFE;
			vSendPowerMode(CMCPwrMode_SAFE);
		}
		break;
		case T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_MMI_STANDBY:
		{
			ETG_TRACE_USR4(("NanomsgClienthandler::vHandleSystemStates() Animation"));
			u8CMCPwrMode = CMCPwrMode_MMI_STANDBY;
			vSendPowerMode(CMCPwrMode_MMI_STANDBY);
		}
		break;
		case T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_MMI_ON:
		{
			ETG_TRACE_USR4(("NanomsgClienthandler::vHandleSystemStates() Cockpit mode"));
			//_u8PNMGRP10Statusflag is not set and system is in MMI_ON state, send power modes to subsystems
			if(_u8PNMGRP10Statusflag == PNM_LOW_VOLT_ACTIVE)
			{
				ETG_TRACE_USR4(("NanomsgClienthandler::vHandleSystemStates() Cockpit mode due to PNMGR10 signal active (low battery condition)"));
				u8CMCPwrMode = CMCPwrMode_MMI_ON;
				vSendPowerMode(CMCPwrMode_MMI_ON);
			}
		}
		break;
		case T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_DIAGNOSIS:
		{
			ETG_TRACE_USR4(("NanomsgClienthandler::vHandleSystemStates() DIAGNOSIS"));
			u8CMCPwrMode = CMCPwrMode_DIAGNOSIS;
			vSendPowerMode(CMCPwrMode_DIAGNOSIS);
		}
		break;
		case T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_DOWNLOAD:
		{
			ETG_TRACE_USR4(("NanomsgClienthandler::vHandleSystemStates() DOWNLOAD"));
			u8CMCPwrMode = CMCPwrMode_DOWNLOAD;
			vSendPowerMode(CMCPwrMode_DOWNLOAD);
		}
		break;
		case T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_MMI_ON_TEL:
		{
			ETG_TRACE_USR4(("NanomsgClienthandler::vHandleSystemStates() MMI_ON_TEL"));
			u8CMCPwrMode = CMCPwrMode_MMI_ON_TEL;
			vSendPowerMode(CMCPwrMode_MMI_ON_TEL);
		}
		break;
		case  T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_2:
		{
			ETG_TRACE_USR4(("NanomsgClienthandler::vHandleSystemStates() MMI_STANDBY_PWR_SAVE_2"));
			u8CMCPwrMode = CMCPwrMode_MMI_STANDBY_PWR_SAVE_2;
			vSendPowerMode(CMCPwrMode_MMI_STANDBY_PWR_SAVE_2);
		}
		break;
		case T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_MMI_ON_SWDL:
		{
			ETG_TRACE_USR4(("NanomsgClienthandler::vHandleSystemStates() MMI_ON_SWDL"));
			u8CMCPwrMode = CMCPwrMode_MMI_ON_SWDL;
			vSendPowerMode(CMCPwrMode_MMI_ON_SWDL);
		}
		break;
		default:
		{
			ETG_TRACE_USR4(("NanomsgClienthandler::vHandleSystemStates() No state"));
		}
		break;
	}	
}

/****************************************************************************
 Function       : vHandlePNMGRP10status
 Description    : To update HMI about the PNMGRP10 Error status.
		  vHandlePNMGRP10status() is called when there is property update for PNMGRP10 signal.
 Parameters     : PNMGRP10staus
 Return Value   : None
 HISTORY:
 Date			 | Author			    | Modification
 	 | 
 ***************************************************************************/
void NanomsgClienthandler::vHandlePNMGRP10status(uint8 PNMGRP10status)
{
	ETG_TRACE_USR4(("NanomsgClienthandler::vHandlePNMGRP10status PNMGRP10status=%d",PNMGRP10status));
	Ilcmdbusclient_tclServiceLcmDbusClientIf* pSrv = dynamic_cast<Ilcmdbusclient_tclServiceLcmDbusClientIf*>(_cpoMain->getHandler("Ilcmdbusclient_tclServiceLcmDbusClientIf"));
	if(!pSrv)
	{
		ETG_TRACE_FATAL(("ERROR: NanomsgClienthandler::vHandleSystemStates" ));
		return;
	}
	_u8PNMGRP10Statusflag = PNMGRP10status;
	if(_u8PNMGRP10Statusflag == PNM_LOW_VOLT_INACTIVE)
	{
		ETG_TRACE_USR4(("NanomsgClienthandler::vHandlePNMGRP10status():PNMGR10 signal inactive (normal battery condition)"));
		UpdateError(u8Index_CMC,(uint8)ERR_PNM_GRP10,(uint8)DEV_NO_ERROR);
		pSrv->sendSubsystemerrorStatusStatus(getSubsystemerrorState());  
	}
	else if(_u8PNMGRP10Statusflag == PNM_LOW_VOLT_ACTIVE)
	{
		ETG_TRACE_USR4(("NanomsgClienthandler::vHandlePNMGRP10status():PNMGR10 signal active (low battery condition)"));
		UpdateError(u8Index_CMC,(uint8)ERR_PNM_GRP10,(uint8)DEV_ERROR);
		pSrv->sendSubsystemerrorStatusStatus(getSubsystemerrorState());  
	}
	else
	{
		ETG_TRACE_USR4(("NanomsgClienthandler::vHandlePNMGRP10status():value is out of range"));
	}
}

entPowerMode NanomsgClienthandler::eGetcIsState(enDevID eDevID, uint8 u8IntPwrMode) //to get the power state of the sub system
{
	entPowerMode ePowerMode = entPowerMode__enPowerMode_Undefined;
	if ((eDevID < DEV_Type_MAX) && (u8IntPwrMode < CMCPwrMode_MAX))
	{
		
		ePowerMode = (entPowerMode)caubSubsystemMap[eDevID][u8IntPwrMode];
	}
	ETG_TRACE_USR4(("NanomsgClienthandler::eGetcIsState eDevID = %d, CMCPwrMode = %d CISPwrMode = %d", eDevID, u8IntPwrMode, ePowerMode));	
	return ePowerMode;
}

void NanomsgClienthandler::vSendPowerMode(uint8 u8CMCPwrMode)
{
	//stop timer
	_NanomsgTimer.stop();
	for (uint8 u8Idx = 0; u8Idx < _u8MaxNumOfSubSystem; u8Idx++)
	{
		SubSystemData[u8Idx].u8PWRModeMismatchCount = 0;
		SubSystemData[u8Idx].ExpectedPwrMode = eGetcIsState(SubSystemData[u8Idx].DeviceID, u8CMCPwrMode); //Update the structure with expected power mode for the new CMC power mode
		if ( SubSystemData[u8Idx].ExpectedPwrMode != entPowerMode__enPowerMode_Undefined )
		{
			if(SubSystemData[u8Idx].u8SelfProtectionFlg == NOT_SET)
			{
				ETG_TRACE_USR4(("NanomsgClienthandler::vSendPowerMode sent for eDevID = %d, u8DevNr = %d, CISPwrMode = %d IP=%s", SubSystemData[u8Idx].DeviceID, SubSystemData[u8Idx].DeviceNumber, SubSystemData[u8Idx].ExpectedPwrMode, SubSystemData[u8Idx].DeviceIPAddress.c_str()));
				u8SendPowerModeDBUS(SubSystemData[u8Idx].DeviceID, SubSystemData[u8Idx].DeviceNumber, SubSystemData[u8Idx].DeviceIPAddress, SubSystemData[u8Idx].ExpectedPwrMode);
			}
			else
			{
				ETG_TRACE_USR4(("NanomsgClienthandler::vSendPowerMode Not sent for eDevID = %d, u8DevNr = %d, CISPwrMode = %d IP=%s", SubSystemData[u8Idx].DeviceID, SubSystemData[u8Idx].DeviceNumber, SubSystemData[u8Idx].ExpectedPwrMode, SubSystemData[u8Idx].DeviceIPAddress.c_str()));
			}
		}
		else
		{
			ETG_TRACE_USR4(("NanomsgClienthandler::vSendPowerMode:No handling" ));
		}
	}
	//start timer
	_NanomsgTimer.start(*this, _NanomsgTimeMSec, 0);
}

uint8 NanomsgClienthandler::u8SendPowerModeDBUS(enDevID eDevID, uint8 u8DevNr, std::string sIPAddr, entPowerMode ePowerMode)
{

	ETG_TRACE_USR4(("NanomsgClienthandler::u8SendPowerModeDBUS Sending sendReqSetPowerModeRequest to eDevID = %d, u8DevNr = %d, ePowerMode = %d IP=%s", eDevID, u8DevNr, ePowerMode, sIPAddr.c_str()));
	ETG_TRACE_USR4(("NanomsgClienthandler::u8SendPowerModeDBUS Sending sendReqSetPowerModeRequest PowerMode=%s",POWER_MODE(ePowerMode)));
	switch (ePowerMode)
	{
		case entPowerMode__enPowerMode_OFF:
		{
			ETG_TRACE_USR4(("NanomsgClienthandler::u8SendPowerModeDBUS Sending sendReqShutdownRequest to eDevID = %d, u8DevNr = %d, Timer=%d, IP=%s ", eDevID, u8DevNr, LCM_SHUTDOWN_TIMER, sIPAddr.c_str()));
			m_poLCMDBUSProxy->sendReqShutdownRequest(*this, LCM_SHUTDOWN_TIMER, eDevID, u8DevNr, MSG_ID_ReqShutdown, sIPAddr);
		}
		break;
		case entPowerMode__enPowerMode_Stand_By:
		case entPowerMode__enPowerMode_Hour_Logic:
		case entPowerMode__enPowerMode_Diagnosis:
		case entPowerMode__enPowerMode_Software_Update:
		case entPowerMode__enPowerMode_ON:
		case entPowerMode__enPowerMode_User_Off:
		case entPowerMode__enPowerMode_Protected_Off:
		{
			m_poLCMDBUSProxy->sendReqSetPowerModeRequest(*this,ePowerMode, eDevID, u8DevNr, MSG_ID_ReqSetPowerMode, sIPAddr);			
		}
		break;
		
		default:
			ETG_TRACE_USR4(("Error: NanomsgClienthandler u8SendPowerModeDBUS power mode not handled "));
		break;
	}
	
	return 0;
}


uint8 NanomsgClienthandler::u8GetSubSystemIndex(std::string sIPAddr)
{
//	ETG_TRACE_USR4(("NanomsgClienthandler::u8GetSubSystemIndex called for IP = %s",sIPAddr.c_str()));
	uint8 u8Idx;
	for (u8Idx = 0; u8Idx < _u8MaxNumOfSubSystem; u8Idx++)
	{
		if ((0 == SubSystemData[u8Idx].DeviceIPAddress.compare(sIPAddr)))
		{
			break;
		}
	}
	return u8Idx;
}

void NanomsgClienthandler::vHandleReceivedPowerMode(enDevID eDevID, uint8 u8DevNr, std::string sIPAddr, entPowerMode u8CISPwrMode, tBool bIsEvent)
{
	Ilcmdbusclient_tclServiceLcmDbusClientIf* pSrv = dynamic_cast<Ilcmdbusclient_tclServiceLcmDbusClientIf*>(_cpoMain->getHandler("Ilcmdbusclient_tclServiceLcmDbusClientIf"));
	if (!pSrv)
	{
		ETG_TRACE_FATAL(( "ERROR: NanomsgClienthandler::vSendWakeupReason LCMDbusClient interface is NULL"));
	}

	uint8 u8Idx = u8GetSubSystemIndex(sIPAddr);
	SubSystemData[u8Idx].ReceivedPwrMode = u8CISPwrMode;
	UpdateError(u8Idx+1,(uint8)POWER_MODE_SUBSYSTEM,MappingOfReceivedPModeForHMI(u8CISPwrMode));
	ETG_TRACE_USR4(("NanomsgClienthandler::vHandleReceivedPowerMode ReceivedPwrMode = %d, ExpectedPwrMode = %d",SubSystemData[u8Idx].ReceivedPwrMode, SubSystemData[u8Idx].ExpectedPwrMode));

	if (bIsEvent == HEALTHCARE_RESPONSE)		//This condition shall execute only Healthcare response. For Statechange event this is not required
	{
		if (u8Idx < _u8MaxNumOfSubSystem)
		{
			if ((SubSystemData[u8Idx].ReceivedPwrMode != SubSystemData[u8Idx].ExpectedPwrMode) && (SubSystemData[u8Idx].u8SelfProtectionFlg == NOT_SET) && (SubSystemData[u8Idx].ExpectedPwrMode != entPowerMode__enPowerMode_Undefined))
			{
				ETG_TRACE_USR4(("NanomsgClienthandler::vHandleReceivedPowerMode State mismatch and re-sending"));
				u8SendPowerModeDBUS(eDevID, u8DevNr, sIPAddr, SubSystemData[u8Idx].ExpectedPwrMode); //Mismatch detected as part of the healthcare response. So, resend the powermode to that sub-system
				SubSystemData[u8Idx].u8PWRModeMismatchCount++;
				if (SubSystemData[u8Idx].u8PWRModeMismatchCount >= HEALTHCARE_MAX_COUNT)
				{
					if(eDevID == enDevID__enDevID_Media_Apm)
					{
						if(_u8NanomsgErrorflag != 1)
						{
							_u8NanomsgErrorflag = 1;	
							pSrv->sendCockpitmodeStatusStatus(ETHERNET_ERROR_ACTIVE);
							ETG_TRACE_USR4(("NanomsgClienthandler:: vHandleReceivedPowerMode  Nanomessage Error for CM-A"));
						}
					}
					UpdateError(u8Idx+1,(uint8)ERR_NANO_MSG,(uint8)DEV_ERROR);
				}
			}
			else
			{
				SubSystemData[u8Idx].u8PWRModeMismatchCount = 0;
				UpdateError(u8Idx+1,(uint8)ERR_NANO_MSG,(uint8)DEV_NO_ERROR);
				if(eDevID == enDevID__enDevID_Media_Apm)
				{
					if(_u8NanomsgErrorflag != 0)
					{
						_u8NanomsgErrorflag = 0;	
						pSrv->sendCockpitmodeStatusStatus(ETHERNET_ERROR_INACTIVE);
						ETG_TRACE_USR4(("NanomsgClienthandler:: vHandleReceivedPowerMode  Nanomessage Error resolved for CM-A "));
					}
				}
			}
		}
	}
	else if (bIsEvent == EVENT_PWRMODE_CHANGE)	//When event powermode changed
	{
		//If Protected off is received from a sub-system, set the condition flag, so that CM-C shall not send statechange request to the sub-system
		if((SubSystemData[u8Idx].ReceivedPwrMode == entPowerMode__enPowerMode_Protected_Off) && (u8CMCPwrMode != CMCPwrMode_SAFE) )	//If Protected off received as an event change power mode and CM_C power mode is not in protected off, set the condition flag to that sub-system
		{
			SubSystemData[u8Idx].u8SelfProtectionFlg = FLAG_SET;
		}
		if(SubSystemData[u8Idx].ReceivedPwrMode != entPowerMode__enPowerMode_Protected_Off)	//If User Off or ON received as an event change power mode, Clear the condition flag to that sub-system
		{
			SubSystemData[u8Idx].u8SelfProtectionFlg = FLAG_CLEAR;
		}
	}
	pSrv->sendSubsystemerrorStatusStatus(getSubsystemerrorState());  
}

void NanomsgClienthandler:: vOnTimerExpiry(void) //This function shall be called on every second
{
	Ilcmdbusclient_tclServiceLcmDbusClientIf* pSrv = dynamic_cast<Ilcmdbusclient_tclServiceLcmDbusClientIf*>(_cpoMain->getHandler("Ilcmdbusclient_tclServiceLcmDbusClientIf"));
	if (!pSrv)
	{
		ETG_TRACE_FATAL(( "ERROR: NanomsgClienthandler::vSendWakeupReason LCMDbusClient interface is NULL"));
	}

	u32GlobalTick++;
	if (u8FlagWakeupReason == NOT_RECEIVED)
	{
		m_poGenericDBUSProxy->sendReqGetDigitalInputRequest(*this, enDevID__enDevID_Media_Apm, 40, MSG_ID_ReqGetDigitalInput, SubSystemData[u8Idx_CMA_PRIMARY].DeviceIPAddress);
		ETG_TRACE_USR4(("NanomsgClienthandler::vOnTimerExpiry sending sendReqGetDigitalInputRequest"));
	}
	if (u8FlagVoltageState == NOT_RECEIVED)
	{
		m_poGenericDBUSProxy->sendReqGetVoltageRequest(*this, enDevID__enDevID_Media_Apm, 40, MSG_ID_ReqGetVoltage, entVoltageSensor__entVoltageSensor_BatterySensor, SubSystemData[u8Idx_CMA_PRIMARY].DeviceIPAddress); 
		ETG_TRACE_USR4(("NanomsgClienthandler::vOnTimerExpiry sending sendReqGetVoltageRequest"));
	}
	if (((u32GlobalTick % LCM_10s_TIMER) == 0) && (u8FlagWakeupReason == RECEIVED)) //Send Healthcare message on every 10 seconds to all connected sub-systems
	{
		for (uint8 u8Idx = 0; u8Idx < _u8MaxNumOfSubSystem; u8Idx++)
		{
			m_poLCMDBUSProxy->sendReqHealthCareRequest(*this, SubSystemData[u8Idx].DeviceID, SubSystemData[u8Idx].DeviceNumber, MSG_ID_ReqHealthCare, SubSystemData[u8Idx].DeviceIPAddress);
			if(u8CMCPwrMode != CMCPwrMode_MMI_ON_SWDL)	//Increase the Healthcare request count only when system not in SW Update mode
				SubSystemData[u8Idx].u8HealthcareReqCount++;
			ETG_TRACE_USR4(("NanomsgClienthandler::vOnTimerExpiry sending sendReqHealthCareRequest for DeviceID = %d HealthcareReqCount = %d IP = %s",SubSystemData[u8Idx].DeviceID, SubSystemData[u8Idx].u8HealthcareReqCount, SubSystemData[u8Idx].DeviceIPAddress.c_str()));
			if(SubSystemData[u8Idx].u8HealthcareReqCount >= HEALTHCARE_MAX_COUNT)	//If healthcare message is not received for 2 minutes for any sub-system, considered that as a Nanomessag error for that sub-system.
			{	
				ETG_TRACE_USR4(("NanomsgClienthandler::vOnTimerExpiry Healthcarecounte exceeded the max count"));
				if(SubSystemData[u8Idx].DeviceID == enDevID__enDevID_Media_Apm)	//Todo: Need to check for primary CM-A
				{
					if(_u8NanomsgErrorflag != 1)
					{
						_u8NanomsgErrorflag = 1;	
						pSrv->sendCockpitmodeStatusStatus(ETHERNET_ERROR_ACTIVE);
						ETG_TRACE_USR4(("NanomsgClienthandler::vOnTimerExpiry  Nanomessage Error for CM-A"));
					}
				}
				UpdateError(u8Idx+1,(uint8)ERR_NANO_MSG,(uint8)DEV_ERROR); //Set Nanoemssage error for the respective sub-system
				pSrv->sendSubsystemerrorStatusStatus(getSubsystemerrorState());  
			}
		}
	}
}


uint8 NanomsgClienthandler::u8GetDeviceID(const std::string Devname)
{
	ETG_TRACE_USR4(("NanomsgClienthandler::u8GetDeviceID called"));
	uint8 u8NewDevID = 0xFF;
	if(Devname == DEV_NAME_CMA)
	{
		u8NewDevID = enDevID__enDevID_Media_Apm;
	}
	else if(Devname == DEV_NAME_CMP)
	{
		u8NewDevID = enDevID__enDevID_Media_CamPort;
	}
	else if(Devname == DEV_NAME_CMG)
	{
		u8NewDevID = enDevID__enDevID_Media_Glass;
	}
	else if(Devname == DEV_NAME_CMR)
	{
		u8NewDevID = enDevID__enDevID_Media_Router;
	}
	else
	{
		ETG_TRACE_USR4(("Error: NanomsgClienthandler::u8GetDeviceID"));
	}
	return u8NewDevID;
		

}
uint8 NanomsgClienthandler::GetIPLastByte(std::string DevIP)
{
//	ETG_TRACE_USR4(("NanomsgClienthandler::u8GetDeviceID called"));
	const char *str = DevIP.c_str();
	unsigned char value[4] = {0};
	uint8 index = 0;
	while(*str)
	{
		if (isdigit((unsigned char)*str))
		{
           		value[index] *= 10;
            		value[index] += *str - '0';
        	}
		else 
		{
            		index++;
        	}
        	str++;
    	}
	ETG_TRACE_USR4(("NanomsgClienthandler::GetIPLastByte IP is %d.%d.%d.%d", value[0],value[1],value[2],value[3]));
	return value[3];
}


void NanomsgClienthandler::UpdateError(uint8 devIndex , uint8 Error, uint8 Value)
{
    std::vector<lcmdbusclient_fi_tclheDevInfo, std::allocator<lcmdbusclient_fi_tclheDevInfo> >::iterator it;
	uint8 u8Idx = 0;
	for (it = Subsystemerrorconstate.SubsystemList.begin(); it != Subsystemerrorconstate.SubsystemList.end(); it++,u8Idx++)
    {
		if (u8Idx == devIndex)
		{
			switch 	(Error)
			{
				case ERR_NANO_MSG:
					switch (Value)
					{
						case DEV_EVALUATING:
							it->devError = (it->devError & MASK_NANOMSG_ERR) | NANOMSG_EVALUATING;  //Evaluating condition Nanomsg error
							break;
						case DEV_NO_ERROR:
							it->devError = (it->devError & MASK_NANOMSG_ERR) | NANOMSG_NO_ERR;	//No Error condition Nanomsg error			
							break;
						case DEV_ERROR:
							it->devError = (it->devError & MASK_NANOMSG_ERR) | NANOMSG_ERR;	    //Error condition Nanomsg error	
							break;
					}
					break;
					
				case ERR_AVDECC:
					switch (Value)
					{
						case DEV_EVALUATING:
							it->devError = (it->devError & MASK_AVDECCMSG_ERR) | AVDECC_EVALUATING;  //Evaluating condition AVDECC error
							break;
						case DEV_NO_ERROR:
							it->devError = (it->devError & MASK_AVDECCMSG_ERR) | AVDECC_NO_ERR;  //No Error condition AVDECC error
							break;
						case DEV_ERROR:
							it->devError = (it->devError & MASK_AVDECCMSG_ERR) | AVDECC_ERR;  //Error condition AVDECC error
							break;
					}
					break;	
					
				case ERR_ETHERNET:
					switch (Value)
					{
						case DEV_EVALUATING:
							it->devError = (it->devError & MASK_ETHERNET_ERR) | ETHERNET_EVALUATING;  //Evaluating condition Ethernet error
							break;
						case DEV_NO_ERROR:
							it->devError = (it->devError & MASK_ETHERNET_ERR) | ETHERNET_NO_ERR;  //No Error condition Ethernet error
							break;
						case DEV_ERROR:
							it->devError = (it->devError & MASK_ETHERNET_ERR) | ETHERNET_ERR;   //Error condition Ethernet error
							break;
					}
					break;			
					
				case ERR_VOLTAGE:
					switch (Value)
					{
						case DEV_EVALUATING:
							it->devError = (it->devError & MASK_VOLTAGE_ERR) | VOLTAGE_EVALUATING;  //Evaluating condition Voltage error
							break;
						case DEV_NO_ERROR:
							it->devError = (it->devError & MASK_VOLTAGE_ERR) | VOLTAGE_NO_ERR;   //No Error condition Volatage error
							break;
						case DEV_OVER_WARNING_VOLTAGE:
							it->devError = (it->devError & MASK_VOLTAGE_ERR) |  VOLTAGE_OVER_WARNING;  //Error condition Over Warning Volatage error
							break;
						case DEV_OVER_CRITICAL_VOLTAGE:
							it->devError = (it->devError & MASK_VOLTAGE_ERR) | VOLTAGE_OVER_CRITICAL;  //Error condition Over Critical Volatage error
							break;
						case DEV_UNDER_WARNING_VOLTAGE:
							it->devError = (it->devError & MASK_VOLTAGE_ERR) | VOLTAGE_UNDER_WARNING;  //Error condition Under Warning Volatage error
							break;
						case DEV_UNDER_CRITICAL_VOLTAGE:
							it->devError = (it->devError & MASK_VOLTAGE_ERR) | VOLTAGE_UNDER_CRITICAL;  //Error condition Under Critical Volatage error
							break;
					}
					break;
					
				case ERR_THERMAL:
					switch (Value)
					{
						case DEV_EVALUATING:
							it->devError = (it->devError & MASK_THERMAL_ERR) | THERMAL_EVALUATINGL;  //Evaluating condition Thermal error
							break;
						case DEV_NO_ERROR:
							it->devError = (it->devError & MASK_THERMAL_ERR) | THERMAL_NO_ERR;   //No Error condition Thermal error
							break;
						case DEV_HIGH_THERMAL:
							it->devError = (it->devError & MASK_THERMAL_ERR) | THERMAL_HIGH;  //Error condition High Thermal error
							break;
						case DEV_CRITICAL_THERMAL:
							it->devError = (it->devError & MASK_THERMAL_ERR) | THERMAL_CRITICAL_HIGH;  //Error condition Critical Thermal error
							break;
						case DEV_OVER_CRITICAL_THERMAL:
							it->devError = (it->devError & MASK_THERMAL_ERR) | THERMAL_OVER;  //Error condition Over Critical Thermal error
							break;
						case DEV_LOW_THERMAL:
							it->devError = (it->devError & MASK_THERMAL_ERR) | THERMAL_LOW;  //Error condition Low Thermal error
							break;
						case DEV_CRITICAL_LOW_THERMAL:
							it->devError = (it->devError & MASK_THERMAL_ERR) | THERMAL_CRITICAL_LOW;  //Error condition Critical Low Thermal error
							break;
						case DEV_UNDER_CRITICAL_LOW_THERMAL:
							it->devError =(it->devError & MASK_THERMAL_ERR) | THERMAL_UNDER;   //Error condition Under Critical Low Thermal error
							break;	
					}
					break;	
					
				case ERR_PNM_GRP10:
					switch (Value)
					{
						case DEV_PNM_ERROR_POWER_MODE_UNDEFINED:
							it->devError = (it->devError & MASK_PNM_ERR) | PNM_UNDEFINED;    //Undefined condition PNM_GRP10 error
							break;
						case DEV_NO_ERROR:
							it->devError = (it->devError & MASK_PNM_ERR) | PNM_NO_ERROR;    //No Error condition PNM_GRP10 error
							break;
						case DEV_ERROR:
							it->devError = (it->devError & MASK_PNM_ERR) | PNM_ERROR;    //Error condition PNM_GRP10 error
							break;
					}
					break;
				case POWER_MODE_SUBSYSTEM:
					switch(Value)
					{
						case DEV_PNM_ERROR_POWER_MODE_UNDEFINED:
							it->devError = (it->devError & MASK_PNM_ERR) | SUBSYSTEM_PWRMODE_EVALUATING;    //Power mode Undefined of subsystem
							break;
						case DEV_POWER_MODE_ON:
							it->devError = (it->devError & MASK_PNM_ERR) | SUBSYSTEM_PWRMODE_ON;    	//Power mode ON of subsystem
							break;
						case DEV_POWER_MODE_USEROFF:
							it->devError = (it->devError & MASK_PNM_ERR) | SUBSYSTEM_PWRMODE_USEROFF;    //Power mode USER_OFF of subsystem
							break;
						case DEV_POWER_MODE_PROCTECTED_OFF:
							it->devError = (it->devError & MASK_PNM_ERR) | SUBSYSTEM_PWRMODE_PROTECTEDOFF;    //Power mode Protected_OFF of subsystem
							break;
						case DEV_POWER_MODE_SWUPDATE:
							it->devError = (it->devError & MASK_PNM_ERR) | SUBSYSTEM_PWRMODE_SWUPDATE;    //Power mode SWUPDATE of subsystem
							break;
						case DEV_POWER_MODE_DIAGNOSIS:
							it->devError = (it->devError & MASK_PNM_ERR) | SUBSYSTEM_PWRMODE_DIAGNOSIS;    //Power mode Diagnosis of subsystem
							break;
						case DEV_POWER_MODE_STARTUP:
							it->devError = (it->devError & MASK_PNM_ERR) | SUBSYSTEM_PWRMODE_STARTUP;    //Power mode Startup of subsystem
							break;
						case DEV_POWER_MODE_HOUR_LOGIC:
							it->devError = (it->devError & MASK_PNM_ERR) | SUBSYSTEM_PWRMODE_HOURLOGIC;    //Power mode Hour logic of subsystem
							break;							
					}
					break;	
					
				case ERR_HOUR_LOGIC:
					switch (Value)
					{
						case HOURLOGIC_INACTIVE:
							it->devError = (it->devError & MASK_HOURLOGIC_END) | HOURLOGIC_END_INACTIVE;   //Inactive condition Hourlogic error
							break;
						case HOURLOGIC_ACTIVE:
							it->devError = (it->devError & MASK_HOURLOGIC_END) | HOURLOGIC_END_ACTIVE;  //Active condition Hourlogic error
							break;	
					}
					break;		
			}
		}
	}
}

void NanomsgClienthandler::InitDevError(uint8 NumOfSubSystem)
{
	ETG_TRACE_USR4(("NanomsgClienthandler::InitDevError called"));
	for(uint8 u8Idx = 0; u8Idx < NumOfSubSystem; u8Idx++)
	{
		UpdateError(u8Idx+1, (uint8)ERR_NANO_MSG,   (uint8)DEV_EVALUATING); // For all these index should start with 0 or 1?  To be confirmed
		UpdateError(u8Idx+1, (uint8)ERR_AVDECC,	    (uint8)DEV_EVALUATING);
		UpdateError(u8Idx+1, (uint8)ERR_ETHERNET,   (uint8)DEV_EVALUATING);
		UpdateError(u8Idx+1, (uint8)ERR_VOLTAGE,    	(uint8)DEV_EVALUATING);
		UpdateError(u8Idx+1, (uint8)ERR_THERMAL,    	(uint8)DEV_EVALUATING);
		UpdateError(u8Idx+1, (uint8)ERR_PNM_GRP10,  	(uint8)DEV_PNM_ERROR_POWER_MODE_UNDEFINED);
		UpdateError(u8Idx+1, (uint8)ERR_HOUR_LOGIC, 	(uint8)HOURLOGIC_INACTIVE);
	}
}

/******************Functions for Tracing Purpose*****************/

const char* NanomsgClienthandler::THERMAL_LEVEL(int TEMP)
{	
	switch(TEMP)
	{
		case entThermalState__entUndefined:
			return "UNDEFINED";
		case entThermalState__entOver:
			return "OVER";
		case entThermalState__entCritical_High:
			return "CRITICAL HIGH";
		case entThermalState__entHigh:
			return "HIGH";
		case entThermalState__entNormal:
			return "NORMAL";
		case entThermalState__entLow:
			return "LOW";
		case entThermalState__entCritical_low:
			return "CRITICAL LOW";
		case entThermalState__entUnder:
			return "UNDER";
		default: 
			return "ERROR";	
	}
}

const char* NanomsgClienthandler::VOLT_LEVEL(int VOLT)
{	
	switch(VOLT)
	{
		case entVoltageLevel__entVoltage_Undefined:
			return "UNDEFINED";
		case entVoltageLevel__entVoltage_OverCritical_1:
			return "CRITICAL HIGH";
		case entVoltageLevel__entVoltage_OverWarning_2:
			return "HIGH";
		case entVoltageLevel__entVoltage_Normal:
			return "NORMAL";
		case entVoltageLevel__entVoltage_UnderWarning_3:
			return "LOW";
		case entVoltageLevel__entVoltage_UnderCritical:
			return "CRITICAL LOW";
		default: 
			return "ERROR";	
	}
}

const char* NanomsgClienthandler::WAKEUP_REASON(int REASON)
{	
	switch(REASON)
	{
		case entWakeupReason__entWakeupReason_No_reason:
			return "NO_REASON";
		case entWakeupReason__entWakeupReason_MIC1:
			return "MIC1";
		case entWakeupReason__entWakeupReason_MIC2:
			return "MIC2";
		case entWakeupReason__entWakeupReason_Wake_HU_In:
			return "WAKE_HU_IN";
		case entWakeupReason__entWakeupReason_Reverse_gear:
			return "REVERSE GEAR";
		case entWakeupReason__entWakeupReason_CAN:
			return "CAN";
		case entWakeupReason__entWakeupReason_IGN_In:
			return "IGN_IN";
		case entWakeupReason__entWakeupReason_Door_status:
			return "DOOR STATUS";
		case entWakeupReason__entWakeupReason_Manual_On:
			return "MANUAL ON";
		case entWakeupReason__entWakeupReason_Ethernet_Q5050:
			return "ETHERNET Q5050";
		case entWakeupReason__entWakeupReason_Ethernet_Q1010:
			return "ETHERNET Q1010";
		case entWakeupReason__entWakeupReason_MIC3:
			return "MIC3";
		case entWakeupReason__entWakeupReason_Tour_Guide:
			return "TOUR GUIDE";
		case entWakeupReason__entWakeupReason_Backend:
			return "BACKEND";
		case entWakeupReason__entWakeupReason_Undefined:
			return "UNDEFINED";
		default:
			return "NO REASON";
		
	}
}

const char* NanomsgClienthandler::POWER_MODE(int MODE)
{	
	switch(MODE)
	{
		case entPowerMode__enPowerMode_OFF:
			return "OFF";
		case entPowerMode__enPowerMode_Stand_By:
			return "STANDBY";
		case entPowerMode__enPowerMode_User_Off:
			return "USER OFF";
		case entPowerMode__enPowerMode_System_Start_Up:
			return "START UP";
		case entPowerMode__enPowerMode_ON:
			return "ON";
		case entPowerMode__enPowerMode_Hour_Logic:
			return "HOURLOGIC";
		case entPowerMode__enPowerMode_Diagnosis:
			return "DIAGNOSIS";
		case entPowerMode__enPowerMode_Software_Update:
			return "SOFTWARE UPDATE";
		case entPowerMode__enPowerMode_Protected_Off:
			return "PROTECTED OFF";
		case entPowerMode__enPowerMode_Undefined:
			return "UNDEFINED";
		default:
			return "NO POWER MODES";

	}
}

uint8 NanomsgClienthandler::u8GetID(enDevID eDevID)
{
	ETG_TRACE_USR4( ( "NanomsgClienthandler::u8GetID called"));
	uint8 u8Idx;
	for (u8Idx = 0; u8Idx < _u8MaxNumOfSubSystem; u8Idx++)
	{
		if (SubSystemData[u8Idx].DeviceID == eDevID)  
		{
			break;
		}
	}
	return u8Idx;
}

//We have different values for system state received from Sub-system(Nanomessage specification) and what is being sent to HMI (Data structure between LCM and HMI)
//Ideally, if the same structure is maintained for sending it to HMI, this chang is not required
uint8 NanomsgClienthandler::MappingOfReceivedPModeForHMI(entPowerMode CISPMode)
{
	uint8 CISPModeForHMI = 0;
	switch(CISPMode)
	{	
		case CISPwrMode_OFF:
		case CISPwrMode_STANDBY:
		case CISPwrMode_UNDEFINED:
		case CISPwrMode_STARTUP:
			CISPModeForHMI = 0;		//Evaluating
			break;

		case CISPwrMode_USEROFF:
			CISPModeForHMI = 2;		//User off
			break;

		case CISPwrMode_ON:
			CISPModeForHMI = 1;		//ON
			break;

		case CISPwrMode_HOUR_LOGIC:
			CISPModeForHMI = 7;		//Hour logic
			break;

		case CISPwrMode_DIAGNOSIS:
			CISPModeForHMI = 5;		//Diagnosis
			break;

		case CISPwrMode_SW_UPDTAE:
			CISPModeForHMI = 4;		//SW Update
			break;

		case CISPwrMode_PROTECTED_OFF:
			CISPModeForHMI = 3;		//Protected Off
			break;
			
		default:
			ETG_TRACE_USR4(("Error: MappingReceivedPModeForHMI "));
			break;
	}
	ETG_TRACE_USR4(("CIS Power Mode = %d, CISPowerMode for HMI = %d", CISPMode,CISPModeForHMI));

	return CISPModeForHMI;
}

}}}}


