
#ifndef _LCMDBUSCLIENT_CLIENTAUDIO_H
#define _LCMDBUSCLIENT_CLIENTAUDIO_H

/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          lcmdbusclient_ClientAudio.h
  * @PROJECT:      CMD project
  * @SW-COMPONENT: lcmdbusclient
  * @Template:     DBusProxy.h.tpl
  * ----------------------------------------------------------------------------
  *
  * @brief         generated file
  *                DBus client
  *
  *                Do manual changes only inside tags
  *
  *                //......................: user specific code start 
  *                //......................: user specific code end 
  *
  * ----------------------------------------------------------------------------
  * @copyright     (c) 2019 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#include <iostream>

#include "asf/core/Logger.h"
#include "asf/core/Proxy.h"
#include "asf/core/Timer.h"

#include "org/genivi/audiomanager/CommandInterfaceProxy.h"

#include "asf/stream/MemoryStream.h"

#include "Ilcmdbusclient_ClientAudio.h"

// lcmdbusclient_ClientAudioInclude: user specific code start
// lcmdbusclient_ClientAudioInclude: user specific code end

namespace org { namespace bosch { namespace cm { namespace lcmdbusclient {

    using namespace::asf::core;
    using namespace::asf::stream;
    using namespace::org::genivi::audiomanager::CommandInterface;
    using namespace::asf::core;
    using namespace::org::bosch::cm::lcmdbusclient;

    class lcmdbusclient_tclClientAudio : public Ilcmdbusclient_tclClientAudio
        , public ServiceAvailableIF
        , private TimerCallbackIF
        , public GetListMainConnectionsCallbackIF
        , public GetListMainSourcesCallbackIF
        , public MainConnectionStateChangedCallbackIF
        , public NewMainConnectionCallbackIF
        , public NumberOfMainConnectionsChangedCallbackIF
    {
    private:
        DECLARE_CLASS_LOGGER();

        tBool _bSrvAvailable;

    public:
        lcmdbusclient_tclClientAudio(lcmdbusclient_tclAppMain* baseRef);
        virtual ~lcmdbusclient_tclClientAudio();

        // ServiceAvailableIF
        virtual void onAvailable(const::boost::shared_ptr <asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange);
        virtual void onUnavailable(const::boost::shared_ptr <asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange);

        // TimerCallbackIF
        virtual void onExpired(asf::core::Timer                          & timer,
                               boost::shared_ptr <asf::core::TimerPayload> payload);
        // GetListMainConnectionsCallbackIF
        virtual void onGetListMainConnectionsError(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const boost::shared_ptr< GetListMainConnectionsError >& error);
        virtual void onGetListMainConnectionsResponse(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const boost::shared_ptr< GetListMainConnectionsResponse >& response);

        // GetListMainSourcesCallbackIF
        virtual void onGetListMainSourcesError(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const boost::shared_ptr< GetListMainSourcesError >& error);
        virtual void onGetListMainSourcesResponse(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const boost::shared_ptr< GetListMainSourcesResponse >& response);

        // NumberOfMainConnectionsChangedCallbackIF
        virtual void onNumberOfMainConnectionsChangedError(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const boost::shared_ptr< NumberOfMainConnectionsChangedError >& error);
        virtual void onNumberOfMainConnectionsChangedSignal(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const boost::shared_ptr< NumberOfMainConnectionsChangedSignal >& signal);

        // NewMainConnectionCallbackIF
        virtual void onNewMainConnectionError(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const boost::shared_ptr< NewMainConnectionError >& error);
        virtual void onNewMainConnectionSignal(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const boost::shared_ptr< NewMainConnectionSignal >& signal);

        // MainConnectionStateChangedCallbackIF
        virtual void onMainConnectionStateChangedError(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const boost::shared_ptr< MainConnectionStateChangedError >& error);
        virtual void onMainConnectionStateChangedSignal(const ::boost::shared_ptr< CommandInterfaceProxy >& proxy, const boost::shared_ptr< MainConnectionStateChangedSignal >& signal);


    private:

        ::boost::shared_ptr <CommandInterfaceProxy> _AudioProxy;

    public:
        virtual const tChar* getName() const { return "lcmdbusclient_tclClientAudio"; }

        virtual tVoid vHandleMessage(lcmdbusclient_tclBaseIf::TMsg* pMsg);
        virtual tVoid vHandleTraceMessage(const tUChar* /*puchData*/) {}
        virtual tVoid vGetReferences();
        virtual tVoid vStartCommunication();
        virtual tVoid vTraceInfo();

        // lcmdbusclient_ClientAudioDeclarationsPart: user specific code start
        std::map<int, std::string> _MappingTable; // source id to source name mapping table
        // lcmdbusclient_ClientAudioDeclarationsPart: user specific code end
    };

}}}} // namespace org { namespace bosch { namespace cm { namespace lcmdbusclient {

#endif // ifndef _LCMDBUSCLIENT_CLIENTAUDIO_H

