/*!
  * \file spm_SystemStateManagerInf4cv.h
  *  \brief
  *    Generic project specific parts of the spm statemachine
  *    generated file
  *    generated in  : 2017
  *    generated with: spm_SystemStateManager.h.tpl
  *
  *  \note
  *   PROJECT: Gen3
  *   SW-COMPONENT: LCM Life Cycle Management (FC SPM)
  * @copyright   (C) 2012 - 2017 Robert Bosch GmbH.
  *              The reproduction, distribution and utilization of this file as
  *              well as the communication of its contents to others without express
  *              authorization is prohibited. Offenders will be held liable for the
  *              payment of damages. All rights reserved in the event of the grant
  *              of a patent, utility model or design.
  *
  ******
  */
  
#ifndef __SPM_SYSTEMSTATEMANAGERINF4CV_H
#define __SPM_SYSTEMSTATEMANAGERINF4CV_H

// spm_tclSystemStateManagerInf4cv_Includes: user specific code start
// spm_tclSystemStateManagerInf4cv_Includes: user specific code end

#include "spm_SystemStateManager.h"

class spm_tclSystemPowerManagerConfig;
class spm_tclSupervisionManagerConfig;

// spm_tclSystemStateManagerInf4cv_Defines: user specific code start
// spm_tclSystemStateManagerInf4cv_Defines: user specific code end

#define SPM_U32_SYSTEM_STATE_ACTIVATE_AUTOMATIC            (tU32)0x00080001

class ISpmFactory;

/*!
  *  \class spm_tclSystemStateManagerInf4cv
  *  \brief This generic class handles differents parts of statemachine. It checks entry point of system state transitions.
          It sets transiton to new system state.

        The ISpmFactory object creates an instance of this class.

  */
class spm_tclSystemStateManagerInf4cv : public spm_tclSystemStateManager
   {
public:
   spm_tclSystemStateManagerInf4cv(const ISpmFactory& factory);
   virtual ~spm_tclSystemStateManagerInf4cv();

protected:
   // ISpmBase interface functions
   // used from base class -> virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vStartCommunication();
   virtual tVoid vStartLateCommunication();
   virtual tVoid vGetReferences();
   virtual const tChar*getName() const { return( "spm_tclSystemStateManagerInf4cv" ); }

   virtual tU8 u8GetFsmId() const { return( SPM_U8_CONFIG_INF4CV ); }

   static spm_tclSystemStateManagerInf4cv *_poMyRef;

   static T_SYSTEM_STATE_ENTRY             _arStateTable[];
   static TStateTransitionElement          _aSysStateTransitionTable[];

   virtual tVoid                           vStateNoTransition(tVoid);

   virtual tBool bActStateReached(tU32 u32SystemState) const;

   virtual tVoid vHandleMessage(tU32 u32Message,
                                tU32 u32Param = 0);

   virtual tVoid vCheckNewStateTransition();

   virtual tU32 u32GetNumberOfTransitionTableEntries() const;

   virtual tU32 u32GetNumberOfStateEntries() const;

   // spm_tclSystemStateManagerInf4cv_Generator: user specific code start
   //gen code start
    #ifndef SPM_SYSTEM_STATE_VERSION
    #define SPM_SYSTEM_STATE_VERSION    "FSM VERSION UNKNOWN"
    #endif

   static tVoid vStateEntryPrepareshutdown(tVoid);
   static tVoid vStateReachedPrepareshutdown(tVoid);
   static tVoid vStateExitPrepareshutdown(tVoid);

   static tVoid vStateEntryShutdown(tVoid);
   static tVoid vStateReachedShutdown(tVoid);
   static tVoid vStateExitShutdown(tVoid);

   static tVoid vStateEntryBackground(tVoid);
   static tVoid vStateReachedBackground(tVoid);
   static tVoid vStateExitBackground(tVoid);

   static tVoid vStateEntryDooropen(tVoid);
   static tVoid vStateReachedDooropen(tVoid);
   static tVoid vStateExitDooropen(tVoid);

   static tVoid vStateEntryStandby(tVoid);
   static tVoid vStateReachedStandby(tVoid);
   static tVoid vStateExitStandby(tVoid);

   static tVoid vStateEntryDownload(tVoid);
   static tVoid vStateReachedDownload(tVoid);
   static tVoid vStateExitDownload(tVoid);

   static tVoid vStateEntryOn(tVoid);
   static tVoid vStateReachedOn(tVoid);
   static tVoid vStateExitOn(tVoid);

   static tVoid vStateEntryIgnition(tVoid);
   static tVoid vStateReachedIgnition(tVoid);
   static tVoid vStateExitIgnition(tVoid);

   static tVoid vStateEntryDiagnosis(tVoid);
   static tVoid vStateReachedDiagnosis(tVoid);
   static tVoid vStateExitDiagnosis(tVoid);

   static tVoid vStateEntryStateprofile(tVoid);
   static tVoid vStateReachedStateprofile(tVoid);
   static tVoid vStateExitStateprofile(tVoid);

   static tVoid vStateEntryMmiontel(tVoid);
   static tVoid vStateReachedMmiontel(tVoid);
   static tVoid vStateExitMmiontel(tVoid);

   static tVoid vStateEntrySafe(tVoid);
   static tVoid vStateReachedSafe(tVoid);
   static tVoid vStateExitSafe(tVoid);

   static tVoid vStateEntryMmistandby(tVoid);
   static tVoid vStateReachedMmistandby(tVoid);
   static tVoid vStateExitMmistandby(tVoid);

   static tVoid vStateEntryMmion(tVoid);
   static tVoid vStateReachedMmion(tVoid);
   static tVoid vStateExitMmion(tVoid);

   static tVoid vStateEntryMmistandbypwrsave1(tVoid);
   static tVoid vStateReachedMmistandbypwrsave1(tVoid);
   static tVoid vStateExitMmistandbypwrsave1(tVoid);

   static tVoid vStateEntryMmistandbypwrsave2(tVoid);
   static tVoid vStateReachedMmistandbypwrsave2(tVoid);
   static tVoid vStateExitMmistandbypwrsave2(tVoid);

   static tVoid vStateEntryMmionswdl(tVoid);
   static tVoid vStateReachedMmionswdl(tVoid);
   static tVoid vStateExitMmionswdl(tVoid);
   //gen code stop
   // spm_tclSystemStateManagerInf4cv_Generator: user specific code end

   // spm_tclSystemStateManagerInf4cv_Declaration: user specific code start
   // spm_tclSystemStateManagerInf4cv_Declaration: user specific code end

   };

#endif // __SPM_SYSTEMSTATEMANAGERINF4CV_H

