/*!
 * \file   :  spm_SystemStateFsmFuncInf4cv.cpp
 * \brief  :  Generated/Updated trace command message handler file
  
 *  \b SW-COMPONENT: FC SPM \n
 *  \b COPYRIGHT:    (C) 2012 - 2022 Robert Bosch GmbH. \n
 *
 *  The reproduction, distribution and utilization of this file as
 *  well as the communication of its contents to others without express
 *  authorization is prohibited. Offenders will be held liable for the
 *  payment of damages. All rights reserved in the event of the grant
 *  of a patent, utility model or design.
 */

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#include "spm_Config.h"

//my class header
#include "spm_SystemStateManagerInf4cv.h"

#ifdef VARIANT_S_FTR_ENABLE_INC_SYSTEMSTATEMACHINE
#include "spm_ISystemStateMachineIncClientHandler.h"
#endif

// spm_SystemStateFsmFuncConfigInclude: user specific code start
#include "spm_SystemStateMachineServiceHandler.h"
//#include "spm_tclAnimationServiceHandler.h"
#include "../../../../LcmProject/clienthandler/spm_AnimationServiceHandler.h"
// spm_SystemStateFsmFuncConfigInclude: user specific code end

#include "spm_ISystemPowerManager.h"
#include "spm_IFactory.h"

//spm helper
#include "spm_CriticalSection.h"

//needed for static trigger functions
#include "spm_SubStateHandlerConfig.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS SPM_TRACE_CLASS_SPM_PRJ
#include "trcGenProj/Header/spm_SystemStateFsmFuncInf4cv.cpp.trc.h"
#endif

#include "spm_trace.h"

T_SYSTEM_STATE_ENTRY spm_tclSystemStateManagerInf4cv::_arStateTable[] = {
   {
      SPM_SYSTEM_PREPARE_SHUTDOWN,
      180000,
      vStateEntryPrepareshutdown,
      vStateReachedPrepareshutdown,
      vStateExitPrepareshutdown
   },
   {
      SPM_SYSTEM_SHUTDOWN,
      0,
      vStateEntryShutdown,
      vStateReachedShutdown,
      vStateExitShutdown
   },
   {
      SPM_SYSTEM_BACKGROUND,
      5000,
      vStateEntryBackground,
      vStateReachedBackground,
      vStateExitBackground
   },
   {
      SPM_SYSTEM_DOOR_OPEN,
      600000,
      vStateEntryDooropen,
      vStateReachedDooropen,
      vStateExitDooropen
   },
   {
      SPM_SYSTEM_STANDBY,
      10000,
      vStateEntryStandby,
      vStateReachedStandby,
      vStateExitStandby
   },
   {
      SPM_SYSTEM_DOWNLOAD,
      3600000,
      vStateEntryDownload,
      vStateReachedDownload,
      vStateExitDownload
   },
   {
      SPM_SYSTEM_ON,
      0,
      vStateEntryOn,
      vStateReachedOn,
      vStateExitOn
   },
   {
      SPM_SYSTEM_IGNITION,
      0,
      vStateEntryIgnition,
      vStateReachedIgnition,
      vStateExitIgnition
   },
   {
      SPM_SYSTEM_DIAGNOSIS,
      0,
      vStateEntryDiagnosis,
      vStateReachedDiagnosis,
      vStateExitDiagnosis
   },
   {
      SPM_SYSTEM_STATE_PROFILE,
      600000,
      vStateEntryStateprofile,
      vStateReachedStateprofile,
      vStateExitStateprofile
   },
   {
      SPM_SYSTEM_MMI_ON_TEL,
      0,
      vStateEntryMmiontel,
      vStateReachedMmiontel,
      vStateExitMmiontel
   },
   {
      SPM_SYSTEM_SAFE,
      0,
      vStateEntrySafe,
      vStateReachedSafe,
      vStateExitSafe
   },
   {
      SPM_SYSTEM_MMI_STANDBY,
      20000,
      vStateEntryMmistandby,
      vStateReachedMmistandby,
      vStateExitMmistandby
   },
   {
      SPM_SYSTEM_MMI_ON,
      0,
      vStateEntryMmion,
      vStateReachedMmion,
      vStateExitMmion
   },
   {
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1,
      5000,
      vStateEntryMmistandbypwrsave1,
      vStateReachedMmistandbypwrsave1,
      vStateExitMmistandbypwrsave1
   },
   {
      SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_2,
      4000,
      vStateEntryMmistandbypwrsave2,
      vStateReachedMmistandbypwrsave2,
      vStateExitMmistandbypwrsave2
   },
   {
      SPM_SYSTEM_MMI_ON_SWDL,
      3600000,
      vStateEntryMmionswdl,
      vStateReachedMmionswdl,
      vStateExitMmionswdl
   },
};

tU32 spm_tclSystemStateManagerInf4cv::u32GetNumberOfStateEntries() const { return( sizeof( _arStateTable ) / sizeof( _arStateTable[0] ) ); }
// *********************************************************************
// ****    HANDLE STATE CHANGES SPM_SYSTEM_PREPARE_SHUTDOWN    ****************
// *********************************************************************
tVoid spm_tclSystemStateManagerInf4cv::vStateEntryPrepareshutdown(){
   SPM_NULL_POINTER_CHECK(_poMyRef);
   #ifdef VARIANT_S_FTR_ENABLE_INC_SYSTEMSTATEMACHINE
   ISpmSystemStateMachineIncClientHandler* poclIncSystemState = dynamic_cast < ISpmSystemStateMachineIncClientHandler* >( _poMyRef->_crfFactory.getSpmObjHandler("ISpmSystemStateMachineIncClientHandler") );
   if (poclIncSystemState != NULL) {
      ETG_TRACE_USR1( ( "spm_tclSystemStateManagerInf4cv::vStateEntryPrepareshutdown(): Send AppSystemState to SCC!" ) );
      (tVoid)poclIncSystemState->bSetAppSystemState(SystemSm_SPM_SYSTEM_PREPARE_SHUTDOWN);
   } else {
      ETG_TRACE_USR1(("spm_tclSystemStateManagerInf4cv::vStateEntryPrepareshutdown(): INC handler not running!"));
   } 
   #endif

   // vStateEntryPrepareshutdown: user specific code start
   // vStateEntryPrepareshutdown: user specific code end

   // Update startup configuration
   _poMyRef->vCheckStartOrderConfiguration();
} // vStateEntryPrepareshutdown

tVoid spm_tclSystemStateManagerInf4cv::vStateReachedPrepareshutdown(){
   // vStateReachedPrepareshutdown: user specific code start
   // vStateReachedPrepareshutdown: user specific code end

   SPM_NULL_POINTER_CHECK(_poMyRef);
   if (_poMyRef->_poclWorkerServer){
      _poMyRef->_poclWorkerServer->bPostMessage("ISpmSystemPowerManager", SPM_U32_WORKER_SPM_PREPARE_SHUTDOWN);
   }
} // vStateReachedPrepareshutdown

tVoid spm_tclSystemStateManagerInf4cv::vStateExitPrepareshutdown(){
   // vStateExitPrepareshutdown: user specific code start
   // vStateExitPrepareshutdown: user specific code end
} // vStateExitPrepareshutdown

// *********************************************************************
// ****    HANDLE STATE CHANGES SPM_SYSTEM_SHUTDOWN    ****************
// *********************************************************************
tVoid spm_tclSystemStateManagerInf4cv::vStateEntryShutdown(){
   SPM_NULL_POINTER_CHECK(_poMyRef);
   #ifdef VARIANT_S_FTR_ENABLE_INC_SYSTEMSTATEMACHINE
   ISpmSystemStateMachineIncClientHandler* poclIncSystemState = dynamic_cast < ISpmSystemStateMachineIncClientHandler* >( _poMyRef->_crfFactory.getSpmObjHandler("ISpmSystemStateMachineIncClientHandler") );
   if (poclIncSystemState != NULL) {
      ETG_TRACE_USR1( ( "spm_tclSystemStateManagerInf4cv::vStateEntryShutdown(): Send AppSystemState to SCC!" ) );
      (tVoid)poclIncSystemState->bSetAppSystemState(SystemSm_SPM_SYSTEM_SHUTDOWN);
   } else {
      ETG_TRACE_USR1(("spm_tclSystemStateManagerInf4cv::vStateEntryShutdown(): INC handler not running!"));
   } 
   #endif

   // vStateEntryShutdown: user specific code start
   // vStateEntryShutdown: user specific code end

   ETG_TRACE_USR1( ( "spm_tclSystemStateManagerInf4cv::vStateEntryShutdown(): Point of no return reached." ) );
   _poMyRef->_bPointOfNoReturnReached = TRUE;
   if (_poMyRef->_poclSystemPowerManager){
      _poMyRef->_poclSystemPowerManager->vShutdownSystem(SPM_U32_SHUTDOWN_NORMAL);
   }
} // vStateEntryShutdown

tVoid spm_tclSystemStateManagerInf4cv::vStateReachedShutdown(){
   // vStateReachedShutdown: user specific code start
   // vStateReachedShutdown: user specific code end
} // vStateReachedShutdown

tVoid spm_tclSystemStateManagerInf4cv::vStateExitShutdown(){
   // vStateExitShutdown: user specific code start
   // vStateExitShutdown: user specific code end
} // vStateExitShutdown

// *********************************************************************
// ****    HANDLE STATE CHANGES SPM_SYSTEM_BACKGROUND    ****************
// *********************************************************************
tVoid spm_tclSystemStateManagerInf4cv::vStateEntryBackground(){
   SPM_NULL_POINTER_CHECK(_poMyRef);
   #ifdef VARIANT_S_FTR_ENABLE_INC_SYSTEMSTATEMACHINE
   ISpmSystemStateMachineIncClientHandler* poclIncSystemState = dynamic_cast < ISpmSystemStateMachineIncClientHandler* >( _poMyRef->_crfFactory.getSpmObjHandler("ISpmSystemStateMachineIncClientHandler") );
   if (poclIncSystemState != NULL) {
      ETG_TRACE_USR1( ( "spm_tclSystemStateManagerInf4cv::vStateEntryBackground(): Send AppSystemState to SCC!" ) );
      (tVoid)poclIncSystemState->bSetAppSystemState(SystemSm_SPM_SYSTEM_BACKGROUND);
   } else {
      ETG_TRACE_USR1(("spm_tclSystemStateManagerInf4cv::vStateEntryBackground(): INC handler not running!"));
   } 
   #endif

   // vStateEntryBackground: user specific code start
   // vStateEntryBackground: user specific code end
} // vStateEntryBackground

tVoid spm_tclSystemStateManagerInf4cv::vStateReachedBackground(){
   // vStateReachedBackground: user specific code start
   // vStateReachedBackground: user specific code end
} // vStateReachedBackground

tVoid spm_tclSystemStateManagerInf4cv::vStateExitBackground(){
   // vStateExitBackground: user specific code start
   // vStateExitBackground: user specific code end
} // vStateExitBackground

// *********************************************************************
// ****    HANDLE STATE CHANGES SPM_SYSTEM_DOOR_OPEN    ****************
// *********************************************************************
tVoid spm_tclSystemStateManagerInf4cv::vStateEntryDooropen(){
   SPM_NULL_POINTER_CHECK(_poMyRef);
   #ifdef VARIANT_S_FTR_ENABLE_INC_SYSTEMSTATEMACHINE
   ISpmSystemStateMachineIncClientHandler* poclIncSystemState = dynamic_cast < ISpmSystemStateMachineIncClientHandler* >( _poMyRef->_crfFactory.getSpmObjHandler("ISpmSystemStateMachineIncClientHandler") );
   if (poclIncSystemState != NULL) {
      ETG_TRACE_USR1( ( "spm_tclSystemStateManagerInf4cv::vStateEntryDooropen(): Send AppSystemState to SCC!" ) );
      (tVoid)poclIncSystemState->bSetAppSystemState(SystemSm_SPM_SYSTEM_DOOR_OPEN);
   } else {
      ETG_TRACE_USR1(("spm_tclSystemStateManagerInf4cv::vStateEntryDooropen(): INC handler not running!"));
   } 
   #endif

   // vStateEntryDooropen: user specific code start
   // vStateEntryDooropen: user specific code end
} // vStateEntryDooropen

tVoid spm_tclSystemStateManagerInf4cv::vStateReachedDooropen(){
   // vStateReachedDooropen: user specific code start
   // vStateReachedDooropen: user specific code end
} // vStateReachedDooropen

tVoid spm_tclSystemStateManagerInf4cv::vStateExitDooropen(){
   // vStateExitDooropen: user specific code start
   // vStateExitDooropen: user specific code end
} // vStateExitDooropen

// *********************************************************************
// ****    HANDLE STATE CHANGES SPM_SYSTEM_STANDBY    ****************
// *********************************************************************
tVoid spm_tclSystemStateManagerInf4cv::vStateEntryStandby(){
   SPM_NULL_POINTER_CHECK(_poMyRef);
   #ifdef VARIANT_S_FTR_ENABLE_INC_SYSTEMSTATEMACHINE
   ISpmSystemStateMachineIncClientHandler* poclIncSystemState = dynamic_cast < ISpmSystemStateMachineIncClientHandler* >( _poMyRef->_crfFactory.getSpmObjHandler("ISpmSystemStateMachineIncClientHandler") );
   if (poclIncSystemState != NULL) {
      ETG_TRACE_USR1( ( "spm_tclSystemStateManagerInf4cv::vStateEntryStandby(): Send AppSystemState to SCC!" ) );
      (tVoid)poclIncSystemState->bSetAppSystemState(SystemSm_SPM_SYSTEM_STANDBY);
   } else {
      ETG_TRACE_USR1(("spm_tclSystemStateManagerInf4cv::vStateEntryStandby(): INC handler not running!"));
   } 
   #endif

   // vStateEntryStandby: user specific code start
   // vStateEntryStandby: user specific code end
} // vStateEntryStandby

tVoid spm_tclSystemStateManagerInf4cv::vStateReachedStandby(){
   // vStateReachedStandby: user specific code start
   // vStateReachedStandby: user specific code end
} // vStateReachedStandby

tVoid spm_tclSystemStateManagerInf4cv::vStateExitStandby(){
   // vStateExitStandby: user specific code start
   // vStateExitStandby: user specific code end
} // vStateExitStandby

// *********************************************************************
// ****    HANDLE STATE CHANGES SPM_SYSTEM_DOWNLOAD    ****************
// *********************************************************************
tVoid spm_tclSystemStateManagerInf4cv::vStateEntryDownload(){
   SPM_NULL_POINTER_CHECK(_poMyRef);
   #ifdef VARIANT_S_FTR_ENABLE_INC_SYSTEMSTATEMACHINE
   ISpmSystemStateMachineIncClientHandler* poclIncSystemState = dynamic_cast < ISpmSystemStateMachineIncClientHandler* >( _poMyRef->_crfFactory.getSpmObjHandler("ISpmSystemStateMachineIncClientHandler") );
   if (poclIncSystemState != NULL) {
      ETG_TRACE_USR1( ( "spm_tclSystemStateManagerInf4cv::vStateEntryDownload(): Send AppSystemState to SCC!" ) );
      (tVoid)poclIncSystemState->bSetAppSystemState(SystemSm_SPM_SYSTEM_DOWNLOAD);
   } else {
      ETG_TRACE_USR1(("spm_tclSystemStateManagerInf4cv::vStateEntryDownload(): INC handler not running!"));
   } 
   #endif

   // vStateEntryDownload: user specific code start
   // vStateEntryDownload: user specific code end
} // vStateEntryDownload

tVoid spm_tclSystemStateManagerInf4cv::vStateReachedDownload(){
   // vStateReachedDownload: user specific code start
   // vStateReachedDownload: user specific code end
} // vStateReachedDownload

tVoid spm_tclSystemStateManagerInf4cv::vStateExitDownload(){
   // vStateExitDownload: user specific code start
   // vStateExitDownload: user specific code end
} // vStateExitDownload

// *********************************************************************
// ****    HANDLE STATE CHANGES SPM_SYSTEM_ON    ****************
// *********************************************************************
tVoid spm_tclSystemStateManagerInf4cv::vStateEntryOn(){
   SPM_NULL_POINTER_CHECK(_poMyRef);
   #ifdef VARIANT_S_FTR_ENABLE_INC_SYSTEMSTATEMACHINE
   ISpmSystemStateMachineIncClientHandler* poclIncSystemState = dynamic_cast < ISpmSystemStateMachineIncClientHandler* >( _poMyRef->_crfFactory.getSpmObjHandler("ISpmSystemStateMachineIncClientHandler") );
   if (poclIncSystemState != NULL) {
      ETG_TRACE_USR1( ( "spm_tclSystemStateManagerInf4cv::vStateEntryOn(): Send AppSystemState to SCC!" ) );
      (tVoid)poclIncSystemState->bSetAppSystemState(SystemSm_SPM_SYSTEM_ON);
   } else {
      ETG_TRACE_USR1(("spm_tclSystemStateManagerInf4cv::vStateEntryOn(): INC handler not running!"));
   } 
   #endif

   // vStateEntryOn: user specific code start
  	if (_poMyRef->_poclWorkerServer)
	{
		_poMyRef->_poclWorkerServer->bPostMessage("ISpmSystemStateManager", SPM_U32_WORKER_SSM_ACTIVATE_AUTOMATIC);
	}
   // vStateEntryOn: user specific code end
} // vStateEntryOn

tVoid spm_tclSystemStateManagerInf4cv::vStateReachedOn(){
   // vStateReachedOn: user specific code start
   // vStateReachedOn: user specific code end
} // vStateReachedOn

tVoid spm_tclSystemStateManagerInf4cv::vStateExitOn(){
   // vStateExitOn: user specific code start
   // vStateExitOn: user specific code end
} // vStateExitOn

// *********************************************************************
// ****    HANDLE STATE CHANGES SPM_SYSTEM_IGNITION    ****************
// *********************************************************************
tVoid spm_tclSystemStateManagerInf4cv::vStateEntryIgnition(){
   SPM_NULL_POINTER_CHECK(_poMyRef);
   #ifdef VARIANT_S_FTR_ENABLE_INC_SYSTEMSTATEMACHINE
   ISpmSystemStateMachineIncClientHandler* poclIncSystemState = dynamic_cast < ISpmSystemStateMachineIncClientHandler* >( _poMyRef->_crfFactory.getSpmObjHandler("ISpmSystemStateMachineIncClientHandler") );
   if (poclIncSystemState != NULL) {
      ETG_TRACE_USR1( ( "spm_tclSystemStateManagerInf4cv::vStateEntryIgnition(): Send AppSystemState to SCC!" ) );
      (tVoid)poclIncSystemState->bSetAppSystemState(SystemSm_SPM_SYSTEM_IGNITION);
   } else {
      ETG_TRACE_USR1(("spm_tclSystemStateManagerInf4cv::vStateEntryIgnition(): INC handler not running!"));
   } 
   #endif

   // vStateEntryIgnition: user specific code start
	if (_poMyRef->_poclWorkerServer){
		_poMyRef->_poclWorkerServer->bPostMessage("ISpmSystemStateManager", SPM_U32_WORKER_SSM_DEACTIVATE_AUTOMATIC);
	}
   //Setting the trigger when system enters user off state due low voltage condition
	if( _poMyRef->_poclSubStateHandler->bIsTriggerSet(SPM_U32_SUBSTATE_Q_CRITICAL))
	{
		_poMyRef->_poclSubStateHandler->vSetSubStateType(SPM_U32_SUBSTATE_DEMAND_AUDIO_MUTE,TRUE);
	}
   // vStateEntryIgnition: user specific code end
} // vStateEntryIgnition

tVoid spm_tclSystemStateManagerInf4cv::vStateReachedIgnition(){
   // vStateReachedIgnition: user specific code start
   // vStateReachedIgnition: user specific code end
} // vStateReachedIgnition

tVoid spm_tclSystemStateManagerInf4cv::vStateExitIgnition(){
   // vStateExitIgnition: user specific code start

   //Clearing the low voltage trigger when coming out of ignition state
	if( _poMyRef->_poclSubStateHandler->bIsTriggerSet(SPM_U32_SUBSTATE_DEMAND_AUDIO_MUTE))
	{
	_poMyRef->_poclSubStateHandler->vSetSubStateType(SPM_U32_SUBSTATE_DEMAND_AUDIO_MUTE,FALSE);
	}
   // vStateExitIgnition: user specific code end
} // vStateExitIgnition

// *********************************************************************
// ****    HANDLE STATE CHANGES SPM_SYSTEM_DIAGNOSIS    ****************
// *********************************************************************
tVoid spm_tclSystemStateManagerInf4cv::vStateEntryDiagnosis(){
   SPM_NULL_POINTER_CHECK(_poMyRef);
   #ifdef VARIANT_S_FTR_ENABLE_INC_SYSTEMSTATEMACHINE
   ISpmSystemStateMachineIncClientHandler* poclIncSystemState = dynamic_cast < ISpmSystemStateMachineIncClientHandler* >( _poMyRef->_crfFactory.getSpmObjHandler("ISpmSystemStateMachineIncClientHandler") );
   if (poclIncSystemState != NULL) {
      ETG_TRACE_USR1( ( "spm_tclSystemStateManagerInf4cv::vStateEntryDiagnosis(): Send AppSystemState to SCC!" ) );
      (tVoid)poclIncSystemState->bSetAppSystemState(SystemSm_SPM_SYSTEM_DIAGNOSIS);
   } else {
      ETG_TRACE_USR1(("spm_tclSystemStateManagerInf4cv::vStateEntryDiagnosis(): INC handler not running!"));
   } 
   #endif

   // vStateEntryDiagnosis: user specific code start
   // vStateEntryDiagnosis: user specific code end
} // vStateEntryDiagnosis

tVoid spm_tclSystemStateManagerInf4cv::vStateReachedDiagnosis(){
   // vStateReachedDiagnosis: user specific code start
   // vStateReachedDiagnosis: user specific code end
} // vStateReachedDiagnosis

tVoid spm_tclSystemStateManagerInf4cv::vStateExitDiagnosis(){
   // vStateExitDiagnosis: user specific code start
   // vStateExitDiagnosis: user specific code end
} // vStateExitDiagnosis

// *********************************************************************
// ****    HANDLE STATE CHANGES SPM_SYSTEM_STATE_PROFILE    ****************
// *********************************************************************
tVoid spm_tclSystemStateManagerInf4cv::vStateEntryStateprofile(){
   SPM_NULL_POINTER_CHECK(_poMyRef);
   #ifdef VARIANT_S_FTR_ENABLE_INC_SYSTEMSTATEMACHINE
   ISpmSystemStateMachineIncClientHandler* poclIncSystemState = dynamic_cast < ISpmSystemStateMachineIncClientHandler* >( _poMyRef->_crfFactory.getSpmObjHandler("ISpmSystemStateMachineIncClientHandler") );
   if (poclIncSystemState != NULL) {
      ETG_TRACE_USR1( ( "spm_tclSystemStateManagerInf4cv::vStateEntryStateprofile(): Send AppSystemState to SCC!" ) );
      (tVoid)poclIncSystemState->bSetAppSystemState(SystemSm_SPM_SYSTEM_STATE_PROFILE);
   } else {
      ETG_TRACE_USR1(("spm_tclSystemStateManagerInf4cv::vStateEntryStateprofile(): INC handler not running!"));
   } 
   #endif

   // vStateEntryStateprofile: user specific code start
  	if (_poMyRef->_poclWorkerServer)
	{
		_poMyRef->_poclWorkerServer->bPostMessage("ISpmSystemStateManager", SPM_U32_WORKER_SSM_ACTIVATE_AUTOMATIC);
	}
   // vStateEntryStateprofile: user specific code end
} // vStateEntryStateprofile

tVoid spm_tclSystemStateManagerInf4cv::vStateReachedStateprofile(){
   // vStateReachedStateprofile: user specific code start
   // vStateReachedStateprofile: user specific code end
} // vStateReachedStateprofile

tVoid spm_tclSystemStateManagerInf4cv::vStateExitStateprofile(){
   // vStateExitStateprofile: user specific code start
   // vStateExitStateprofile: user specific code end
} // vStateExitStateprofile

// *********************************************************************
// ****    HANDLE STATE CHANGES SPM_SYSTEM_MMI_ON_TEL    ****************
// *********************************************************************
tVoid spm_tclSystemStateManagerInf4cv::vStateEntryMmiontel(){
   SPM_NULL_POINTER_CHECK(_poMyRef);
   #ifdef VARIANT_S_FTR_ENABLE_INC_SYSTEMSTATEMACHINE
   ISpmSystemStateMachineIncClientHandler* poclIncSystemState = dynamic_cast < ISpmSystemStateMachineIncClientHandler* >( _poMyRef->_crfFactory.getSpmObjHandler("ISpmSystemStateMachineIncClientHandler") );
   if (poclIncSystemState != NULL) {
      ETG_TRACE_USR1( ( "spm_tclSystemStateManagerInf4cv::vStateEntryMmiontel(): Send AppSystemState to SCC!" ) );
      (tVoid)poclIncSystemState->bSetAppSystemState(SystemSm_SPM_SYSTEM_ON);
   } else {
      ETG_TRACE_USR1(("spm_tclSystemStateManagerInf4cv::vStateEntryMmiontel(): INC handler not running!"));
   } 
   #endif

   // vStateEntryMmiontel: user specific code start
   // vStateEntryMmiontel: user specific code end
} // vStateEntryMmiontel

tVoid spm_tclSystemStateManagerInf4cv::vStateReachedMmiontel(){
   // vStateReachedMmiontel: user specific code start
   // vStateReachedMmiontel: user specific code end
} // vStateReachedMmiontel

tVoid spm_tclSystemStateManagerInf4cv::vStateExitMmiontel(){
   // vStateExitMmiontel: user specific code start
   // vStateExitMmiontel: user specific code end
} // vStateExitMmiontel

// *********************************************************************
// ****    HANDLE STATE CHANGES SPM_SYSTEM_SAFE    ****************
// *********************************************************************
tVoid spm_tclSystemStateManagerInf4cv::vStateEntrySafe(){
   SPM_NULL_POINTER_CHECK(_poMyRef);
   #ifdef VARIANT_S_FTR_ENABLE_INC_SYSTEMSTATEMACHINE
   ISpmSystemStateMachineIncClientHandler* poclIncSystemState = dynamic_cast < ISpmSystemStateMachineIncClientHandler* >( _poMyRef->_crfFactory.getSpmObjHandler("ISpmSystemStateMachineIncClientHandler") );
   if (poclIncSystemState != NULL) {
      ETG_TRACE_USR1( ( "spm_tclSystemStateManagerInf4cv::vStateEntrySafe(): Send AppSystemState to SCC!" ) );
      (tVoid)poclIncSystemState->bSetAppSystemState(SystemSm_SPM_SYSTEM_ON);
   } else {
      ETG_TRACE_USR1(("spm_tclSystemStateManagerInf4cv::vStateEntrySafe(): INC handler not running!"));
   } 
   #endif

   // vStateEntrySafe: user specific code start
   // vStateEntrySafe: user specific code end
} // vStateEntrySafe

tVoid spm_tclSystemStateManagerInf4cv::vStateReachedSafe(){
   // vStateReachedSafe: user specific code start
   // vStateReachedSafe: user specific code end
} // vStateReachedSafe

tVoid spm_tclSystemStateManagerInf4cv::vStateExitSafe(){
   // vStateExitSafe: user specific code start
   // vStateExitSafe: user specific code end
} // vStateExitSafe

// *********************************************************************
// ****    HANDLE STATE CHANGES SPM_SYSTEM_MMI_STANDBY    ****************
// *********************************************************************
tVoid spm_tclSystemStateManagerInf4cv::vStateEntryMmistandby(){
   SPM_NULL_POINTER_CHECK(_poMyRef);
   #ifdef VARIANT_S_FTR_ENABLE_INC_SYSTEMSTATEMACHINE
   ISpmSystemStateMachineIncClientHandler* poclIncSystemState = dynamic_cast < ISpmSystemStateMachineIncClientHandler* >( _poMyRef->_crfFactory.getSpmObjHandler("ISpmSystemStateMachineIncClientHandler") );
   if (poclIncSystemState != NULL) {
      ETG_TRACE_USR1( ( "spm_tclSystemStateManagerInf4cv::vStateEntryMmistandby(): Send AppSystemState to SCC!" ) );
      (tVoid)poclIncSystemState->bSetAppSystemState(SystemSm_SPM_SYSTEM_ON);
   } else {
      ETG_TRACE_USR1(("spm_tclSystemStateManagerInf4cv::vStateEntryMmistandby(): INC handler not running!"));
   } 
   #endif

   // vStateEntryMmistandby: user specific code start
   tU8 u8AnimationType = 0;
    spm_tclAnimationServiceHandler* poAnimationClient = dynamic_cast <spm_tclAnimationServiceHandler*>( ISpmFactory::_poFactoryRef->getClientHandler("spm_tclAnimationServiceHandler") );
    if(NULL != poAnimationClient){
    poAnimationClient->vStartAnimation(u8AnimationType);
    }
	if (_poMyRef->_poclWorkerServer){
		_poMyRef->_poclWorkerServer->bPostMessage("ISpmSystemStateManager", SPM_U32_WORKER_SSM_ACTIVATE_AUTOMATIC);
	}
   // vStateEntryMmistandby: user specific code end
} // vStateEntryMmistandby

tVoid spm_tclSystemStateManagerInf4cv::vStateReachedMmistandby(){
   // vStateReachedMmistandby: user specific code start
   // vStateReachedMmistandby: user specific code end
} // vStateReachedMmistandby

tVoid spm_tclSystemStateManagerInf4cv::vStateExitMmistandby(){
   // vStateExitMmistandby: user specific code start
   // vStateExitMmistandby: user specific code end
} // vStateExitMmistandby

// *********************************************************************
// ****    HANDLE STATE CHANGES SPM_SYSTEM_MMI_ON    ****************
// *********************************************************************
tVoid spm_tclSystemStateManagerInf4cv::vStateEntryMmion(){
   SPM_NULL_POINTER_CHECK(_poMyRef);
   #ifdef VARIANT_S_FTR_ENABLE_INC_SYSTEMSTATEMACHINE
   ISpmSystemStateMachineIncClientHandler* poclIncSystemState = dynamic_cast < ISpmSystemStateMachineIncClientHandler* >( _poMyRef->_crfFactory.getSpmObjHandler("ISpmSystemStateMachineIncClientHandler") );
   if (poclIncSystemState != NULL) {
      ETG_TRACE_USR1( ( "spm_tclSystemStateManagerInf4cv::vStateEntryMmion(): Send AppSystemState to SCC!" ) );
      (tVoid)poclIncSystemState->bSetAppSystemState(SystemSm_SPM_SYSTEM_ON);
   } else {
      ETG_TRACE_USR1(("spm_tclSystemStateManagerInf4cv::vStateEntryMmion(): INC handler not running!"));
   } 
   #endif

   // vStateEntryMmion: user specific code start
   	if (_poMyRef->_poclWorkerServer)
	{
		_poMyRef->_poclWorkerServer->bPostMessage("ISpmSystemStateManager", SPM_U32_WORKER_SSM_ACTIVATE_AUTOMATIC);
	}
   // vStateEntryMmion: user specific code end
} // vStateEntryMmion

tVoid spm_tclSystemStateManagerInf4cv::vStateReachedMmion(){
   // vStateReachedMmion: user specific code start
   // vStateReachedMmion: user specific code end
} // vStateReachedMmion

tVoid spm_tclSystemStateManagerInf4cv::vStateExitMmion(){
   // vStateExitMmion: user specific code start
   // vStateExitMmion: user specific code end
} // vStateExitMmion

// *********************************************************************
// ****    HANDLE STATE CHANGES SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1    ****************
// *********************************************************************
tVoid spm_tclSystemStateManagerInf4cv::vStateEntryMmistandbypwrsave1(){
   SPM_NULL_POINTER_CHECK(_poMyRef);
   #ifdef VARIANT_S_FTR_ENABLE_INC_SYSTEMSTATEMACHINE
   ISpmSystemStateMachineIncClientHandler* poclIncSystemState = dynamic_cast < ISpmSystemStateMachineIncClientHandler* >( _poMyRef->_crfFactory.getSpmObjHandler("ISpmSystemStateMachineIncClientHandler") );
   if (poclIncSystemState != NULL) {
      ETG_TRACE_USR1( ( "spm_tclSystemStateManagerInf4cv::vStateEntryMmistandbypwrsave1(): Send AppSystemState to SCC!" ) );
      (tVoid)poclIncSystemState->bSetAppSystemState(SystemSm_SPM_SYSTEM_ON);
   } else {
      ETG_TRACE_USR1(("spm_tclSystemStateManagerInf4cv::vStateEntryMmistandbypwrsave1(): INC handler not running!"));
   } 
   #endif

   // vStateEntryMmistandbypwrsave1: user specific code start
   // vStateEntryMmistandbypwrsave1: user specific code end
} // vStateEntryMmistandbypwrsave1

tVoid spm_tclSystemStateManagerInf4cv::vStateReachedMmistandbypwrsave1(){
   // vStateReachedMmistandbypwrsave1: user specific code start
   // vStateReachedMmistandbypwrsave1: user specific code end
} // vStateReachedMmistandbypwrsave1

tVoid spm_tclSystemStateManagerInf4cv::vStateExitMmistandbypwrsave1(){
   // vStateExitMmistandbypwrsave1: user specific code start
   // vStateExitMmistandbypwrsave1: user specific code end
} // vStateExitMmistandbypwrsave1

// *********************************************************************
// ****    HANDLE STATE CHANGES SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_2    ****************
// *********************************************************************
tVoid spm_tclSystemStateManagerInf4cv::vStateEntryMmistandbypwrsave2(){
   SPM_NULL_POINTER_CHECK(_poMyRef);
   #ifdef VARIANT_S_FTR_ENABLE_INC_SYSTEMSTATEMACHINE
   ISpmSystemStateMachineIncClientHandler* poclIncSystemState = dynamic_cast < ISpmSystemStateMachineIncClientHandler* >( _poMyRef->_crfFactory.getSpmObjHandler("ISpmSystemStateMachineIncClientHandler") );
   if (poclIncSystemState != NULL) {
      ETG_TRACE_USR1( ( "spm_tclSystemStateManagerInf4cv::vStateEntryMmistandbypwrsave2(): Send AppSystemState to SCC!" ) );
      (tVoid)poclIncSystemState->bSetAppSystemState(SystemSm_SPM_SYSTEM_STANDBY);
   } else {
      ETG_TRACE_USR1(("spm_tclSystemStateManagerInf4cv::vStateEntryMmistandbypwrsave2(): INC handler not running!"));
   } 
   #endif

   // vStateEntryMmistandbypwrsave2: user specific code start
   // vStateEntryMmistandbypwrsave2: user specific code end
} // vStateEntryMmistandbypwrsave2

tVoid spm_tclSystemStateManagerInf4cv::vStateReachedMmistandbypwrsave2(){
   // vStateReachedMmistandbypwrsave2: user specific code start
   // vStateReachedMmistandbypwrsave2: user specific code end
} // vStateReachedMmistandbypwrsave2

tVoid spm_tclSystemStateManagerInf4cv::vStateExitMmistandbypwrsave2(){
   // vStateExitMmistandbypwrsave2: user specific code start
   // vStateExitMmistandbypwrsave2: user specific code end
} // vStateExitMmistandbypwrsave2

// *********************************************************************
// ****    HANDLE STATE CHANGES SPM_SYSTEM_MMI_ON_SWDL    ****************
// *********************************************************************
tVoid spm_tclSystemStateManagerInf4cv::vStateEntryMmionswdl(){
   SPM_NULL_POINTER_CHECK(_poMyRef);
   #ifdef VARIANT_S_FTR_ENABLE_INC_SYSTEMSTATEMACHINE
   ISpmSystemStateMachineIncClientHandler* poclIncSystemState = dynamic_cast < ISpmSystemStateMachineIncClientHandler* >( _poMyRef->_crfFactory.getSpmObjHandler("ISpmSystemStateMachineIncClientHandler") );
   if (poclIncSystemState != NULL) {
      ETG_TRACE_USR1( ( "spm_tclSystemStateManagerInf4cv::vStateEntryMmionswdl(): Send AppSystemState to SCC!" ) );
      (tVoid)poclIncSystemState->bSetAppSystemState(SystemSm_SPM_SYSTEM_ON);
   } else {
      ETG_TRACE_USR1(("spm_tclSystemStateManagerInf4cv::vStateEntryMmionswdl(): INC handler not running!"));
   } 
   #endif

   // vStateEntryMmionswdl: user specific code start
   // vStateEntryMmionswdl: user specific code end
} // vStateEntryMmionswdl

tVoid spm_tclSystemStateManagerInf4cv::vStateReachedMmionswdl(){
   // vStateReachedMmionswdl: user specific code start
   // vStateReachedMmionswdl: user specific code end
} // vStateReachedMmionswdl

tVoid spm_tclSystemStateManagerInf4cv::vStateExitMmionswdl(){
   // vStateExitMmionswdl: user specific code start
   // vStateExitMmionswdl: user specific code end
} // vStateExitMmionswdl

