/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_if.h
  * @brief        
  * @copyright    (C) 2013 - 2018 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */
/* --DO NOT PROTECT THIS FILE AGAINST DOUBLE INCLUDE !!! */

/* --General Information to the Component Maintainer

     Please remind that a modification of an interface can cause some trouble to the components
     which import the interface. The interface file may only export files from the component or
     another interface file.

  */

/* --COMPONENT INTERFACE(S) -- */

/*
     Interface: GENERIC
     Description: $DESCRIPTION$
  */

#ifdef SPM_S_IMPORT_INTERFACE_GENERIC
   /* --Protection against double include of the interface. */
    #ifndef SPM_S_ALREADY_INCLUDE_GENERIC
      #define SPM_S_ALREADY_INCLUDE_GENERIC
      /* --Includes. */
        #ifndef _SPM_CONFIG_H // spm config not used for external access
         #define _SPM_CONFIG_H
        #endif
    #endif /* --SPM_S_ALREADY_INCLUDE_GENERIC */
#endif /* --SPM_S_IMPORT_INCLUDE_GENERIC */

#ifdef SPM_S_IMPORT_INTERFACE_DP_SPM
   /* --Protection against double include of the interface. */
   #ifndef SPM_S_ALREADY_INCLUDE_DP_SPM
      #define SPM_S_ALREADY_INCLUDE_DP_SPM
      /* --Includes. */
   #include "../ai_lcm_generic/LcmGeneric/statehandling/spm_SubStateDefines.h"
   #include "../ai_lcm_generic/LcmGeneric/versions/spm_VersionInfoDp.h"
   #include "../ai_lcm_generic/LcmGeneric/engineering/spm_StatisticTypes.h"
   #include "../ai_lcm_generic/LcmGeneric/framework/cca/server/spm_CcaServiceTypes.h"
   #endif /* --SPM_S_ALREADY_INCLUDE_APPSTARTER */
#endif /* --SPM_S_IMPORT_INCLUDE_APPSTARTER */

#ifdef SPM_S_IMPORT_INTERFACE_SYSTEMIDS
   /* --Protection against double include of the interface. */
    #ifndef SPM_S_ALREADY_INCLUDE_SYSTEMIDS
      #define SPM_S_ALREADY_INCLUDE_SYSTEMIDS
      #include "../ai_lcm_generic/LcmGeneric/interfaces/spm_GlobDefsExt.h"
        #if ( OSAL_OS == OSAL_WINNT )
         #pragma message("warning: This interface is deprecated. Instead use the cfc_fi interface which provides consistently the FC SPM functionality.")
        #else
         #warning "This if-header is deprecated. Instead use the cfc_fi if which provides consistently the FC SPM functionality."//lint !e10 !e16
        #endif
   #endif /* --SPM_S_ALREADY_INCLUDE_SYSTEMIDS */
#endif /* --SPM_S_IMPORT_INCLUDE_SYSTEMIDS */

#ifdef SPM_S_IMPORT_INTERFACE_APPSTARTER
/* --Protection against double include of the interface. */
    #ifndef SPM_S_ALREADY_INCLUDE_APPSTARTER
      #define SPM_S_ALREADY_INCLUDE_APPSTARTER
        #pragma message(This interface is deprecated. Instead use the cfc_fi interface which provides consistently the FC SPM functionality.)
    #endif /* --SPM_S_ALREADY_INCLUDE_APPSTARTER */
#endif /* --SPM_S_IMPORT_INCLUDE_APPSTARTER */

#ifdef SPM_S_IMPORT_INTERFACE_SPM
/* --Protection against double include of the interface. */
    #ifndef SPM_S_ALREADY_INCLUDE_SPM
      #define SPM_S_ALREADY_INCLUDE_SPM
        #pragma message(This interface is deprecated. Instead use the cfc_fi interface which provides consistently the FC SPM functionality.)
    #endif /* --SPM_S_ALREADY_INCLUDE_APPSTARTER */
#endif /* --SPM_S_IMPORT_INCLUDE_APPSTARTER */


#if !( defined SPM_S_IMPORT_INTERFACE_GENERIC     \
       ||                                           \
       defined SPM_S_IMPORT_INTERFACE_SYSTEMIDS   \
       ||                                           \
       defined SPM_S_IMPORT_INTERFACE_APPSTARTER  \
       ||                                           \
       defined SPM_S_IMPORT_INTERFACE_DP_SPM  \
       ||                                           \
       defined SPM_S_IMPORT_INTERFACE_SPM )
    #pragma message ( "You have to define an interface for the component: SPM." )
#endif // if !(defined SPM_S_IMPORT_INTERFACE_GENERIC || defined SPM_S_IMPORT_INTERFACE_SYSTEMIDS || defined SPM_S_IMPORT_INTERFACE_APPSTARTER || defined
       // SPM_S_IMPORT_INTERFACE_SPM)

