/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         ProcBaseEnv.h
  * @brief        
  * @copyright    (C) 2013 - 2018 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */
#ifndef PROCBASEENV_HEADER
#define PROCBASEENV_HEADER

/* --s32RunExeEnvironment
   This function starts (and stops) the fc navi application. This function has to be
   called when using an exeutable (not dynamic link library!) as environment. */

#if OSAL_OS == OSAL_WINCE || OSAL_OS == OSAL_WINNT
   #if defined EXPORT_RUNEXEENVIRONMENT
      #define NAVI_DECL __declspec(dllexport)
   #elif defined IMPORT_RUNEXEENVIRONMENT
      #define NAVI_DECL __declspec(dllimport)
   #else
      #define NAVI_DECL
   #endif
#else
   #define NAVI_DECL
#endif


/*
  *  s32RunExeEnvironment is a C++-Function! Dont move its declaration in
  *  the "external-C" - part!
  */
NAVI_DECL tS32 s32RunEnv();

NAVI_DECL tVoid vStartCCAApplications(tVoid);
NAVI_DECL tVoid vStopCCAApplications(tVoid);

#endif // ifndef PROCBASEENV_HEADER

