/*****************************************************************************
* FILE:         lcm_ServiceLcmDbusIf.h
* PROJECT:      G3G project
* SW-COMPONENT: lcm
* Template:     ServiceIf.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2019 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __lcm_ServiceLcmDbusIf__IF__H_
#define __lcm_ServiceLcmDbusIf__IF__H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "I_lcm_ServiceLcmDbusIf.h"
#include "lcm_AppMain.h"
#include "lcm_ServiceLcmDbusCallbackIf.h"

// lcm_tclServiceLcmDbusIf_Include: user specific code start
// lcm_tclServiceLcmDbusIf_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class Ilcm_tclServiceLcmDbus;

class lcm_tclServiceLcmDbusIf : public Ilcm_tclServiceLcmDbusIf, public lcm_tclServiceLcmDbusCallbackIF
{
public:

   lcm_tclServiceLcmDbusIf(tVoid); 
   lcm_tclServiceLcmDbusIf(lcm_tclAppMain* poMainAppl);
   virtual ~lcm_tclServiceLcmDbusIf();

   // lcm_tclServiceLcmDbusIfDeclarations: user specific code start
   // lcm_tclServiceLcmDbusIfDeclarations: user specific code end

   virtual tVoid onServiceAvailable();
   virtual tVoid onServiceUnavailable();
   
   virtual const tChar* getName() const { return "lcm_tclServiceLcmDbusIf"; };
   
   virtual tVoid vHandleMessage(lcm_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();
   
    /***************************************************************************
    * Application specific methods.
    ***************************************************************************/
   virtual tVoid sendAppStartRequestStatus(lcm_fi_tclString strSwBlockName, lcm_fi_tclString strServiceName, tU32 u32AppId);
   virtual tVoid sendAppInitializedStatus(tU32 u32AppId);
   virtual tVoid sendAppStateChangeStatus(tU32 u32AppId, tU32 u32State);
   virtual tVoid sendAppEndStatus(tU32 u32AppId);
   virtual tVoid sendNewServiceLoadedStatus(lcm_fi_tclString strServiceName, lcm_fi_tclString strBlockName, tU32 u32AppId);
   virtual tVoid sendFailedServicesListStatus(lcm_fi_tcl_SPM_ServiceList tServices);
   virtual tVoid sendNewProcessIdStatus(lcm_fi_tclString strBlockName, lcm_fi_tclString strServiceName, tU32 u32ProcessId);
   virtual tVoid sendStartupFailureIndicationStatus(lcm_fi_tcl_StartupFailureInfo tStartupFailureInd);
   virtual tVoid sendSupervisionStateChangeStatus(tBool bSupervisionActive);

   virtual tBool onAppStateChangeSet(tU32 u32AppId, tU32 u32State, tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onAppEndSet(tU32 u32AppId, tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onSupervisionStateChangeSet(tBool bSupervisionActive, tBool& bPropertyChanged, tU16& u16ErrorCode);

   virtual tVoid sendStartProcessMResult(tS32 s32ReturnVal, lcm_fi_tclString strLocation, tU32 u32ProcId, tU32 u32SpawnDuration);
   virtual tVoid sendStopProcessMResult(tS32 s32ReturnVal);
   virtual tVoid sendStartupFinishedMResult(tS32 s32ReturnVal);
   virtual tVoid sendGetProcessIdMResult();
   virtual tVoid sendTriggerGetUnitListMResult();
   virtual tVoid sendRestartProcessMResult(tS32 s32ReturnVal);


   virtual tVoid onStartProcessMStart(lcm_fi_tclString strLocation, tU32 u32Prio, tU32 u32Affinity, tU32 u32AffinityEnd, tU32 u32NiceLevel, tU32 u32NiceLevelEnd, lcm_fi_tcl_e32_LCM_START_PROC_TYPE u32Type, tU32 u32Info);
   virtual tVoid onStopProcessMStart(lcm_fi_tclString strLocation, tU32 u32ProcId);
   virtual tVoid onStartupFinishedMStart(lcm_fi_tcl_e32_LCM_STARTUP_TYPE eStartUpParam);
   virtual tVoid onGetProcessIdMStart(lcm_fi_tclString strServiceName);
   virtual tVoid onTriggerGetUnitListMStart();
   virtual tVoid onRestartProcessMStart(lcm_fi_tclString strLocation, tU32 u32ProcId);

   virtual void vGetAppStartRequestMsg(lcm_dbusctrlfi_tclMsgAppStartRequestStatus& oStatus) {if (_poServerRef) _poServerRef->vGetAppStartRequestMsg(oStatus);}
   virtual void vGetAppInitializedMsg(lcm_dbusctrlfi_tclMsgAppInitializedStatus& oStatus) {if (_poServerRef) _poServerRef->vGetAppInitializedMsg(oStatus);}
   virtual void vGetAppStateChangeMsg(lcm_dbusctrlfi_tclMsgAppStateChangeStatus& oStatus) {if (_poServerRef) _poServerRef->vGetAppStateChangeMsg(oStatus);}
   virtual void vGetAppEndMsg(lcm_dbusctrlfi_tclMsgAppEndStatus& oStatus) {if (_poServerRef) _poServerRef->vGetAppEndMsg(oStatus);}
   virtual void vGetNewServiceLoadedMsg(lcm_dbusctrlfi_tclMsgNewServiceLoadedStatus& oStatus) {if (_poServerRef) _poServerRef->vGetNewServiceLoadedMsg(oStatus);}
   virtual void vGetFailedServicesListMsg(lcm_dbusctrlfi_tclMsgFailedServicesListStatus& oStatus) {if (_poServerRef) _poServerRef->vGetFailedServicesListMsg(oStatus);}
   virtual void vGetNewProcessIdMsg(lcm_dbusctrlfi_tclMsgNewProcessIdStatus& oStatus) {if (_poServerRef) _poServerRef->vGetNewProcessIdMsg(oStatus);}
   virtual void vGetStartupFailureIndicationMsg(lcm_dbusctrlfi_tclMsgStartupFailureIndicationStatus& oStatus) {if (_poServerRef) _poServerRef->vGetStartupFailureIndicationMsg(oStatus);}
   virtual void vGetSupervisionStateChangeMsg(lcm_dbusctrlfi_tclMsgSupervisionStateChangeStatus& oStatus) {if (_poServerRef) _poServerRef->vGetSupervisionStateChangeMsg(oStatus);}

private:
   Ilcm_tclServiceLcmDbus* _poServerRef;

// lcm_tclServiceLcmDbusIfDeclarationsPart2: user specific code start
// lcm_tclServiceLcmDbusIfDeclarationsPart2: user specific code end

};

#endif // __lcm_ServiceLcmDbusIf__IF__H_


