/*****************************************************************************
* FILE:         lcm_ServiceLcmDbusIf.cpp
* PROJECT:      G3G project
* SW-COMPONENT: lcm
* Template:     ServiceIf.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  
*               Generated file
*               Do here service handler specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2019 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/



// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#define ETG_S_IMPORT_INTERFACE_PLATFORM
#include "etg_if.h"

// lcm_tclServiceLcmDbusIfIncludes: user specific code start
#include "IDbusProxy.h"
#include "IDbusManagerProxy.h"
#include "IDbusServiceProxy.h"
#include "ILcmRecoveryClientStub.h"
using namespace ::org::bosch::cm::lcm;
// lcm_tclServiceLcmDbusIfIncludes: user specific code end

#include "lcm_ServiceLcmDbusIf.h"
#include "I_lcm_ServiceLcmDbus.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_LCM_SERVER_LCMDBUS
#include "trcGenProj/Header/lcm_ServiceLcmDbusIf.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: lcm_tclServiceLcmDbusIf::
*             lcm_tclServiceLcmDbusIf(lcm_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
lcm_tclServiceLcmDbusIf::lcm_tclServiceLcmDbusIf(lcm_tclAppMain* poMainAppl) : 
Ilcm_tclServiceLcmDbusIf(poMainAppl)
{
   ETG_TRACE_USR4(("lcm_tclServiceLcmDbusIf() entered."));
   _poServerRef = OSAL_NULL;

   // lcm_tclServiceLcmDbusIfConstructor: user specific code start
   // lcm_tclServiceLcmDbusIfConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: lcm_tclServiceLcmDbusIf::
*             ~lcm_tclServiceLcmDbusIf(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
lcm_tclServiceLcmDbusIf::~lcm_tclServiceLcmDbusIf(tVoid)
{
   ETG_TRACE_USR4(("~lcm_tclServiceLcmDbusIf() entered."));
   _poServerRef = OSAL_NULL;
   
   // lcm_tclServiceLcmDbusIfDestructor: user specific code start
   // lcm_tclServiceLcmDbusIfDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid lcm_tclServiceLcmDbusIf::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'lcm_ServiceLcmDbusIf.h':
*     Add forward declaration:
*         class Ilcm_tclObject2Get;
*
*     Add declaration of object reference:
*         Ilcm_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ilcm_tclObject2Get*>(_cpoMain->getHandler("Ilcm_tclObject2Get"));
*     LCMDBUS_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid lcm_tclServiceLcmDbusIf::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("lcm_tclServiceLcmDbusIf::vGetReferences() entered."));

   _poServerRef = dynamic_cast<Ilcm_tclServiceLcmDbus*>(_cpoMain->getHandler("Ilcm_tclServiceLcmDbus"));

   LCM_NULL_POINTER_CHECK(_poServerRef);

   _poServerRef->vSetCallbackIf(this);

   //set callback interface

   // lcm_tclServiceLcmDbusIfvGetReferences: user specific code start
   // lcm_tclServiceLcmDbusIfvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid lcm_tclServiceLcmDbusIf::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid lcm_tclServiceLcmDbusIf::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("lcm_tclServiceLcmDbusIf::vStartCommunication() entered."));
   // lcm_tclServiceLcmDbusIfvStartCommunication: user specific code start
   // lcm_tclServiceLcmDbusIfvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid lcm_tclServiceLcmDbusIf::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid lcm_tclServiceLcmDbusIf::vHandleMessage(lcm_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("lcm_tclServiceLcmDbusIf::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(lcm_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   // lcm_tclServiceLcmDbusIfvHandleMessage: user specific code start
   // lcm_tclServiceLcmDbusIfvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid lcm_tclServiceLcmDbusIf::vHandleTraceMessage()
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid lcm_tclServiceLcmDbusIf::vHandleTraceMessage(const tUChar* puchData)
{
   LCM_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("lcm_tclServiceLcmDbusIf::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // lcm_tclServiceLcmDbusIfvHandleTraceMessage: user specific code start
   // lcm_tclServiceLcmDbusIfvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid lcm_tclServiceLcmDbusIf::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid lcm_tclServiceLcmDbusIf::vTraceInfo()
{
   // lcm_tclServiceLcmDbusIfvTraceInfo: user specific code start
   // lcm_tclServiceLcmDbusIfvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid lcm_tclServiceLcmDbusIf::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid lcm_tclServiceLcmDbusIf::onServiceAvailable()
{
   ETG_TRACE_USR4(("lcm_tclServiceLcmDbusIf::onServiceAvailable() entered."));

   // lcm_tclServiceLcmDbusIfvOnServiceAvailable: user specific code start
   // lcm_tclServiceLcmDbusIfvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid lcm_tclServiceLcmDbusIf::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid lcm_tclServiceLcmDbusIf::onServiceUnavailable()
{
   ETG_TRACE_USR4(("lcm_tclServiceLcmDbusIf::onServiceUnavailable() entered."));

   // lcm_tclServiceLcmDbusIfvOnServiceUnavailable: user specific code start
   // lcm_tclServiceLcmDbusIfvOnServiceUnavailable: user specific code end
}

tBool lcm_tclServiceLcmDbusIf::onAppStateChangeSet(tU32 u32AppId, tU32 u32State, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // onAppStateChangeSet: user specific code start
   (void)bPropertyChanged;
   (void)u16ErrorCode;
   ETG_TRACE_USR4( ( "lcmlate_tclServiceDbusctrlIf::onAppStateChangeSet(): %u %u", ETG_ENUM(ail_u16AppId, u32AppId), ETG_ENUM(SPM_APPSTATE_DEF, u32State) ) );

   IDbusProxy *poDbusTmp = dynamic_cast < IDbusProxy* >( _cpoMain->getHandler("IDbusProxy") );
   LCM_NULL_POINTER_CHECK_VAL(poDbusTmp);
   poDbusTmp->vPostLcmRequest(u32AppId, AMT_C_U16_PWR_PROXY_STATE_CHANGE_REQ, u32State, 0);

   // onAppStateChangeSet: user specific code end
   return _bResult;
}
tBool lcm_tclServiceLcmDbusIf::onAppEndSet(tU32 u32AppId, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // onAppEndSet: user specific code start
   (void)bPropertyChanged;
   (void)u16ErrorCode;
   ETG_TRACE_USR4( ( "lcmlate_tclServiceDbusctrlIf::onAppEndSet(): %d", u32AppId ) );

   IDbusProxy *poDbusTmp = dynamic_cast < IDbusProxy* >( _cpoMain->getHandler("IDbusProxy") );
   LCM_NULL_POINTER_CHECK_VAL(poDbusTmp);
   poDbusTmp->vPostLcmRequest(u32AppId, AMT_C_U16_PWR_PROXY_END_APP, 0, 0);
   // onAppEndSet: user specific code end
   return _bResult;
}
tBool lcm_tclServiceLcmDbusIf::onSupervisionStateChangeSet(tBool bSupervisionActive, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // onSupervisionStateChangeSet: user specific code start
   (void)bPropertyChanged;
   (void)u16ErrorCode;
   ETG_TRACE_USR4( ( "lcm_tclServiceLcmDbusIf::onSupervisionStateChangeSet(): state of bSupervisionState: %d!", ETG_ENUM( SPM_STATE_COMMON, bSupervisionActive) ) );
   ILcmRecoveryClientStub *_poILcmRecoveryClientStub = dynamic_cast < ILcmRecoveryClientStub* >( _cpoMain->getHandler("ILcmRecoveryClientStub") );
   LCM_NULL_POINTER_CHECK_VAL(_poILcmRecoveryClientStub);
   _poILcmRecoveryClientStub->vSupervisionStateChange(bSupervisionActive);
   // onSupervisionStateChangeSet: user specific code end
   return _bResult;
}

tVoid lcm_tclServiceLcmDbusIf::onStartProcessMStart(lcm_fi_tclString strLocation, tU32 u32Prio, tU32 u32Affinity, tU32 u32AffinityEnd, tU32 u32NiceLevel, tU32 u32NiceLevelEnd, lcm_fi_tcl_e32_LCM_START_PROC_TYPE u32Type, tU32 u32Info) {

   // onStartProcessMStart: user specific code start
   (void)u32Affinity;
   (void)u32AffinityEnd;
   (void)u32NiceLevel;
   (void)u32NiceLevelEnd;
   (void)u32Type;
   (void)u32Info;
   ETG_TRACE_USR4( ( "lcmlate_tclServiceDbusctrlIf::onStartProcessMStart(): start process : '%50s'", strLocation.szValue ) );

   if (lcm_fi_tcl_e32_LCM_START_PROC_TYPE::FI_EN_SPM_U32_START_PROC_TYPE_OSAL_SPAWN == u32Type.enType){
      OSAL_trProcessAttribute rAttr;
      rAttr.szName        = strLocation;
      rAttr.szAppName     = strLocation;
      rAttr.u32Priority   = u32Prio;
      rAttr.szCommandLine = 0;  // command line parameter

      ETG_TRACE_USR4( ( "lcm_tclServiceLcmDbusIf::onStartProcessMStart(): start process '%50s' now (%dms)", strLocation.szValue, OSAL_ClockGetElapsedTime() ) );
      OSAL_tProcessID s32ProcId = OSAL_ProcessSpawn(&rAttr);
      ETG_TRACE_USR4( ( "lcm_tclServiceLcmDbusIf::onStartProcessMStart(): Osal native process running now (%d) with ID %d", OSAL_ClockGetElapsedTime(), s32ProcId ) );

   } else {
      IDbusManagerProxy *poDbusTmp = dynamic_cast < IDbusManagerProxy* >( _cpoMain->getHandler("IDbusManagerProxy") );
      LCM_NULL_POINTER_CHECK(poDbusTmp);
      poDbusTmp->vStartUnit(strLocation.szValue);
   }
   // onStartProcessMStart: user specific code end
}
tVoid lcm_tclServiceLcmDbusIf::onStopProcessMStart(lcm_fi_tclString strLocation, tU32 u32ProcId) {

   // onStopProcessMStart: user specific code start
   ETG_TRACE_USR4( ( "lcmlate_tclServiceDbusctrlIf::onStopProcessMStart(): stop process : '%50s'",strLocation.szValue ) );
   (void)u32ProcId;
   IDbusManagerProxy *poDbusTmp = dynamic_cast < IDbusManagerProxy* >( _cpoMain->getHandler("IDbusManagerProxy") );
   LCM_NULL_POINTER_CHECK(poDbusTmp);
   poDbusTmp->vStopUnit(strLocation.szValue);
   // onStopProcessMStart: user specific code end
}
tVoid lcm_tclServiceLcmDbusIf::onStartupFinishedMStart(lcm_fi_tcl_e32_LCM_STARTUP_TYPE eStartUpParam) {

   // onStartupFinishedMStart: user specific code start
   ETG_TRACE_USR4( ( "lcmlate_tclServiceDbusctrlIf::onStartupFinishedMStart(): %d", (tU32)eStartUpParam.enType ) );
   if (eStartUpParam.enType == lcm_fi_tcl_e32_LCM_STARTUP_TYPE::FI_EN_SPM_U32_STARTUP_ACTIVE){
      _cpoMain->theServer()->vPostMsgStartActive("Ilcm_tclClientStartupCtrlClient");
   } else if (eStartUpParam.enType == lcm_fi_tcl_e32_LCM_STARTUP_TYPE::FI_EN_SPM_U32_STARTUP_DONE){
      _cpoMain->theServer()->vPostMsgStartDone("Ilcm_tclClientStartupCtrlClient");
   }
   // onStartupFinishedMStart: user specific code end
}
tVoid lcm_tclServiceLcmDbusIf::onGetProcessIdMStart(lcm_fi_tclString strServiceName) {

   // onGetProcessIdMStart: user specific code start
   IDbusServiceProxy *poDbusTmp = dynamic_cast < IDbusServiceProxy* >( _cpoMain->getHandler("IDbusServiceProxy") );

   LCM_NULL_POINTER_CHECK(poDbusTmp);
   poDbusTmp->vTriggerGetMainPid(strServiceName.szValue);
   sendGetProcessIdMResult();
   // onGetProcessIdMStart: user specific code end
}
tVoid lcm_tclServiceLcmDbusIf::onTriggerGetUnitListMStart() {

   // onTriggerGetUnitListMStart: user specific code start
   IDbusManagerProxy *poDbusTmp = dynamic_cast < IDbusManagerProxy* >( _cpoMain->getHandler("IDbusManagerProxy") );

   LCM_NULL_POINTER_CHECK(poDbusTmp);
   poDbusTmp->vTriggerGetListUnit();
   // onTriggerGetUnitListMStart: user specific code end
}
tVoid lcm_tclServiceLcmDbusIf::onRestartProcessMStart(lcm_fi_tclString strLocation, tU32 u32ProcId) {

   // onRestartProcessMStart: user specific code start
    ETG_TRACE_USR4( ( "lcmlate_tclServiceDbusctrlIf::onRestartProcessMStart(): restart process : '%50s'",strLocation.szValue ) );
    (void)u32ProcId;
    IDbusManagerProxy *poDbusTmp = dynamic_cast < IDbusManagerProxy* >( _cpoMain->getHandler("IDbusManagerProxy") );
    LCM_NULL_POINTER_CHECK(poDbusTmp);
    poDbusTmp->vRestartUnit(strLocation.szValue);
   // onRestartProcessMStart: user specific code end
}

tVoid lcm_tclServiceLcmDbusIf::sendAppStartRequestStatus(lcm_fi_tclString strSwBlockName, lcm_fi_tclString strServiceName, tU32 u32AppId) {
    //just forward send request
    LCM_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendAppStartRequestStatus(strSwBlockName, strServiceName, u32AppId);
}

tVoid lcm_tclServiceLcmDbusIf::sendAppInitializedStatus(tU32 u32AppId) {
    //just forward send request
    LCM_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendAppInitializedStatus(u32AppId);
}

tVoid lcm_tclServiceLcmDbusIf::sendAppStateChangeStatus(tU32 u32AppId, tU32 u32State) {
    //just forward send request
    LCM_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendAppStateChangeStatus(u32AppId, u32State);
}

tVoid lcm_tclServiceLcmDbusIf::sendAppEndStatus(tU32 u32AppId) {
    //just forward send request
    LCM_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendAppEndStatus(u32AppId);
}

tVoid lcm_tclServiceLcmDbusIf::sendNewServiceLoadedStatus(lcm_fi_tclString strServiceName, lcm_fi_tclString strBlockName, tU32 u32AppId) {
    //just forward send request
    LCM_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendNewServiceLoadedStatus(strServiceName, strBlockName, u32AppId);
}

tVoid lcm_tclServiceLcmDbusIf::sendFailedServicesListStatus(lcm_fi_tcl_SPM_ServiceList tServices) {
    //just forward send request
    LCM_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendFailedServicesListStatus(tServices);
}

tVoid lcm_tclServiceLcmDbusIf::sendNewProcessIdStatus(lcm_fi_tclString strBlockName, lcm_fi_tclString strServiceName, tU32 u32ProcessId) {
    //just forward send request
    LCM_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendNewProcessIdStatus(strBlockName, strServiceName, u32ProcessId);
}

tVoid lcm_tclServiceLcmDbusIf::sendStartupFailureIndicationStatus(lcm_fi_tcl_StartupFailureInfo tStartupFailureInd) {
    //just forward send request
    LCM_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendStartupFailureIndicationStatus(tStartupFailureInd);
}

tVoid lcm_tclServiceLcmDbusIf::sendSupervisionStateChangeStatus(tBool bSupervisionActive) {
    //just forward send request
    LCM_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendSupervisionStateChangeStatus(bSupervisionActive);
}



tVoid lcm_tclServiceLcmDbusIf::sendStartProcessMResult(tS32 s32ReturnVal, lcm_fi_tclString strLocation, tU32 u32ProcId, tU32 u32SpawnDuration) {
    //just forward send request
    LCM_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendStartProcessMResult(s32ReturnVal, strLocation, u32ProcId, u32SpawnDuration);
}

tVoid lcm_tclServiceLcmDbusIf::sendStopProcessMResult(tS32 s32ReturnVal) {
    //just forward send request
    LCM_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendStopProcessMResult(s32ReturnVal);
}

tVoid lcm_tclServiceLcmDbusIf::sendStartupFinishedMResult(tS32 s32ReturnVal) {
    //just forward send request
    LCM_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendStartupFinishedMResult(s32ReturnVal);
}

tVoid lcm_tclServiceLcmDbusIf::sendGetProcessIdMResult() {
    //just forward send request
    LCM_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendGetProcessIdMResult();
}

tVoid lcm_tclServiceLcmDbusIf::sendTriggerGetUnitListMResult() {
    //just forward send request
    LCM_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendTriggerGetUnitListMResult();
}

tVoid lcm_tclServiceLcmDbusIf::sendRestartProcessMResult(tS32 s32ReturnVal) {
    //just forward send request
    LCM_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendRestartProcessMResult(s32ReturnVal);
}





// lcm_tclServiceLcmDbusIflcm_ServiceLcmDbusIf: user specific code start
// lcm_tclServiceLcmDbusIflcm_ServiceLcmDbusIf: user specific code end

//EOF
