/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         LcmAsfComponent.cpp
  * @brief        
  * @copyright    (C) 2013 - 2018 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */
#define ETG_S_IMPORT_INTERFACE_GENERIC
#define ETG_S_IMPORT_INTERFACE_PLATFORM
#include "etg_if.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define SCD_S_IMPORT_INTERFACE_GENERIC
#include "scd_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#ifdef VARIANT_S_FTR_ENABLE_DATAPOOL
#define DP_S_IMPORT_INTERFACE_BASE
#include "dp_if.h"
#endif

#include "LcmAsfComponent.h"
#include "CcaSrvProxy.h"

#include "buildversion_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_LCM_APPLICATION
#include "trcGenProj/Header/LcmAsfComponent.cpp.trc.h"
#endif

extern void vAppProxyStarter(lcm_tclAppMain *poServer);

namespace org {
namespace genivi {

    using namespace::asf::core;
    using namespace::asf::stream;

    DEFINE_CLASS_LOGGER_AND_LEVEL("org/genivi/LcmAsfComponent", LcmAsfComponent, Info);

    LcmAsfComponent::LcmAsfComponent()
        : BaseComponent()
        , _poCcaSrvProxy(NULL) {
            LOG_INFO("Constructor for LcmAsfComponent called");

            // Start Trace
            vInitPlatformEtg();

#           ifdef BUILDVERSION_DISPLAY_STARTUP_TRACE_ENABLED
            BuildVersion_vDisplayStartupMessage("PROCLCM");
#           endif

            OSAL_tIODescriptor  regHandle;
            if((regHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_REGISTRY,OSAL_EN_READWRITE)) != OSAL_ERROR )
            {
                if((OSAL_s32IOControl(regHandle, OSAL_C_S32_IOCTRL_BUILD_REG,(intptr_t)"/dev/root/opt/bosch/base/registry/proclcm.reg")) == OSAL_OK)
                {
                    ETG_TRACE_FATAL(("REGISTRY loaded '/dev/root/opt/bosch/base/registry/proclcm.reg'!"));

                } else {
                    ETG_TRACE_FATAL(("!!!!!!!!!! FAILED to load REGISTRY  '/dev/root/opt/bosch/base/registry/proclcm.reg'!"));
                }
            }
            OSAL_s32IOClose(regHandle);

            // Initialise AMT framework (tracing, static variables, ...)
            // Must be called before using AMT framework.
            amt_bInit();
            scd_init();

#           ifdef VARIANT_S_FTR_ENABLE_DATAPOOL
            DP_vCreateDatapool();
#           endif

            _poCcaServer = lcm_tclAppMain::theServer();
            if (_poCcaServer != NULL){

           // and new create DBUS and CCA connector client
           ::org::genivi::vProxyStarter(_poCcaServer);
           vAppProxyStarter(_poCcaServer);

                if ( _poCcaServer->bInitInstance(0, CCA_C_U16_APP_SPM_SLV, OSAL_ThreadWhoAmI()) == FALSE )
                {
                    ETG_TRACE_FATAL(("!!! vStartCCAApplications(): lcm_tclAppMain bInitInstance FAILED" ));
                }

                _poCcaServer->vStart();
            }
    }

    LcmAsfComponent::~LcmAsfComponent(){
        LOG_INFO("~lcmAsfComponent called");
        _poCcaSrvProxy   = NULL;
        _poCcaServer     = NULL;

    }

}
} // namespace org { namespace genivi {

