/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         CcaSrvProxy.cpp
  * @brief        
  * @copyright    (C) 2013 - 2018 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */
#include "CcaSrvProxy.h"
//  boost::shared_ptr is used here cause by ASF interface.

namespace org { namespace bosch { namespace cm { namespace lcm {

using namespace::asf::core;
using namespace::asf::stream;
using namespace::asf::cca::CcaServerHook;

DEFINE_CLASS_LOGGER_AND_LEVEL("org/bosch/cm/lcm/CcaSrvProxy", CcaSrvProxy, Info);


CcaSrvProxy::CcaSrvProxy(lcm_tclAppMain* baseRef)
   : ICcaSrvProxy(baseRef)
   , CcaServerHookStub()
{
    _poMainRef = baseRef;
   LOG_INFO("Constructor for CcaSrvProxy called");
}

CcaSrvProxy::~CcaSrvProxy(){
   LOG_INFO("~CcaSrvProxy called");
   _poMainRef = NULL;
}

void CcaSrvProxy::onCcaMessage(const::boost::shared_ptr <asf::core::Blob>& request){

      _tclBaseStreamMessage oMyBaseMsg((tU8*)request->getBytes());

      _poMainRef->bDispatchCCAMessages(&oMyBaseMsg);
}

} } } } // namespace org { namespace bosch { namespace cm { namespace lcm {
