/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          lcm_ServiceLcmDbusCallbackIF.h
  * @PROJECT:      CMD project
  * @SW-COMPONENT: lcm
  * @Template:     serviceCallbackIf.h.tpl
  * ----------------------------------------------------------------------------
  *
  * @brief         generated file
  *                service callback interface
  *
  *                Do here client specific implementation
  *                Changes possible only inside tags
  *
  *                //......................: user specific code start 
  *                //......................: user specific code end
  *
  * ----------------------------------------------------------------------------
  * @copyright     (c) 2019 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#ifndef __lcm_dbusctrl_fi_CALLBACKIF_H_
#define __lcm_dbusctrl_fi_CALLBACKIF_H_

class lcm_tclServiceLcmDbusCallbackIF
{
   public:
       virtual ~lcm_tclServiceLcmDbusCallbackIF() {};

       virtual tVoid onServiceAvailable() = 0;
       virtual tVoid onServiceUnavailable() = 0;

       virtual tBool onAppStateChangeSet(tU32 u32AppId, tU32 u32State, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
       virtual tBool onAppEndSet(tU32 u32AppId, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
       virtual tBool onSupervisionStateChangeSet(tBool bSupervisionActive, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;

       virtual tVoid onStartProcessMStart(lcm_fi_tclString strLocation, tU32 u32Prio, tU32 u32Affinity, tU32 u32AffinityEnd, tU32 u32NiceLevel, tU32 u32NiceLevelEnd, lcm_fi_tcl_e32_LCM_START_PROC_TYPE u32Type, tU32 u32Info) = 0;
       virtual tVoid onStopProcessMStart(lcm_fi_tclString strLocation, tU32 u32ProcId) = 0;
       virtual tVoid onStartupFinishedMStart(lcm_fi_tcl_e32_LCM_STARTUP_TYPE eStartUpParam) = 0;
       virtual tVoid onGetProcessIdMStart(lcm_fi_tclString strServiceName) = 0;
       virtual tVoid onTriggerGetUnitListMStart() = 0;
       virtual tVoid onRestartProcessMStart(lcm_fi_tclString strLocation, tU32 u32ProcId) = 0;
};

#endif //__lcm_dbusctrl_fi_CALLBACKIF_H_


