/*****************************************************************************
* FILE:         lcm_ServiceLcmDbus.cpp
* PROJECT:      G3G project
* SW-COMPONENT: lcm
* Template:     ServiceHandler.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2019 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#define ETG_S_IMPORT_INTERFACE_PLATFORM
#include "etg_if.h"

// lcm_tclServiceLcmDbusIncludes: user specific code start
// lcm_tclServiceLcmDbusIncludes: user specific code end

#include "lcm_ServiceLcmDbus.h"
#include "lcm_ServiceLcmDbusCallbackIf.h"



#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_LCM_SERVER_LCMDBUS
#include "trcGenProj/Header/lcm_ServiceLcmDbus.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
#define LCMDBUS_SERVICE_ID              95
#define LCMDBUS_FI_MAJOR_VERSION        1
#define LCMDBUS_FI_MINOR_VERSION        0

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(lcm_tclServiceLcmDbus, ahl_tclBaseWork)
   ON_MESSAGE_SVCDATA(LCM_DBUSCTRLFI_C_U16_STARTPROCESS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleStartProcessOpMStart)
   ON_MESSAGE_SVCDATA(LCM_DBUSCTRLFI_C_U16_STOPPROCESS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleStopProcessOpMStart)
   ON_MESSAGE_SVCDATA(LCM_DBUSCTRLFI_C_U16_STARTUPFINISHED, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleStartupFinishedOpMStart)
   ON_MESSAGE_SVCDATA(LCM_DBUSCTRLFI_C_U16_GETPROCESSID, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleGetProcessIdOpMStart)
   ON_MESSAGE_SVCDATA(LCM_DBUSCTRLFI_C_U16_TRIGGERGETUNITLIST, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleTriggerGetUnitListOpMStart)
   ON_MESSAGE_SVCDATA(LCM_DBUSCTRLFI_C_U16_RESTARTPROCESS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleRestartProcessOpMStart)
END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: lcm_tclServiceLcmDbus::
*             lcm_tclServiceLcmDbus(lcm_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
lcm_tclServiceLcmDbus::lcm_tclServiceLcmDbus(lcm_tclAppMain* poMainAppl) : 
Ilcm_tclServiceLcmDbus(poMainAppl, LCMDBUS_SERVICE_ID, LCMDBUS_FI_MAJOR_VERSION, LCMDBUS_FI_MINOR_VERSION )
{
   ETG_TRACE_USR4(("lcm_tclServiceLcmDbus() entered."));
   _poCallbackIf = OSAL_NULL;

   _tAppStartRequest_u32AppId = 0;
   _tAppInitialized_u32AppId = 0;
   _tAppStateChange_u32AppId = 0;
   _tAppStateChange_u32State = 0;
   _tAppEnd_u32AppId = 0;
   _tNewServiceLoaded_u32AppId = 0;
   _tNewProcessId_u32ProcessId = 0;
   _tSupervisionStateChange_bSupervisionActive = FALSE;
   _tStartProcess_u32Prio = 0;
   _tStartProcess_u32Affinity = 0;
   _tStartProcess_u32AffinityEnd = 0;
   _tStartProcess_u32NiceLevel = 0;
   _tStartProcess_u32NiceLevelEnd = 0;
   _tStartProcess_u32Info = 0;
   _tStopProcess_u32ProcId = 0;
   _tRestartProcess_u32ProcId = 0;

   // lcm_tclServiceLcmDbusConstructor: user specific code start
   _tNewServiceLoaded_strServiceName = "";
   _tNewServiceLoaded_strBlockName   = "none";
   // lcm_tclServiceLcmDbusConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: lcm_tclServiceLcmDbus::
*             ~lcm_tclServiceLcmDbus(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
lcm_tclServiceLcmDbus::~lcm_tclServiceLcmDbus(tVoid)
{
   ETG_TRACE_USR4(("~lcm_tclServiceLcmDbus() entered."));
   _poCallbackIf = OSAL_NULL;
   
   // lcm_tclServiceLcmDbusDestructor: user specific code start
   // lcm_tclServiceLcmDbusDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid lcm_tclServiceLcmDbus::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'lcm_ServiceLcmDbus.h':
*     Add forward declaration:
*         class Ilcm_tclObject2Get;
*
*     Add declaration of object reference:
*         Ilcm_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ilcm_tclObject2Get*>(_cpoMain->getHandler("Ilcm_tclObject2Get"));
*     LCMDBUS_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid lcm_tclServiceLcmDbus::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("lcm_tclServiceLcmDbus::vGetReferences() entered."));
   // lcm_tclServiceLcmDbusvGetReferences: user specific code start
   // lcm_tclServiceLcmDbusvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid lcm_tclServiceLcmDbus::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid lcm_tclServiceLcmDbus::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("lcm_tclServiceLcmDbus::vStartCommunication() entered."));
   // lcm_tclServiceLcmDbusvStartCommunication: user specific code start
   // lcm_tclServiceLcmDbusvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid lcm_tclServiceLcmDbus::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   lcm_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid lcm_tclServiceLcmDbus::vHandleMessage(lcm_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("lcm_tclServiceLcmDbus::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(lcm_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   
   // lcm_tclServiceLcmDbusvHandleMessage: user specific code start
   // lcm_tclServiceLcmDbusvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid lcm_tclServiceLcmDbus::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid lcm_tclServiceLcmDbus::vHandleTraceMessage(const tUChar* puchData)
{
   LCM_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("lcm_tclServiceLcmDbus::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // lcm_tclServiceLcmDbusvHandleTraceMessage: user specific code start
   // lcm_tclServiceLcmDbusvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid lcm_tclServiceLcmDbus::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid lcm_tclServiceLcmDbus::vTraceInfo()
{
   ETG_TRACE_FATAL(("Property support:      AppStartRequest (LCM_DBUSCTRLFI_C_U16_APPSTARTREQUEST) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      AppInitialized (LCM_DBUSCTRLFI_C_U16_APPINITIALIZED) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      AppStateChange (LCM_DBUSCTRLFI_C_U16_APPSTATECHANGE) -> Opcode: UpReg, RelUpReg, Get, Set, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      AppEnd (LCM_DBUSCTRLFI_C_U16_APPEND) -> Opcode: UpReg, RelUpReg, Get, Set, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      NewServiceLoaded (LCM_DBUSCTRLFI_C_U16_NEWSERVICELOADED) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      FailedServicesList (LCM_DBUSCTRLFI_C_U16_FAILEDSERVICESLIST) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      NewProcessId (LCM_DBUSCTRLFI_C_U16_NEWPROCESSID) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      StartupFailureIndication (LCM_DBUSCTRLFI_C_U16_STARTUPFAILUREINDICATION) -> Opcode: Error, Get, RelUpReg, Status, UpReg, "));
   ETG_TRACE_FATAL(("Property support:      SupervisionStateChange (LCM_DBUSCTRLFI_C_U16_SUPERVISIONSTATECHANGE) -> Opcode: Set, Status, Error, "));
   ETG_TRACE_FATAL(("Method   support:      StartProcess (LCM_DBUSCTRLFI_C_U16_STARTPROCESS) -> Opcode: MethodStart, MethodResult, "));
   ETG_TRACE_FATAL(("Method   support:      StopProcess (LCM_DBUSCTRLFI_C_U16_STOPPROCESS) -> Opcode: MethodStart, MethodResult, "));
   ETG_TRACE_FATAL(("Method   support:      StartupFinished (LCM_DBUSCTRLFI_C_U16_STARTUPFINISHED) -> Opcode: MethodStart, MethodResult, "));
   ETG_TRACE_FATAL(("Method   support:      GetProcessId (LCM_DBUSCTRLFI_C_U16_GETPROCESSID) -> Opcode: MethodStart, MethodResult, "));
   ETG_TRACE_FATAL(("Method   support:      TriggerGetUnitList (LCM_DBUSCTRLFI_C_U16_TRIGGERGETUNITLIST) -> Opcode: MethodStart, MethodResult, "));
   ETG_TRACE_FATAL(("Method   support:      RestartProcess (LCM_DBUSCTRLFI_C_U16_RESTARTPROCESS) -> Opcode: MethodStart, MethodResult, "));

   // lcm_tclServiceLcmDbusvTraceInfo: user specific code start
   // lcm_tclServiceLcmDbusvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid lcm_tclServiceLcmDbus::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid lcm_tclServiceLcmDbus::vOnServiceAvailable()
{
   ETG_TRACE_USR4(("vOnServiceAvailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceAvailable();

   // lcm_tclServiceLcmDbusvOnServiceAvailable: user specific code start
   // lcm_tclServiceLcmDbusvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid lcm_tclServiceLcmDbus::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid lcm_tclServiceLcmDbus::vOnServiceUnavailable()
{
   ETG_TRACE_USR4(("vOnServiceUnavailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceUnavailable();

   // lcm_tclServiceLcmDbusvOnServiceUnavailable: user specific code start
   // lcm_tclServiceLcmDbusvOnServiceUnavailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tBool lcm_tclServiceLcmDbus
*                 ::bStatusMessageFactory(tU16 u16FunctionId,
*                                         amt_tclServiceData& roOutMsg,
*                                         amt_tclServiceData* poInMsg)
*
* DESCRIPTION: This function is called by the CCA framework to request ANY
*              property which is offered by this service. For each property
*              accessed via parameter 'u16FunctionId' the user has to prepare
*              the corresponding FI data object which is then copied to the
*              referenced parameter 'roOutMsg'.
*
* PARAMETER: [IN] u16FunctionId = Function ID of the requested property.
*            [OUT] roOutMsg = Reference to the service data object to which the
*                             content of the prepared FI data object should be
*                             copied to.
*            [IN] poInMsg = Selector message which is used to select dedicated
*                           content to be copied to 'roOutMsg' instead of
*                           updating the entire FI data object.
*
* RETURNVALUE: TRUE = Status message for property successfully generated.
*              FALSE = Failed to generate status message for property.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadService::bStatusMessageFactory().
*******************************************************************************/
tBool lcm_tclServiceLcmDbus
::bStatusMessageFactory(tU16 u16FunctionId,
                        amt_tclServiceData& roOutMsg,
                        amt_tclServiceData* poInMsg)
{
   (tVoid)poInMsg;   // These lines are added to avoid LINT warnings. Please
   (tVoid)roOutMsg;  // remove as soon as variables are used.

   tBool bSuccess = FALSE;

   ETG_TRACE_USR4(("lcm_tclServiceLcmDbus:bStatusMessageFactory() entered. FID = 0x%04x.", u16FunctionId));

   switch (u16FunctionId)
   {
   case LCM_DBUSCTRLFI_C_U16_APPSTARTREQUEST:
      {
         lcm_dbusctrlfi_tclMsgAppStartRequestStatus oStatus;

         oStatus.strSwBlockName = _tAppStartRequest_strSwBlockName;
         oStatus.strServiceName = _tAppStartRequest_strServiceName;
         oStatus.u32AppId = _tAppStartRequest_u32AppId;

         // CaseAppStartRequestStatus_Pre: user specific code start
         // CaseAppStartRequestStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, LCMDBUS_FI_MAJOR_VERSION);

         // CaseAppStartRequestStatus: user specific code start
         // CaseAppStartRequestStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case LCM_DBUSCTRLFI_C_U16_APPINITIALIZED:
      {
         lcm_dbusctrlfi_tclMsgAppInitializedStatus oStatus;

         oStatus.u32AppId = _tAppInitialized_u32AppId;

         // CaseAppInitializedStatus_Pre: user specific code start
         // CaseAppInitializedStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, LCMDBUS_FI_MAJOR_VERSION);

         // CaseAppInitializedStatus: user specific code start
         // CaseAppInitializedStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case LCM_DBUSCTRLFI_C_U16_APPSTATECHANGE:
      {
         lcm_dbusctrlfi_tclMsgAppStateChangeStatus oStatus;

         oStatus.u32AppId = _tAppStateChange_u32AppId;
         oStatus.u32State = _tAppStateChange_u32State;

         // CaseAppStateChangeStatus_Pre: user specific code start
         // CaseAppStateChangeStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, LCMDBUS_FI_MAJOR_VERSION);

         // CaseAppStateChangeStatus: user specific code start
         // CaseAppStateChangeStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case LCM_DBUSCTRLFI_C_U16_APPEND:
      {
         lcm_dbusctrlfi_tclMsgAppEndStatus oStatus;

         oStatus.u32AppId = _tAppEnd_u32AppId;

         // CaseAppEndStatus_Pre: user specific code start
         // CaseAppEndStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, LCMDBUS_FI_MAJOR_VERSION);

         // CaseAppEndStatus: user specific code start
         // CaseAppEndStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case LCM_DBUSCTRLFI_C_U16_NEWSERVICELOADED:
      {
         lcm_dbusctrlfi_tclMsgNewServiceLoadedStatus oStatus;

         oStatus.strServiceName = _tNewServiceLoaded_strServiceName;
         oStatus.strBlockName = _tNewServiceLoaded_strBlockName;
         oStatus.u32AppId = _tNewServiceLoaded_u32AppId;

         // CaseNewServiceLoadedStatus_Pre: user specific code start
         // CaseNewServiceLoadedStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, LCMDBUS_FI_MAJOR_VERSION);

         // CaseNewServiceLoadedStatus: user specific code start
         // CaseNewServiceLoadedStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case LCM_DBUSCTRLFI_C_U16_FAILEDSERVICESLIST:
      {
         lcm_dbusctrlfi_tclMsgFailedServicesListStatus oStatus;

         oStatus.tServices = _tFailedServicesList_tServices;

         // CaseFailedServicesListStatus_Pre: user specific code start
         // CaseFailedServicesListStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, LCMDBUS_FI_MAJOR_VERSION);

         // CaseFailedServicesListStatus: user specific code start
         // CaseFailedServicesListStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case LCM_DBUSCTRLFI_C_U16_NEWPROCESSID:
      {
         lcm_dbusctrlfi_tclMsgNewProcessIdStatus oStatus;

         oStatus.strBlockName = _tNewProcessId_strBlockName;
         oStatus.strServiceName = _tNewProcessId_strServiceName;
         oStatus.u32ProcessId = _tNewProcessId_u32ProcessId;

         // CaseNewProcessIdStatus_Pre: user specific code start
         // CaseNewProcessIdStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, LCMDBUS_FI_MAJOR_VERSION);

         // CaseNewProcessIdStatus: user specific code start
         // CaseNewProcessIdStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case LCM_DBUSCTRLFI_C_U16_STARTUPFAILUREINDICATION:
      {
         lcm_dbusctrlfi_tclMsgStartupFailureIndicationStatus oStatus;

         oStatus.tStartupFailureInd = _tStartupFailureIndication_tStartupFailureInd;

         // CaseStartupFailureIndicationStatus_Pre: user specific code start
         // CaseStartupFailureIndicationStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, LCMDBUS_FI_MAJOR_VERSION);

         // CaseStartupFailureIndicationStatus: user specific code start
         // CaseStartupFailureIndicationStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case LCM_DBUSCTRLFI_C_U16_SUPERVISIONSTATECHANGE:
      {
         lcm_dbusctrlfi_tclMsgSupervisionStateChangeStatus oStatus;

         oStatus.bSupervisionActive = _tSupervisionStateChange_bSupervisionActive;

         // CaseSupervisionStateChangeStatus_Pre: user specific code start
         // CaseSupervisionStateChangeStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, LCMDBUS_FI_MAJOR_VERSION);

         // CaseSupervisionStateChangeStatus: user specific code start
         // CaseSupervisionStateChangeStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;

   default:
      {
         // Case_Default_Status: user specific code start
         // Case_Default_Status: user specific code end
     }
     break;
   } // switch



   if (!bSuccess)
   {
      ETG_TRACE_ERR(("bStatusMessageFactory(). Creation of message with 'FID = %u' failed.", u16FunctionId));

      NORMAL_M_ASSERT_ALWAYS();
   }

   return bSuccess;
} // bStatusMessageFactory


/*******************************************************************************
*
* FUNCTION: tBool lcm_tclServiceLcmDbus
*                 ::bProcessSet(amt_tclServiceData* poMessage,
*                               tBool& bPropertyChanged,
*                               tU16& u16ErrorCode)
*
* DESCRIPTION: This function is called by the CCA framework when it has
*              received a message for a property with Opcode 'SET' or 'PURESET'
*              and there is no dedicated handler function defined in the
*              message map for this pair of FID and opcode. The user has to
*              set the application specific property to the requested value
*              and the CCA framework then cares about informing the requesting
*              client as well as other registered clients.
*
* PARAMETER: [IN] poMessage = Property to be set.
*            [OUT] bPropertyChanged = Property changed flag to be set to TRUE
*                                     if property has changed. Otherwise to be
*                                     set to FALSE (default).
*            [OUT] u16ErrorCode = Error code to be set if a CCA error occurs,
*                                 otherwise don't touch.
*
* RETURNVALUE: TRUE = Send 'STATUS' message to the requesting client if opcode
*                     was 'SET'. Send 'STATUS' message to other registered
*                     clients as well if [OUT] parameter 'bPropertyChanged'
*                     is set to TRUE.
*              FALSE = Send an error message to the requesting client.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadService::bProcessSet().
*******************************************************************************/
tBool lcm_tclServiceLcmDbus
::bProcessSet(amt_tclServiceData* poMessage,
              tBool& bPropertyChanged,
              tU16& u16ErrorCode)
{
   (tVoid)bPropertyChanged;  // These lines are added to avoid LINT warnings.
   (tVoid)u16ErrorCode;      // Please remove as soon as variables are used.

   tBool bSuccess = FALSE;

   tU16 u16FunctionId = poMessage->u16GetFunctionID();

   ETG_TRACE_USR4(("lcm_tclServiceLcmDbus:bProcessSet() entered. FID = 0x%04x.", u16FunctionId));

   fi_tclVisitorMessage oVisitorMsg(poMessage);

   switch (u16FunctionId)
   {
   case LCM_DBUSCTRLFI_C_U16_APPSTATECHANGE:
      {
         lcm_dbusctrlfi_tclMsgAppStateChangeSet oSet;

         if (oVisitorMsg.s32GetData(oSet, LCMDBUS_FI_MAJOR_VERSION) != OSAL_ERROR) {
             bSuccess = onAppStateChangeSet(oSet.u32AppId, oSet.u32State, bPropertyChanged, u16ErrorCode);
             if (_poCallbackIf && _poCallbackIf->onAppStateChangeSet(oSet.u32AppId, oSet.u32State, bPropertyChanged, u16ErrorCode)) {
                bSuccess = TRUE;
             }
         }
         // CaseAppStateChangeSet: user specific code start
         // CaseAppStateChangeSet: user specific code end

         oSet.vDestroy();
      }
      break;
   case LCM_DBUSCTRLFI_C_U16_APPEND:
      {
         lcm_dbusctrlfi_tclMsgAppEndSet oSet;

         if (oVisitorMsg.s32GetData(oSet, LCMDBUS_FI_MAJOR_VERSION) != OSAL_ERROR) {
             bSuccess = onAppEndSet(oSet.u32AppId, bPropertyChanged, u16ErrorCode);
             if (_poCallbackIf && _poCallbackIf->onAppEndSet(oSet.u32AppId, bPropertyChanged, u16ErrorCode)) {
                bSuccess = TRUE;
             }
         }
         // CaseAppEndSet: user specific code start
         // CaseAppEndSet: user specific code end

         oSet.vDestroy();
      }
      break;
   case LCM_DBUSCTRLFI_C_U16_SUPERVISIONSTATECHANGE:
      {
         lcm_dbusctrlfi_tclMsgSupervisionStateChangeSet oSet;

         if (oVisitorMsg.s32GetData(oSet, LCMDBUS_FI_MAJOR_VERSION) != OSAL_ERROR) {
             bSuccess = onSupervisionStateChangeSet(oSet.bSupervisionActive, bPropertyChanged, u16ErrorCode);
             if (_poCallbackIf && _poCallbackIf->onSupervisionStateChangeSet(oSet.bSupervisionActive, bPropertyChanged, u16ErrorCode)) {
                bSuccess = TRUE;
             }
         }
         // CaseSupervisionStateChangeSet: user specific code start
         // CaseSupervisionStateChangeSet: user specific code end

         oSet.vDestroy();
      }
      break;

   default:
      {
         // Case_Default_Set: user specific code start
         // Case_Default_Set: user specific code end
      }
      break;
   } //lint !e764: switch statement possibly does not have a case --> generated process function
   return bSuccess;
} // bProcessSet

tVoid lcm_tclServiceLcmDbus::sendAppStartRequestStatus(lcm_fi_tclString strSwBlockName, lcm_fi_tclString strServiceName, tU32 u32AppId)
{

   _tAppStartRequest_strSwBlockName = strSwBlockName;
   _tAppStartRequest_strServiceName = strServiceName;
   _tAppStartRequest_u32AppId = u32AppId;


   ETG_TRACE_USR4(("sendAppStartRequestStatus() called."));
   eUpdateClients(LCM_DBUSCTRLFI_C_U16_APPSTARTREQUEST);
}
tVoid lcm_tclServiceLcmDbus::sendAppInitializedStatus(tU32 u32AppId)
{

   _tAppInitialized_u32AppId = u32AppId;


   ETG_TRACE_USR4(("sendAppInitializedStatus() called."));
   eUpdateClients(LCM_DBUSCTRLFI_C_U16_APPINITIALIZED);
}
tVoid lcm_tclServiceLcmDbus::sendAppStateChangeStatus(tU32 u32AppId, tU32 u32State)
{

   _tAppStateChange_u32AppId = u32AppId;
   _tAppStateChange_u32State = u32State;


   ETG_TRACE_USR4(("sendAppStateChangeStatus() called."));
   eUpdateClients(LCM_DBUSCTRLFI_C_U16_APPSTATECHANGE);
}
tVoid lcm_tclServiceLcmDbus::sendAppEndStatus(tU32 u32AppId)
{

   _tAppEnd_u32AppId = u32AppId;


   ETG_TRACE_USR4(("sendAppEndStatus() called."));
   eUpdateClients(LCM_DBUSCTRLFI_C_U16_APPEND);
}
tVoid lcm_tclServiceLcmDbus::sendNewServiceLoadedStatus(lcm_fi_tclString strServiceName, lcm_fi_tclString strBlockName, tU32 u32AppId)
{

   _tNewServiceLoaded_strServiceName = strServiceName;
   _tNewServiceLoaded_strBlockName = strBlockName;
   _tNewServiceLoaded_u32AppId = u32AppId;


   ETG_TRACE_USR4(("sendNewServiceLoadedStatus() called."));
   eUpdateClients(LCM_DBUSCTRLFI_C_U16_NEWSERVICELOADED);
}
tVoid lcm_tclServiceLcmDbus::sendFailedServicesListStatus(lcm_fi_tcl_SPM_ServiceList tServices)
{

   _tFailedServicesList_tServices = tServices;


   ETG_TRACE_USR4(("sendFailedServicesListStatus() called."));
   eUpdateClients(LCM_DBUSCTRLFI_C_U16_FAILEDSERVICESLIST);
}
tVoid lcm_tclServiceLcmDbus::sendNewProcessIdStatus(lcm_fi_tclString strBlockName, lcm_fi_tclString strServiceName, tU32 u32ProcessId)
{

   _tNewProcessId_strBlockName = strBlockName;
   _tNewProcessId_strServiceName = strServiceName;
   _tNewProcessId_u32ProcessId = u32ProcessId;


   ETG_TRACE_USR4(("sendNewProcessIdStatus() called."));
   eUpdateClients(LCM_DBUSCTRLFI_C_U16_NEWPROCESSID);
}
tVoid lcm_tclServiceLcmDbus::sendStartupFailureIndicationStatus(lcm_fi_tcl_StartupFailureInfo tStartupFailureInd)
{

   _tStartupFailureIndication_tStartupFailureInd = tStartupFailureInd;


   ETG_TRACE_USR4(("sendStartupFailureIndicationStatus() called."));
   eUpdateClients(LCM_DBUSCTRLFI_C_U16_STARTUPFAILUREINDICATION);
}
tVoid lcm_tclServiceLcmDbus::sendSupervisionStateChangeStatus(tBool bSupervisionActive)
{

   _tSupervisionStateChange_bSupervisionActive = bSupervisionActive;


   ETG_TRACE_USR4(("sendSupervisionStateChangeStatus() called."));
   eUpdateClients(LCM_DBUSCTRLFI_C_U16_SUPERVISIONSTATECHANGE);
}

tBool lcm_tclServiceLcmDbus::onAppStateChangeSet(tU32 u32AppId, tU32 u32State, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // lint
   (tVoid)u32AppId; (tVoid)u32State;
   (tVoid)bPropertyChanged; (tVoid)u16ErrorCode;
   // onAppStateChangeSet: user specific code start
   // onAppStateChangeSet: user specific code end
   return _bResult;
}
tBool lcm_tclServiceLcmDbus::onAppEndSet(tU32 u32AppId, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // lint
   (tVoid)u32AppId;
   (tVoid)bPropertyChanged; (tVoid)u16ErrorCode;
   // onAppEndSet: user specific code start
   // onAppEndSet: user specific code end
   return _bResult;
}
tBool lcm_tclServiceLcmDbus::onSupervisionStateChangeSet(tBool bSupervisionActive, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // lint
   (tVoid)bSupervisionActive;
   (tVoid)bPropertyChanged; (tVoid)u16ErrorCode;
   // onSupervisionStateChangeSet: user specific code start
   // onSupervisionStateChangeSet: user specific code end
   return _bResult;
}


tVoid lcm_tclServiceLcmDbus::vHandleStartProcessOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         lcm_dbusctrlfi_tclMsgStartProcessMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, LCMDBUS_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tStartProcess_strLocation = oMStart.strLocation;
            _tStartProcess_u32Prio = oMStart.u32Prio;
            _tStartProcess_u32Affinity = oMStart.u32Affinity;
            _tStartProcess_u32AffinityEnd = oMStart.u32AffinityEnd;
            _tStartProcess_u32NiceLevel = oMStart.u32NiceLevel;
            _tStartProcess_u32NiceLevelEnd = oMStart.u32NiceLevelEnd;
            _tStartProcess_u32Type = oMStart.u32Type;
            _tStartProcess_u32Info = oMStart.u32Info;



            // Remember that we have to send an answer to this request
            _oMemStartProcess.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onStartProcessMStart(oMStart.strLocation, oMStart.u32Prio, oMStart.u32Affinity, oMStart.u32AffinityEnd, oMStart.u32NiceLevel, oMStart.u32NiceLevelEnd, oMStart.u32Type, oMStart.u32Info);
            if (_poCallbackIf) _poCallbackIf->onStartProcessMStart(oMStart.strLocation, oMStart.u32Prio, oMStart.u32Affinity, oMStart.u32AffinityEnd, oMStart.u32NiceLevel, oMStart.u32NiceLevelEnd, oMStart.u32Type, oMStart.u32Info);
            // vHandleStartProcessOpMStart: user specific code start
            // vHandleStartProcessOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleStartProcessOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid lcm_tclServiceLcmDbus::onStartProcessMStart(lcm_fi_tclString strLocation, tU32 u32Prio, tU32 u32Affinity, tU32 u32AffinityEnd, tU32 u32NiceLevel, tU32 u32NiceLevelEnd, lcm_fi_tcl_e32_LCM_START_PROC_TYPE u32Type, tU32 u32Info) {

   // onStartProcessMStart: user specific code start
   (void)strLocation;
   (void)u32Prio;
   (void)u32Affinity;
   (void)u32AffinityEnd;
   (void)u32NiceLevel;
   (void)u32NiceLevelEnd;
   (void)u32Type;
   (void)u32Info;
   // onStartProcessMStart: user specific code end
}
tVoid lcm_tclServiceLcmDbus::sendStartProcessMResult(tS32 s32ReturnVal, lcm_fi_tclString strLocation, tU32 u32ProcId, tU32 u32SpawnDuration) {
   if (_oMemStartProcess.bIsPending() == TRUE) {
      lcm_dbusctrlfi_tclMsgStartProcessMethodResult  oMResult;
      //the data content

      oMResult.s32ReturnVal = s32ReturnVal;
      oMResult.strLocation = strLocation;
      oMResult.u32ProcId = u32ProcId;
      oMResult.u32SpawnDuration = u32SpawnDuration;


      _oMemStartProcess.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemStartProcess.u16GetSourceAppID(), 
         _oMemStartProcess.u16GetRegisterID(), 
         _oMemStartProcess.u16GetCMDCounter(), 
         (tU16) LCM_DBUSCTRLFI_C_U16_STARTPROCESS, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendStartProcessMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", LCM_DBUSCTRLFI_C_U16_STARTPROCESS, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid lcm_tclServiceLcmDbus::vHandleStopProcessOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         lcm_dbusctrlfi_tclMsgStopProcessMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, LCMDBUS_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tStopProcess_strLocation = oMStart.strLocation;
            _tStopProcess_u32ProcId = oMStart.u32ProcId;



            // Remember that we have to send an answer to this request
            _oMemStopProcess.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onStopProcessMStart(oMStart.strLocation, oMStart.u32ProcId);
            if (_poCallbackIf) _poCallbackIf->onStopProcessMStart(oMStart.strLocation, oMStart.u32ProcId);
            // vHandleStopProcessOpMStart: user specific code start
            // vHandleStopProcessOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleStopProcessOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid lcm_tclServiceLcmDbus::onStopProcessMStart(lcm_fi_tclString strLocation, tU32 u32ProcId) {

   // onStopProcessMStart: user specific code start
   (void)strLocation;
   (void)u32ProcId;
   // onStopProcessMStart: user specific code end
}
tVoid lcm_tclServiceLcmDbus::sendStopProcessMResult(tS32 s32ReturnVal) {
   if (_oMemStopProcess.bIsPending() == TRUE) {
      lcm_dbusctrlfi_tclMsgStopProcessMethodResult  oMResult;
      //the data content

      oMResult.s32ReturnVal = s32ReturnVal;


      _oMemStopProcess.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemStopProcess.u16GetSourceAppID(), 
         _oMemStopProcess.u16GetRegisterID(), 
         _oMemStopProcess.u16GetCMDCounter(), 
         (tU16) LCM_DBUSCTRLFI_C_U16_STOPPROCESS, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendStopProcessMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", LCM_DBUSCTRLFI_C_U16_STOPPROCESS, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid lcm_tclServiceLcmDbus::vHandleStartupFinishedOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         lcm_dbusctrlfi_tclMsgStartupFinishedMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, LCMDBUS_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tStartupFinished_eStartUpParam = oMStart.eStartUpParam;



            // Remember that we have to send an answer to this request
            _oMemStartupFinished.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onStartupFinishedMStart(oMStart.eStartUpParam);
            if (_poCallbackIf) _poCallbackIf->onStartupFinishedMStart(oMStart.eStartUpParam);
            // vHandleStartupFinishedOpMStart: user specific code start
            // vHandleStartupFinishedOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleStartupFinishedOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid lcm_tclServiceLcmDbus::onStartupFinishedMStart(lcm_fi_tcl_e32_LCM_STARTUP_TYPE eStartUpParam) {

   // onStartupFinishedMStart: user specific code start
   (void)eStartUpParam;
   // onStartupFinishedMStart: user specific code end
}
tVoid lcm_tclServiceLcmDbus::sendStartupFinishedMResult(tS32 s32ReturnVal) {
   if (_oMemStartupFinished.bIsPending() == TRUE) {
      lcm_dbusctrlfi_tclMsgStartupFinishedMethodResult  oMResult;
      //the data content

      oMResult.s32ReturnVal = s32ReturnVal;


      _oMemStartupFinished.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemStartupFinished.u16GetSourceAppID(), 
         _oMemStartupFinished.u16GetRegisterID(), 
         _oMemStartupFinished.u16GetCMDCounter(), 
         (tU16) LCM_DBUSCTRLFI_C_U16_STARTUPFINISHED, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendStartupFinishedMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", LCM_DBUSCTRLFI_C_U16_STARTUPFINISHED, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid lcm_tclServiceLcmDbus::vHandleGetProcessIdOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         lcm_dbusctrlfi_tclMsgGetProcessIdMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, LCMDBUS_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tGetProcessId_strServiceName = oMStart.strServiceName;



            // Remember that we have to send an answer to this request
            _oMemGetProcessId.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onGetProcessIdMStart(oMStart.strServiceName);
            if (_poCallbackIf) _poCallbackIf->onGetProcessIdMStart(oMStart.strServiceName);
            // vHandleGetProcessIdOpMStart: user specific code start
            // vHandleGetProcessIdOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleGetProcessIdOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid lcm_tclServiceLcmDbus::onGetProcessIdMStart(lcm_fi_tclString strServiceName) {

   // onGetProcessIdMStart: user specific code start
   (void)strServiceName;
   // onGetProcessIdMStart: user specific code end
}
tVoid lcm_tclServiceLcmDbus::sendGetProcessIdMResult() {
   if (_oMemGetProcessId.bIsPending() == TRUE) {
      lcm_dbusctrlfi_tclMsgGetProcessIdMethodResult  oMResult;
      //the data content



      _oMemGetProcessId.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemGetProcessId.u16GetSourceAppID(), 
         _oMemGetProcessId.u16GetRegisterID(), 
         _oMemGetProcessId.u16GetCMDCounter(), 
         (tU16) LCM_DBUSCTRLFI_C_U16_GETPROCESSID, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendGetProcessIdMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", LCM_DBUSCTRLFI_C_U16_GETPROCESSID, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid lcm_tclServiceLcmDbus::vHandleTriggerGetUnitListOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         lcm_dbusctrlfi_tclMsgTriggerGetUnitListMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, LCMDBUS_FI_MAJOR_VERSION) != OSAL_ERROR) {



            // Remember that we have to send an answer to this request
            _oMemTriggerGetUnitList.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onTriggerGetUnitListMStart();
            if (_poCallbackIf) _poCallbackIf->onTriggerGetUnitListMStart();
            // vHandleTriggerGetUnitListOpMStart: user specific code start
            // vHandleTriggerGetUnitListOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleTriggerGetUnitListOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid lcm_tclServiceLcmDbus::onTriggerGetUnitListMStart() {

   // onTriggerGetUnitListMStart: user specific code start
   // onTriggerGetUnitListMStart: user specific code end
}
tVoid lcm_tclServiceLcmDbus::sendTriggerGetUnitListMResult() {
   if (_oMemTriggerGetUnitList.bIsPending() == TRUE) {
      lcm_dbusctrlfi_tclMsgTriggerGetUnitListMethodResult  oMResult;
      //the data content



      _oMemTriggerGetUnitList.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemTriggerGetUnitList.u16GetSourceAppID(), 
         _oMemTriggerGetUnitList.u16GetRegisterID(), 
         _oMemTriggerGetUnitList.u16GetCMDCounter(), 
         (tU16) LCM_DBUSCTRLFI_C_U16_TRIGGERGETUNITLIST, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendTriggerGetUnitListMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", LCM_DBUSCTRLFI_C_U16_TRIGGERGETUNITLIST, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid lcm_tclServiceLcmDbus::vHandleRestartProcessOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         lcm_dbusctrlfi_tclMsgRestartProcessMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, LCMDBUS_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tRestartProcess_strLocation = oMStart.strLocation;
            _tRestartProcess_u32ProcId = oMStart.u32ProcId;



            // Remember that we have to send an answer to this request
            _oMemRestartProcess.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onRestartProcessMStart(oMStart.strLocation, oMStart.u32ProcId);
            if (_poCallbackIf) _poCallbackIf->onRestartProcessMStart(oMStart.strLocation, oMStart.u32ProcId);
            // vHandleRestartProcessOpMStart: user specific code start
            // vHandleRestartProcessOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleRestartProcessOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid lcm_tclServiceLcmDbus::onRestartProcessMStart(lcm_fi_tclString strLocation, tU32 u32ProcId) {

   // onRestartProcessMStart: user specific code start
   (void)u32ProcId;
   ETG_TRACE_USR4(("SPM  :: onRestartProcessMStart: %s!",strLocation.szValue ));
   // onRestartProcessMStart: user specific code end
}
tVoid lcm_tclServiceLcmDbus::sendRestartProcessMResult(tS32 s32ReturnVal) {
   if (_oMemRestartProcess.bIsPending() == TRUE) {
      lcm_dbusctrlfi_tclMsgRestartProcessMethodResult  oMResult;
      //the data content

      oMResult.s32ReturnVal = s32ReturnVal;


      _oMemRestartProcess.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemRestartProcess.u16GetSourceAppID(), 
         _oMemRestartProcess.u16GetRegisterID(), 
         _oMemRestartProcess.u16GetCMDCounter(), 
         (tU16) LCM_DBUSCTRLFI_C_U16_RESTARTPROCESS, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendRestartProcessMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", LCM_DBUSCTRLFI_C_U16_RESTARTPROCESS, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}




// lcm_tclServiceLcmDbuslcm_ServiceLcmDbus: user specific code start
// lcm_tclServiceLcmDbuslcm_ServiceLcmDbus: user specific code end

//EOF
