/*****************************************************************************
 * @file:         AsfClientStarter.cpp
 * @PROJECT:      CMD project
 * @SW-COMPONENT: lcm
 * @Template:     AsfClientStarter.cpp.tpl
 * ----------------------------------------------------------------------------
 *
 * @brief:  generated file
 *          create ASF proxies
 *
 *          Do manual changes only inside tags
 *
 *          //......................: user specific code start 
 *          //......................: user specific code end 
 *
 * ----------------------------------------------------------------------------
 * @copyright   (c) 2019 Robert Bosch GmbH.
 *              The reproduction, distribution and utilization of this file as
 *              well as the communication of its contents to others without express
 *              authorization is prohibited. Offenders will be held liable for the
 *              payment of damages. All rights reserved in the event of the grant
 *              of a patent, utility model or design.
 *****************************************************************************/
#include <iostream>

#include "lcm_AppMain.h"

#include "CcaSrvProxy.h"

// AsfClientStarterIncludeTop: user specific code start
// AsfClientStarterIncludeTop: user specific code end

#include "lcm_ClientSpm.h"
#include "lcm_ClientStartupCtrlClient.h"

// AsfClientStarterInclude: user specific code start
#include "DbusManagerProxy.h"
#ifdef VARIANT_S_FTR_ENABLE_DBUS_PROPERTY
#include "DbusPropertiesProxy.h"
#endif
#include "DbusProxy.h"
#include "DbusServiceProxy.h"
#include "DbusUnitProxy.h"
#include "LcmConsumerStub.h"
#include "LcmRecoveryClientStub.h"
#include "LifeCycleConsumerProxy.h"
#include "LifeCycleControlStub.h"
// AsfClientStarterInclude: user specific code end

namespace org { namespace genivi {
using namespace ::org::bosch::cm::lcm;

    void vProxyStarter(lcm_tclAppMain *poServer){
        {
            CcaSrvProxy *poCcaSrvProxy = new CcaSrvProxy(poServer);
            poServer->vAddObj(poCcaSrvProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        // AsfClientStarterlcm_tclClientSpm: user specific code start
        // AsfClientStarterlcm_tclClientSpm: user specific code end
        {
            lcm_tclClientSpm *poCcaProxy = new lcm_tclClientSpm(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        // AsfClientStarterlcm_tclClientStartupCtrlClient: user specific code start
        // AsfClientStarterlcm_tclClientStartupCtrlClient: user specific code end
        {
            lcm_tclClientStartupCtrlClient *poCcaProxy = new lcm_tclClientStartupCtrlClient(poServer);
            poServer->vAddObj(poCcaProxy);
        } //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list

        // AsfClientProxyStarter: user specific code start
   {
      // proxies to communicate with systemd
      DbusManagerProxy       *poDbusManagerProxy       = new DbusManagerProxy(poServer);
      poServer->   vAddObj(poDbusManagerProxy);
      #ifdef VARIANT_S_FTR_ENABLE_DBUS_PROPERTY
         DbusPropertiesProxy *poDbusPropertiesProxy    = new DbusPropertiesProxy(poServer);
         poServer->vAddObj(poDbusPropertiesProxy);
      #endif
      DbusProxy              *poDbusProxy              = new DbusProxy(poServer);
      poServer->   vAddObj(poDbusProxy);
      DbusServiceProxy       *poDbusServiceProxy       = new DbusServiceProxy(poServer);
      poServer->   vAddObj(poDbusServiceProxy);
      DbusUnitProxy          *poDbusUnitProxy          = new DbusUnitProxy(poServer);
      poServer->   vAddObj(poDbusUnitProxy);

      // LCM GENIVI interfaces
      LcmConsumerStub        *poLcmConsumerStub        = new LcmConsumerStub(poServer);
      poServer->vAddObj(poLcmConsumerStub);
      LcmRecoveryClientStub  *poLcmRecoveryClientStub  = new LcmRecoveryClientStub(poServer);
      poServer->vAddObj(poLcmRecoveryClientStub);
      LifeCycleConsumerProxy *poLifeCycleConsumerProxy = new LifeCycleConsumerProxy(poServer);
      poServer->vAddObj(poLifeCycleConsumerProxy);
      LifeCycleControlStub   *poLifeCycleControlStub   = new LifeCycleControlStub(poServer);
      poServer->vAddObj(poLifeCycleControlStub);
   }     //lint !e429 Custodial pointer 'xxx' (line xx) has not been freed or returned --> pointer is added to list
        // AsfClientProxyStarter: user specific code end
    }

} } //namespace org { namespace genivi {
